/*
 * Created on Nov 7, 2003
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;

import com.standbysoft.datepicker.DefaultMonthModel;
import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;

/**
 * Shows how general features like today button, week numbers, locale, etc are used.
 */
public class GeneralDemo extends JPanel {
	private JMonthView monthView;
	private JDatePicker datePicker;
	private JLabel localeLabel;
	private JComboBox localeComboBox;
	private JCheckBox weekNumbersVisible;
	private JCheckBox enabledCheckBox;
	private JCheckBox todayCheckBox;
	private JLabel dowFirstLabel;
	private JComboBox dowFirstComboBox;
	private JCheckBox minDateCheckBox;
	private JDatePicker minDateDatePicker;
	private JCheckBox maxDateCheckBox;
	private JDatePicker maxDateDatePicker;
	private DefaultMonthModel monthModel;

	public GeneralDemo() {
		monthModel = new DefaultMonthModel();
		monthView = new JMonthView();
		monthView.setMonthModel(monthModel);
		datePicker = new JDatePicker();
		
		localeLabel = new JLabel("Locale:");
		localeComboBox = new JComboBox(Locale.getAvailableLocales());

		localeComboBox.setSelectedItem(monthView.getLocale());
		localeComboBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					Locale locale = (Locale) localeComboBox.getSelectedItem();
					monthView.setLocale(locale);
					datePicker.setLocale(locale);
				}
			}
		});
		localeComboBox.setRenderer(new DefaultListCellRenderer() {
			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				Locale locale = (Locale) value;
				l.setText(locale.getDisplayName());

				return l;
			}
		});
		
		enabledCheckBox = new JCheckBox("Enable", monthView.isEnabled());
		enabledCheckBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				monthView.setEnabled(enabledCheckBox.isSelected());
				datePicker.setEnabled(enabledCheckBox.isSelected());
			}
		});
		
		weekNumbersVisible = new JCheckBox("Show week numbers (MonthView only)", monthView.isWeekNumbersVisible());
		weekNumbersVisible.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				monthView.setWeekNumbersVisible(weekNumbersVisible.isSelected());
			}
		});
		
		todayCheckBox = new JCheckBox("Show Today (MonthView only)", monthView.isDisplayToday());
		todayCheckBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				monthView.setDisplayToday(todayCheckBox.isSelected());
			}
		});
		
		dowFirstLabel = new JLabel("First Day of Week:");

		dowFirstComboBox = new JComboBox();
		dowFirstComboBox.addItem(new Integer(Calendar.SUNDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.MONDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.TUESDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.WEDNESDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.THURSDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.FRIDAY));
		dowFirstComboBox.addItem(new Integer(Calendar.SATURDAY));
		dowFirstComboBox.setSelectedItem(new Integer(monthView.getMonthModel().getDowFirst()));
		dowFirstComboBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					Integer df = (Integer) dowFirstComboBox.getSelectedItem();
					monthView.setDowFirst(df.intValue());
				}
			}
		});
		dowFirstComboBox.setRenderer(new DefaultListCellRenderer() {
			private String DAY_NAMES[] = new DateFormatSymbols().getWeekdays();

			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				Integer day = (Integer) value;
				l.setText(DAY_NAMES[day.intValue()]);

				return l;
			}
		});
		
		minDateCheckBox = new JCheckBox("MinDate");
		minDateDatePicker = new JDatePicker();
		minDateDatePicker.addDateSelectionListener(new DateSelectionAdapter() {
			public void dateSelectionChanged(DateSelectionEvent evt) {
				monthModel.setMinimumAllowed(minDateDatePicker.getSelectedDate());
			}
		});
		minDateCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					monthModel.setMinimumAllowed(minDateDatePicker.getSelectedDate());
				} else {
					monthModel.setMinimumAllowed(null);
				}
				minDateDatePicker.setEnabled(evt.getStateChange() == ItemEvent.SELECTED);
			}
		});
		minDateCheckBox.setSelected(!minDateCheckBox.isSelected());
		minDateCheckBox.setSelected(!minDateCheckBox.isSelected());
		
		maxDateCheckBox = new JCheckBox("MaxDate");
		maxDateDatePicker = new JDatePicker();
		maxDateDatePicker.addDateSelectionListener(new DateSelectionAdapter() {
			public void dateSelectionChanged(DateSelectionEvent evt) {
				monthModel.setMaximumAllowed(maxDateDatePicker.getSelectedDate());
			}
		});
		maxDateCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					monthModel.setMaximumAllowed(maxDateDatePicker.getSelectedDate());
				} else {
					monthModel.setMaximumAllowed(null);
				}
				maxDateDatePicker.setEnabled(evt.getStateChange() == ItemEvent.SELECTED);
			}
		});
		maxDateCheckBox.setSelected(!maxDateCheckBox.isSelected());
		maxDateCheckBox.setSelected(!maxDateCheckBox.isSelected());
		
		setLayout(new GridBagLayout());
		add(monthView, new GridBagConstraints(0, 0, 1, 8, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(datePicker, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(localeLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(localeComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(new JLabel(), new GridBagConstraints(3, 0, 1, 9, 1.0, 1.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		add(enabledCheckBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(new JSeparator(), new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(todayCheckBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(weekNumbersVisible, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(minDateCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(minDateDatePicker, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(maxDateCheckBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(maxDateDatePicker, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(dowFirstLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(dowFirstComboBox, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
	}

	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("GeneralDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		GeneralDemo newContentPane = new GeneralDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}
