/*
 * SouthComponent.java
 *
 * Created on September 10, 2002, 6:59 PM
 */

package demo;
import com.develop.jawin.*;
import com.develop.io.*;
import com.develop.jawin.win32.*;
import DirectAnimation.*;

/**
 *
 * @author  Cyril
 */
public class SouthComponent extends AXComponent {
    java.awt.Image img = null;
    /** Creates a new instance of SouthComponent */
    public SouthComponent() throws COMException {
        super(DAViewerControl.progID);
        try {
            java.awt.MediaTracker tracker = new java.awt.MediaTracker(this);
            img = java.awt.Toolkit.getDefaultToolkit().getImage("./Paradise.jpg");
            tracker.addImage(img, 0);
            tracker.waitForAll();
        }catch(Exception e){}
    }
    /**
     * @throws COMException  */
    public void initInstance() throws COMException {
        IDA3ViewerControl davControl = new IDA3ViewerControl(getControl());
        addEventListener(_IDAViewerControlEvents.class, new DAListener());
        IDA3Statics m = new IDA3Statics(davControl.getMeterLibrary());
        
        // Create an animated color
        IDANumber half = m.DANumber(0.5);
        IDAColor clr = m.ColorHslAnim(m.Mul(m.getLocalTime(), m.DANumber(0.345)), half, half);
        
        // Contstruct a 12pt font and a text image
        IDAFontStyle Font = m.Font("ms sans serif", 5, clr);
        IDAImage txtImg = m.StringImage("NewJawin API (windowless DA)", Font);
        // Move the text image across the page
        IDANumber pos = m.Mul(m.Sin(m.getLocalTime()), m.DANumber(0.02));
        IDANumber scl = m.Add(m.DANumber(2), m.Abs(m.Mul(m.Sin(m.getLocalTime()), m.DANumber(3))));
        IDATransform2 xf = m.Compose2(m.Translate2Anim(m.DANumber(0), pos),
        m.Scale2UniformAnim(scl));
        txtImg = txtImg.Transform(xf);
        // Rotate the text image
        IDATransform2 bgr = m.Rotate3RateDegrees(m.Vector3(1, 1, 1), 45).ParallelTransform2();
        txtImg = txtImg.Transform(bgr);
        // Assign the animation back to the control and start it
        davControl.setBackgroundImage(m.SolidColorImage(m.getBlack()));
        davControl.setImage(txtImg);
        davControl.Start();
    }
    
    public void paint(java.awt.Graphics g) {
        super.paint(g);
        if(img != null)
            g.drawImage(img, 0, 0, getWidth(), getHeight(), 0, 0, img.getWidth(this), img.getHeight(this), this);
    }
}
