/*
 * Decompiled with CFR 0.152.
 */
package vscript;

import java.awt.Component;
import java.awt.Container;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import vscript.GUI.LoadListener;
import vscript.GUI.VScriptRunnerPanel;
import vscript.Tag;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.loader.ScriptLoader;
import vscript.loader.ScriptObserver;
import vscript.message.Messagable;
import vscript.message.Message;
import vscript.message.MessageNode;
import vscript.message.RemoteMessageNode;
import vscript.parser.Parser;
import vscript.remote.RemoteReciever;
import vscript.remote.RemoteVSR;

public class VScriptRunner
implements Runnable,
ScriptObserver {
    public static VScriptRunner vsr;
    private VScriptRunnerPanel vsrPanel;
    private Thread messageDeliveryThread;
    private LinkedList messageList = new LinkedList();
    private MessageNode root;
    private MessageNode vsrPanelNode;
    private ScriptLoader scriptLoader;
    private HashMap iMap = new HashMap(8);
    private HashMap nameMap = new HashMap(8);
    private HashMap containerMap = new HashMap(8);

    private VScriptRunner() {
        this.messageDeliveryThread = new Thread((Runnable)this, "MessageDelivery");
        this.root = new MessageNode(null, "vsr_root");
        this.scriptLoader = new ScriptLoader();
        this.vsrPanel = new VScriptRunnerPanel();
        this.vsrPanelNode = new MessageNode(this.root, "vsr");
        this.vsrPanelNode.addInterpretedObject(this.vsrPanel);
        this.vsrPanel.setEventTagManager(new EventTagManager(this, this.vsrPanelNode));
        new RemoteReciever(this.root).start();
    }

    public static VScriptRunner getVScriptRunner() {
        if (vsr == null) {
            vsr = new VScriptRunner();
            VScriptRunner.vsr.messageDeliveryThread.start();
        }
        return vsr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            MessageNode messageNode;
            Message message;
            LinkedList linkedList = this.messageList;
            synchronized (linkedList) {
                while (this.messageList.size() == 0) {
                    try {
                        this.messageList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                message = (Message)this.messageList.removeFirst();
                messageNode = message.getSourceMessageNode();
                message.prepareMessage(messageNode);
            }
            messageNode.passMessage(message);
        }
    }

    public void addToMessageQueue(Message message) {
        LinkedList linkedList = this.messageList;
        synchronized (linkedList) {
            this.messageList.addLast(message);
            this.messageList.notify();
        }
    }

    public void addToRootNode(Object object, String string) {
        MessageNode messageNode = object instanceof RemoteVSR ? new RemoteMessageNode(this.root, string) : new MessageNode(this.root, string);
        if (object instanceof Messagable) {
            ((Messagable)object).setEventTagManager(new EventTagManager(this, messageNode));
        }
        messageNode.addInterpretedObject(object);
    }

    public void loadScript(String string) {
        this.scriptLoader.loadScript(string, this);
    }

    public void reLoadScript(String string) throws MalformedURLException {
        this.unLoadScript(string);
        this.scriptLoader.reloadScript(string, this);
    }

    public void unLoadScript(String string) throws MalformedURLException {
        JPanel jPanel;
        Object v = this.nameMap.remove(string);
        Object v2 = this.iMap.remove(string);
        if (v2 instanceof JComponent && (jPanel = (JPanel)this.containerMap.remove(string)) != null) {
            jPanel.remove((JComponent)v2);
            jPanel.repaint();
        }
        if (v2 instanceof LoadListener) {
            ((LoadListener)v2).componentUnloaded();
        }
        if (v != null) {
            this.vsrPanelNode.removeChildNode((String)v);
        }
    }

    public void showScript(String string) {
        String string2 = (String)this.nameMap.get(string);
        if (string2 != null) {
            Message message = Parser.parseMessage(string2 + ".show()");
            message.setSourceMessageNode(this.vsrPanelNode);
            this.addToMessageQueue(message);
        }
    }

    public void interpretScript(String string, String string2, String string3, Tag tag) throws MalformedURLException, ParseException {
        Tag tag2;
        JPanel jPanel = null;
        if (this.iMap.containsKey(string)) {
            this.unLoadScript(string);
        }
        if ((tag2 = tag != null ? tag : this.getScriptTag(string)) != null) {
            String string4 = tag2.getTagIdentifier();
            TagInterpreter tagInterpreter = tag2.getInterpreter();
            if (tagInterpreter != null) {
                Object object;
                if (string2 == null) {
                    jPanel = this.vsrPanel;
                } else {
                    object = this.vsrPanelNode.getObject(Parser.parseMessage(string2 + ".a()"));
                    jPanel = (JPanel)object;
                    if (jPanel == null) {
                        System.out.println(string2 + ": Container not present.");
                    }
                }
                this.vsrPanelNode.setContainer(jPanel);
                Object object2 = tagInterpreter.interpret(tag2, this.vsrPanelNode, 1);
                this.iMap.put(string, object2);
                this.nameMap.put(string, string4);
                if (object2 instanceof JComponent) {
                    this.containerMap.put(string, jPanel);
                    if (jPanel == this.vsrPanel) {
                        this.vsrPanel.add((Component)((JComponent)object2), string4);
                        this.vsrPanel.setFirstChild(string4);
                    } else if (jPanel != null) {
                        object = null;
                        if (string3 != null) {
                            object = Parser.parsePos(string3);
                        }
                        if (object == null) {
                            object = Parser.parsePos("0,0,1000,1000");
                        }
                        jPanel.add((Component)((JComponent)object2), object);
                        Container container = jPanel.getParent();
                        if (container != null) {
                            container.validate();
                            container.repaint();
                        }
                    }
                }
                if (object2 instanceof LoadListener) {
                    object = (LoadListener)object2;
                    object.componentLoaded();
                }
            }
        }
    }

    private Tag getScriptTag(String string) throws MalformedURLException, ParseException {
        List list = this.scriptLoader.getScriptTag(string);
        ListIterator listIterator = list.listIterator(0);
        if (listIterator.hasNext()) {
            Tag tag = (Tag)listIterator.next();
            return tag;
        }
        return null;
    }

    public JPanel getPanel() {
        return this.vsrPanel;
    }

    public void scriptLoaded(String string) {
    }

    public void loadFile(String string) {
        this.scriptLoader.loadFile(string);
    }

    public byte[] getFile(String string) {
        return this.scriptLoader.getFile(string);
    }
}

