/*
 * Decompiled with CFR 0.152.
 */
package vscript.message;

import java.util.Iterator;
import java.util.LinkedList;
import vscript.message.Argument;
import vscript.message.Messagable;
import vscript.message.MessageNode;
import vscript.parser.Parser;

public class Message {
    private LinkedList destinationList;
    private String message;
    private Argument[] argument;
    private MessageNode sourceNode;
    private int nextDest;
    private String fullMsg;

    public Message(LinkedList linkedList, String string, String[] stringArray) {
        this.destinationList = linkedList;
        this.message = string;
        this.argument = new Argument[stringArray.length];
        int n = 0;
        while (n < this.argument.length) {
            this.argument[n] = Parser.parseArgument(stringArray[n]);
            ++n;
        }
        this.fullMsg = this.constructMessage();
    }

    public LinkedList getDestination() {
        return this.destinationList;
    }

    public void removeNextDestination() {
        ++this.nextDest;
    }

    public void resetDestination() {
        this.nextDest = 0;
    }

    public int getNextDestIndex() {
        return this.nextDest;
    }

    public void setNextDestIndex(int n) {
        this.nextDest = n;
    }

    public String getNextDestination(boolean bl) {
        if (this.destinationList.size() > this.nextDest) {
            return (String)this.destinationList.get(this.nextDest);
        }
        if (bl) {
            this.nextDest = 0;
        }
        return null;
    }

    public String getMessageString() {
        return this.message;
    }

    public String[] getArguments() {
        if (this.argument == null) {
            return null;
        }
        String[] stringArray = new String[this.argument.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.argument[n].getArgString();
            ++n;
        }
        return stringArray;
    }

    public void setSourceMessageNode(MessageNode messageNode) {
        this.sourceNode = messageNode;
    }

    public MessageNode getSourceMessageNode() {
        return this.sourceNode;
    }

    public String constructMessage() {
        StringBuffer stringBuffer = new StringBuffer(20);
        Iterator iterator = this.destinationList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.message);
        stringBuffer.append('(');
        if (this.argument.length == 0) {
            stringBuffer.append(' ');
        }
        int n = 0;
        while (n < this.argument.length) {
            stringBuffer.append(this.argument[n].getArgString());
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.fullMsg;
    }

    public void prepareMessage(MessageNode messageNode) {
        int n = 0;
        while (n < this.argument.length) {
            int n2 = 0;
            while (n2 < this.argument[n].values.length) {
                Object object = messageNode.getObject(this.argument[n].message[n2]);
                if (object == null) {
                    return;
                }
                if (object instanceof Messagable) {
                    Messagable messagable = (Messagable)object;
                    this.argument[n].message[n2].prepareMessage(messageNode);
                    String[] stringArray = this.argument[n].message[n2].getArguments();
                    if (stringArray.length == 1) {
                        this.argument[n].values[n2] = messagable.getDataValue(stringArray[0]);
                    }
                }
                ++n2;
            }
            this.argument[n].constructArgString();
            ++n;
        }
    }
}

