/*
 * Decompiled with CFR 0.152.
 */
package javazoom.upload;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javazoom.upload.UploadException;
import javazoom.upload.parsing.CfuMultipartParser;
import javazoom.upload.parsing.CosMultipartParser;
import javazoom.upload.parsing.StrutsMultipartParser;

public class MultipartFormDataRequest {
    public static String COSPARSER = "com.oreilly.servlet.multipart.MultipartParser";
    public static String STRUTSPARSER = "org.apache.struts.upload.MultipartIterator";
    public static String CFUPARSER = "org.apache.commons.fileupload.MultipartStream";
    public static String DEFAULTPARSER = COSPARSER;
    public static String PARSERTEMPDIRECTORY = System.getProperty("java.io.tmpdir");
    public static int MAXCONTENTLENGTHALLOWED = 0x40000000;
    public static String DEFAULTENCODING = "iso-8859-1";
    private Hashtable _$205 = new Hashtable();
    private Hashtable _$206 = new Hashtable();

    public MultipartFormDataRequest(HttpServletRequest httpServletRequest, Vector vector, int n, String string, String string2) throws UploadException, IOException {
        if (httpServletRequest == null) {
            new UploadException(UploadException.INVALIDREQUEST);
        }
        if (string == null) {
            string = DEFAULTPARSER;
        }
        if (string.equalsIgnoreCase(COSPARSER)) {
            CosMultipartParser cosMultipartParser = new CosMultipartParser();
            cosMultipartParser.handleRequest(httpServletRequest, vector, n, this._$205, this._$206, string2);
        } else if (string.equalsIgnoreCase(STRUTSPARSER)) {
            StrutsMultipartParser strutsMultipartParser = new StrutsMultipartParser();
            strutsMultipartParser.handleRequest(httpServletRequest, vector, n, this._$205, this._$206, PARSERTEMPDIRECTORY, string2);
        } else if (string.equalsIgnoreCase(CFUPARSER)) {
            CfuMultipartParser cfuMultipartParser = new CfuMultipartParser();
            cfuMultipartParser.handleRequest(httpServletRequest, vector, n, this._$205, this._$206, PARSERTEMPDIRECTORY, string2);
        } else {
            throw new UploadException("Unknown multipart parser");
        }
    }

    public MultipartFormDataRequest(HttpServletRequest httpServletRequest, Vector vector, int n, String string) throws UploadException, IOException {
        this(httpServletRequest, vector, n, DEFAULTPARSER, DEFAULTENCODING);
    }

    public MultipartFormDataRequest(HttpServletRequest httpServletRequest, Vector vector, int n) throws UploadException, IOException {
        this(httpServletRequest, vector, n, DEFAULTPARSER);
    }

    public MultipartFormDataRequest(HttpServletRequest httpServletRequest, Vector vector) throws UploadException, IOException {
        this(httpServletRequest, vector, MAXCONTENTLENGTHALLOWED);
    }

    public MultipartFormDataRequest(HttpServletRequest httpServletRequest) throws UploadException, IOException {
        this(httpServletRequest, null, MAXCONTENTLENGTHALLOWED);
    }

    public Hashtable getFiles() {
        return this._$206;
    }

    public Enumeration getParameterNames() {
        return this._$205.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this._$205.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this._$205.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isMultipartFormData(HttpServletRequest httpServletRequest) {
        String string = null;
        String string2 = httpServletRequest.getHeader("Content-Type");
        String string3 = httpServletRequest.getContentType();
        if (string2 == null && string3 != null) {
            string = string3;
        } else if (string3 == null && string2 != null) {
            string = string2;
        } else if (string2 != null && string3 != null) {
            String string4 = string = string2.length() > string3.length() ? string2 : string3;
        }
        return string != null && string.toLowerCase().startsWith("multipart/form-data");
    }

    public static void isParserAvailable(String string) throws UploadException {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UploadException("Parser missing : " + classNotFoundException.getMessage());
        }
    }
}

