// ==============================================================
//
//  Copyright (c) 1999-2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================

static char id [] = "@(#)## n-ary Huffman Template Algorithm ## Author : Alex Vinokur ## "__FILE__;


// ##############################################################
// =================================
//  n-ary Huffman Template Algorithm
// ==================================
//
//  FILE : service.cpp
//
//  AUTHOR : Alex Vinokur
//
//  DESCRIPTION :
//
//         Implementation of the following auxiliary functions : 
//         -----------------------------------------------------
//         - void               show_file (...)
//         -----------------------------------------------------
//
// ##############################################################


// ===========================
#include "service.h"
// ===========================

// #####################################################
void   show_file (
	const string& file_type_i, 
	const string& file_name_i, 
	const string& delimiter_i
	)
{
string		ret_string;
string		file_line;
ifstream	fin (file_name_i.c_str());

	if (!fin)
	{
	       	ret_string = "Unable to open file " + file_name_i;	
		ERROR_MSG(ret_string);
		cout << ret_string << endl;
		return;
	}
	assert (fin);


	cout << endl;
	cout << "\t-----------------------" << endl;
	cout << "\t--- " << file_type_i << " file : " << file_name_i << endl;
	cout << "\t-----------------------" << endl;

	for (int i = 1; getline (fin, file_line); i++)
	{
		vector<string> file_vline;
		istringstream isstr (file_line.c_str ());

		copy(
			istream_iterator<string>(isstr),
			istream_iterator<string> (),
			back_inserter (file_vline)
			);

		cout << "\t  Line#" << i << " ---> ";

		copy (
			file_vline.begin (),
			file_vline.end (),
			ostream_iterator<string> (cout, delimiter_i.c_str())
			);
		cout << endl;

	} // for

		cout << "\t-----------------------" << endl;

} // string   show_file


// #######################################################
// ##### PART : CLASSES ##################################
// #######################################################
// =============================
// Constructor-0
ClassLogo::ClassLogo ()
{
	show_logo ("START");
}

// =============================
// Destructor
ClassLogo::~ClassLogo ()
{
	cout << endl;
	cout << endl;
	cout << endl;
	show_logo ("FINISH");
}

// =============================
void	ClassLogo::show_logo (const string& msg_i) const
{
time_t timer;
	timer	= time(NULL);

const string pref1 = "\t#";
const string pref2 = pref1 + " ";
const string logo1 = "n-ary Huffman Template Algorithm";
const string logo2 = "  Alex Vinokur";
const string logo3 = "  http://up.to/alexvn";
const string logo4 = string ("  --> [") + string (sw_version) + string ("]");

size_t the_width = 0;
	the_width = MAX_VALUE (the_width, logo1.size());
	the_width = MAX_VALUE (the_width, logo2.size());
	the_width = MAX_VALUE (the_width, logo3.size());
	the_width = MAX_VALUE (the_width, logo4.size());

	cout << endl;
	cout << pref1 << string (the_width + 1, '=') << endl;
	cout << pref2 << logo1 << endl;
	cout << pref2 << logo4 << endl;
	cout << pref2 << logo2 << endl;
	cout << pref2 << logo3 << endl;
	cout << pref1 << string (the_width + 1, '-') << endl;
	cout << pref2 << msg_i << endl;
	cout << pref2 << asctime (localtime(&timer));
	cout << pref1 << string (the_width + 1, '=') << endl;
	cout << endl;
}

// #######################################################
ClassLogo	logo;


// #######################################################
// ################ END OF FILE ##########################
// #######################################################

