// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : enums.h
//
//  DESCRIPTION :
//         Enumerations
//
// ##############################################################


// ################
#ifndef _ENUMS_H
#define _ENUMS_H

// ================
#include "common.h"
// ================

// ----------------------------------------
enum TapeKinds
{
  MASTER_COMPUTATION_TAPE,
  SYNCHRONOUS_COMPUTATION_TAPE,
  BACKUP_COMPUTATION_TAPE,
  SYNCHRONOUS_BACKUP_COMPUTATION_TAPE,
  TESTER_TAPE,
  NUMBER_OF_TAPE_KINDS
};


// ----------------------------------------
enum TesterCalculationResults
{
  UNDEF_TesterCalculationResults,
  TESTER_CALCULATION__USER_REQUIRED_CHECK_POINT,
  TESTER_CALCULATION__AUTOMATIC_NOT_APPLICABLE_CHECK_POINT,
  TESTER_CALCULATION__AUTOMATIC_HALTING_CHECK_POINT,
  NUMBER_OF_TESTER_CALCULATION_RESULTS
};



// ----------------------------------------
enum MachineCalculationResults
{
  UNDEF_MachineCalculationResults,
  MACHINE_CALCULATION__CHECK_POINT_AFTER_BACKING_UP,
  MACHINE_CALCULATION__CHECK_POINT_AFTER_RECOVERY,
  MACHINE_CALCULATION__CHECK_POINT_AFTER_NO_APPLICABLE_RULE,
  MACHINE_CALCULATION__EMERGENCY_STATE,
  MACHINE_CALCULATION__SHUTTING_DOWN_STATE,
  NUMBER_OF_MACHINE_CALCULATION_RESULTS
};


// ----------------------------------------
#define	SYNCHRONOUS_TAPE_ALPHABET__EMPTY_SYMBOL		"b" 
#define	SYNCHRONOUS_TAPE_ALPHABET__BOUNDARY_SYMBOL	"x" 
#define	SYNCHRONOUS_TAPE_ALPHABET__SIGN_SYMBOL		"+" 

enum SunchronousTapeInternalAlphabetSymbols
{
  SYNCHRONOUS_TAPE_ALPHABET__BOUNDARY_SYMBOL__INDEX,	
  SYNCHRONOUS_TAPE_ALPHABET__SIGN_SYMBOL__INDEX,	
  NUMBER_OF_SYNCHRONOUS_TAPE_ALPHABET_SYMBOLS
};


// ----------------------------------------
// ----------------------------------------
enum ProgramStateTopKinds
{
  PROGRAM_STATE_TOP_KIND__USER_DEFINED,
  PROGRAM_STATE_TOP_KIND__NEUTRAL,
  PROGRAM_STATE_TOP_KIND__PRE_INITIAL,
  PROGRAM_STATE_TOP_KIND__POST_HALTING,
  PROGRAM_STATE_TOP_KIND__USER_REQUIRED,
  PROGRAM_STATE_TOP_KIND__EMBEDDED,
  NUMBER_OF_PROGRAM_STATE_TOP_KINDS
};


// ----------------------------------------
enum UserDefinedProgramStateKinds
{
  USER_DEFINED_PROGRAM_STATE_KIND__INITIAL,
  USER_DEFINED_PROGRAM_STATE_KIND__INTERNAL,
  USER_DEFINED_PROGRAM_STATE_KIND__HALTING,
  NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS
};


// ----------------------------------------
enum UserRequiredProgramStateKinds
{
  USER_REQUIRED_PROGRAM_STATE_KIND__CHECK_POINT,
  NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS
};


// ----------------------------------------
enum PreInitialProgramStateKinds
{
  PRE_INITIAL_PROGRAM_STATE_KIND__INITIAL,
  NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS
};


// ----------------------------------------
enum PostHaltingProgramStateKinds
{
  POST_HALTING_PROGRAM_STATE_KIND__HALTING,
  NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS
};


// ----------------------------------------
enum NeutralProgramStateKinds
{
  NEUTRAL_PROGRAM_STATE_KIND__CUR_NEUTRAL,
  NEUTRAL_PROGRAM_STATE_KIND__NEXT_THE_SAME,
  NEUTRAL_PROGRAM_STATE_KIND__NEXT_NOT_THE_SAME,
  NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS
};



// ----------------------------------------
enum EmbeddedProgramStateKinds
{
  EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP,
  EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL,
  EMBEDDED_PROGRAM_STATE_KIND__BACKUP,
  EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL,
  EMBEDDED_PROGRAM_STATE_KIND__RECOVERY,
  EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL,
  EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL,
  EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY,
  EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN,
  NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS
};


// ----------------------------------------
// ----------------------------------------
enum PreInitialBackupStates
{
  PRE_INITIAL_BACKUP_STATE_K1,
  PRE_INITIAL_BACKUP_STATE_K2,
  NUMBER_OF_PRE_INITIAL_BACKUP_STATES
};


enum ComputationControlStates
{
  COMPUTATION_CONTROL_STATE_R1,
  COMPUTATION_CONTROL_STATE_R2,
  NUMBER_OF_COMPUTATION_CONTROL_STATES
};

enum BackupStates
{
  BACKUP_STATE_S1,
  BACKUP_STATE_S2,
  BACKUP_STATE_S3,
  BACKUP_STATE_S4,
  NUMBER_OF_BACKUP_STATES
};

enum BackupControlStates
{
  BACKUP_CONTROL_STATE_T1,
  BACKUP_CONTROL_STATE_T2,
  BACKUP_CONTROL_STATE_T3,
  BACKUP_CONTROL_STATE_T4,
  NUMBER_OF_BACKUP_CONTROL_STATES
};

enum RecoveryStates
{
  RECOVERY_STATE_V1,
  RECOVERY_STATE_V2,
  RECOVERY_STATE_V3,
  RECOVERY_STATE_V4,
  NUMBER_OF_RECOVERY_STATES
};

enum RecoveryControlStates
{
  RECOVERY_CONTROL_STATE_W1,
  RECOVERY_CONTROL_STATE_W2,
  RECOVERY_CONTROL_STATE_W3,
  RECOVERY_CONTROL_STATE_W4,
  NUMBER_OF_RECOVERY_CONTROL_STATES
};

enum SummaryControlStates
{
  SUMMARY_CONTROL_STATE_U1,
  SUMMARY_CONTROL_STATE_U2,
  NUMBER_OF_SUMMARY_CONTROL_STATES
};
				  
enum EmbeddedEmergencyStates
{
  EMBEDDED_EMERGENCY_STATE__BASIC_E1,
  EMBEDDED_EMERGENCY_STATE__COMPUTATION_CONTROL_E2,
  EMBEDDED_EMERGENCY_STATE__BACKUP_E3,
  EMBEDDED_EMERGENCY_STATE__BACKUP_CONTROL_E4,
  EMBEDDED_EMERGENCY_STATE__RECOVERY_E5,
  EMBEDDED_EMERGENCY_STATE__RECOVERY_CONTROL_E6,
  EMBEDDED_EMERGENCY_STATE__SUMMARY_CONTROL_E7,
  NUMBER_OF_EMBEDDED_EMERGENCY_STATES
};
				  
enum EmbeddedHaltingStates
{
  EMBEDDED_HALTING_STATE_N1,
  NUMBER_OF_EMBEDDED_HALTING_STATES
};


const size_t total_embedded_program_states_CNS =
		NUMBER_OF_PRE_INITIAL_BACKUP_STATES + 
		NUMBER_OF_COMPUTATION_CONTROL_STATES +
		NUMBER_OF_BACKUP_STATES + 
		NUMBER_OF_BACKUP_CONTROL_STATES +
		NUMBER_OF_RECOVERY_STATES +
		NUMBER_OF_RECOVERY_CONTROL_STATES +
		NUMBER_OF_SUMMARY_CONTROL_STATES +
		NUMBER_OF_EMBEDDED_EMERGENCY_STATES +
		NUMBER_OF_EMBEDDED_HALTING_STATES
		;

// ----------------------------------------
// --- defines : EMBEDDED STATES : BEGIN --
// ----------------------------------------
#define EMBSTATE_K1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP][PRE_INITIAL_BACKUP_STATE_K1]
#define EMBSTATE_K2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__PRE_INITIAL_BACKUP][PRE_INITIAL_BACKUP_STATE_K2]

#define EMBSTATE_R1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL][COMPUTATION_CONTROL_STATE_R1]
#define EMBSTATE_R2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__COMPUTATION_CONTROL][COMPUTATION_CONTROL_STATE_R2]

#define EMBSTATE_S1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP][BACKUP_STATE_S1]
#define EMBSTATE_S2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP][BACKUP_STATE_S2]
#define EMBSTATE_S3 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP][BACKUP_STATE_S3]
#define EMBSTATE_S4 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP][BACKUP_STATE_S4]

#define EMBSTATE_T1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL][BACKUP_CONTROL_STATE_T1]
#define EMBSTATE_T2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL][BACKUP_CONTROL_STATE_T2]
#define EMBSTATE_T3 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL][BACKUP_CONTROL_STATE_T3]
#define EMBSTATE_T4 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__BACKUP_CONTROL][BACKUP_CONTROL_STATE_T4]

#define EMBSTATE_V1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY][RECOVERY_STATE_V1]
#define EMBSTATE_V2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY][RECOVERY_STATE_V2]
#define EMBSTATE_V3 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY][RECOVERY_STATE_V3]
#define EMBSTATE_V4 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY][RECOVERY_STATE_V4]

#define EMBSTATE_W1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL][RECOVERY_CONTROL_STATE_W1]
#define EMBSTATE_W2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL][RECOVERY_CONTROL_STATE_W2]
#define EMBSTATE_W3 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL][RECOVERY_CONTROL_STATE_W3]
#define EMBSTATE_W4 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__RECOVERY_CONTROL][RECOVERY_CONTROL_STATE_W4]

#define EMBSTATE_U1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL][SUMMARY_CONTROL_STATE_U1]
#define EMBSTATE_U2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SUMMARY_CONTROL][SUMMARY_CONTROL_STATE_U2]

#define EMBSTATE_N1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN][EMBEDDED_HALTING_STATE_N1]

#define EMBSTATE_E1 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__BASIC_E1]
#define EMBSTATE_E2 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__COMPUTATION_CONTROL_E2]
#define EMBSTATE_E3 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__BACKUP_E3]
#define EMBSTATE_E4 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__BACKUP_CONTROL_E4]
#define EMBSTATE_E5 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__RECOVERY_E5]
#define EMBSTATE_E6 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__RECOVERY_CONTROL_E6]
#define EMBSTATE_E7 embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__EMERGENCY][EMBEDDED_EMERGENCY_STATE__SUMMARY_CONTROL_E7]


// ----------------------------------------
// --- defines : EMBEDDED STATES : END ----
// ----------------------------------------


#endif	// _ENUMS_M_H
