// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-istype.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : istype methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========
bool TuringMachine::is_pseudo_never_mind_symbol (const symbol_mt& symbol_i) const
{
 return (belongs_to (symbol_i, pseudo_never_mind_symbols_alphabet_));

 // return (count (
 // 		pseudo_never_mind_symbols_alphabet_.begin(),
 // 		pseudo_never_mind_symbols_alphabet_.end(),
 // 		symbol_i
 // 		)
 // 		);
}


// =========
bool TuringMachine::is_pseudo_not_marker_symbol (const symbol_mt& symbol_i) const
{
  return (belongs_to (symbol_i, pseudo_not_marker_symbols_alphabet_));

}


// =========
bool TuringMachine::is_pseudo_not_marker_and_not_blank_symbol (const symbol_mt& symbol_i) const
{
  return (belongs_to (symbol_i, pseudo_not_marker_and_not_blank_symbols_alphabet_));
}


// =========
bool TuringMachine::is_pseudo_write_nothing_symbol (const symbol_mt& symbol_i) const
{
 return (count (
		pseudo_write_nothing_symbols_alphabet_.begin(),
		pseudo_write_nothing_symbols_alphabet_.end(),
		symbol_i
		)
		);
}

// =========
bool TuringMachine::is_initial_program_state (const state_t& state_i) const
{
  // return (belongs_to (state_i, user_defined_initial_program_states_) || belongs_to (state_i, pre_initial_program_states_));
  return (find (user_defined_initial_program_states_.begin(), user_defined_initial_program_states_.end(), state_i) != user_defined_initial_program_states_.end());
}

// =========
bool TuringMachine::is_halting_program_state (const state_t& state_i) const
{
  return (find (user_defined_halting_program_states_.begin(), user_defined_halting_program_states_.end(), state_i) != user_defined_halting_program_states_.end());
}


// =========
bool TuringMachine::is_internal_program_state (const state_t& state_i) const
{
  return (find (user_defined_internal_program_states_.begin(), user_defined_internal_program_states_.end(), state_i) != user_defined_internal_program_states_.end());
}

// =========
bool TuringMachine::is_user_defined_program_state (const state_t& state_i) const
{
  return (is_initial_program_state(state_i) || is_halting_program_state (state_i) || is_internal_program_state (state_i));
}


// =========
bool TuringMachine::is_neutral_program_state (const state_t& state_i) const
{
  return (belongs_to (state_i, neutral_program_states_));
}


// =========
bool TuringMachine::is_pre_initial_program_state (const state_t& state_i) const
{
  return (belongs_to (state_i, pre_initial_program_states_));
}


// =========
bool TuringMachine::is_post_halting_program_state (const state_t& state_i) const
{
  return (belongs_to (state_i, post_halting_program_states_));
}


// =========
bool TuringMachine::is_embedded_shutting_down_program_state (const state_t& state_i) const
{
  return (belongs_to (state_i, embedded_program_states_[EMBEDDED_PROGRAM_STATE_KIND__SHUTTING_DOWN]));
}


// =========
bool TuringMachine::is_user_required_check_point_program_state (const state_t& state_i) const
{
map<CurSituation, state_t>::const_iterator	pos_iter;
  for (pos_iter = user_required_check_point_program_states_.begin();
       pos_iter != user_required_check_point_program_states_.end();
       pos_iter++)
  {
    if (state_i == pos_iter->second) return true;
  }
  return false;
}


// =========
bool TuringMachine::is_user_required_check_point_program_pre_state (const state_t& state_i) const
{
map<CurSituation, state_t>::const_iterator	pos_iter;
  for (pos_iter = user_required_check_point_program_states_.begin();
       pos_iter != user_required_check_point_program_states_.end();
       pos_iter++)
  {
    if (state_i == pos_iter->first.get_state()) return true;
  }
  return false;
}

// =========
bool TuringMachine::is_embedded_program_state_of_specific_kind (EmbeddedProgramStateKinds kind_i, const state_t& state_i) const
{
  assert (count (embedded_program_states_[kind_i].begin(), embedded_program_states_[kind_i].end(), state_i) >= 0);
  assert (count (embedded_program_states_[kind_i].begin(), embedded_program_states_[kind_i].end(), state_i) <= 1);

  return (count (embedded_program_states_[kind_i].begin(), embedded_program_states_[kind_i].end(), state_i) == 1);
}
	    

// =========
bool TuringMachine::is_embedded_program_state (const state_t& state_i, EmbeddedProgramStateKinds& kind_o, size_t& index_o) const
{
  assert (!embedded_program_states_.empty());

  for (size_t i = 0; i < embedded_program_states_.size(); i++)
  {
    if (is_embedded_program_state_of_specific_kind (static_cast<EmbeddedProgramStateKinds>(i), state_i)) 
    {
      kind_o = static_cast<EmbeddedProgramStateKinds>(i);
      index_o = distance (
			embedded_program_states_[i].begin(), 
			find (
				embedded_program_states_[i].begin(), 
				embedded_program_states_[i].end(), 
				state_i
				)
			);
      assert (index_o < embedded_program_states_[i].size());
      return true;
    }
  }  

  return false; 
}



// =========
bool TuringMachine::is_embedded_program_state (const state_t& state_i) const
{
EmbeddedProgramStateKinds	kind;
size_t	id;
  return (is_embedded_program_state (state_i, kind, id));
}


// =========
bool TuringMachine::is_user_defined_marker (const symbol_mt& symbol_i) const
{
  return (symbol_i == get_user_defined_marker ());
}


// =========
bool TuringMachine::is_embedded_synchronous_tape_marker_s (const symbol_mt& symbol_i)
{
  return (symbol_i == get_embedded_synchronous_tape_marker_s ());
}


