/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3FieldDataException;
import helliker.id3.ID3Tag;
import helliker.id3.NullsoftID3GenreTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3v1Tag
implements ID3Tag {
    private final int TAG_SIZE = 128;
    private final int TITLE_SIZE = 30;
    private final int ARTIST_SIZE = 30;
    private final int ALBUM_SIZE = 30;
    private final int YEAR_SIZE = 4;
    private final int COMMENT_SIZE = 28;
    private final int TRACK_LOCATION = 126;
    private final int GENRE_LOCATION = 127;
    private final int MAX_GENRE = 255;
    private final int MAX_TRACK = 255;
    private final String TAG_START = "TAG";
    private File mp3 = null;
    private boolean headerExists = false;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private String comment = null;
    private int genre;
    private int track;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ID3v1Tag(File file) throws IOException, FileNotFoundException {
        this.mp3 = file;
        this.title = new String();
        this.artist = new String();
        this.album = new String();
        this.year = new String();
        this.comment = new String();
        this.genre = -1;
        this.track = -1;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            this.headerExists = this.checkHeader(randomAccessFile);
            if (this.headerExists) {
                this.readTag(randomAccessFile);
            }
            Object var4_3 = null;
            if (randomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (randomAccessFile == null) throw throwable;
            randomAccessFile.close();
            throw throwable;
        }
        randomAccessFile.close();
    }

    private boolean checkHeader(RandomAccessFile randomAccessFile) throws IOException, FileNotFoundException {
        boolean bl = false;
        if (randomAccessFile.length() > (long)128) {
            randomAccessFile.seek(randomAccessFile.length() - (long)128);
            byte[] byArray = new byte[3];
            if (randomAccessFile.read(byArray) != 3) {
                throw new IOException("Error encountered reading ID3 header");
            }
            String string = new String(byArray, 0, 3);
            bl = string.equals("TAG");
        }
        return bl;
    }

    private void readTag(RandomAccessFile randomAccessFile) throws IOException, FileNotFoundException {
        randomAccessFile.seek(randomAccessFile.length() - (long)128);
        byte[] byArray = new byte[128];
        randomAccessFile.read(byArray, 0, 128);
        String string = new String(byArray, 0, 128);
        int n = "TAG".length();
        this.title = this.chopSubstring(string, n, n += 30);
        this.artist = this.chopSubstring(string, n, n += 30);
        this.album = this.chopSubstring(string, n, n += 30);
        this.year = this.chopSubstring(string, n, n += 4);
        this.comment = this.chopSubstring(string, n, n += 28);
        this.track = byArray[126] & 0xFF;
        this.genre = byArray[127] & 0xFF;
    }

    private String chopSubstring(String string, int n, int n2) {
        String string2 = string.substring(n, n2);
        int n3 = string2.indexOf(0);
        if (n3 != -1) {
            string2 = string2.substring(0, n3);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTag() throws IOException, FileNotFoundException {
        block5: {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.mp3, "rw");
                if (this.headerExists) {
                    randomAccessFile.seek(randomAccessFile.length() - (long)128);
                } else {
                    randomAccessFile.seek(randomAccessFile.length());
                }
                randomAccessFile.write(this.getBytes());
                Object var3_2 = null;
                if (randomAccessFile == null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                throw throwable;
            }
            randomAccessFile.close();
        }
        this.headerExists = true;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[128];
        int n = 0;
        System.arraycopy("TAG".getBytes(), 0, byArray, n, "TAG".length());
        System.arraycopy(this.title.getBytes(), 0, byArray, n += "TAG".length(), this.title.length());
        System.arraycopy(this.artist.getBytes(), 0, byArray, n += 30, this.artist.length());
        System.arraycopy(this.album.getBytes(), 0, byArray, n += 30, this.album.length());
        System.arraycopy(this.year.getBytes(), 0, byArray, n += 30, this.year.length());
        System.arraycopy(this.comment.getBytes(), 0, byArray, n += 4, this.comment.length());
        byArray[126] = (byte)this.track;
        byArray[127] = (byte)this.genre;
        return byArray;
    }

    private byte[] getFieldBytes(String string, int n) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append('\u0000');
        }
        return stringBuffer.toString().getBytes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeTag() throws IOException, FileNotFoundException {
        if (this.headerExists) {
            block5: {
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(this.mp3, "rw");
                    Long l = new Long(randomAccessFile.length() - (long)128);
                    byte[] byArray = new byte[l.intValue()];
                    if (randomAccessFile.read(byArray) != l.intValue()) {
                        throw new IOException("Error encountered while removing tag");
                    }
                    randomAccessFile.setLength(l);
                    randomAccessFile.seek(0L);
                    randomAccessFile.write(byArray);
                    Object var5_4 = null;
                    if (randomAccessFile == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    throw throwable;
                }
                randomAccessFile.close();
            }
            this.headerExists = false;
        }
    }

    public String getGenreString() {
        return NullsoftID3GenreTable.getGenre(this.genre);
    }

    public boolean setGenreString(String string) {
        int n = NullsoftID3GenreTable.getGenre(string);
        boolean bl = false;
        if (n != -1) {
            this.genre = n;
            bl = true;
        }
        return bl;
    }

    public boolean tagExists() {
        return this.headerExists;
    }

    public String getTitle() {
        return this.title.trim();
    }

    public void setTitle(String string) {
        this.title = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getArtist() {
        return this.artist.trim();
    }

    public void setArtist(String string) {
        this.artist = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getAlbum() {
        return this.album.trim();
    }

    public void setAlbum(String string) {
        this.album = string.length() > 30 ? string.substring(0, 30) : string;
    }

    public String getYear() {
        return this.year.trim();
    }

    public void setYear(String string) {
        this.year = string.length() > 4 ? string.substring(0, 4) : string;
    }

    public String getComment() {
        return this.comment.trim();
    }

    public void setComment(String string) {
        this.comment = string.length() > 28 ? string.substring(0, 28) : string;
    }

    public int getTrack() {
        return this.track;
    }

    public void setTrack(int n) {
        if (n <= 255 && n >= 0) {
            this.track = n;
        }
    }

    public int getGenre() {
        return this.genre;
    }

    public void setGenre(int n) throws ID3FieldDataException {
        if (n > 255 || n < 0) {
            throw new ID3FieldDataException("Invalid genre value.  Must be between 0 and 255.");
        }
        this.genre = n;
    }

    public int getSize() {
        int n = 0;
        if (this.headerExists) {
            n = 128;
        }
        return n;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("ID3v1.1\nTagSize:\t\t\t").append(this.getSize()).append(" bytes\nTitle:\t\t\t\t").append(this.getTitle()).append("\nArtist:\t\t\t\t").append(this.getArtist()).append("\nAlbum:\t\t\t\t").append(this.getAlbum()).append("\nYear:\t\t\t\t").append(this.getYear()).append("\nComment:\t\t\t").append(this.getComment()).append("\nTrack:\t\t\t\t").append(this.getTrack()).append("\nGenre:\t\t\t\t").append(this.getGenreString())));
    }

    public void copyFrom(ID3Tag iD3Tag) {
    }
}

