/*
 * Decompiled with CFR 0.152.
 */
package javazoom.Util.ini;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javazoom.Util.ini.Alphabetizer;
import javazoom.Util.ini.Array;

public class SortedStrings
extends Alphabetizer
implements Cloneable {
    public static final int DEFAULT_SIZE = 32;
    private String[] strings;
    private int string_count;
    private double growth_rate = 2.0;

    public SortedStrings() {
        this.clear();
    }

    public SortedStrings(int n) {
        this.clear(n);
    }

    public SortedStrings(DataInput dataInput) throws IOException {
        int n = this.string_count = dataInput.readInt();
        this.strings = new String[n];
        String[] stringArray = this.strings;
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = dataInput.readUTF();
            ++n2;
        }
    }

    public SortedStrings(String[] stringArray) {
        this(stringArray.length);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.add(stringArray[n2]);
            ++n2;
        }
    }

    public Object clone() {
        try {
            SortedStrings sortedStrings = (SortedStrings)super.clone();
            sortedStrings.strings = (String[])this.strings.clone();
            return sortedStrings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void emit(DataOutput dataOutput) throws IOException {
        int n = this.string_count;
        String[] stringArray = this.strings;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeUTF(stringArray[n2]);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public SortedStrings merge(SortedStrings var1_1) {
        block5: {
            var2_2 = this.string_count;
            var3_3 = var1_1.string_count;
            var4_4 = this.strings;
            var5_5 = var1_1.strings;
            var8_6 = 0;
            var9_7 = 0;
            var10_8 = new SortedStrings(var2_2 + var3_3);
            while (var8_6 < var2_2 && var9_7 < var3_3) {
                var6_9 = var4_4[var8_6];
                var7_10 = var5_5[var9_7];
                if (Alphabetizer.compare(var6_9, var7_10) < 0) {
                    var10_8.add(var6_9);
                    ++var8_6;
                    continue;
                }
                if (Alphabetizer.compare(var7_10, var6_9) < 0) {
                    var10_8.add(var7_10);
                    ++var9_7;
                    continue;
                }
                var10_8.add(var6_9);
                ++var8_6;
                ++var9_7;
            }
            if (var8_6 >= var2_2) ** GOTO lbl31
            while (var8_6 < var2_2) {
                var10_8.add(var4_4[var8_6]);
                ++var8_6;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var10_8.add(var5_5[var9_7]);
                ++var9_7;
lbl31:
                // 2 sources

                ** while (var9_7 < var3_3)
            }
        }
        return var10_8;
    }

    public SortedStrings diff(SortedStrings sortedStrings) {
        int n = this.string_count;
        int n2 = sortedStrings.string_count;
        String[] stringArray = this.strings;
        String[] stringArray2 = sortedStrings.strings;
        int n3 = 0;
        int n4 = 0;
        SortedStrings sortedStrings2 = new SortedStrings(n);
        while (n3 < n && n4 < n2) {
            String string = stringArray[n3];
            String string2 = stringArray2[n4];
            if (Alphabetizer.compare(string, string2) < 0) {
                sortedStrings2.add(string);
                ++n3;
                continue;
            }
            if (Alphabetizer.compare(string2, string) < 0) {
                ++n4;
                continue;
            }
            ++n3;
            ++n4;
        }
        if (n3 < n) {
            while (n3 < n) {
                sortedStrings2.add(stringArray[n3]);
                ++n3;
            }
        }
        return sortedStrings2;
    }

    public void clear() {
        this.clear(32);
    }

    public void clear(int n) {
        this.strings = new String[n];
        this.string_count = 0;
    }

    public void add(String string) {
        if (this.string_count == 0 || Alphabetizer.greaterThan(string, this.strings[this.string_count - 1])) {
            if (this.string_count == this.strings.length) {
                this.strings = Array.grow(this.strings, this.growth_rate);
            }
            this.strings[this.string_count] = string;
            ++this.string_count;
        } else {
            this.insert(this.search(string), string);
        }
    }

    private void insert(int n, String string) {
        if (this.strings[n] == string) {
            return;
        }
        if (this.string_count == this.strings.length) {
            this.strings = Array.grow(this.strings, this.growth_rate);
        }
        System.arraycopy(this.strings, n, this.strings, n + 1, this.string_count - n);
        this.strings[n] = string;
        ++this.string_count;
    }

    public void remove(String string) {
        int n = this.search(string);
        if (n < this.string_count && Alphabetizer.equalTo(this.strings[n], string)) {
            this.removeIndex(n);
        }
    }

    public void removeIndex(int n) {
        if (n < this.string_count) {
            System.arraycopy(this.strings, n + 1, this.strings, n, this.string_count - n - 1);
            --this.string_count;
        }
    }

    public boolean contains(String string) {
        int n = this.search(string);
        return n < this.string_count && Alphabetizer.equalTo(this.strings[this.search(string)], string);
    }

    public int stringCount() {
        return this.string_count;
    }

    public int indexOf(String string) {
        int n = this.search(string);
        return n < this.string_count && Alphabetizer.equalTo(this.strings[n], string) ? n : -1;
    }

    public String stringAt(int n) {
        return this.strings[n];
    }

    protected int search(String string) {
        int n;
        String[] stringArray = this.strings;
        int n2 = 0;
        int n3 = this.string_count;
        while (true) {
            if (n2 >= n3 - 1) {
                if (n2 < this.string_count && !Alphabetizer.greaterThan(string, stringArray[n2])) {
                    return n2;
                }
                return n2 + 1;
            }
            n = (n2 + n3) / 2;
            String string2 = stringArray[n];
            if (Alphabetizer.greaterThan(string, string2)) {
                n2 = n + 1;
                continue;
            }
            if (!Alphabetizer.lessThan(string, string2)) break;
            n3 = n;
        }
        return n;
    }

    public String[] toStringArray() {
        String[] stringArray = new String[this.string_count];
        System.arraycopy(this.strings, 0, stringArray, 0, this.string_count);
        return stringArray;
    }

    public static String[] sort(String[] stringArray) {
        SortedStrings sortedStrings = new SortedStrings(stringArray);
        return sortedStrings.toStringArray();
    }
}

