/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.TDebug;
import org.tritonus.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.sampled.convert.TMatrixFormatConversionProvider;
import org.tritonus.sampled.file.MpegEncoding;

public class MpegFormatConversionProvider
extends TMatrixFormatConversionProvider {
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MpegEncoding.MPEG1L1, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS;

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        return new DecodedMpegAudioInputStream(this, targetFormat, audioInputStream);
    }

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        AudioFormat.Encoding enc;
        boolean conversion = super.isConversionSupported(targetFormat, sourceFormat);
        if (!conversion && (enc = sourceFormat.getEncoding()) instanceof MpegEncoding && (sourceFormat.getFrameRate() != (float)-1 || sourceFormat.getFrameSize() != -1)) {
            conversion = true;
        }
        return conversion;
    }

    static {
        t = true;
        f = false;
        CONVERSIONS = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};
    }

    public class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public DecodedMpegAudioInputStream(MpegFormatConversionProvider this$0, AudioFormat outputFormat, AudioInputStream inputStream) {
            super(inputStream, outputFormat, -1L);
            this.m_encodedStream = inputStream;
            this.m_bitstream = new Bitstream((InputStream)inputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(this, outputFormat.getChannels());
            this.m_decoder.setOutputBuffer((Obuffer)this.m_oBuffer);
        }

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("header is null (end of mpeg stream)");
                        }
                        this.m_circularBuffer.close();
                        return;
                    }
                    Obuffer decoderOutput = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.m_circularBuffer.write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException e) {
                    e.printStackTrace();
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out(e);
                    }
                }
                catch (DecoderException e) {
                    e.printStackTrace();
                    if (!TDebug.TraceAudioConverter) break block6;
                    TDebug.out(e);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public DMAISObuffer(DecodedMpegAudioInputStream this$1, int nChannels) {
                this.m_nChannels = nChannels;
                this.m_abBuffer = new byte[2304 * nChannels];
                this.m_anBufferPointers = new int[nChannels];
                this.reset();
                this.m_bIsBigEndian = this$1.isBigEndian();
            }

            public void append(int nChannel, short sValue) {
                byte bSecondByte;
                byte bFirstByte;
                if (this.m_bIsBigEndian) {
                    bFirstByte = (byte)(sValue >>> 8 & 0xFF);
                    bSecondByte = (byte)(sValue & 0xFF);
                } else {
                    bFirstByte = (byte)(sValue & 0xFF);
                    bSecondByte = (byte)(sValue >>> 8 & 0xFF);
                }
                this.m_abBuffer[this.m_anBufferPointers[nChannel]] = bFirstByte;
                this.m_abBuffer[this.m_anBufferPointers[nChannel] + 1] = bSecondByte;
                int n = nChannel;
                this.m_anBufferPointers[n] = this.m_anBufferPointers[n] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int nValue) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                for (int i = 0; i < this.m_nChannels; ++i) {
                    this.m_anBufferPointers[i] = i * 2;
                }
            }
        }
    }
}

