/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.log;

import com.rathedg.util.log.StreamLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;

public final class RotatingFileLogger
extends StreamLogger {
    public static final byte HOUR = 0;
    public static final byte DAY = 1;
    public static final byte MONTH = 2;
    byte period;
    boolean prefix;
    boolean usefileseparator;
    String filename;
    FileOutputStream out;
    short year;
    byte hour;
    byte day;
    byte month;
    char separator;

    public RotatingFileLogger(String string, byte by, boolean bl, boolean bl2) throws IOException {
        if (bl2 && !bl) {
            throw new IllegalArgumentException("prefix=false and usefileseparator=true can not be used together");
        }
        this.filename = string;
        this.period = by;
        this.prefix = bl;
        this.usefileseparator = bl2;
        this.separator = bl2 ? File.separatorChar : (char)46;
        this.setDateFields();
        String string2 = this.formatName();
        if (bl2) {
            new File(new File(string2).getParent()).mkdirs();
        }
        this.out = new FileOutputStream(string2, true);
        this.setStream(this.out);
    }

    public synchronized void log(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        short s = (short)gregorianCalendar.get(1);
        if (s != this.year) {
            this.reopen();
        } else if (this.period == 2) {
            if (gregorianCalendar.get(2) + 1 != this.month) {
                this.reopen();
            }
        } else if (this.period == 1) {
            if (gregorianCalendar.get(3) != this.month || gregorianCalendar.get(5) != this.day) {
                this.reopen();
            }
        } else if (gregorianCalendar.get(3) != this.month || gregorianCalendar.get(5) != this.day || gregorianCalendar.get(11) != this.hour) {
            this.reopen();
        }
        super.log(string);
    }

    private synchronized void reopen() {
        this.setDateFields();
        try {
            this.out.close();
            String string = this.formatName();
            if (this.usefileseparator) {
                new File(new File(string).getParent()).mkdirs();
            }
            this.out = new FileOutputStream(string, true);
            this.setStream(this.out);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(new GregorianCalendar() + " (" + this + ") error rotating log file: " + iOException.getMessage());
        }
    }

    private void setDateFields() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.hour = (byte)gregorianCalendar.get(11);
        this.day = (byte)gregorianCalendar.get(5);
        this.month = (byte)(gregorianCalendar.get(2) + 1);
        this.year = (short)gregorianCalendar.get(1);
    }

    private String formatName() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(this.year)).append(this.separator);
        if (this.month < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(this.month);
        if (this.period == 1) {
            stringBuffer.append(this.separator);
            if (this.day < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(this.day);
        } else if (this.period == 0) {
            stringBuffer.append(this.separator);
            if (this.day < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(this.day).append(this.separator);
            if (this.hour < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(this.hour);
        }
        if (this.prefix) {
            File file = new File(new File(this.filename).getCanonicalPath());
            String string = new File(file.getParent()).getPath() + File.separatorChar + stringBuffer;
            return string + "-" + file.getName();
        }
        return this.filename + "-" + stringBuffer;
    }

    public synchronized String toString() {
        try {
            return this.getClass().getName() + "(" + this.formatName() + ")";
        }
        catch (IOException iOException) {
            return this.getClass().getName() + "(exception occured while formatting name of log file)";
        }
    }
}

