/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.net;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class IP {
    private byte[] address;

    public IP(byte by, byte by2, byte by3, byte by4) {
        this.address = new byte[4];
        this.address[0] = by;
        this.address[1] = by2;
        this.address[2] = by3;
        this.address[3] = by4;
    }

    public IP(byte[] byArray) {
        this.address = byArray;
    }

    public IP(int n) {
        this.address = new byte[4];
        this.address[3] = (byte)(n >> 24 & 0xFF);
        this.address[2] = (byte)(n >> 16 & 0xFF);
        this.address[1] = (byte)(n >> 8 & 0xFF);
        this.address[0] = (byte)(n & 0xFF);
    }

    public byte[] getAddress() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IP)) {
            return false;
        }
        IP iP = (IP)object;
        return iP.address[0] == this.address[0] && iP.address[1] == this.address[1] && iP.address[2] == this.address[2] && iP.address[3] == this.address[3];
    }

    public int hashCode() {
        return this.toInt();
    }

    public String toString() {
        return String.valueOf(this.address[0] & 0xFF) + "." + String.valueOf(this.address[1] & 0xFF) + "." + String.valueOf(this.address[2] & 0xFF) + "." + String.valueOf(this.address[3] & 0xFF);
    }

    public int toInt() {
        return this.address[0] & 0xFF | (this.address[1] & 0xFF) << 8 | (this.address[2] & 0xFF) << 16 | (this.address[3] & 0xFF) << 24;
    }

    public static IP parse(String string) {
        if (string.indexOf("..") != -1) {
            return null;
        }
        if (string.charAt(0) == '.') {
            return null;
        }
        if (string.charAt(string.length() - 1) == '.') {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        byte[] byArray = new byte[4];
        try {
            int n = 0;
            while (n < 4) {
                short s = Short.parseShort(stringTokenizer.nextToken());
                if (s < 0 || s > 255) {
                    return null;
                }
                byArray[n] = (byte)s;
                n = (byte)(n + 1);
            }
            if (stringTokenizer.hasMoreTokens()) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        return new IP(byArray);
    }
}

