#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. System start/stop script.
#

#CACHALOT_HOME=/opt/cachalot

action()
{
	# if CACHALOT_HOME not defined
	if [ -z "$CACHALOT_HOME" ]; then
        PRG=$0
        # Resolve symlinks.
        while [ -L "$PRG" ]; do
            ls=`ls -ld "$PRG"`
            link=`expr "$ls" : '.*-> \(.*\)$'`
            if expr "$link" : '/' > /dev/null; then
                PRG="$link"
            else
                PRG="`dirname $PRG`/$link"
            fi
        done
        # define CACHALOT_HOME
        CACHALOT_HOME=`dirname "$PRG"`/..
	fi

    TRU=$CACHALOT_HOME/bin/tru_$1.sh
    if [ ! -r "$TRU" ]; then
        echo "Can't find file: $TRU."
        echo "This file is needed to run this program."
        echo
        exit 1
    fi

    ERU=$CACHALOT_HOME/bin/eru_$1.sh
    if [ ! -r "$TRU" ]; then
        echo "Can't find file: $ERU."
        echo "This file is needed to run this program."
        echo
        exit 1
    fi

    UIU=$CACHALOT_HOME/bin/uiu_$1.sh
    if [ ! -r "$UIU" ]; then
        echo "Can't find file: $UIU."
        echo "This file is needed to run this program."
        echo
        exit 1
    fi

    "$TRU"
    "$ERU"
    "$UIU"

    exit 0
}

case "$1" in
    'start' | 'stop')  action $1 ;;
    *)
        echo
        echo "RatheDG Cachalot System 1.2.0. System start/stop script."
        echo
        echo "Usage:"
        echo "     In order to start system use:    cachalot.sh start"
        echo "     In order to stop system use:     cachalot.sh stop"
        echo
        exit 0
esac
