#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. TRU stop script.
#
# Note:
#    1) System parameters marked as (!) MUST be configured by deployer.
#       System will not work if these parameters are not defined properly.
#
#    2) System parameters marked as (S) are important for system security.
#       It is recommended to configure them after initial system installation
#       and configuration.
#

#
# $SERVER is host where TRU is running.
# See 'shutdown.address' parameter in tru.conf.
#
SERVER=localhost

#
# $PORT is port which TRU is listening for shutdown request.
# See 'shutdown.port' parameter in tru.conf.
#
PORT=9007

#
# (S) $PASSWORD is TRU shutdown password.
# See 'shutdown.password' parameter in tru.conf.
#
PASSWORD=MyTRUShutdownPassword

# if CACHALOT_HOME not defined
if [ -z "$CACHALOT_HOME" ]; then
    PRG=$0
    # Resolve symlinks.
    while [ -L "$PRG" ]; do
        ls=`ls -ld "$PRG"`
        link=`expr "$ls" : '.*-> \(.*\)$'`
        if expr "$link" : '/' > /dev/null; then
            PRG="$link"
        else
            PRG="`dirname $PRG`/$link"
        fi
    done
    # define CACHALOT_HOME
    CACHALOT_HOME=`dirname "$PRG"`/..
fi

ENV=$CACHALOT_HOME/bin/environment.sh
if [ ! -r "$ENV" ]; then
    echo "Can't find file: $ENV."
    echo "This file is needed to run this program."
    echo
    exit 1
fi

. "$ENV"

$JAVA com.rathedg.cachalot.tru.Shutdown $SERVER $PORT $PASSWORD

