@rem
@rem RatheDG Cachalot System 1.2.0. System installation script.
@rem

@echo off

rem -- defaults --------------------------------------------------------------

set DEFAULT_LOG_DIR=c:\var\opt\cachalot

set DEFAULT_JAVA_DIST=c:\temp\cachalot-java-winnt.zip

set DEFAULT_TOMCAT_DIST=c:\temp\cachalot-tomcat.zip

set DEFAULT_JPCAP_DIST=c:\temp\cachalot-jpcap-winnt.zip

set DEFAULT_PGSQL_JDBC=c:\temp\cachalot-jdbc-pgsql.zip

goto select

rem -- logs ------------------------------------------------------------------

rem
rem Creates directory for log files.
rem
:logs

echo Creates directory for log files.
mkdir %DEFAULT_LOG_DIR%
if errorlevel 1 goto error

echo Done.

goto :EOF


rem -- java ------------------------------------------------------------------

rem
rem Installs and configures Java Runtime Environment 1.3.1_08.
rem
:java

set JAVA=%2
if "%JAVA%"=="" set JAVA=%DEFAULT_JAVA_DIST%

if exist "%JAVA%" goto JAVA_1
    echo Can't find file: %JAVA%.
    echo This file is needed to run this program.
    goto :EOF
:JAVA_1

echo Using CACHALOT_HOME:  %CACHALOT_HOME%
echo Using JAVA_INSTALL:   %JAVA%

echo Installing Java Runtime Environment 1.3.1_08.
unzip -qq "%JAVA%" -d "%CACHALOT_HOME%"
if errorlevel 1 goto error

echo Done.

goto :EOF


rem -- tomcat ----------------------------------------------------------------

rem
rem Installs and configures Jakarta Tomcat 4.1.24.
rem
:tomcat
set TOMCAT=%2
if "%TOMCAT%"=="" set TOMCAT=%DEFAULT_TOMCAT_DIST%

if exist "%TOMCAT%" goto TOMCAT_1
    echo Can't find file: %TOMCAT%.
    echo This file is needed to run this program.
    goto :EOF
:TOMCAT_1

echo Using CACHALOT_HOME:   %CACHALOT_HOME%
echo Using TOMCAT_INSTALL:  %TOMCAT%

echo Extracting Jakarta Tomcat 4.1.24.
unzip -qq "%TOMCAT%" -d "%CACHALOT_HOME%"
if errorlevel 1 goto error

echo Done.

goto :EOF


rem -- jpcap -----------------------------------------------------------------

rem
rem Installs and configures JPcap 0.01.13.
rem
:jpcap

set JPCAP=%2
if "%JPCAP%"=="" set JPCAP=%DEFAULT_JPCAP_DIST%

if exist "%JPCAP%" goto JPCAP_1
    echo Can't find file: %JPCAP%.
    echo This file is needed to run this program.
    goto :EOF
:JPCAP_1

echo Using CACHALOT_HOME:  %CACHALOT_HOME%
echo Using JPCAP_INSTALL:  %JPCAP%

echo Installing JPcap 0.01.13.
unzip -qq "%JPCAP%" -d "%CACHALOT_HOME%"
if errorlevel 1 goto error

echo Done.

goto :EOF


rem -- pgsql_jdbc ------------------------------------------------------------

rem
rem Installs JDBC driver for PostgreSQL.
rem
:pgsql_jdbc

set JDBC=%2
if "%JDBC%"=="" set JDBC=%DEFAULT_PGSQL_JDBC%

if exist "%JDBC%" goto JDBC_1
    echo Can't find file: %JDBC%.
    echo This file is needed to run this program.
    goto :EOF
:JDBC_1

echo Using CACHALOT_HOME:  %CACHALOT_HOME%
echo Using JDBC_INSTALL:   %JDBC%

echo Installing PostgreSQL JDBC driver.
unzip -qq "%JDBC%" -d "%CACHALOT_HOME%"
if errorlevel 1 goto error

echo Done.

goto :EOF


rem -- error -----------------------------------------------------------------

rem
rem .
rem
:error

echo Failed, status code = %ERRORLEVEL%
goto :EOF


rem -- select ----------------------------------------------------------------

:select

if not defined CACHALOT_HOME set CACHALOT_HOME=%~dp0..

if "%1" == "logs" goto logs
if "%1" == "java" goto java
if "%1" == "tomcat" goto tomcat
if "%1" == "jpcap" goto jpcap
if "%1" == "pgsql_jdbc" goto pgsql_jdbc

echo RatheDG Cachalot System 1.2.0 Installer.
echo Parameters:
echo     logs
echo         Creates directory for log files (c:\var\opt\cachalot)."
echo     java [cachalot-java]"
echo         Installs and configures Java Runtime Environment 1.3.1_08."
echo         * 'cachalot-java' is path to cachalot-java.zip file."
echo            Default value is c:\temp\cachalot-java.zip."
echo     tomcat [cachalot-tomcat]
echo         Installs and configures Jakarta Tomcat 4.1.24.
echo         * 'cachalot-tomcat' is path to cachalot-tomcat.zip file.
echo            Default value is c:\temp\cachalot-tomcat.zip.
echo     jpcap [cachalot-jpcap]"
echo         Installs and configures JPcap 0.01.13."
echo         * 'cachalot-jpcap' is path to cachalot-jpcap-winnt.zip file."
echo            Default value is c:\temp\cachalot-jpcap-winnt.zip."
echo     pgsql_jdbc [pgsql-jdbc]"
echo         Installs JDBC driver for PostgreSQL."
echo         * 'pgsql_jdbc' is path to cachalot-jdbc-pgsql.zip file."
echo            Default value is c:\temp\cachalot-jdbc-pgsql.zip."

