// #########################################################
// === File #10 of 14 : adapt.cpp ==========================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : adapt.cpp
//
//  DESCRIPTION :
//         Implementation of performeter's user-related classes
//
// ##############################################################

//===============
#include "adapt.h"
//===============


//#########################################
//#
//#  Template Functions	(Specialization)
//#  Prototypes is in file user.h
//#
//#########################################


//###############################################
//###############################################

#define	SEC_COFACTOR	1000

//===============================================
//=== clock_t, clock_t, RESOURCE_user_time_used
//===============================================

//=============================
template <>
string GetResourceStateUnitName<clock_t, clock_t, RESOURCE_user_time_used> ()
{
  return "clock";
}

template <>
string GetResourceCostUnitName<clock_t, clock_t, RESOURCE_user_time_used> ()
{
  return "clock";
}

template <>
string GetResourceName<clock_t, clock_t, RESOURCE_user_time_used> ()
{
  return "user time used";
}



//=============================
template <>
clock_t GetCurrentResource<clock_t, clock_t, RESOURCE_user_time_used>()
{
  return clock();
}

//=============================
template <>
clock_t GetDiffResourceValue<clock_t, clock_t, RESOURCE_user_time_used>(
		const clock_t&	start_resource_value_i, 
		const clock_t&	end_resource_value_i
		)
{
  return (end_resource_value_i - start_resource_value_i);
}

//=============================
template <>
bool ResourceValueIsSuspiciouslySmall<clock_t, clock_t, RESOURCE_user_time_used>(
		clock_t	cost_value_i 
		)
{
  return (cost_value_i == 0);
}



//=============================
template <>
bool ResourceValueIsSuspiciouslyBig<clock_t, clock_t, RESOURCE_user_time_used>(
		clock_t	cost_value_i 
		)
{
clock_t	shifted_value;
#define	BITS_IN_STOCK	2
const size_t	used_bits =  sizeof (cost_value_i) * CHAR_BIT - BITS_IN_STOCK;

  shifted_value = cost_value_i >> used_bits;

  return ((shifted_value == 0) ? false : true);
}



//===============================================
//=== uclock_t, uclock_t, RESOURCE_user_time_used
//===============================================

//=============================
template <>
string GetResourceStateUnitName<uclock_t, uclock_t, RESOURCE_user_time_used> ()
{
  return "uclock";
}

template <>
string GetResourceCostUnitName<uclock_t, uclock_t, RESOURCE_user_time_used> ()
{
  return "uclock";
}

template <>
string GetResourceName<uclock_t, uclock_t, RESOURCE_user_time_used> ()
{
  return "user time used";
}



//=============================
template <>
uclock_t GetCurrentResource<uclock_t, uclock_t, RESOURCE_user_time_used>()
{
  return uclock();
}

//=============================
template <>
uclock_t GetDiffResourceValue<uclock_t, uclock_t, RESOURCE_user_time_used>(
		const uclock_t&	start_resource_value_i, 
		const uclock_t&	end_resource_value_i
		)
{
  return (end_resource_value_i - start_resource_value_i);
}

//=============================
template <>
bool ResourceValueIsSuspiciouslySmall<uclock_t, uclock_t, RESOURCE_user_time_used>(
		uclock_t	cost_value_i 
		)
{
  return (cost_value_i == 0);
}



//=============================
template <>
bool ResourceValueIsSuspiciouslyBig<uclock_t, uclock_t, RESOURCE_user_time_used>(
		uclock_t	cost_value_i 
		)
{
uclock_t	shifted_value;
#define	BITS_IN_STOCK	2
const size_t	used_bits =  sizeof (cost_value_i) * CHAR_BIT - BITS_IN_STOCK;

  shifted_value = cost_value_i >> used_bits;

  return ((shifted_value == 0) ? false : true);
}


//###############################################
//###############################################
//===============================================
//=== timeval, double, RESOURCE_user_time_used
//===============================================



//=========================
bool operator== (const timeval& inst1_i, const timeval& inst2_i)
{
 return (
	(inst1_i.tv_sec == inst2_i.tv_sec)
	&&
 	(inst1_i.tv_usec == inst2_i.tv_usec)
	);
}

//=========================
bool operator< (const timeval& inst1_i, const timeval& inst2_i)
{
 if (inst1_i.tv_sec < inst2_i.tv_sec)	return true;
 if (inst1_i.tv_sec > inst2_i.tv_sec)	return false;

 return (inst1_i.tv_usec < inst2_i.tv_usec);

}

//=========================
bool operator<= (const timeval& inst1_i, const timeval& inst2_i)
{
  return ((inst1_i < inst2_i) || (inst1_i == inst2_i));

}

//=========================
ostream& operator<< (ostream& o, const timeval& instance_i)
{
  return o << "timeval-(" 
	   << instance_i.tv_sec
	   << " sec, "
	   << instance_i.tv_usec
	   << " usec )";
}



//=============================
//-----------------------------
template <>
string GetResourceStateUnitName<timeval, double, RESOURCE_user_time_used> ()
{
  return "timeval";
}

template <>
string GetResourceCostUnitName<timeval, double, RESOURCE_user_time_used> ()
{
ostringstream oss;
  oss << "microsec";
  if (SEC_COFACTOR != 1)
  {
    oss << "/" << SEC_COFACTOR;
  }
  oss << " (double)";

  return oss.str();
}

template <>
string GetResourceName<timeval, double, RESOURCE_user_time_used> ()
{
  return "user time used (via rusage)";
}


//-----------------------------
template <>
string GetResourceStateUnitName<timeval, ulonglong, RESOURCE_user_time_used> ()
{
  return "timeval";
}

template <>
string GetResourceCostUnitName<timeval, ulonglong, RESOURCE_user_time_used> ()
{
ostringstream oss;
  oss << "microsec";
  if (SEC_COFACTOR != 1)
  {
    oss << "/" << SEC_COFACTOR;
  }
  oss << " (unsigned long long)";

  return oss.str();
}

template <>
string GetResourceName<timeval, ulonglong, RESOURCE_user_time_used> ()
{
  return "user time used (via rusage)";
}



//===============================================
//-----------------------------------------------
template <>
timeval GetCurrentResource<timeval, double, RESOURCE_user_time_used>()
{
rusage cur_rusage;
  getrusage(RUSAGE_SELF, &cur_rusage);
  return cur_rusage.ru_utime;

}

//-----------------------------------------------
template <>
timeval GetCurrentResource<timeval, ulonglong, RESOURCE_user_time_used>()
{
rusage cur_rusage;
  getrusage(RUSAGE_SELF, &cur_rusage);
  return cur_rusage.ru_utime;

}


//=============================
template <>
double GetDiffResourceValue<timeval, double, RESOURCE_user_time_used>(
		const timeval&	start_resource_value_i, 
		const timeval&	end_resource_value_i
		)
{

double ret_value = 
	(
	  end_resource_value_i.tv_sec 
	  - 
	  start_resource_value_i.tv_sec
	)
	+ 
	(
	  end_resource_value_i.tv_usec 
	  -
	  start_resource_value_i.tv_usec
	)/ 1.0e6;

  ret_value *= SEC_COFACTOR;

  return ret_value;

}


template <>
ulonglong GetDiffResourceValue<timeval, ulonglong, RESOURCE_user_time_used>(
		const timeval&	start_resource_value_i, 
		const timeval&	end_resource_value_i
		)
{
  return static_cast<ulonglong> (GetDiffResourceValue<timeval, double, RESOURCE_user_time_used>(start_resource_value_i, end_resource_value_i));
}

//=============================
template <>
bool ResourceValueIsSuspiciouslySmall<timeval, double, RESOURCE_user_time_used>(
		double	cost_value_i 
		)
{
  return (cost_value_i == 0.0);
}

template <>
bool ResourceValueIsSuspiciouslySmall<timeval, ulonglong, RESOURCE_user_time_used>(
		ulonglong	cost_value_i 
		)
{
  return (cost_value_i == 0);
}


//=============================
template <>
bool ResourceValueIsSuspiciouslyBig<timeval, double, RESOURCE_user_time_used>(
		double	cost_value_i 
		)
{
  return (cost_value_i > 60.0 * 60.0 * 24.0 * 31.0);
}

//=============================
template <>
bool ResourceValueIsSuspiciouslyBig<timeval, ulonglong, RESOURCE_user_time_used>(
		ulonglong	cost_value_i 
		)
{
  return (cost_value_i > 60 * 60 * 24 * 31);
}



//###############################################
//###############################################

//===============================================
//=== AAA, BBB, RESOURCE_pseudo
//===============================================


//###################################################
//############## "Resource" Test Class ##############
//###################################################
//=========================
AAA::AAA () 
{
  //counter_ = ++counter_s; 
  a_value_ = random ();
}

//=========================
AAA::AAA (int a_value_i) 
{
  //counter_ = ++counter_s; 
  a_value_ = a_value_i;
}

//=========================
AAA::~AAA () 
{
}


//=========================
int AAA::get_a_value () const
{
  return a_value_;
}

//=========================
ostream& operator<< (ostream& o, const AAA& instance_i)
{
  return o << "AAA-" << instance_i.a_value_;
}
//----------------------
bool operator< (const AAA& inst1_i, const AAA& inst2_i)
{
  return (inst1_i.a_value_ < inst2_i.a_value_);
}
//----------------------
bool operator== (const AAA& inst1_i, const AAA& inst2_i)
{
  return (inst1_i.a_value_ == inst2_i.a_value_);
}
//----------------------
bool operator<= (const AAA& inst1_i, const AAA& inst2_i)
{
  return ((inst1_i < inst2_i) || (inst1_i == inst2_i));
}
//----------------------
AAA operator- (const AAA& inst1_i, const AAA& inst2_i)
{
AAA aaa;
  aaa.a_value_ = inst1_i.a_value_ - inst2_i.a_value_;
  if (aaa.a_value_ < 0) aaa.a_value_ = -aaa.a_value_;
  return aaa;
}



//###################################################
//############## "Source" Test Class ################
//###################################################
//=========================
BBB::BBB()
{
  // counter_ = ++counter_s;
  b_value_ = random () + 10;
}

//=========================
BBB::BBB(int b_value_i)
{
  // counter_ = ++counter_s;
  b_value_ = b_value_i;
}

//=========================
BBB::~BBB()
{
}
//=========================
int BBB::get_b_value () const
{
  return b_value_;
}

//=========================
BBB& BBB::operator+= (const BBB& inst_i)
{
  b_value_ += inst_i.b_value_;
  return (*this);
}

//=========================
ostream& operator<< (ostream& o, const BBB& instance_i)
{
  return o << "BBB-" << instance_i.b_value_;
}
//----------------------
bool operator< (const BBB& inst1_i, const BBB& inst2_i)
{
  return (inst1_i.b_value_ < inst2_i.b_value_);
}
//----------------------
bool operator== (const BBB& inst1_i, const BBB& inst2_i)
{
  return (inst1_i.b_value_ == inst2_i.b_value_);
}
//----------------------
bool operator<= (const BBB& inst1_i, const BBB& inst2_i)
{
  return ((inst1_i < inst2_i) || (inst1_i == inst2_i));
}
//----------------------
BBB operator- (const BBB& inst1_i, const BBB& inst2_i)
{
BBB bbb;
  bbb.b_value_ = inst1_i.b_value_ - inst2_i.b_value_;
  if (bbb.b_value_ < 0) bbb.b_value_ = -bbb.b_value_;
  return bbb;
}

//----------------------
BBB operator/ (const BBB& inst1_i, unsigned int int_value_i)
{
BBB bbb;
  bbb.b_value_ = inst1_i.b_value_/int_value_i;
  return bbb;
}


//=============================
template <>
string GetResourceStateUnitName<AAA, BBB, RESOURCE_pseudo> ()
{
  return "state-AAA-unit";
}

template <>
string GetResourceCostUnitName<AAA, BBB, RESOURCE_pseudo> ()
{
  return "cost-BBB-unit";
}

template <>
string GetResourceName<AAA, BBB, RESOURCE_pseudo> ()
{
  return "pseudo resource";
}


//===============================================
template <>
AAA GetCurrentResource<AAA, BBB, RESOURCE_pseudo>()
{
static int init_a_value = 125;
  init_a_value += 27000 + random ()%10000;
  return AAA(init_a_value);
}

//=============================
template <>
BBB GetDiffResourceValue<AAA, BBB, RESOURCE_pseudo>(
		const AAA&	start_resource_value_i, 
		const AAA&	end_resource_value_i
		)
{
AAA aaa;
  aaa = end_resource_value_i - start_resource_value_i;
  return BBB (3 * aaa.get_a_value());
  //return BBB ((aaa.get_a_value() * 1000)/start_resource_value_i.get_a_value());
}



//=============================
template <>
bool ResourceValueIsSuspiciouslySmall<AAA, BBB, RESOURCE_pseudo>(
		BBB	cost_value_i 
		)
{
  return false;
  return (cost_value_i.get_b_value() == 0);
}

//=============================
template <>
bool ResourceValueIsSuspiciouslyBig<AAA, BBB, RESOURCE_pseudo>(
		BBB	cost_value_i 
		)
{
uclock_t	shifted_value;
#define	BITS_IN_STOCK	2
const size_t	used_bits =  sizeof (cost_value_i.get_b_value()) * CHAR_BIT - BITS_IN_STOCK;

  shifted_value = (cost_value_i.get_b_value() >> used_bits);

  return ((shifted_value == 0) ? false : true);
}


//---------------------------
//###########################################


// ------------------- C++ code : END ----------------------
// === File #10 of 14 : adapt.cpp ==========================
