// #########################################################
// === File #12 of 14 : demo.cpp ===========================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : demo.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


//==============
#include "demo.h"
//==============


//#########################################
//#
//#  Function Implementation
//#  Prototypes are in file user.h
//#
//#########################################
//=============================
void SetEnvIt ()
{
  SetTotalTests (15);
  SetScaleAndTotalIterations (250000, 750000);
  SetDiscardingThreshold(0.17);

  SetDetailedMeasurementReportFlag(true);
  SetMeasurementReportFlag(true);
  //SetTracingReportFlag(true);
}


//=============================
void MeasureIt ()
{
  MeasureFunc (demo_10);
  MeasureFunc (demo_11);
}

//=============================
void CompareIt ()
{
  CompareFunc ("delete-new-string etc", demo_01);
  CompareFunc ("delete-new-string etc", demo_02);
  CompareFunc ("delete-new-string etc", demo_03);
  CompareFunc ("delete-new-string etc", demo_04);
  CompareFunc ("delete-new-string etc", demo_05);

  CompareFunc ("delete-new-string only", demo_05);
  CompareFunc ("delete-new-string only", demo_06);
  CompareFunc ("delete-new-string only", demo_07);
  CompareFunc ("delete-new-string only", demo_08);
  CompareFunc ("delete-new-string only", demo_09);

  CompareFunc ("strlen vs. string-size", get_string_size);

  CompareFunc ("ostrstream vs. ostringstream", write_to_stream);

} // CompareIt



//#########################################
//#
//#  Functions To Be Measured (Compared)
//#  Prototypes are in file demo.h
//#
//#########################################
//=============================
void demo_01 (void)
{
TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "do nothing") 
  {
  }
} // demo_01


//=============================
void demo_02 (void)
{

  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 40") 
  {
    delete new std::string("1234567890123456789012345678901234567890");
  }
} // demo_02


//=============================
void demo_03 (void)
{
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 4") 
  {
    delete new std::string("ABCD");
  }
} // demo_03 


//=============================
void demo_04 (void)
{
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 4 (10 times)") 
  {
    for (int i = 0; i < 10; i++)
    {
      delete new std::string("ABCD");
    }
  }
} // demo_04


//=============================
void demo_05 (void)
{
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 4 (20 times)") 
  {
    for (int i = 0; i < 20; i++)
    {
      delete new std::string("ABCD");
    }
  }
} // demo_05


//=============================
void demo_06 (void)
{
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF");
    }
  }

  {
  TURN_ON (timeval, double, RESOURCE_user_time_used, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF");
    }
  }

  {
  TURN_ON (timeval, ulonglong, RESOURCE_user_time_used, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF");
    }
  }


  {
  TURN_ON (AAA, BBB, RESOURCE_pseudo, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF");
    }
  }

} // demo_06


//=============================
void demo_07 (void)
{
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 9") 
    {
      delete new std::string("ABCDEF123");
    }
  }

} // demo_07


//=============================
void demo_08 (void)
{
  {
  TURN_ON (timeval, double, RESOURCE_user_time_used, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF123");
    }
  }

  {
  TURN_ON (timeval, ulonglong, RESOURCE_user_time_used, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF123");
    }
  }


} // demo_08

//=============================
void demo_09 (void)
{
  {
  TURN_ON (AAA, BBB, RESOURCE_pseudo, "delete new string of size 6") 
    {
      delete new std::string("ABCDEF123");
    }
  }

} // demo_09



//=============================
void demo_10 (void)
{
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "delete new string of size 5") 
  {
    delete new std::string("ABCDE");
  }
} // demo_10 


//=============================
void demo_11 (void)
{
char str[] = "ABCD";
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, "strlen-4") 
  {
    strlen(str);
  }
} // demo_11 

//###########################################

// ------------------- C++ code : END ----------------------
// === File #12 of 14 : demo.cpp ===========================
