// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_string.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============


// #########################################
#define CSTR0	"0123456789"
#define CSTR1	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
#define CSTR2	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"

static const size_t max_cstr_size = string(CSTR2).size();

// -------------------------------------------
#define NUMBER_OF_TEST_STRINGS	3
static const char* t_acstr[] = {CSTR0, CSTR1, CSTR2};
static vector<string> t_vstr (t_acstr, t_acstr + NUMBER_OF_TEST_STRINGS);
// -------------------------------------------


// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################


// =============================
void string_init1 (void)
{

const string htext__ptr_char               ("init char*            ");
const string htext__char_array             ("init char[]           ");

  // -------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    char* cstr			= const_cast<char*> (t_vstr[i].c_str());
    const size_t cstr_size	= string (cstr).size();

    assert (t_vstr[i].size() == strlen (cstr));

    {
      TURN_ON_DEFAULT_TIMER (htext__ptr_char, cstr_size) 
      {
        char* dummy = cstr;
      }
    }


    {
      switch (i)
      {
        case 0 :
          {
            TURN_ON_DEFAULT_TIMER (htext__char_array, string(CSTR0).size()) 
            {
              char dummy[] = CSTR0;
            }
	  }
          break;

        case 1 :
          {
            TURN_ON_DEFAULT_TIMER (htext__char_array, string(CSTR1).size()) 
            {
              char dummy[] = CSTR1;
            }
          }
          break;

        case 2 :
          {
            TURN_ON_DEFAULT_TIMER (htext__char_array, string(CSTR2).size()) 
            {
              char dummy[] = CSTR2;
            }
          }
          break;

	default :
          assert (0);
          break;
      }
    }

  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // string_init1



// =============================
void string_init2 (void)
{

const string htext__malloc_and_free        ("malloc & free         ");
const string htext__malloc_strcpy_and_free ("(malloc+strcpy) & free");
const string htext__malloc_memset_and_free ("(malloc+memset) & free");
const string htext__ctor_and_dtor          ("ctor & dtor           ");
const string htext__new_and_delete         ("new & delete          ");

  // -------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    char* cstr			= const_cast<char*> (t_vstr[i].c_str());
    const size_t cstr_size	= string (cstr).size();
    const size_t cstr_size1	= cstr_size + 1;

    assert (t_vstr[i].size() == strlen (cstr));


    {
      TURN_ON_DEFAULT_TIMER (htext__malloc_and_free, cstr_size) 
      {
        free (malloc (cstr_size));
      }
    }


    {
      TURN_ON_DEFAULT_TIMER (htext__malloc_strcpy_and_free, cstr_size) 
      {
        char* dummy = (char*) malloc (cstr_size1);
        strcpy (dummy, cstr);
        free (dummy);
      }
    }

  
    {
      TURN_ON_DEFAULT_TIMER (htext__malloc_memset_and_free, cstr_size) 
      {
        char* dummy = (char*) malloc (cstr_size);
        memset (dummy, 0, cstr_size);
        free (dummy);
      }
    }
  

    {
      TURN_ON_DEFAULT_TIMER (htext__ctor_and_dtor, cstr_size) 
      {
        string (cstr);
      }
    }    

    {
      TURN_ON_DEFAULT_TIMER (htext__new_and_delete, cstr_size) 
      {
        delete (new string (cstr));
      }
    }    
  
  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // string_init2



// =============================
void string_treat1 (void)
{
string sstore;

#define INCREASE_TIMES 100
const size_t malloc_size = INCREASE_TIMES * max_cstr_size + 1;
const size_t erase_index = malloc_size - max_cstr_size - 1;
  assert (erase_index + max_cstr_size < malloc_size);

char* cstore = (char*) malloc (malloc_size);
  assert (!(cstore == NULL));

const string htext__strcpy                                ("strcpy                ");
const string htext__assignation_operator                  ("operator=             ");
const string htext__strcat                                ("strcat                ");
const string htext__plus_assignation_operator             ("operator+=            ");
const string htext__plus_operator                         ("operator+             ");


  // -------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    string str (t_vstr[i]);
    char* cstr			= const_cast<char*> (str.c_str());
    const size_t cstr_size	= string (cstr).size();
    assert (str.size() == cstr_size);

    assert (str.size() == strlen (cstr));

    {
      TURN_ON_DEFAULT_TIMER (htext__strcpy, cstr_size) 
      {
        strcpy (cstore, cstr);
      }
    }


    {
      TURN_ON_DEFAULT_TIMER (htext__assignation_operator, cstr_size) 
      {
        sstore = str;
      }
    }


    {
      cstore[0] = 0; 
      TURN_ON_DEFAULT_TIMER (htext__strcat, cstr_size) 
      {
        strcat (cstore, cstr);
        cstore [0] = 0;
      }
    }


    {
      sstore.erase();
      TURN_ON_DEFAULT_TIMER (htext__plus_assignation_operator, cstr_size) 
      {
        sstore += str;
        sstore.erase();
      }
    }


    {
      sstore.erase();
      TURN_ON_DEFAULT_TIMER (htext__plus_operator, cstr_size) 
      {
        sstore = sstore + str;
        sstore.erase();
      }
    }

  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // string_treat1



// =============================
void string_treat2 (void)
{
string sstore;

#define INCREASE_TIMES 100
const size_t malloc_size = INCREASE_TIMES * max_cstr_size + 1;
const size_t erase_index = malloc_size - max_cstr_size - 1;
  assert (erase_index + max_cstr_size < malloc_size);

char* cstore = (char*) malloc (malloc_size);
  assert (!(cstore == NULL));

const string htext__accumulated_strcat                    ("accumulated strcat    ");
const string htext__accumulated_plus_assignation_operator ("accumulated operator+=");
const string htext__accumulated_plus_operator             ("accumulated operator+ ");



  // -------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    string str (t_vstr[i]);
    char* cstr			= const_cast<char*> (str.c_str());
    const size_t cstr_size	= string (cstr).size();
    assert (str.size() == cstr_size);

    assert (str.size() == strlen (cstr));


    {
      cstore[0] = 0; 
      TURN_ON_DEFAULT_TIMER (htext__accumulated_strcat, cstr_size) 
      {
        strcat (cstore, cstr);
        cstore [erase_index] = 0;
      }
    }


    {
      sstore.erase();
      TURN_ON_DEFAULT_TIMER (htext__accumulated_plus_assignation_operator, cstr_size) 
      {
        sstore += str;
        sstore.erase((sstore.size() > erase_index) ? erase_index : sstore.size());
      }
    }

    {
      sstore.erase();
      TURN_ON_DEFAULT_TIMER (htext__accumulated_plus_operator, cstr_size) 
      {
        sstore = sstore + str;
        sstore.erase((sstore.size() > erase_index) ? erase_index : sstore.size());
      }
    }
  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // string_treat2




// =============================
void string_len (void)
{
const string htext__strlen            ("strlen       ");
const string htext__string_size       ("string.size()");



  // -------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    string str (t_vstr[i]);
    char* cstr			= const_cast<char*> (str.c_str());
    const size_t cstr_size	= string (cstr).size();

    assert (str.size() == strlen (cstr));

    {
      TURN_ON_DEFAULT_TIMER (htext__strlen, cstr_size) 
      {
        strlen (cstr);
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__string_size, cstr_size) 
      {
        str.size();
      }
    }
  
  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // string_len



///////////////
// End-Of-File
///////////////

