<%@ Language=VBScript %>
<%Option Explicit%>
<%
'On Error Resume Next
Response.Expires = -1

' check whether the logged on user can access this page
If Session("AppUserID") = "" Then
	Response.Redirect "UserLogon.asp"
End If

If Session("AppRoleID") <> 1 Then ' not an admin
	Response.Redirect "Error.asp?err=User has no permissions to access this page&backto=UserLogon.asp"
	Response.End
End If

Const cPageTitle = "Create Alert"

Dim m_debugText

Dim objReports
Set objReports = Server.CreateObject("GsElgReportsCom.Reports")

Dim m_FeedbackMessage
Dim m_actionType ' determines what action type should be taken before rendering the page
Dim m_AlertDesc
Dim m_AlertMetaData
Dim nRetVal
Dim m_alertHdrID
Dim m_alertSql

' filter display strings
Dim m_ServerLogTypeFilterText
Dim m_ELSourceText
Dim m_EventTypeText
Dim m_EventCategoryText
Dim m_EventIDText

' recipient schedule strings
Dim m_AlertRecipientID
Dim m_Email
Dim m_Days(7)
Dim m_radioScheduleHours
Dim m_FromHours
Dim m_FromMinutes
Dim m_FromAmPm
Dim m_ToHours
Dim m_ToMinutes
Dim m_ToAmPm
Dim m_scheduleDaysMeta
Dim i
Dim ic

m_FeedbackMessage = ""
m_radioScheduleHours = "24"
m_FromHours = 9
m_FromMinutes = 0
m_FromAmPm = "AM"
m_ToHours = 5
m_ToMinutes = 0
m_ToAmPm = "PM"
m_scheduleDaysMeta = 0

m_actionType = Request.Form("hActionType")

' do we have an existing alert?
m_alertHdrID = Request("hAlertHdrID")

If m_alertHdrID = "" Then
	m_alertHdrID = -1	' new alert
End If

If m_actionType = "Change Alert Criteria" Then	' user is comming from the same page after clicking on "Change Alert Criteria"
	' 1) get the submitted form with the alert criteria
	' 2) create or update the alert hdr 
	' 3) redirect to the reports page
	
	' get the submitted form
	SubmittedFormGet m_AlertMetaData, true
	m_AlertDesc = Request.Form("textAlertDesc")

	' create or update the hdr
	nRetVal = objReports.AlertHdrUpdate(Session("AppUserID"), m_AlertDesc, m_AlertMetaData, m_alertHdrID)
	If nRetVal < 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
		Response.End
	End If

	' no errors - retrieve the hdr id and redirect to the reports page
	' append the alert hdr id
	m_AlertMetaData = m_AlertMetaData & "<INPUT TYPE=""HIDDEN"" NAME=""hAlertHdrID"" VALUE=""" & m_alertHdrID & """ />"

	' write the form and redirect to the reports page
	Response.Write "<HTML><HEAD><SCRIPT language=""javascript"">" & chr(10)
	Response.Write "function BodyOnLoad(){" & chr(10) & "frmMain.submit();" & chr(10) & "}" & chr(10)
	Response.Write "</SCRIPT></HEAD><BODY onload=""BodyOnLoad()"">" & chr(10)
	Response.Write "<FORM name=""frmMain"" action=""GsElgReportPage.asp"" method=""post"">"
	' write the form contents
	Response.Write m_AlertMetaData
	Response.Write "</FORM></BODY></HTML>"
	Response.End
ElseIf m_actionType = "Update Recipient" Then ' save the currently edited alert recipient
	' 1) update the recipient and the corresponding schedule in the database
	' 2) get the alert hdr info and display it

	' get the recipient-related form values
	m_AlertRecipientID = Request.Form("hAlertRecipientID")
	'Response.Write "m_AlertRecipientID " & m_AlertRecipientID 
	m_Email = Request.Form("textEmail")
	For i=1 To 7
		m_Days(i) = Request.Form("chk_Days" & Cstr(i))
	Next
	m_radioScheduleHours = Request.Form("rScheduleHours")
	m_FromHours = Request.Form("cbo_FromHours")
	m_FromMinutes = Request.Form("cbo_FromMinutes")
	m_FromAmPm = Request.Form("cbo_FromAmPm")
	m_ToHours = Request.Form("cbo_ToHours")
	m_ToMinutes = Request.Form("cbo_ToMinutes")
	m_ToAmPm = Request.Form("cbo_ToAmPm")
	
	RecipientUpdate()
	
	' reset the global variables = prepare for the next recipient
	m_Email = ""
	m_AlertRecipientID = ""
	m_radioScheduleHours = "24"
	m_FromHours = 9
	m_FromMinutes = 0
	m_FromAmPm = "AM"
	m_ToHours = 5
	m_ToMinutes = 0
	m_ToAmPm = "PM"
	m_scheduleDaysMeta = 0
	
ElseIf m_actionType = "Remove Recipient" Then ' removes a recipient from the list
	' 1) Remove the recipient from the database
	' 2) get the alert hdr info and display it
	m_AlertRecipientID = Request.Form("hAlertRecipientID")
	nRetVal = objReports.AlertRecipientRemove(m_alertHdrID, m_AlertRecipientID)
	If nRetVal < 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
		Response.End
	End If
	
	' reset the current recipient id (removed)
	m_AlertRecipientID = ""
ElseIf m_actionType = "Edit Recipient" Then ' Retrieves the recipient info for editing and
	' 1) Get the recipient info
	m_AlertRecipientID = Request.Form("hAlertRecipientID")
	' no need of doing anything else - when displaying the schedule
	' the code will detect that one alert is in focus
ElseIf m_actionType = "Save Alert" Then ' save the alert
	' response.Write "m_actionType " & m_actionType
	' 1) get the submitted form with the alert criteria
	' 2) update the alert hdr
	' 3) set the alert status to active
	' 3) redirect to the alert list page
		
	' get the submitted form
	SubmittedFormGet m_AlertMetaData, true
	m_AlertDesc = Request.Form("textAlertDesc")

	' update the hdr
	nRetVal = objReports.AlertHdrUpdate(Session("AppUserID"), m_AlertDesc, m_AlertMetaData, m_alertHdrID)
	' update the alert status to "active"

	nRetVal = objReports.AlertHdrSetStatus(m_alertHdrID, 1)
	If nRetVal < 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
		Response.End
	Else
		' write the form and redirect to the alert list page
		Response.Write "<script>document.location.href = 'AlertList.asp';</script>"
		Response.End
	End If
End If

'******** do the following whenever we load this page

' make all days selections checked by default
For i=1 To 7
	m_Days(i) = "checked"
Next

' get the form params
SubmittedFormGet m_AlertMetaData, true
m_AlertDesc = Request.Form("textAlertDesc")

If m_AlertMetaData <> "" Then ' came from the reports page or refreshing this page after updating alert recipient
	'update the hdr
	nRetVal = objReports.AlertHdrUpdate(Session("AppUserID"), m_AlertDesc, m_AlertMetaData, m_alertHdrID)
ElseIf m_alertHdrID = -1 And m_AlertMetaData = "" Then ' this should not happen - user entered incorrect query string
	Response.Write "<script>document.location.href = 'Error.asp?err=This alert does not exist&backto=AlertList.asp';</script>"
	Response.End
End If

If nRetVal < 0 Then
	Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
	Response.End
End If

' display the hdr info 
m_AlertMetaData = ""
'response.Write m_alertHdrID
response.Flush
nRetVal = objReports.AlertHdrGet(m_alertHdrID, m_AlertDesc, m_AlertMetaData)

m_AlertMetaData = m_AlertMetaData & "<INPUT TYPE=""HIDDEN"" NAME=""hAlertHdrID"" VALUE=""" & m_alertHdrID & """ />"


If nRetVal < 0 Then
	Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
	Response.End
End If

nRetVal = AlertCriteriaGet(m_AlertMetaData)

' ******************************************************
' SERVER FUNCTIONS
' ******************************************************

Function AlertScheduleDisplay(alertHdrID)
	Dim sXml
	Dim objXml
	Dim node
	Dim nodeList
	Dim buffer
	Dim bgColor
	
	AlertScheduleDisplay = objReports.AlertScheduleGet(alertHdrID, sXml)
	If AlertScheduleDisplay < 0 Then
		Exit Function
	Else
'		Response.Write Server.HTMLEncode(sXml)
		Set objXml = Server.CreateObject("Microsoft.XMLDom")
		objXml.loadXml(sXml)
		Set nodeList = objXml.documentElement.selectNodes("ALERTRECIPIENT")
		
		bgColor = "white"
		
		For Each node In nodeList
			If node.getAttribute("AlertRecipientID") = m_AlertRecipientID Then ' set focus on the selected recipient
				buffer = "<TR style=""background:silver;color:red"">"

				m_Email = node.getAttribute("Email")
				m_alertRecipientID = node.getAttribute("AlertRecipientID")
				If node.getAttribute("ScheduleTimeDisplay") = "24 hours" Then ' 24 hours
					m_radioScheduleHours = "24"
				Else
					m_radioScheduleHours = "0"
				End If

				m_FromHours = node.getAttribute("StartHour")
				m_FromMinutes = node.getAttribute("StartMinute")
				m_FromAmPm = node.getAttribute("StartAmPm")
				m_ToHours = node.getAttribute("EndHour")
				m_ToMinutes = node.getAttribute("EndMinute")
				m_ToAmPm = node.getAttribute("EndAmPm")
				m_scheduleDaysMeta = node.getAttribute("ScheduleDaysMeta")
				
				For i = 1 To 7
'					Response.Write 2^(i-1) & " " & m_scheduleDaysMeta & " " & (2^(i-1) And CLng(m_scheduleDaysMeta)) & "<br>"
					If (2^(i-1) And CLng(m_scheduleDaysMeta)) > 0 Then
						m_days(i) = "checked"
					Else
						m_days(i) = ""
					End If
				Next
			Else
				buffer = "<TR style=""background:" & bgColor & """>"
			End If
			buffer = buffer & "<TD>" & node.getAttribute("Email") & "</TD>"
			buffer = buffer & "<TD>" & node.getAttribute("ScheduleDaysDisplay") & "</TD>"
			buffer = buffer & "<TD>" & node.getAttribute("ScheduleTimeDisplay") & "</TD>"
			buffer = buffer & "<TD><A href=""javascript:RecipientEdit('" & node.getAttribute("AlertRecipientID") & "')"">Edit</A></TD>"
			buffer = buffer & "<TD><A href=""javascript:RecipientRemove('" & node.getAttribute("AlertRecipientID") & "')"">Remove</A></TD>"
	
			buffer = buffer & "</TR>"
			Response.Write buffer
			buffer = ""
			If bgColor = "whitesmoke" Then
				bgColor = "white"
			Else
				bgColor = "whitesmoke"
			End If
		Next
	End If

End Function

Function RecipientUpdate()
	Dim objXml
	Dim rootEl
	Dim el
	
	Set objXml = Server.CreateObject("Microsoft.XMLDom")
	objXml.loadXml("<ALERTSCHEDULE />")
	Set rootEl = objXml.documentElement

	Call rootEl.setAttribute("AlertHdrID", m_alertHdrID)
	Call rootEl.setAttribute("AlertRecipientID", m_AlertRecipientID)
	Call rootEl.setAttribute("Email", m_Email)
	
	If m_radioScheduleHours <> 24 Then
		Call rootEl.setAttribute("ScheduleStartTime", CStr(m_FromHours) & ":" & CStr(m_FromMinutes) & " " & CStr(m_FromAmPm))
		Call rootEl.setAttribute("ScheduleEndTime", CStr(m_ToHours) & ":" & CStr(m_ToMinutes) & " " & CStr(m_ToAmPm))
	Else
		Call rootEl.setAttribute("ScheduleStartTime", "")
		Call rootEl.setAttribute("ScheduleEndTime", "")
	End If

	For i=1 To 7
		If m_Days(i) <> "" Then
			Set el = objXml.CreateElement("SCHEDULEDAY")
			Call el.setAttribute("DayName", m_Days(i))
			Call el.setAttribute("DayValue", i-1)
			rootEl.appendChild(el)
		End If
	Next

'	response.Write server.HTMLEncode(objXml.xml)
	nRetVal = objReports.AlertRecipientUpdate(objXml.xml)
'	response.Write "nRetVal " & nRetVal
	If nRetVal < 0 Then
		Response.Write "<script>alert('Error inserting new recipient duplicate email address')</script>"
	End If

End Function

Function AlertCriteriaGet(alertMetaData)
	Dim nRetVal
	Dim objCriteria
	Dim sXml
	Dim buffer
	Dim objXml
	Dim node
	Dim childNodes
	Dim curNode
	Dim cr

	Set objXml = Server.CreateObject("Microsoft.XMLDom")

	Set objCriteria = Server.CreateObject("Microsoft.XMLDom")
	objCriteria.loadXml("<QueryParameters />")
	
	' get the query string params and load them into the XML tree
	nRetVal = GatherQueryParameters(objCriteria, alertMetaData)
	'Response.Write Server.HTMLEncode(objCriteria.xml )
	'Response.Flush

	' generate SQL query
	nRetVal = objReports.SqlForAlertGenerate(m_alertHdrID, m_alertSql)
'	nRetVal = objReports.SqlForAlertGenerate(m_alertHdrID, m_alertSql, objCriteria.documentElement.xml)
	If nRetVal <> 0 Then
		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
		Response.End
	End If

	' get the server and log types in XML format
	buffer = objCriteria.documentElement.getAttribute("ServerLogTypeFilter")
	cr = ""
	If buffer <> "" Then
		objReports.ServerLogTypeFilterListGet buffer, sXml
		objXml.loadXml (sXml)
		Set childNodes = objXml.documentElement.childNodes
		curNode = ""
		For Each node in childNodes
			buffer = node.getAttribute("ServerName") 
			If curNode <> buffer Then
				curNode = buffer
				m_ServerLogTypeFilterText = m_ServerLogTypeFilterText & cr & "<b>" & buffer & "</b> - "
				m_ServerLogTypeFilterText = m_ServerLogTypeFilterText & node.getAttribute("LogTypeName")
				cr = "<br>"
			Else
				m_ServerLogTypeFilterText = m_ServerLogTypeFilterText & ", " & node.getAttribute("LogTypeName")
			End If
		Next
	Else
		m_ServerLogTypeFilterText = "All"
	End If

	' get the source names in XML format
	buffer = objCriteria.documentElement.getAttribute("ELSource")
	
	If buffer <> "" Then
		sXml = ""
		objReports.EventSourceListGet buffer, sXml
		objXml.loadXml (sXml)
		Set childNodes = objXml.documentElement.childNodes
		cr = ""
		For Each node in childNodes
			m_ELSourceText = m_ELSourceText & cr & node.getAttribute("ELSourceName")
			cr = "<br>"
		Next
	Else
		m_ELSourceText = "All"
	End If

	' get the event types in XML format
	buffer = objCriteria.documentElement.getAttribute("EventType")
	
	If buffer <> "" Then
		sXml = ""
		objReports.EventTypeListGet buffer, sXml
		
		objXml.loadXml (sXml)
		Set childNodes = objXml.documentElement.childNodes
		cr = ""
		For Each node in childNodes
			m_EventTypeText = m_EventTypeText & cr & node.getAttribute("EventTypeName")
			cr = "<br>"
		Next
	Else
		m_EventTypeText = "All"
	End If

	' get the event categories in XML format
	buffer = objCriteria.documentElement.getAttribute("EventCategory")
	
	If buffer <> "" Then
		sXml = ""
		objReports.EventCategoryListGet buffer, sXml
		
		objXml.loadXml (sXml)
		Set childNodes = objXml.documentElement.childNodes
		cr = ""
		For Each node in childNodes
			m_EventCategoryText = m_EventCategoryText & cr & node.getAttribute("EventCategoryName")
			cr = "<br>"
		Next
	Else
		m_EventCategoryText = "All"
	End If

	' get event id's to include/exclude
	buffer = objCriteria.documentElement.getAttribute("EventID")
	
	If buffer <> "" Then
		m_EventIDText = buffer
		buffer = objCriteria.documentElement.getAttribute("EventIDExclude")
		If buffer = "exclude" Then
			m_EventIDText = "<font color=""red"">Exclude:&nbsp;</font>" & m_EventIDText
		Else
			m_EventIDText = "<font color=""green"">Include:&nbsp;</font>" & m_EventIDText
		End If
	Else
		m_EventIDText = "All"
	End If

End Function

Function GatherQueryParameters(ByRef objCriteria, ByRef alertMetaData)
	Dim curEl
	Dim nRetVal
	Dim metaEl
	Dim criteriaEl
	Dim buffer

	Dim sXmlMetaData
	Dim objMetaData

	Set objMetaData = Server.CreateObject("Microsoft.XMLDom")

	' load form elements into XML tree
	objMetaData.loadXml("<MetaData>" & alertMetaData & "</MetaData>")
	
	Set criteriaEl = objCriteria.documentElement

	' set query parameters
	Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='hServerLogTypeFilter']")
	Call criteriaEl.setAttribute("ServerLogTypeFilter", curEl.getAttribute("value"))

	Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='hELSource']")
	If Not curEl Is Nothing Then
		buffer = curEl.getAttribute("value")
		If InStr(1, buffer, "All") <= 0 Then
			Call criteriaEl.setAttribute("ELSource", buffer)
		End If
	End If

	Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='hEventType']")
	If Not curEl Is Nothing Then
		buffer = curEl.getAttribute("value")
		If InStr(1, buffer, "All") <= 0 Then
			Call criteriaEl.setAttribute("EventType", buffer)
		End If
	End If

	Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='chk_EventID']")
	If Not curEl Is Nothing Then ' filter by event id
		Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='radio_EventIDExclude']")
		If curEl Is Nothing Then ' include ID's
			Call criteriaEl.setAttribute("EventIDExclude", "include")
		Else
			Call criteriaEl.setAttribute("EventIDExclude", curEl.getAttribute("value"))
		End If
	
		Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='txtEventID']")
		Call criteriaEl.setAttribute("EventID", curEl.getAttribute("value"))
	End If

	Set curEl = objMetaData.documentElement.selectSingleNode("//INPUT[@name='hEventCategory']")
	If Not curEl Is Nothing Then
		buffer = curEl.getAttribute("value")
		If InStr(1, buffer, "All") <= 0 Then
			Call criteriaEl.setAttribute("EventCategory", buffer)
		End If
	End If
End Function

Sub SubmittedFormGet(ByRef alertMetaData, bFilter)
	Dim formItem
	
	For Each formItem In Request.Form
		If bFilter = true Then
			If formItem <> "" And _
					formItem <> "textAlertDesc" And _
					formItem <> "hSavedReportDescription" And _
					formItem <> "hAlertHdrID" And _
					formItem <> "hAlertRecipientID" And _
					formItem <> "hAlertSql" And _
					formItem <> "textEmail" And _
					formItem <> "rScheduleHours" And _
					formItem <> "cbo_FromHours" And _
					formItem <> "cbo_FromMinutes" And _
					formItem <> "cbo_FromAmPm" And _
					formItem <> "cbo_ToHours" And _
					formItem <> "cbo_ToMinutes" And _
					formItem <> "cbo_ToAmPm" And _
					InStr(1,formItem, "chk_Days") < 1 And _
					formItem <> "hActionType" Then
				alertMetaData = alertMetaData & chr(10) & "<INPUT TYPE=""hidden"" name=""" & formItem & """ value=""" & Request.Form(formItem) & """ />"
			End If
		Else
			alertMetaData = alertMetaData & chr(10) & "<INPUT TYPE=""hidden"" name=""" & formItem & """ value=""" & Request.Form(formItem) & """ />"
		End If
	Next
End Sub


%>
<!--
GsElg Reports Version 1.5 
Copyright 2002-2003 Gravity Square, Inc. - http://www.gravitysquare.com
Developed by Alpentia Software. Inc. - http://www.alpentia.com
-->
<HTML>
	<HEAD>
		<TITLE>GsElg Reports -
			<%=cPageTitle%>
		</TITLE>
		<LINK rel="STYLESHEET" href="stylesheets/style.css"></LINK>
		<SCRIPT language="JavaScript">

function QuerySubmit(){
	var el = event.srcElement
	alert(el.name);
	if(FormValidate() == false){
		return false;
	}

	return true;
}

function FormValidate(){
	var s;
	//re = / /g;
	
	s = TrimString(frmMain.textAlertDesc.value)
	if(s == ''){
		alert('Enter alert description');
		return false;
	}
	frmMain.textAlertDesc.value = s

	return true;
}

function AlertCriteriaChange(){
	frmMain.hActionType.value = 'Change Alert Criteria';
	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return true;
}

function RecipientAddUpdate(action){
	if(action == 'new'){
		frmMain.hAlertRecipientID.value = '';
	}

	var s = TrimString(frmMain.textEmail.value);
	if(s == '' || !IsValidEmail(s)){
		alert('Enter valid email address');
		return;
	}
		
	if(	!frmMain.chk_Days1.checked
		&& !frmMain.chk_Days2.checked
		&& !frmMain.chk_Days3.checked
		&& !frmMain.chk_Days4.checked
		&& !frmMain.chk_Days5.checked
		&& !frmMain.chk_Days6.checked
		&& !frmMain.chk_Days7.checked 
			){
		alert('At least one day has to be checked');
		return;
	}

	frmMain.hActionType.value = 'Update Recipient';
	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return;
}

function RecipientRemove(alertRecipientID){
	frmMain.hAlertRecipientID.value = alertRecipientID;
	frmMain.hActionType.value = 'Remove Recipient';
	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return true;
}

function RecipientEdit(alertRecipientID){
	frmMain.hAlertRecipientID.value = alertRecipientID;
	frmMain.hActionType.value = 'Edit Recipient';
	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return true;
}

function SaveAlertOnClick(){
	if(FormValidate() == false){
		return false;
	}
	frmMain.hActionType.value = 'Save Alert';
	frmMain.action = 'AlertDetail.asp';
	frmMain.submit();
	return true;
}

// show/hide the time selectors
function ScheduleHoursOnClick(){
	var el = event.srcElement;
	if(el.value == 24){
		tdTimeSelector.style.visibility = 'hidden';
	}
	else{
		tdTimeSelector.style.visibility = 'visible';
	}
}

function TrimString(strValue) {
     var ichar, icount;

     ichar = strValue.length - 1;
     icount = -1;
     while (strValue.charAt(ichar)==' ' && ichar > icount)
         --ichar;
     if (ichar!=(strValue.length-1))
         strValue = strValue.slice(0,ichar+1);
     ichar = 0;
     icount = strValue.length - 1;
     while (strValue.charAt(ichar)==' ' && ichar < icount)
         ++ichar;
     if (ichar!=0)
         strValue = strValue.slice(ichar,strValue.length);
     return strValue;
 }

function IsValidEmail(emailString) {
     emailString = TrimString(emailString);
     if (!(/^[\w\.]+@[a-z\.]+$/.test(emailString))) {
         return false;
     }
     return true;
 }

</SCRIPT>
	</HEAD>
	<BODY bgcolor="white">
		<TABLE border="0" width="800" bgcolor="whitesmoke">
			<!-- #INCLUDE FILE="include/TopNav.asp" -->
			<TR>
				<TD style="height:5;font-size:1;background:white">&nbsp;</TD>
			</TR>
			<TR>
				<TD>
					<FORM method="post" name="frmMain" onsubmit="return QuerySubmit();" action="AlertDetail.asp">
						<%
			' retrieve all submitted form items
			Response.Write m_AlertMetaData

			If nRetVal < 0 Then
				Response.Write "<script>document.location.href = 'Error.asp?err=Unable to retrieve the submitted form&backto=SaveReport.asp';</script>"
				Response.End
			End If			
			%>
						<TABLE width="100%" cellpadding="0" cellspacing="0" bgcolor="white" border="0">
							<TR>
								<TD align="center">
									<TABLE cellpadding="1" cellspacing="0" bgcolor="silver" style="border-color:black">
										<TR>
											<TD style="height:5;font-size:1;background:white">
												&nbsp;</TD>
										</TR>
										<TR>
											<TD align="left" bgcolor="white">
												<B><FONT size="3">&nbsp;<%=cPageTitle%>
													</FONT></B>
											</TD>
										</TR>
										<%=m_FeedbackMessage%>
										<TR>
											<TD style="height:10;font-size:1;background:white">&nbsp;</TD>
										</TR>
										<TR>
											<TD align="center">
												<TABLE border="0" cellpadding="0" cellspacing="1" bgcolor="beige">
													<TR>
														<TD>
															<B>Description:</B>
														</TD>
														<TD>
															<INPUT type="text" size="100" name="textAlertDesc" id="textAlertDesc" value="<%=m_AlertDesc%>">
														</TD>
													</TR>
													<TR style="display:none">
													<!--<TR>-->
														<TD valign="top">
															<B>SQL Query:</B>
														</TD>
														<TD>
															<!--<TEXTAREA cols="75" rows="5" name="textAlertSql"><%=m_alertSql%></TEXTAREA>-->
															<TEXTAREA cols="75" rows="5" name="textAlertSql" ID="Textarea1"><%=m_debugText%></TEXTAREA>
														</TD>
													</TR>
													<TR>
														<TD colspan="2">
															<TABLE border="0" cellspacing="1" cellpadding="1" ID="Table2" width="100%" style="background:beige">
																<TR>
																	<TD colspan="2" style="font-weight:bold;background:black;color:white"><B>Alert 
																			conditions:</B>
																	</TD>
																</TR>
																<TR style="background:white">
																	<TD width="120" valign="top"><B>Servers/Logs:</B></TD>
																	<TD valign="top"><%=m_ServerLogTypeFilterText%>
																	</TD>
																</TR>
																<TR style="background:whitesmoke">
																	<TD width="120" valign="top"><B>Source:</B></TD>
																	<TD valign="top"><%=m_ELSourceText%></TD>
																</TR>
																<TR style="background:white">
																	<TD width="120" valign="top"><B>Event Type:</B></TD>
																	<TD valign="top"><%=m_EventTypeText%></TD>
																</TR>
																<TR style="background:whitesmoke">
																	<TD width="120" valign="top"><B>Event ID:</B></TD>
																	<TD valign="top"><%=m_EventIDText%></TD>
																</TR>
																<TR style="background:white">
																	<TD width="120" valign="top"><B>Event Category:</B></TD>
																	<TD valign="top"><%=m_EventCategoryText%></TD>
																</TR>
																<TR style="background:whitesmoke">
																	<TD colspan="2"><A href="javascript:AlertCriteriaChange();"><STRONG>Change Alert Criteria</STRONG></A></TD>
																</TR>
															</TABLE>
														</TD>
													</TR>
													<TR>
														<TD colspan="2" style="height:5;font-size:1;background:beige">
															&nbsp;</TD>
													</TR>
													<TR>
														<TD colspan="2">
															<TABLE border="0" cellspacing="1" cellpadding="1" ID="Table1" width="100%" style="background:beige">
																<TR>
																	<TD colspan="5" style="font-weight:bold;background:black;color:white">
																		<B>Alert Recipients:</B>
																	</TD>
																</TR>
																<TR style="background:whitesmoke">
																	<TD><B>Email Address</B></TD>
																	<TD><B>Days</B></TD>
																	<TD><B>Hours</B></TD>
																	<TD><B>&nbsp;</B></TD>
																	<TD><B>&nbsp;</B></TD>
																</TR>
																<%
																' display schedule (if exists)
																If m_AlertHdrID > 0 Then
																	nRetVal = AlertScheduleDisplay(m_alertHdrID)
																	If nRetVal < 0 Then
																		Response.Write "<script>document.location.href = 'Error.asp?err=Error executing query&backto=AlertDetail.asp';</script>"
																		Response.End
																	End If
																End If
																%>
															</TABLE>
														</TD>
													</TR>
													<TR>
														<TD colspan="2">
															<TABLE border="0" cellspacing="0" cellpadding="2" ID="Table3" width="100%" style="background:beige">
																<TR>
																	<TD colspan="2" style="height:8;font-size:1;background:white">
																		&nbsp;<INPUT type="hidden" name="hAlertRecipientID" value="<%=m_alertRecipientID%>"></TD>
																</TR>
																<TR style="background:white">
																	<TD width="120"><B>Email Address:</B></TD>
																	<TD>&nbsp;<INPUT type="text" size="60" NAME="textEmail" value="<%=m_email%>"></TD>
																</TR>
																<TR>
																	<TD colspan="2" style="height:8;font-size:1;background:white">
																		&nbsp;</TD>
																</TR>
																<TR style="background:white">
																	<TD width="120" valign="top"><B>Days:</B></TD>
																	<TD>
																		<INPUT type="checkbox" NAME="chk_Days1" value="Sun" <%=m_Days(1)%> ID="Checkbox1"><FONT color="red">Sun</FONT>&nbsp;
																		<INPUT type="checkbox" NAME="chk_Days2" value="Mon" <%=m_Days(2)%>>Mon
																		&nbsp;<INPUT type="checkbox" NAME="chk_Days3" value="Tue" <%=m_Days(3)%>>Tue 
																		&nbsp;<INPUT type="checkbox" NAME="chk_Days4" value="Wed" <%=m_Days(4)%>>Wed 
																		&nbsp;<INPUT type="checkbox" NAME="chk_Days5" value="Thu" <%=m_Days(5)%>>Thu 
																		&nbsp;<INPUT type="checkbox" NAME="chk_Days6" value="Fri" <%=m_Days(6)%>>Fri 
																		&nbsp;<INPUT type="checkbox" NAME="chk_Days7" value="Sat" <%=m_Days(7)%>><FONT color="red">Sat</FONT>
																	</TD>
																</TR>
																<TR>
																	<TD colspan="2" style="height:8;font-size:1;background:white">
																		&nbsp;</TD>
																</TR>
																<TR style="background:white">
																	<TD width="120" valign="top">
																		<B>Hours:</B>
																	</TD>
																	<TD>
																		<TABLE>
																			<TR>
																				<TD><INPUT type="radio" name="rScheduleHours" <%If m_radioScheduleHours = 24 Then%>checked<%End If%> onclick="ScheduleHoursOnClick()" value="24">24 
																					hours &nbsp;&nbsp;<INPUT type="radio" NAME="rScheduleHours" <%If m_radioScheduleHours = 0 Then%>checked<%End If%> onclick="ScheduleHoursOnClick()" value="0">Selected 
																					time
																				</TD>
																				<TD <%If m_radioScheduleHours = 24 Then%>style="visibility:hidden"<%Else%>style="visibility:visible"<%End If%> id="tdTimeSelector">
																					&nbsp;From:
																					<SELECT name="cbo_FromHours">
																						<%
																							For i = 1 To 12
																								If i < 10 Then ic = "0" & CStr(i) Else ic = CStr(i)
																								Response.Write "<OPTION value=""" & i & """"
																								If i = CInt(m_FromHours) Then 
																									Response.Write " SELECTED"
																								End If
																								Response.Write ">" & ic & "</OPTION>"
																							Next
																						%>
																					</SELECT>
																					<SELECT NAME="cbo_FromMinutes">
																						<%
																							i = 0
																							Do While i < 60 
																								If i < 10 Then ic = "0" & CStr(i) Else ic = CStr(i)
																								Response.Write "<OPTION value=""" & ic & """"
																								If i = CInt(m_FromMinutes) Then 
																									Response.Write " SELECTED"
																								End If
																								Response.Write ">" & ic & "</OPTION>"
																								i = i + 15
																							Loop
																						%>
																					</SELECT>
																					<SELECT NAME="cbo_FromAmPm">
																						<OPTION value="AM" <%If m_FromAmPm = "AM" Then%> SELECTED<%End If%>>AM</OPTION>
																						<OPTION value="PM" <%If m_FromAmPm = "PM" Then%> SELECTED<%End If%>>PM</OPTION>
																					</SELECT>
																					&nbsp;&nbsp;To:
																					<SELECT NAME="cbo_ToHours">
																						<%
																							For i = 1 To 12
																								If i < 10 Then ic = "0" & CStr(i) Else ic = CStr(i)
																								Response.Write "<OPTION value=""" & i & """"
																								If i = CInt(m_ToHours) Then 
																									Response.Write " SELECTED"
																								End If
																								Response.Write ">" & ic & "</OPTION>"
																							Next
																						%>
																					</SELECT>
																					<SELECT NAME="cbo_ToMinutes">
																						<%
																							i = 0
																							Do While i < 60 
																								If i < 10 Then ic = "0" & CStr(i) Else ic = CStr(i)
																								Response.Write "<OPTION value=""" & ic & """"
																								If i = CInt(m_ToMinutes) Then 
																									Response.Write " SELECTED"
																								End If
																								Response.Write ">" & ic & "</OPTION>"
																								i = i + 15
																							Loop
																						%>
																					</SELECT>
																					<SELECT NAME="cbo_ToAmPm">
																						<OPTION value="AM" <%If m_ToAmPm = "AM" Then%> SELECTED<%End If%>>AM</OPTION>
																						<OPTION value="PM" <%If m_ToAmPm = "PM" Then%> SELECTED<%End If%>>PM</OPTION>
																					</SELECT>
																				</TD>
																			</TR>
																		</TABLE>
																</TR>
																<TR style="background:white">
																	<TD colspan="2">
																		<%If m_AlertRecipientID <> "" Then%><A href="javascript:RecipientAddUpdate('update');"><STRONG>Update Recipient</STRONG></A>&nbsp;&nbsp;<%End If%>
																		<A href="javascript:RecipientAddUpdate('new');"><STRONG>Add Recipient</STRONG></A>
																	</TD>
																</TR>
															</TABLE>
														</TD>
													</TR>
													<TR>
														<TD colspan="2" style="height:5;font-size:1;background:beige">
															&nbsp;</TD>
													</TR>
												</TABLE>
											</TD>
										</TR>
										<TR>
											<TD style="border-top-color:black;border-top-style:outset;border-top-width:2;height:5;font-size:1">
												&nbsp;</TD>
										</TR>
										<TR>
											<TD align="center" bgcolor="silver">
												<INPUT type="button" NAME="btnSaveAlert" value="Save Alert" onclick="SaveAlertOnClick()">&nbsp;
											</TD>
										</TR>
										<TR>
											<TD style="border-bottom-color:grey;border-bottom-style:outset;border-bottom-width:2;height:5;font-size:1">
												&nbsp;</TD>
										</TR>
									</TABLE>
								</TD>
							</TR>
						</TABLE>
						<INPUT type="hidden" name="hActionType" value="<%=m_actionType%>">
					</FORM>
				</TD>
			</TR>
			<!-- #INCLUDE FILE="include/Footer.inc" -->
		</TABLE>
	</BODY>
</HTML>
<%
Set objReports = Nothing
%>
