// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : demoapp.h
//
//  DESCRIPTION :
//         Demo2 application related class definition
//
// #################################################################


//////////////////////////
#ifndef INCLUDED_DEMOAPP_H
#define INCLUDED_DEMOAPP_H
//////////////////////////


// =================
#include "client.h"
#include "server.h"
#include "demotype.h"
// =================


// ------------------
class ApplicationRun;

#define DEFAULT_IP_SERVER_ADDRESS	"127.0.0.1"
#define DEFAULT_IP_PORT_NUMBER		4001
#define DEFAULT_NUMBER_OF_TEST_REQUESTS	25


#define SCREEN_LOG_SUFFIX	"screen"
#define MILESTONE_LOG_SUFFIX	"mstone"
#define TRACE_LOG_SUFFIX	"trace"
#define LOG_SUFFIX		"log"


#define CLIENT_SCREEN_LOG_NAME     (CLIENT_NAME + string ("_") + SCREEN_LOG_SUFFIX + string (".") +  LOG_SUFFIX)
#define CLIENT_MILESTONE_LOG_NAME  (CLIENT_NAME + string ("_") + MILESTONE_LOG_SUFFIX + string (".") +  LOG_SUFFIX)
#define CLIENT_TRACE_LOG_NAME      (CLIENT_NAME + string ("_") + TRACE_LOG_SUFFIX + string (".") +  LOG_SUFFIX)

#define SERVER_SCREEN_LOG_NAME     (SERVER_NAME + string ("_") + SCREEN_LOG_SUFFIX + string (".") +  LOG_SUFFIX)
#define SERVER_MILESTONE_LOG_NAME  (SERVER_NAME + string ("_") + MILESTONE_LOG_SUFFIX + string (".") +  LOG_SUFFIX)
#define SERVER_TRACE_LOG_NAME      (SERVER_NAME + string ("_") + TRACE_LOG_SUFFIX + string (".") +  LOG_SUFFIX)


#define INFO_PER_REQUESTS	100
// ------------------

// ---------------------------
// ----------------------------
class BasicCallPrepareReply
{

  public :
    virtual vector<BasicDataType*> demo2_call_prepare_reply(
		ApplicationRun&		app_io,
		const BasicDataType*&	ptr_packet_i
		) = 0;

    BasicCallPrepareReply ();
    virtual ~BasicCallPrepareReply ();
};

// ----------------------------
class BasicCallPrepareSubReply
{

  public :
    virtual BasicDataType* demo2_call_prepare_subreply(
		ApplicationRun&		app_io,
		const BasicDataType*&	ptr_packet_i
		) = 0;

    BasicCallPrepareSubReply ();
    virtual ~BasicCallPrepareSubReply ();
};



// ----------------------------
template <typename T>
class CallPrepareReply : public BasicCallPrepareReply
{
friend class ApplicationInit;

  private :
    static map<string, BasicCallPrepareSubReply*>	map_subreplies_s;
    const map<string, BasicCallPrepareSubReply*>	map_subreplies_;

  public :
    vector<BasicDataType*> demo2_call_prepare_reply(
		ApplicationRun&		app_io,
		const BasicDataType*&	ptr_packet_i
		);

    CallPrepareReply ();
    ~CallPrepareReply ();
};



// ----------------------------
template <typename T1, typename T2>
class CallPrepareSubReply : public BasicCallPrepareSubReply
{
  public :
    BasicDataType* demo2_call_prepare_subreply(
		ApplicationRun&		app_io,
		const BasicDataType*&	ptr_packet_i
		);

    CallPrepareSubReply ();
    ~CallPrepareSubReply ();
};




// ---------------------------
// ----------------------------
class ApplicationInit
{

  protected :
    // -------------------
    streambuf*		save_sbuf_cout_;
    ofstream		screen_log_;
    ofstream		milestone_log_;
    ofstream		trace_log_;

    string		screen_log_name_;
    string		milestone_log_name_;
    string		trace_log_name_;

    // ------------------

    static void		Set_Log_Name (string& file_o, const string& name_i);
    static void		Open_Log (ofstream& fout_o, const string& name_i);
    static void		Close_Log (ofstream& fout_o);
    static void		Flush_Log (ofstream& fout_o, ostringstream& oss_io);

    void	set_screen_log_name(const string& name_i);
    void	open_screen_log();
    void	close_screen_log();

    void	set_milestone_log_name(const string& name_i);
    void	open_milestone_log();
    void	close_milestone_log();
    void	flush_milestone_log();

    void	set_trace_log_name(const string& name_i);
    void	open_trace_log();
    void	close_trace_log();
    void	flush_trace_log();

    void	remove_old_logs(bool is_client_i) const;

    void	show_logo() const;

  public :
    ApplicationInit ();
    virtual ~ApplicationInit ();
};


// ---------------------------
// ---------------------------
class ApplicationRun : public ApplicationInit
{
friend class ApplicationInit;

  private :
    static map<string, BasicCallPrepareReply*>	map_replies_s;
    const map<string, BasicCallPrepareReply*>	map_replies_;

  public :
    // Constructor-1
    ApplicationRun ();

    // Destructor
    ~ApplicationRun ();

    // ------ Demo1 ------
    bool demo1_run_client (const string& ip_server_address_i, int ip_port_no_i);
    bool demo1_run_server (int ip_port_no_i);

    // ------ Demo2 ------
    BasicDataType* demo2_prepare_request (const vector<BasicDataType*>& replies_i);

    template <typename T>
    vector<T> get_subreply_data (const vector<BasicDataType*>& replies_i) const;

    template <typename T>
    PacketType<T>* demo2_prepare_typed_request (const vector<BasicDataType*>& replies_i);


    vector<BasicDataType*> demo2_prepare_reply (const BasicDataType*& request_i);

    template <typename T1, typename T2>
    vector<T2> demo2_prepare_subreply (const vector<T1>& request_data_i);

    static size_t Get_Reply_Transmission_Len(const vector<BasicDataType*>& replies_i);
    static bool   Is_Reply_Allowed_Len (
			const vector<BasicDataType*>&	replies_i,
			size_t				max_allowed_len_i = BUFSIZE_DEFAULT
			);


    static BasicDataType* Create_Emergency_Packet(const vector<string>& msg_i);
    static bool String_Is_Graph (const string& str_i);

    bool demo2_run_client (const string& ip_server_address_i, int ip_port_no_i, size_t number_of_test_requests_i);
    bool demo2_run_server (int ip_port_no_i);


};

//////
#endif
//////

