// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : packet.cpp
//
//  DESCRIPTION :
//         Packet related class implementation
//         (non-template methods)
//
// #################################################################


// =================
#include "packet2.h"
// =================


// ---------------------
ulong	BasicDataType::created_s (0);
ulong	BasicDataType::deleted_s (0);

// ---------------------
// ---------------------
// Constructor-1
BasicDataType::BasicDataType (
		const string&	typeid_data_type_i,
		const string& file_i,
		const ulong line_no_i
		)
		:
		typeid_data_type_ (typeid_data_type_i),
		id_ (++created_s),
		file_ (file_i),
		line_no_ (line_no_i)
{
SET_DETAILED_TRACE ("(Ctor) typeid_data_type = " << typeid_data_type_ 
                      << ", id = " << id_
                      << ", file = " << file_
                      << ", lineno = " << line_no_
                      );
}


// ---------------------
// Destructor
BasicDataType::~BasicDataType()
{
SET_DETAILED_TRACE ("(Dtor) typeid_data_type = " << typeid_data_type_ 
                      << ", id = " << id_
                      << ", file = " << file_
                      << ", lineno = " << line_no_
                      );
  deleted_s++;

}


// ---------------------
string BasicDataType::get_typeid_data_type () const
{
SET_TRACE;
  return typeid_data_type_;
}


// ---------------------
bool BasicDataType::is_packet_allowed_len (size_t max_allowed_len_i) const
{
SET_TRACE;
  return (get_packet_transmission_len () < max_allowed_len_i);
}


// ---------------------
size_t BasicDataType::Get_PrePacket_Len ()
{
SET_TRACE;
  return sizeof (size_t); 	// Number of subreplies in reply is of size_t
}


// ---------------------
ulong BasicDataType::Get_Created_Instances ()
{
SET_TRACE;
  return created_s;
}

// ---------------------
ulong BasicDataType::Get_Deleted_Instances ()
{
SET_TRACE;
  return deleted_s;
}


