#!/usr/bin/perl

###############################################################################
#
# _AFColorScheme.cgi - Create/Edit Color Schemes
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/09/11 17:58:00 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFColorScheme.cgi,v 1.26.2.3 2001/09/11 17:58:00 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

$Class = $CGIQuery->param('fid');

&lookupClass;

if ($CGIQuery->param('scheme') ne "") {
	$ColorScheme = $CGIQuery->param('scheme');
	$ColorQueryString = &lookupColors($ColorScheme);
}

# Load up color variables
&loadColors($ColorQueryString);

if ($CGIEnvUser eq "") {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}


$func = $CGIQuery->param('func');

# Width and Height for highlight images
$WH = "8";
if ($FontBase > 1) {
	$WH = "10";
}
if ($FontBase >= 4) {
	$WH = "12";
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} elsif ($func eq "picker") {
	$FSbgimage = $FTbgimage = $FCbgimage = "";
	$BodyTag = &makeBodyTag("Topics");
} elsif ($func eq "bg") {
	$BodyTag = &makeBodyTag("Topics");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "menu") {
	$helplink = "file=ColorSchemeCORP_Admin.html";
	$helplink .= "&anchor=ColorsSummary";
	$helplink .= "&helptitle=Colors%20Frame";

	&showHeaderBackHTML("Colors", "<br>", 0, 1, 0, $helplink);
	
	# Have to reload colors now
	&loadColors($ColorQueryString);
	
	&printResetJavascript;
	
	print "<script language=javascript>\n";
	print "<!--\n";
	print "function nada() {\n";
	print "}\n";
	print "// -->\n";
	print "</script>\n\n";
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=lastname value=\"\">\n";
	print "<input type=hidden name=lastvalue value=\"\">\n";
	
	print "<table cellpadding=0 cellspacing=3 border=0>\n";
	print "<tr><td valign=top>";
	
	print "<table cellpadding=0 cellspacing=2 border=0>\n";
	
		
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	
	########## Load Scheme ###########
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Load Alternate Color Scheme</b>";
	print "</td><tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize;
	print "<select name=LoadScheme onChange=parent.loadScheme(this.name)>\n";
	$getsch = new CGI($ColorQueryString);
	$ColorScheme = $getsch->param('scheme');
	local (%cschemes) = &lookupColorSchemes;
	@snames = sort(@allschemenames);
	for ($i=0; $i < @snames; $i++) {
		$name = @snames[$i];
		$num = $cschemes{"$name"};
		print "<option value=", $num;
		if ($ColorScheme == $num) {
			print " selected";
		}
		print "> ", $name, "\n";
	}
	print "</select>\n";
	print "</td><tr>\n\n";
		
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	
	# Name
	print "<tr><td>", $FontFace, $FontSize;
	print "Color Scheme Name<br>\n";
	print "<input type=text size=15 name=\"schemename\" value=\"$ColorSchemename\"><p>\n";
	print "</td><tr>\n\n";
	
	print "<tr><td>";
	# Control buttons
	print "<a href=\"javascript:nada()\" onClick=parent.updatePreview()>";
	print $BtnFormPreview;
	print "</a>\n";
	
	if ($Demo) {
		print $BtnFormSaveDemo;
	} else {
		print "<a href=\"javascript:nada()\" onClick='parent.saveScheme()'>";
		print $BtnFormSave;
		print "</a>";
	}
	print "<br>&nbsp;\n";
	
	print "</td></tr>\n\n";
	
	
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	######### Global ###########
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Global</b>";
	print "</td><tr>\n\n";

	# F_FH
	#print "<tr><td>", $FontFace, $FontSize;
	#print "<a name='F_FH'></a>";
	#print "$ForM Highlight<br>\n";
	#print "<input type=radio name=sel value='F_FH'> ";
	#print "<input type=text size=9 maxlength=7 name=\"F_FH\" value=\"$Ffacultyhilight\"><p>\n";
	#print "</td><tr>\n\n";
	print "<input type=hidden name=\"F_FH\" value=\"$Ffacultyhilight\">\n";
	
	# F_SH
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='F_SH'></a>";
	print "User Highlight (non-$form)<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"F_SH\">";
	# Radio and Text
	print "<input type=radio name=sel value='F_SH' ";
	print "onClick=parent.highlight('F_SH')> ";
	print "<input type=text size=9 maxlength=7 name=\"F_SH\" value=\"$Fstudenthilight\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].F_SH.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";

	print "</table>\n";
	
	
	print "</td><td valign=top>";
	
	print "<table cellpadding=0 cellspacing=2 border=0>\n";
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";

	########## Topics ###########
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Topics Frame</b>";
	print "</td><tr>\n\n";

	# FSHB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSHB'></a>";
	print "Topics Header Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSHB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSHB' ";
	print "onClick=parent.highlight('FSHB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSHB\" value=\"$FSheaderback\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSHB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";

	# FSHT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSHT'></a>";
	print "Topics Header Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSHT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSHT' ";
	print "onClick=parent.highlight('FSHT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSHT\" value=\"$FSheadertext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSHT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSLB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSLB'></a>";
	print "Topics Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSLB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSLB' ";
	print "onClick=parent.highlight('FSLB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSLB\" value=\"$FSbg\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSLB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSLT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSLT'></a>";
	print "Topics Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSLT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSLT' ";
	print "onClick=parent.highlight('FSLT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSLT\" value=\"$FStext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSLT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSLD
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSLD'></a>";
	print "Topics Date Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSLD\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSLD' ";
	print "onClick=parent.highlight('FSLD')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSLD\" value=\"$FSdate\">\n";
	# print "<input type=hidden size=9 maxlength=7 name=\"FSLD\" value=\"$FSdate\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSLD.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSL'></a>";
	print "Topics Active Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSL' ";
	print "onClick=parent.highlight('FSL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSL\" value=\"$FSlink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSVL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSVL'></a>";
	print "Topics Visited Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FSVL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FSVL' ";
	print "onClick=parent.highlight('FSVL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FSVL\" value=\"$FSvlink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FSVL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FSBI
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FSBI'></a>";
	print "Topics Background Image<br>\n";
	# print "<input type=radio name=sel value='FSBI'> ";
	print "<input type=text size=20 name=\"FSBI\" value=\"$FSbgimage\" onChange=\"parent.updatePreview()\">\n";
	print "</td><tr>\n\n";

	print "</table>\n";
	
	print "</td>\n";
	print "<td valign=top>\n";


	print "<table cellpadding=0 cellspacing=2 border=0>\n";
		
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	######### Threads ##########
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Threads Frame</b>";
	print "</td><tr>\n\n";

	# FTHB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTHB'></a>";
	print "Threads Header Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTHB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTHB' ";
	print "onClick=parent.highlight('FTHB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTHB\" value=\"$FTheaderback\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTHB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";

	# FTHT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTHT'></a>";
	print "Threads Header Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTHT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTHT' ";
	print "onClick=parent.highlight('FTHT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTHT\" value=\"$FTheadertext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTHT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTST
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTST'></a>";
	print "Selected Topic Highlight Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTST\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTST' ";
	print "onClick=parent.highlight('FTST')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTST\" value=\"$FTseltopic\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTST.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTLB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTLB'></a>";
	print "Threads Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTLB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTLB' ";
	print "onClick=parent.highlight('FTLB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTLB\" value=\"$FTbg\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTLB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTLT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTLT'></a>";
	print "Threads Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTLT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTLT' ";
	print "onClick=parent.highlight('FTLT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTLT\" value=\"$FTtext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTLT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTLD
	#print "<tr><td>", $FontFace, $FontSize;
	#print "<a name='FTLD'></a>";
	#print "Threads Date Color<br>\n";
	#print "<input type=radio name=sel value='FTLD'> ";
	#print "<input type=text size=9 maxlength=7 name=\"FTLD\" value=\"$FTdate\">\n";
	print "<input type=hidden size=9 maxlength=7 name=\"FTLD\" value=\"$FTdate\" onChange=\"parent.updatePreview()\">\n";
	#print "<a href=\"javascript:nada()\" ";
	#print "onClick=parent.showColor(document.forms[0].FTLD.value)>";
	#print $BtnCopyPicker, "</a>\n";
	#print "</td><tr>\n\n";
	
	# FTL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTL'></a>";
	print "Threads Active Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTL' ";
	print "onClick=parent.highlight('FTL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTL\" value=\"$FTlink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTVL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTVL'></a>";
	print "Threads Visited Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FTVL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FTVL' ";
	print "onClick=parent.highlight('FTVL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FTVL\" value=\"$FTvlink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FTVL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FTBI
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FTBI'></a>";
	print "Threads Background Image<br>\n";
	# print "<input type=radio name=sel value='FTBI'> ";
	print "<input type=text size=20 name=\"FTBI\" value=\"$FTbgimage\" onChange=\"parent.updatePreview()\"><p>\n";
	print "</td><tr>\n\n";

	print "</table>\n";
	

	print "</td>\n";
	print "<td valign=top>\n";


	print "<table cellpadding=0 cellspacing=2 border=0>\n";
	
	print "<tr><td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	######### Content ##########
	print "<tr><td>", $FontFace, $FontSize;
	print "<b>Content Frame</b>";
	print "</td><tr>\n\n";

	# FCHB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCHB'></a>";
	print "Content Header Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCHB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCHB' ";
	print "onClick=parent.highlight('FCHB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCHB\" value=\"$FCheaderback\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCHB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";

	# FCHT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCHT'></a>";
	print "Content Header Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCHT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCHT' ";
	print "onClick=parent.highlight('FCHT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCHT\" value=\"$FCheadertext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCHT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCLB
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCLB'></a>";
	print "Content Background<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCLB\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCLB' ";
	print "onClick=parent.highlight('FCLB')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCLB\" value=\"$FCbg\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCLB.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCLT
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCLT'></a>";
	print "Content Text<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCLT\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCLT' ";
	print "onClick=parent.highlight('FCLT')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCLT\" value=\"$FCtext\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCLT.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCLD
	#print "<tr><td>", $FontFace, $FontSize;
	#print "Content Date Color<br>\n";
	#print "<input type=radio name=sel value='FCLD'> ";
	#print "<input type=text size=9 maxlength=7 name=\"FCLD\" value=\"$FCdate\">\n";
	print "<input type=hidden size=9 maxlength=7 name=\"FCLD\" value=\"$FCdate\">\n";
	#print "<a href=\"javascript:nada()\" ";
	#print "onClick=parent.showColor(document.forms[0].FCLD.value)>";
	#print $BtnCopyPicker, "</a>\n";
	#print "</td><tr>\n\n";
	
	# FCL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCL'></a>";
	print "Content Active Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCL' ";
	print "onClick=parent.highlight('FCL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCL\" value=\"$FClink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCVL
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCVL'></a>";
	print "Content Visited Link<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCVL\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCVL' ";
	print "onClick=parent.highlight('FCVL')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCVL\" value=\"$FCvlink\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCVL.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCMHH
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCMHH'></a>";
	print "Content Message Header Highlight<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCMHH\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCMHH' ";
	print "onClick=parent.highlight('FCMHH')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCMHH\" value=\"$FCmsgheadhilight\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCMHH.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCMBH
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCMBH'></a>";
	print "Content Message Highlight<br>\n";
	# Highlight Image
	print "<img src=$ImgSrcClearDot width=$WH height=$WH border=0 ";
	print "name=\"FCMBH\">";
	# Radio and Text
	print "<input type=radio name=sel value='FCMBH' ";
	print "onClick=parent.highlight('FCMBH')> ";
	print "<input type=text size=9 maxlength=7 name=\"FCMBH\" value=\"$FCmsghilight\" onChange=\"parent.updatePreview()\">\n";
	print "<a href=\"javascript:nada()\" ";
	print "onClick=parent.showColor(document.forms[0].FCMBH.value)>";
	print $BtnCopyPicker, "</a>\n";
	print "</td><tr>\n\n";
	
	# FCBI
	print "<tr><td>", $FontFace, $FontSize;
	print "<a name='FCBI'></a>";
	print "Content Background Image<br>\n";
	# print "<input type=radio name=sel value='FCBI'> ";
	print "<input type=text size=20 name=\"FCBI\" value=\"$FCbgimage\" onChange=\"parent.updatePreview()\"><p>\n";
	print "</td><tr>\n\n";
	
	print "</table>\n";
	
	print "</td></tr></table>\n";

	print "</form>\n";
	
	# Check the first item, and highlight it
	print "<script language=javascript>\n<!--\n";
	print "document.forms[0].sel[1].checked = true;\n";
	print "parent.highlight('FSHB');\n";
	print "// -->\n</script>\n";
	
	print "</body></html>\n";
	
} elsif ($func eq "save" || $func eq "apply") {
	$in = unescape($ENV{'QUERY_STRING'});
	$CGIQuery = new CGI($in);
	@names = $CGIQuery->param;
	
	$schemename = $CGIQuery->param('schemename');
	if ($CGIQuery->param('newschemename') ne "") {
		$schemename = $CGIQuery->param('newschemename');
	}
	
	$overwrite = $CGIQuery->param('overwrite');
	
	# Check to see if there is already a color shcheme by this name, or
	# if the name is blank.
	local (%cschemes) = &lookupColorSchemes;
	@snames = sort(@allschemenames);
	
	$exists = 0;
	for ($i=0; $i < @snames; $i++) {
		if (@snames[$i] eq $schemename) {
			$exists = 1;
		}
	}
	
	if ($func eq "apply") {
		$not = "not";
		if ($CGIQuery->param('apply') eq "YES") {
			# Turn on signal Handling
			$trapSignals = 1;
		
			$not = "";
			$schemenum = $CGIQuery->param('schemenum');
			$C_colors = &lookupColors("$schemenum");
			
			# Modify class.db
			$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;
		
			@retval = `$setDB $dbfile -thash -k \"C_colors\" -d \"$C_colors\"`;
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
				exit();
			}
			
			# If we got a signal, exit here.
			if ($gotSignal) {
				close(DEVNULL);
				exit(0);
			}
		}
		
		&showHeaderBackHTML("Apply Color Scheme", "<br>");
		
		print "The color scheme has $not been applied to the current $corf ($Class).<p>\n";
		
		print "<a href=# onClick=window.close()>$BtnClose</a>\n";
		exit();
	}
	
	$helplink = "file=ColorSchemeCORP_Admin.html";
	$helplink .= "&anchor=ColorsSummary";
	$helplink .= "&helptitle=Save%20Color%20Scheme";
	
	&showHeaderBackHTML("Save Color Scheme", "<br>", 0, 0, 0, $helplink);
	
	&printJavascript;
	
	if ($schemename eq "" || ($exists && $overwrite ne "1")) {
		print "<form action=$CGIEnvScript method=GET>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=func value=save>\n";
			
		if ($exists) {
			print "<input type=hidden name=overwrite value=1>\n";
			print "The name you have chosen for your color scheme already ";
			print "exists. To overwrite it, hit the \"Save\" button. \n";
			print "Or you can change the name and then hit \"Save\".<p>\n";
		} else {
			print "You have not given your color scheme a name. Please enter ";
			print "a name below and hit \"Save\".<p>\n";
		}
	
		print "<input type=text size=30 name=newschemename value=\"";
		print $schemename, "\">\n";
		print "<input type=hidden name=query value=\"blah\&";
		print $in, "\">\n";
		# print "<input type=submit name=Save value=Save>\n";
		print "<a href=javascript:document.forms[0].submit()>";
		print $BtnFormSave;
		print "</a>";
		print "<a href=javascript:window.close()>";
		print $BtnCancel;
		print "</a>\n";
		print "</form>\n";
		exit();
	}
	
	# Get the max scheme number
	if ($overwrite eq "1") {
		$schemenum = $cscheme{"$schemename"};
	} else {
		$schemenum = 0;
		for ($i=0; $i < @allschemenums; $i++) {
			if (@allschemenums[$i] > $schemenum) {
				$schemenum = @allschemenums[$i];
			}
		}
		$schemenum++;
	}
	
	# Build the scheme string
	$string = "";
	for ($i=0; $i < @names; $i++) {
		if (@names[$i] =~ /^F/) {
			$string .= @names[$i] . "=" . $CGIQuery->param("@names[$i]");
			$string .= "\&";
		}
	}
	$string .= "schemename=" . escape("$schemename") . "\&";
	$string .= "scheme=" . $schemenum;
	
	$string = &Escape($string);
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS;
	@retval = `$setDB $dbfile -thash -q -k \"$schemenum\" -d \"$string\"`;
	$status = &dbErrorCheck($?, @retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to add $schemenum to Colors database: $dbfile. Check file permissions and try again.", 1);
		exit();
	}
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	print "Your color scheme has been saved.<p>";
	
	if ($Class ne "") {
		print "Would you like to apply this color scheme to the current $corf ($Class)?\n";
		print "<form action=$CGIEnvScript method=GET>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=func value=apply>\n";
		print "<input type=hidden name=schemenum value=\"$schemenum\">\n";
		print "<input type=radio name=apply value=\"YES\" checked>\n";
		print "Yes &nbsp;&nbsp;\n";
		print "<input type=radio name=apply value=\"NO\">\n";
		print "No <br>\n";
		print $BtnFormSubmit;
		print "</form>\n";
	} else {
		print "<a href=# onClick=window.close()>$BtnClose</a>\n";
	}
	
} elsif ($func eq "picker") {
	# Show the lower frame, no user selected.

	$helplink = "file=ColorSchemeCORP_Admin.html";
	$helplink .= "&anchor=ColorPickerSummary";
	$helplink .= "&helptitle=Color%20Picker";
	
	&showHeaderBackHTML("Color Picker", "<br>", 0, 2, 0, $helplink);
	
	&showPicker;
	
} elsif ($func eq "preview") {
	$newurl = $CGI_ClassEditColorVw . "?fid=" . $Class . "\&preview=true\&";
	$newurl .= escape($ColorQueryString);
	print $CGIQuery->redirect("$newurl");
	exit();

} elsif ($func eq "bg") {
	# Show the lower frame, no user selected.
	
	# Check for existence of directory
	if (! -e $C_rootpath . "/" . $DIR_BGIMAGES) {
		&confmakedir($C_rootpath . "/" . $DIR_BGIMAGES);
	
		# Copy background images
		@bgs = glob("./$DIR_IMAGES/$DIR_BGIMAGES/*.jpg");
		for ($i=0; $i < @bgs; $i++) {
			@getname = split(/\//, @bgs[$i]);
			$targ = $C_rootpath . "/" . $DIR_BGIMAGES . "/" . @getname[$#getname];
			&copy(@bgs[$i], $targ);
		}
	}
	
	# Handle an upload first.
	$upload = $CGIQuery->param('upload');
	if ($upload ne "") {
		$msg = &saveBG($upload);
	}
	
	$helplink = "file=ColorSchemeCORP_Admin.html";
	$helplink .= "&anchor=BackgroundImagesSummary";
	$helplink .= "&helptitle=Background%20Images%20Frame";

	&showHeaderBackHTML("Background Images", "", 0, 2, 0, $helplink);
	
	&showBGs($msg);

} elsif ($func eq "delete") {
	$file = $CGIQuery->param('file');
	$confirm = $CGIQuery->param('confirm');
	
	$realfile = $file;
	$realfile =~ s/^$C_rooturl/$C_rootpath/;
	
	if (! -e $realfile) {
		&showErrorBackHTML("The selected file: $file, does not exist.", 0);
		exit();
	}
	
	# Check for or ask for confirmation
	if ($confirm eq "") {
		&showHeaderBackHTML("Are you sure?", "", 0, 0, 0, "");
		print "<table border=0 width=100%>\n";
		print "<tr><td>", $ImgIndent, "</td>";
		print "<td>", $FontFace, $FontSize;
		print "<form action=$CGIEnvScript method=POST>\n";
	
		print "$FontRed Are you sure you ";
		print "want to delete the image shown below? </font><br>";

		print "<input type=hidden name=func value=$func>\n";
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=file value=\"$file\">\n";
		print "&nbsp;&nbsp;<input type=radio name=confirm value='YES'> Yes &nbsp;\n";
		print "<input type=radio name=confirm value='NO'> No<br>\n";
	
		print "<table border=0 cellpadding=0 cellspacing=1 width=100%>\n";
		print "<tr><td bgcolor=$FTheaderback>", $FontFace, $FontSize;	
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
		print "</table>\n";
	
		print $BtnFormSubmit;
		print "\n</form>\n";
		
		print "<br><br>";
		print "<img src=\"", $file, "?", time(), "\" border=0>\n";
		
		print "</td></tr></table>\n";
		print "</body></html>\n";
	} elsif ($confirm eq "YES") {
		# Do deletion
		$tfile = $realfile;
		$tfile =~ s/\.(\w{3})$/_t\.$1/;
		
		if (! unlink($tfile)) {
			&showErrorBackHTML("Unable to delete thumbnail file: $tfile. Check file permissions and try again.", 1);
			exit();
		}
		
		if (! unlink($realfile)) {
			&showErrorBackHTML("Unable to delete file: $tfile. Check file permissions and try again.", 1);
			exit();
		}
		
		&showHeaderBackHTML("Deletion Successful", "", 0, 0, 0, "");
		print "The background image has been deleted.<p>\n";
		print "<a href=# onClick=window.close()>", $BtnClose, "</a>\n";
		print "<script language=javascript>\n<!--\n";
		print "window.opener.top.bg.document.location.reload();\n";
		print "// -->\n</script>\n";
		print "</body></html>\n";
	} else {
		# Cancelled
		&showHeaderBackHTML("Deletion Cancelled", "", 0, 0, 0, "");
		print "The image was not deleted.<p>\n";
		print "<a href=# onClick=window.close()>", $BtnClose, "</a>\n";
		print "</body></html>\n";
	}
} else {
	# No function chosen. Print out frameset
	print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
	print "<html><head><title>$Class Forum Color Editing</title>\n";
	
	&printColorScript;
	&printJavascript;
	
	print "</head>\n";
	print "<frameset cols='220,*' border=2>\n";
	print "	<frameset rows='300,*' border=2>\n";
	print "		<frame name=picker src=$CGIEnvScript?fid=$Class&func=picker&scheme=$ColorScheme ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "		<frame name=bg src=$CGIEnvScript?fid=$Class&func=bg&scheme=$ColorScheme ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	</frameset>\n";
	print "	<frameset rows='55%,*' border=2>\n";
	print "		<frame name=colorlist src=$CGIEnvScript?fid=$Class&func=menu&scheme=$ColorScheme ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "		<frame name=preview src=$CGIEnvScript?fid=$Class&func=preview&scheme=$ColorScheme ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	</frameset>\n";
	print "</frameset>\n";
}

sub showPicker {
	print <<end_print;
	
<script language="JavaScript">
<!--
var lock = 0;

function highlight(val) {
	if (lock == 0) {
		document.bgColor = val;
		document.forms[0].sel.value = val;
	}
}

function lockIt() {
	if (lock == 0) {
		lock = 1;
		document.forms[0].CLock.checked = true;
	} else {
		lock = 0;
		document.forms[0].CLock.checked = false;
	}
}

function unLockIt() {
	lock = 0;
	document.forms[0].CLock.checked = false;
}
// -->
</script>

end_print

	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	print "<tr>\n";
	print "	<td bgcolor=#000000 valign=middle>\n";
	print "		<table border=0 cellpadding=0 cellspacing=1>\n";
	print "		<tr>\n";

	open(f, "216.txt");
	while(<f>) {
		$it = $_;
		chomp($it);
		if ($it ne "") {
			if ($it !~ /^\#/) {
				$it = "#" . $it;
			}
			while(length($it) > 7) {
				chop($it);
			}
			print "\t\t\t<td bgcolor=$it><a href=\"javascript:lockIt()\" onMouseOver=\"highlight(\'$it\'); return true\">";
			print "<img src=images/cleardot.gif width=10 height=10 border=0></a></td>\n";
		} else {
			print "\t\t</tr>\n\n\t\t<tr>\n";
		}
	}
	print "		</tr>\n";

	print "		</table>";
	print "	</td>\n</tr></table>\n";

	print "<form onSubmit='return false'>\n";
	print "Locked: ";
	print "<input type=checkbox name=CLock onClick=lockIt()>\n";
	print "<input type=text size=8 maxlength=7 name=\"sel\" value=\"$FSbg\" onChange=\"document.bgColor=this.value;unLockIt();lockIt()\">\n";
		
	print "<a href=\"#\" onClick=\"parent.showHexToRGB()\">";
	print "$BtnHexRGB</a>\n";
	
	print "<a href=\"#\" onClick=\"parent.applyColor(document.forms[0].sel.value);unLockIt()\">";
	print $BtnPhotoApply;
	print "</a>\n";
	print "<a href=\"#\" onClick=\"parent.Revert()\">";
	print $BtnFormRevert, "</a>\n";
	print "</form>";

}

sub showBGs {
	local($msg) = @_;
	
	if ($msg ne "") {
		print $FontRed, $msg, "</font><br>\n";
	}

	print "<form action=$CGIEnvScript method=POST enctype=multipart/form-data>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=$func>\n";
	print "<input type=hidden name=schemename value=\"$ColorSchemename\">\n";
	
	print "<table border=0 cellspacing=5 cellpadding=0>\n";
	
	### Show name and apply
	print "<a name=form>\n";
	print "<tr><td bgcolor=$FSheaderback colspan=2>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	
	print "<tr><td colspan=2>", $FontSize, $FontFace;
	print "<b>Selected Background</b></td></tr>\n";
	
	print "<tr><td colspan=2 nowrap>", $FontSize, $FontFace;
	print "<input type=text size=25 name=filename value=\"$fullfilename\"><br>";
	print "<b>Apply To:</b><br>\n";
	print "<input type=checkbox name=applyto value=FSBI> Topics &nbsp;\n";
	print "<input type=checkbox name=applyto value=FTBI> Threads &nbsp;\n";
	print "<input type=checkbox name=applyto value=FCBI> Content &nbsp;<br>\n";
	print "<a href=\"#form\" onClick=parent.applyBG()>";
	print $BtnPhotoApply, "</a><br>\n";
	print "</td></tr>\n\n";

	### Add New
	print "<tr><td bgcolor=$FSheaderback colspan=2>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";
	
	print "<tr><td colspan=2>", $FontSize, $FontFace;
	print "<b>Upload a Background Image</b></td></tr>\n";
	
	print "<tr><td colspan=2>", $FontSize, $FontFace;
	print "<input type=file size=20 name=upload><br>\n";
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr>\n\n";
		
	### Thumbnails
	print "<tr><td bgcolor=$FSheaderback colspan=2>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=2>";
	print "</td></tr>\n\n";

	print "<tr><td colspan=2>", $FontSize, $FontFace;
	print "<b>Background Thumbnails</b></td>\n";
	print "</tr>\n";
	print "<tr><td colspan=2>", $FontSize, $FontFace;
	print "Click thumbnail to view image</td>\n";
	print "</tr>\n";
	print "</table>\n\n";
	
	print "<table border=0 cellspacing=5 cellpadding=0>\n";
	
	# Get a directory listing
	$dir = $C_rootpath . "/" . $DIR_BGIMAGES . "/*_t.*";
	@files = glob($dir);
	
	for ($i=0; $i < @files; $i++) {
		if (! ($i % 2)) {
			$started = 1;
			print "<tr>";
		}
		
		$realfile = @files[$i];
		$realfile =~ s/_t\.(\w{3})$/\.$1/;
		if (! -e $realfile) {
			$realfile = @files[$i];
		}
		@files[$i] =~ s/^$C_rootpath/$C_rooturl/;
		$realfile =~ s/^$C_rootpath/$C_rooturl/;
		
		print "<td align=center nowrap>", $FontFace, $FontSize;
		print "<a name=\"", @files[$i], "\">";
		print "<a href=\"#form", @files[$i], "\" onClick='parent.openwin(\"";
		print $realfile, "?", time(), "\",480,320,\"Preview\");";
		print "document.forms[0].filename.value=\"";
		print $realfile, "\"'>";
		print "<img src=\"", @files[$i], "?", time(), "\" border=0></a><br>";
		print "[ <a href=\"#form\" onClick=\"document.forms[0].filename.value='";
		print $realfile, "'\">";
		print "Select</a> ]&nbsp;";
		print "[ <a href=\"#", @files[$i], "\" onClick='parent.openwin(\"";
		print $CGIEnvScript, "?func=delete&file=", $realfile, "&fid=", $Class;
		print " \",480,320)'>Delete</a> ]";
		print "</td>\n";

		if ($i % 2) {
			$started = 0;
			print "</tr>\n";
		}
	}
	
	if ($started) {
		print "<td>&nbsp;</td></tr>\n";
	}
	
	print "</table>\n";
	print "</form>\n";
}

sub saveBG {
	local($upload) = @_;
	local($temp, @ident, $width, $height, $newfile, $i, $ext, $filebase);

	# Save a temporary file
	$temp = $C_rootpath . "/" . $DIR_BGIMAGES . "/" . time();
	open(f, ">$temp") || &showFileErrorHTML($temp, "w");
	binmode(f);
	while(<$upload>) {
		print f $_;
	}
	close(f);
	
	# Find out what type of file this is.
	if ($isWin) {
		@ident = split(/\s+/, `$IMGidentify -ping \"$temp\"`);
	} else {
		@ident = split(/\s+/, `$IMGidentify $temp`);
	}
	@ident[1] =~ s/\+.*//;
	($width, $height) = split(/x/, @ident[1]);
	
	# New File name
	$filebase = $C_rootpath . "/" . $DIR_BGIMAGES . "/" . &replaceNonAlpha($ColorSchemename) . "_";
	for ($i=.01; $i < 1; $i += .01) {
		$ext = $i;
		$ext =~ s/\.//;
		if (! -e $filebase . $ext . ".jpg" && ! -e $filebase . $ext . ".gif") {
			$filebase = $filebase . $ext;
			last;
		}
	}

	if (@ident[4] =~ /JPEG/i || @ident[5] =~ /JPEG/i) {
		&copy($temp, $filebase . ".jpg");
		rename($temp, $filebase . "_t.jpg");
		
		$newfile = $filebase . "_t.jpg";
		if ($width > 240 || $height > 240) {
			`$IMGmogrify -crop 240x240 -geometry \"80x80!\" $newfile`;
		} elsif ($width > 120 || $height > 120) {
			`$IMGmogrify -crop 120x120 -geometry \"80x80!\" $newfile`;
		} else {
			`$IMGmogrify -geometry \"80x80!\" $newfile`;
		}
		$fullfilename = $filebase . ".jpg";
	} elsif (@ident[4] =~ /GIF/i || @ident[5] =~ /GIF/i || @ident[6] =~ /GIF/i) {
		&copy($temp, $filebase . ".gif");
		rename($temp, $filebase . "_t.gif");
		
		$newfile = $filebase . "_t.gif";
		if ($width > 240 || $height > 240) {
			`$IMGmogrify -crop 240x240 -geometry \"80x80!\" $newfile`;
		} elsif ($width > 120 || $height > 120) {
			`$IMGmogrify -crop 120x120 -geometry \"80x80!\" $newfile`;
		} else {
			`$IMGmogrify -geometry \"80x80!\" $newfile`;
		}
		$fullfilename = $filebase . ".gif";
	} else {
		# Invalid file format
		&showErrorBackHTML("Invalid File Format. The only acceptable background image formats are gif and jpg.", 1);
		exit();
	}
	
	return("Background Image Uploaded.");
}

sub printColorScript {
	print <<end_print;
	<script language=javascript>
	<!--
	function selectItem(whichOne) {
		f = colorlist.document.forms[0];
		for (var i=0; i < f.sel.length; i++) {
			if (f.sel[i].value == whichOne) {
				f.sel[i].checked = true;
			}
		}
		// Highlight Image
		highlight(whichOne);
		
		// Go to anchor
		colorlist.document.location.hash = whichOne;
	}
		
	function showColor(color) {
		f = picker.document.forms[0];
		f.sel.value = color;
		picker.document.bgColor = color;
		picker.unLockIt();
		picker.lockIt();
	}
	
	function applyColor(color) {
		f = colorlist.document.forms[0];
		for (var i=0; i < f.sel.length; i++) {
			if (f.sel[i].checked) {
				f.lastname.value = f.sel[i].value;
				f.lastvalue.value = f.elements[f.sel[i].value].value;
				f.elements[f.sel[i].value].value = color;
			}
		}
		updatePreview();
	}
	
	function applyBG() {
		f = colorlist.document.forms[0];
		f2 = bg.document.forms[0];
		if (f2.filename.value == "") {
			alert("Please select a background.");
			return;
		}
		var found = 0;
		for (i=0; i < f2.applyto.length; i++) {
			if (f2.applyto[i].checked) {
				found = 1;
				// f.lastname.value = f2.applyto[i].value;
				// f.lastvalue.value = f.elements[f2.applyto[i].value].value;
				f.elements[f2.applyto[i].value].value = f2.filename.value;
			}
		}
		if (!found) {
			alert("Please select a frame to apply your background.");
			return;
		}
		updatePreview();
	}
	
	function Revert() {
		f = colorlist.document.forms[0];
		if (f.lastname.value != "") {
			f.elements[f.lastname.value].value = f.lastvalue.value;
			f.lastname.value = "";
			updatePreview();
		}
	}
	
	function updatePreview() {
		f = colorlist.document.forms[0];
		var qstring = "";
		for (var i=0; i < f.elements.length; i++) {
			if (f.elements[i].name != "sel") {
				qstring += f.elements[i].name + "=" + f.elements[i].value + "\&";
			}
		}
		qstring = escape(qstring);
		qstring = "preview=true\&" + qstring;
		preview.document.location = "$CGI_ClassEditColorVw" + "?" + qstring;
	}
	
	function loadScheme(elemName) {
		f = colorlist.document.forms[0];
		var ind = f.elements[elemName].selectedIndex;
		var scheme = f.elements[elemName].options[ind].value;
		document.location = "$CGIEnvScript" + "?fid=$Class" + "&scheme=" + scheme;
	}
	
	function saveScheme() {
		f = colorlist.document.forms[0];
		var newloc = "$CGIEnvScript" + "?func=save&newwin=true&fid=$Class";
		var qstring = "";
		for (var i=0; i < f.elements.length; i++) {
			if (f.elements[i].name != "sel") {
				qstring += f.elements[i].name + "=" + f.elements[i].value + "\&";
			}
		}
		qstring = escape(qstring);
		newloc += "\&" + qstring;
		openwin(newloc,360,240);
	}
	
	function showHexToRGB() {
		var newloc = "$CGI_ClassHexToRGB" + "?fid=$Class";
		newloc += "\&color=" + escape(picker.document.forms[0].sel.value);
		openwin(newloc,360,160,'HexRGBWin');
	}
	
	function highlight(whichOne) {
		resetHighlight();
		colorlist.document.images[whichOne].src = "$IcoSelSrc";
	}
	
	function resetHighlight() {
		for (var i=0; i < colorlist.document.images.length; i++) {
			if (colorlist.document.images[i].src.indexOf("$IcoSelSrc") != -1) {
				colorlist.document.images[i].src = "$ImgSrcClearDot";
			}
		}
	}
	// -->
	</script>
	
end_print
}
