#!/usr/bin/perl

###############################################################################
#
# _AFEdSubjAdd.cgi - Change list of Topics for the forum
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdSubjAdd.cgi,v 1.32.2.2 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "T_Init.pl";

$Class = $CGIQuery->param('fid');
$Subject = $CGIQuery->param('tid');
$func = $CGIQuery->param('func');

&lookupClass;
&lookupUser($CGIEnvUser);

&loadColors($ColorQueryString);

&checkCookieGuest($CGIEnvUser, $C_authtype);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !&IS_FAC($U_Perms)) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "showedit" && $Subject ne "") {
	# Class and subject chosen, print out editing page.

	$newsubject = $CGIQuery->param('newsubject');
	$location = $CGIQuery->param('location');
	$MakeSects = $CGIQuery->param('MakeSects');
	$AllowPost = $CGIQuery->param('AllowPost');
	
	if ($AllowPost eq "YES") {
		$allowpost = "all";
	} else {
		$allowpost = "nopost";
	}
	
	$dorefresh = 0;
	
	if (($newsubject ne "" || $MakeSects ne "") && $location ne "") {
		# Add a section
		
		@location = $CGIQuery->param('location');
	
		if ($newsubject ne "") {
			@makesubs[0] = $newsubject;
		} else {
			for ($k=1; $k <= $C_Sect_n; $k++) {
				@makesubs[$k -1] = $C_Sects{$k}{"name"};
			}
		}
		
		for ($l=0; $l < @makesubs; $l++) {
			$newsubject = @makesubs[$l];
	
			# Take out funky characters and spaces
			$newsubject = &realClean($newsubject);

			$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
		
			for ($i=0; $i < @location; $i++) {
		
				$newloc = $C_rootpath . "/" . $DIR_CLASSFORUM . @location[$i];
				if ($newloc !~ /\/$/) {
					$newloc .= "/";
				}
				$newloc .= $newsubject;
			
				$tmp = $newloc;
				$tmp =~ s/$C_rootpath\/$DIR_CLASSFORUM\///;
				$dbkey = $tmp;
			
				# if the subject contains /'s, mark its parents to be expanded
				@tmp = split (/\//, $tmp);
				$prev = "";
				for($j=0; $j < @tmp; $j++) {	
					if ($prev ne "") {
						$expand .= $prev . "/" . @tmp[$j] . ",";
						$prev = $prev . "/" . @tmp[$j];
					} else {
						$expand .= @tmp[$j] . "," ;
						$prev = @tmp[$j];
					}
				}
			
				if (! -e $newloc) {
					mkdir($newloc, 0775);
				}
			
				# Add it to the database
   
   				$prettysub = $newsubject;
				$prettysub =~ s/_/ /g;
				$parent = @location[$i];
				$parent =~ s/^\///;
				@getindents = split(/\//, $parent);
				$ImgIndents = @getindents;
			
   				$value = "0\\t$prettysub\\t$ImgIndents\\t0\t$parent\\t$allowpost";
				
				@retval = `$setDB $dbfile -tbtree -q -k \"$dbkey\" -d \"$value\"`;
				$status = &dbErrorCheck($?, @retval[0]);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to write to Topics database: $dbfile.");
					exit();
				}
			
				# Update subdirs for the parent
				if ($parent ne "") {
					($key, @getvalues) = split(/\t/, `$prtDB $dbfile -tbtree -k \"$parent\"`);
					
					$status = &dbErrorCheck($?, $key);
					if ($status) {
						&showErrorBackHTML("$status<p>Unable to read topic: $parent from Topics database: $dbfile.");
						exit();
					}

					@getvalues[3] = 1;
					$value = join("\\t", @getvalues);
					
					@retval = `$setDB $dbfile -tbtree -q -k \"$parent\" -d \"$value\"`;
					
					$status = &dbErrorCheck($?, @retval[0]);
					if ($status) {
						&showErrorBackHTML("$status<p>Unable to write to Topics database: $dbfile.");
						exit();
					}
				}
			}
		}
		
		if ($Subject eq "NEW") {
			$Subject = $newsubject;		
			$dorefresh = 1;
		}
		
	}
	
	########################
	# Print out the web page
	########################
	
	if ($Subject eq "NEW") {
		$header = "Create New Topic";
	} else {
		$header = "Add Topics to " . &printPretty($Subject);
	}
	
	&showHeaderBackHTML($header);
	
	# Start Form
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=tid value=\"$Subject\">\n";
	print "<input type=hidden name=func value=showedit>\n";
	
	if ($Subject eq "NEW") {
		print "<input type=hidden name=location value='/'>\n";
	}

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	if (($newsubject ne "" || $MakeSects eq "YES") && $location eq "") {
		print "<tr><td>$FontFace $FontSize3 $FontRed<b>You must choose a location!</b></td></tr>";
	}
	
	if ($Subject ne "NEW") {
		print "<tr><td>";
		print $FontFace, $FontSize2;	
		print "<b>Where:</b>";
		print "</td></tr>\n";
		
		print "<tr><td background=$ImgSrcTableBg>";
		print $ImgIndentSmall;
		print "</td></tr>\n";
	}
	
	print "<tr><td>";
	print $FontFace, $FontSize;	
	
	if ($Subject ne "NEW") {
		&printsubjectlist($Subject);
	}
	
	if ($Subject ne "NEW") {
		print "</td></tr>\n";
	
		print "<tr><td>";
		print $FontFace, $FontSize2;	
		print "<b>What:</b>";
		print "</td></tr>\n";
		
		print "<tr><td background=$ImgSrcTableBg>";
		print $ImgIndentSmall;
		print "</td></tr>\n";
		
		print "<tr><td>";
		print $FontFace, $FontSize;
	}
	
	
	print "<table border=0><tr>";
	print "<td>";
	print $ImgClear88;
	print "</td>";
	print "<td>", $FontFace, $FontSize;
	print "<b>New Topic Name:</b></td>";
	print "<td>";
	print $ImgClear88;
	print "</td>";
	if ($Subject ne "NEW") {
		print "<td colspan=2>", $FontFace, $FontSize;
		print "<b>Create List of these Topic Names</b>";
		print "</td>";
	}	
	print "</tr>\n";
	
	print "<tr>";
	print "<td>";
	print $ImgClear88;
	print "</td>";
	print "<td valign=top>", $FontFace, $FontSize;
	
	if ($Subject ne "NEW") {
		print "<input type=radio name=MakeSects value=NO checked>";
	}
	
	print "<input type=text name=newsubject size=30 maxlength=30";
	if ($newsubject ne "" && $location eq "") {
		print " value=\"$newsubject\"";
	}
	if ($Subject ne "NEW") {
		print " onFocus=\"document.forms[0].MakeSects.checked=0\"";
	}
	print"></td>";
	
	print "<td>";
	print $ImgClear88;
	print "</td>";
	
	if ($Subject ne "NEW") {
		print "<td valign=top>", $FontFace,$FontSize;
		print "<input type=radio name=\"MakeSects\" value=\"YES\" ";
		print "onClick=document.forms[0].newsubject.value=''></td>\n";
		print "<td valign=top>", $FontFace,$FontSize;
		&printSectionSelection;
		print "</td>\n";
	} 
	print "</tr>\n";
	
	print "<tr>";
	print "<td>";
	print $ImgClear88;
	print "</td>";
	print "<td colspan=3>", $FontFace,$FontSize;
	print "<input type=checkbox value=YES name=AllowPost checked>\n";
	print "Allow posting to your new topic(s)</td></tr>\n";

	print "<tr>";
	print "<td>";
	print $ImgClear88;
	print "</td>";
	print "<td colspan=3>", $FontFace,$FontSize;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print "</td></tr></table>\n\n";
	
	print "</td></tr>\n";
	
	print "</table>\n";
	print "</td></tr>\n";
	
	print "</table><p>\n\n";
	
	print "</form>\n\n";
	
	if ($dorefresh) {
		print "<script language=javascript>\n";
		print "parent.subjectmenu.document.location.reload();\n";
		print "</script>\n";
	}
	
# End of data processing
#
##########################################################	

} elsif ($func eq "menu") {

	#####################################################
	# Class chosen, but no subject. Print list of subjects
	#####################################################

	@selected = $CGIQuery->param('selected');
	$selleng = @selected;
	$BtnSelected = @selected[$selleng - 1];
	
	&showHeaderBackHTML("Add a Topic for $CorF - $Class", "", 0, 1);

	# Start Form
	print "<form action=$CGIEnvScript method=POST target=subjectedit>\n";
	print "<input type=hidden name=func value=showedit>\n";
	print "<input type=hidden name=fid value=\"$Class\">\n\n";

	# Print form
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr><td valign=middle align=right>";
	print $FontFace, $FontSize, $ImgClear88;
	print "<select name=tid size=4>\n";
	print "<option value='NEW'> (Create New Topic)\n";
	
	# Get the list of existing subjects
	@ls = &gettopsubjectlist($Subject);
	
	# Put the list of subjects in the selection box
	for ($i=0; $i < @ls; $i++) {
		print "<option value=\"", @ls[$i], "\"";
		if ($BtnSelected eq @ls[$i]) {
			print " SELECTED";
		}
		print "> ";
		print &printPretty(@ls[$i]), "\n";
	}
	
	print "</select></td>";
	print "<td valign=bottom align=left width=90%>", $FontSize, $FontFace;
	# print "<input type=submit name=submit value='Edit'>";
	print $BtnFormEdit;
	print "</td></tr>\n\n";

	print "</table>\n";
	print "</form>\n";
	
} elsif ($func eq "nothing" || $func eq "showedit") {

	# User input nothing, tell them to select something
	
	&showHeaderBackHTML("Please Choose a Topic Above");
	
} else {
	# Print out frameset
	print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
	print "<html><head><title>$Class Forum User Editing</title></head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=subjectmenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=subjectedit src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}


########

sub printsubjectlist {
	local($Subject) = @_;

	# Start a table
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	# Get the listing from the database
	
	$dbfile = $C_rootpath . "/" . $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, $posttime, $nicename, $ImgIndents, $subdirs, $parent) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}

		if ($DB_Key eq $Subject || $DB_Key =~ /^$Subject\//) {
	
			print "<tr>";
			print "<td valign=top>", $FontFace, $FontSize;
			
			# Print a spacer for the margin
			print $ImgClear88;
		
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print $ImgClear88;
			}
		
			if ($subdirs) {
				print $BtnExpanded;
			} else {
				print $IcoNoReplies;
			}
		
			print $ImgIndentSmall;
			print $nicename;
			print "</td></tr>\n";
		
			print "<tr><td valign=top>", $FontFace, $FontSize;
			print $ImgClear88, $ImgClear88;
			# Print the indents
			for ($k=0; $k < $ImgIndents; $k++) {
				print $ImgClear88;
			}
			print $IcoNoReplies;
			print "<input type=checkbox name=location value=\"/";
			print $DB_Key;
			print "\"> ";
			print "<font color=$FCdate>";
			print "Add Topic under</font><font color=#000000> $nicename";
			print "</font></td></tr>\n";
		}
	}
	
	print "</table>\n\n";
}

sub printSectionSelection {
	for ($j=1; $j <= $C_Sect_n; $j++) {
		print $C_Sects{$j}{"name"}, "\n";
		print "<br>";
	}
}
