#!/usr/bin/perl

###############################################################################
#
# _AFEdUserDel.cgi - Copy/Move/Delete Users
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:52 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdUserDel.cgi,v 1.25.2.2 2001/08/21 17:50:52 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

$Class = $CGIQuery->param('fid');
$adduser = $CGIQuery->param('adduser');
$what = $CGIQuery->param('what');
$sorting = $CGIQuery->param('sorting');
$menulimit = $CGIQuery->param('menulimit');
$func = $CGIQuery->param('func');

# Process lists to get $getuser
if ($adduser eq "") {
	$founduser = 0;
	@names = $CGIQuery->param;
	for ($i=0; $i < @names; $i++) {
		$thename = @names[$i];
		if ($thename =~ /^getuser/) {
			$theval = $CGIQuery->param("$thename");
			if ($theval ne "(NULL)") {
				$founduser++;
				if ($founduser > 1) {
					&showErrorHTML("Please select only ONE user.");
					exit();
				}
				$getuser = $theval;
			}
		}
	}
}

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);
	
&lookupClass;

# Load up color variables
&loadColors($ColorQueryString);

if (!$forumadmin) {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

if ($CGIEnvUser eq "" && !$forumadmin) {
	&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource.");
	exit();
}

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

###############################################################################
#
# Process submitted data

if ($func eq "doedit") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&douserdel;
	exit();
}

if ($Class ne "" && $getuser ne "") {
	# Class and user chosen, print out user editing page.
	
	# Get user data
	$found = &lookupUser($getuser);
	
	if ($found == 0) {
		$header = "Move/Copy/Delete User - $getuser";
	} else {
		$header = "User $getuser Not Found";
	}
	
	&showHeaderBackHTML($header);

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	if ($found != 0) {
		print "<tr><td>", $FontFace, $FontSize2;
		print "The user you selected, $getuser, could not be found in the ";
		print "database of users.</td></tr>";
		print "</table>";
		exit();
	}
	
	print "</table>";
	
	&printuserdel($CGIEnvScript);
	
} elsif ($func eq "menu") {
	# User selection
	
	&showHeaderBackHTML("Move/Copy/Delete Users for $CorF - $Class");
	
	&printResetJavascript;
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";

	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=$func>\n";
	print "<tr><td valign=middle>",$FontFace, $FontSize;
	print "View by: </td>";
	print "<td valign=middle>",$FontFace, $FontSize;
	print "<select name=sorting onChange=submit()>\n";
	@sortoptions = ("userid", "SUID", "lastname", "firstname");
	@sortnames = ("User ID", "SUID", "Last Name", "First Name");
	for ($k=0; $k < @sortoptions; $k++) {
		print "<option value=", @sortoptions[$k];
		if ($sorting eq @sortoptions[$k]) {
			print " selected";
		}
		print "> ", @sortnames[$k], "\n";
	}
	print "</select>";
	print " Limit each menu to ";
	print "<select name=menulimit onChange=submit()>\n";
	@numoptions = (5,10,25,50,100);
	if ($menulimit eq "") { $menulimit = 25;}
	&printSelOptions($menulimit, \@numoptions);
	print "</select>";
	print "entries.";
	print "</td></tr>\n";
	print "</form>";

	print "<form action=$CGIEnvScript method=POST target=deluser>";
	print "<tr><td valign=middle>",$FontFace, $FontSize;
	print " Edit existing user: </td>";
	print "<td valign=top>",$FontFace, $FontSize;
	print "<input type=hidden name=fid value=\"$Class\">";
	print "<input type=hidden name=func value=chooseuser>\n";
	# print "<select name=getuser>";
	&printuserlist($sorting);
	print "</select>";
	print $BtnFormEdit;
	print $BtnFormClear;
	print "</td></tr></form>\n";

	print "</table>\n\n";
	
} elsif ($func eq "nothing") {
	# Show the lower frame, no user selected.

	&showHeaderBackHTML("Choose a User in the Frame Above");

} else {
	# No function chosen. Print out frameset
	print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
	print "<html><head><title>$Class Forum User Editing</title></head>\n";
	print "<frameset rows='120,*' border=2>\n";
	print "	<frame name=delusermenu src=$CGIEnvScript?fid=$Class&func=menu ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=deluser src=$CGIEnvScript?fid=$Class&func=nothing ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}	


sub douserdel {
	$getuser = $CGIQuery->param('getuser');
	$submit = $CGIQuery->param('submit');
	$copyto = $CGIQuery->param('copyto');
	$moveto = $CGIQuery->param('moveto');
	$newsection = $CGIQuery->param('newsection');
	
	$copyuser = $CGIQuery->param('copyuser.x');
	$moveuser = $CGIQuery->param('moveuser.x');
	$deleteuser = $CGIQuery->param('deleteuser.x');
	
	$overwrite = $CGIQuery->param('overwrite');

	# copy and move require panFora System Admin password
	if (!$forumadmin && ($copyuser ne "" || $moveuser ne "")) {
		$nexturl = $CGIEnvScript . "?fid=" . $Class . "&copyto=" . $copyto;
		$nexturl .= "&func=doedit&copyuser.x=$copyuser";
		$nexturl .= "&moveto=" . $moveto . "&moveuser.x=" . $moveuser;
		$nexturl .= "&getuser=" . $getuser;
		$nexturl = escape($nexturl);
		
		print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
		exit();
	}
	
	if ($overwrite eq "NO") {
		&showHeaderBackHTML("Copy Cancelled", "<br>You cancelled the copy operation", 1);
		exit();
	}

	# Get user data
	&lookupUser($getuser);
	# This gets us $CGIEnvUser and $value
	
	$realclass = $Class;
	
	if ($newsection ne "") {
		$U_C_Sect = $newsection;
	}
	
	($junk, $origsectnum) = split(/\:/, $U_C_Sect);
	
	if (($copyto ne $Class || $moveto ne $Class) && ($moveto ne "" && $copyto ne "") && $deleteuser eq "") {
	
		# Now look up the class we are moving/copying to
		$origclass = $Class;
		if ($copyto ne $Class) {
			$Class = $copyto;
		} else {
			$Class = $moveto;
		}
		&lookupClass;
		
		# Does the user's section exist in the other class?
		if ($origsectnum > $C_Sect_n) {
			&picksection;
			exit();
		}
		
		# Get the section number
		($junk, $sectnum) = split(/\:/, $U_C_Sect);
		
		# Rebuild the value to insert
		$value = "$U_SUID\\t$U_Pass\\t$U_NameFirst\\t$U_NameLast\\t$U_NamePref\\t$U_Email\\t$U_Phone\\t$U_Perms\\t$U_C_Sect\\t$U_Photo,$U_PhotoLarge\\t$U_Classify\\t$U_ProfileText\\t$U_Sig\\t$U_HideEmail";
		
		# Now put the user in that other class.
		$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
		
		($u, @junk) = split(/\t/, `$prtDB $dbfile -thash -k \"$getuser\"`);
		$status = &dbErrorCheck($?, $u);
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		if ($u ne "" && ! $status && $overwrite eq "") {
			&copyOrSkip($getuser);
			exit();
		} else {
			@retval = `$setDB $dbfile -thash -q -k \"$getuser\" -d \"$value\"`;
			
			$status = &dbErrorCheck($?, @retval[0]);
			if ($status) {
				&showErrorBackHTML("$status<p>Unable to write to $dbfile. Check file permissions and try again.", 1);
				exit();
			}
		}
		
		$DB_Key = $getuser;
	
		###################################################################
		# Get the .htgroup file info
		if ($getuser ne "Anonymous") {
			&addtoht($DB_Key, $U_C_Sect);
		}
		#
		##########################################################
	
	
		##########################################################
		# Add user photos
		if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
			&addphoto($DB_Key);
		}
		#
		##########################################################
	
		##########################################################
		# Modify mailing lists as needed
		if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
			&addtomail($DB_Key);
		}
		#
		##########################################################
		
		if (&IS_FAC($U_Perms)) {
			&addToClassFac($DB_Key);
		}
		
		# If this is a move, we need to remove the user from the old class
		if ($moveto ne "" && $moveto ne $origclass) {
			$Class = $origclass;
			&lookupClass;
			&delfromdb($getuser);
			&delfromht($getuser);
			# Don't delete photo or it disappears from their posts
			# &delphoto($getuser);
			&delfrommail($getuser);
			
			&showHeaderBackHTML("User Moved", "User $getuser moved from $origclass to $moveto",0);
			exit();
		}
		
		# rebuild mailing lists from scratch
		&rebuildmail;
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		&showHeaderBackHTML("User Copied", "User $getuser copied to $Class",0);
		exit();
		
	} elsif ($deleteuser ne "" && $CGIQuery->param('confirm') eq "") {
		# Ask user to confirm deletion
		&confirmdel;
		exit();
	} elsif ($deleteuser ne "" && $CGIQuery->param('confirm') ne "YES") {
		# User selected no.
		&showHeaderBackHTML("Deletion Cancelled", "User $getuser deletion cancelled", 0);
		exit();
	} elsif ($deleteuser ne "" && $CGIQuery->param('confirm') eq "YES") {
		# Confirmation received. Delete user.
		
		# Turn on signal Handling
		$trapSignals = 1;
		
		&delfromdb($getuser);
		&delfromht($getuser);
		# Leave photo for existing posts
		# &delphoto($getuser);
		&delfrommail($getuser);
				
		# rebuild mailing lists from scratch
		&rebuildmail;
		
		# If we got a signal, exit here.
		if ($gotSignal) {
			close(DEVNULL);
			exit(0);
		}
		
		&showHeaderBackHTML("User Deleted", "User $getuser deleted from $corf: $Class", 0);
		exit();
	}
}

sub confirmdel {
	# Print user deletion confirmation page.
	
	&showHeaderBackHTML("Are you Sure?");
	
	print $FontSize2, "$FontRed<b>Are you sure you want to ";
	print "permanently delete $U_NameFirst $U_NameLast ($getuser)?</font></font><p>\n";
	
	print "<form action=$CGIEnvScript method=POST>";
	print "<input type=hidden name=fid value=$Class>";
	print "<input type=hidden name=getuser value=$getuser>";
	print "<input type=hidden name=func value=doedit>";
	print "<input type=radio name=confirm value=\"YES\"> Yes\n";
	print "<input type=radio name=confirm value=\"NO\" checked> No<br>\n";
	print $BtnFormUserDel;
	# print "<input type=submit name=submit value=\"Delete User\">\n";
	print "</form>";
	
}

sub picksection {
	&showHeaderBackHTML("Choose a $SorG");
	
	print "$FontSize2 The $sorg for this user does not exist in the $corf ";
	print "to which the user is being copied/moved. Please select the target ";
	print "$sorg for this user.<br>";
	print "<form action=$CGIEnvScript methind=POST>\n";
	print "<input type=hidden name=copyto value=$copyto>\n";
	print "<input type=hidden name=moveto value=$moveto>\n";
	# $Class has been changed.
	print "<input type=hidden name=fid value=$origclass>\n";
	print "<input type=hidden name=getuser value=$getuser>\n";
	print "<input type=hidden name=func value=doedit>\n";
	
	print "<select name=newsection>\n";
	# $Class is set to the new class here.
	for ($i=1; $i <= $C_Sect_n; $i++) {
		print "<option value='", $Class, ":", $C_Sects{$i}{"num"}, "'";
		if ($sectnum == $C_Sects{$i}{"num"}) {
			print " selected";
		}
		print ">";
		print $C_Sects{$i}{"name"}, "\n";
	}
	print "</select>\n";
	print $BtnFormSubmit;
	print "\n</form>";	
}

sub copyOrSkip {
	# What to do with existing users?
	local($user) = @_;
	
	if ($copyuser ne "") {
		$showclass = $copyto;
	} else {
		$showclass = $moveto;
	}
	
	&showHeaderBackHTML("Existing User","<br>");
	
	print "The following user already exists in the ", $showclass;
	print " $CorF: ";
	print $FontRed, $user, "</font>.<p>\n";
	print "Would you like to overwrite the user in ", $showclass,"?<p>\n";
	
	print "<form action=$CGIEnvScript method=POST>\n";
	print "<input type=hidden name=fid value=$realclass>\n";
	print "<input type=hidden name=copyto value=$copyto>\n";
	print "<input type=hidden name=moveto value=$moveto>\n";
	print "<input type=hidden name=func value=doedit>\n";
	print "<input type=radio name=overwrite value=\"YES\" checked> Yes &nbsp;\n";
	print "<input type=radio name=overwrite value=\"NO\"> No<p>\n";
	if ($copyuser ne "") {
		print $BtnFormUserCp;
	} else {
		print $BtnFormUserMv;
	}
	print "\n<input type=hidden name=getuser value=\"$user\">\n";
	
	print "</form>\n";
	exit();
}
