<?php

//
// ionCube Run Time Loading Compatibility Tester v2.3
//
// Last modified 2003-08-05
//
// Copyright (c) 2002-2003 ionCube Ltd.
//

//
// Detect some system parameters
//
function ic_system_info()
{
  $thread_safe = false;
  $debug_build = false;
  $php_ini_path = '';

  ob_start();
  phpinfo(INFO_GENERAL);
  $php_info = ob_get_contents();
  ob_end_clean();

  foreach (split("\n",$php_info) as $line) {
    if (eregi('command',$line)) {
      continue;
    }

    if (eregi('thread safety.*(enabled|yes)',$line)) {
      $thread_safe = true;
    }

    if (eregi('debug.*(enabled|yes)',$line)) {
      $debug_build = true;
    }

    if (eregi("configuration file.*(</B></td><TD ALIGN=\"left\">| => |v\">)([^ <]*)(.*</td.*)?",$line,$match)) {
      $php_ini_path = $match[2];

      //
      // If we can't access the php.ini file then we probably lost on the match
      //
      if (!@file_exists($php_ini_path)) {
	$php_ini_path = '';
      }
    }
  }

  return array('THREAD_SAFE' => $thread_safe,
	       'DEBUG_BUILD' => $debug_build,
	       'PHP_INI'     => $php_ini_path);
}


//
// Text or HTML output?
//
$nl =  ((php_sapi_name() == 'cli') ? "\n" : '<br>');

$ok = true;
$already_installed = false;

//
// Where are we?
//
$here = dirname(__FILE__);


//
// Is the loader already installed?
//
if (extension_loaded('ionCube Loader')) {
  echo "An ionCube Loader is already installed and runtime loading is unnecessary.
Encoded files should load without problems.$nl$nl";
  $already_installed = true;
}


//
// Test some system info
//
$sys_info = ic_system_info();

if ($sys_info['THREAD_SAFE']) {
  echo "Your PHP installation appears to have threading support, and PHP design
limitations don't support runtime loading on threaded builds.$nl${nl}To use encoded files the Loader should be installed in the php.ini file.$nl";
  $ok = false;
}

if ($sys_info['DEBUG_BUILD']) {
  echo "Your PHP installation appears to be built with debugging support
enabled, and is incompatible with ionCube Loaders.$nl${nl}Debugging support in PHP produces slower execution, is
not recommended for production builds, and was probably a mistake.${nl}${nl}You should rebuild PHP without the --enable-debug option, and if
you obtained your PHP install from an RPM then the producer of the
RPM should be notified so that it can be corrected.$nl";
  $ok = false;
}

//
// Check safe mode and for a valid extensions directory
//
if (ini_get('safe_mode')) {
  if (!$already_installed) {
    echo "PHP safe mode is enabled and run time loading will not be possible.$nl";
  }
  $ok = false;
} elseif (!is_dir(realpath(ini_get('extension_dir')))) {
  if (!$already_installed) {
    echo "The setting of extension_dir in the php.ini file is not a directory, and
run time loading will not be possible. You do not need write permissions on the
extension_dir, but for runtime loading to work, a path from the extensions
directory to wherever the Loader is installed needs to exist and be valid.$nl";
  }
  $ok = false;
}

if ($ok) {

  if ($already_installed) {
    echo "Although a Loader is already installed, this script will still search
for one, but only for information purposes. It will not try to install
one again because it is unnecessary.$nl";
  }

  //
  // Look for a Loader
  //

  $_ln_old='ioncube_loader.so';
  $_ln_old_loc="/ioncube/$_ln_old";

  $_u = php_uname();
  $_os = substr($_u,0,strpos($_u,' '));

  $_php_version = phpversion();
  $_php_family = substr($_php_version,0,3);

  $_ln_new='ioncube_loader_'.strtolower(substr($_u,0,3)).'_'.$_php_family.'.so';
  $_ln_new_loc="/ioncube/$_ln_new";

  echo "${nl}Looking for Loader '$_ln_new' or '$_ln_old'${nl}${nl}";

  $_rd=str_repeat('/..',substr_count($_id=realpath(ini_get('extension_dir')),'/')).dirname(__FILE__).'/';

  echo "Extensions Dir: $_id$nl";
  echo "Relative Path:  $_rd$nl";

  $_ln = '';
  $_i=strlen($_rd);
  while($_i--) {
    if($_rd[$_i]=='/') {
      // Try the old style Loader name
      $_lp=substr($_rd,0,$_i).$_ln_old_loc;
      $_fqlp=$_id.$_lp;
      if(file_exists($_fqlp)) {
	echo "Found Loader:   $_fqlp$nl";
	$_ln=$_lp;
	break;
      }
      // Try the new style Loader name
      $_lp=substr($_rd,0,$_i).$_ln_new_loc;
      $_fqlp=$_id.$_lp;
      if(file_exists($_fqlp)) {
	echo "Found Loader:   $_fqlp$nl";
	$_ln=$_lp;
	break;
      }
    }
  }

  //
  // If Loader not found, try the fallback of in the extensions directory
  //
  if (!$_ln) {
    if (file_exists($_id.$_ln_old_loc)) {
      $_ln = $_ln_old_loc;
    }
    if (file_exists($_id.$_ln_new_loc)) {
      $_ln = $_ln_new_loc;
    }

    if ($_ln) {
      echo "Found Loader $_ln in extensions directory.$nl";
    }
  }

  echo $nl;

  if ($_ln) {
    if (!$already_installed) {
      echo "Trying to install Loader - this may produce an error...$nl";
      dl($_ln);

      if(extension_loaded('ionCube Loader')) {
	echo "The Loader was successfully installed, and encoded files should be able to
automatically install the Loader when needed. No changes to your php.ini file
should be required to use encoded files on this system.${nl}";
      } else {
	echo "The Loader was not installed.$nl";
      } 
    } else {
      echo "The required Loader was found, but installation is not being tried 
because a working Loader is already installed.$nl";
    }
  } else {
    if (!$already_installed) {
      echo "Runtime loading should be possible on your system, but no suitable Loader
was found at this time.$nl$nl";
      echo "The $_os Loader for PHP $_php_family releases, including support for PHP $_php_version,
is required.$nl";
    } else {
      echo "Runtime loading should be possible on your system, but no suitable Loader
was found at this time. However, as the Loader appears to be installed already
this does not matter, and Encoded files should run without problems.$nl";
    }
  }
}

$email = 'support@ioncube.com';
if (php_sapi_name() != 'cli') {
  $email = "<a href=\"mailto:$email\">$email</a>";
}

echo "${nl}Please send the output of this script to $email if you
have questions or require assistance.$nl$nl";

?>
