<%
//	Created by:	Lineasoft Sagl
//	Web site:	www.lineasoft.ch
//	Version:	1.2  (01.10.2002)
//	File:		equercus.inc
//
//	Copyright  2002, Lineasoft Sagl (Switzerland)
%>

<%// Utility Functions%>
<!--#include file="adojavas.inc"-->
<!--#include file="utils.inc"-->
<!--#include file="parser.inc"-->

<%// Objects%>
<!--#include file="node.inc"-->
<!--#include file="language.inc"-->
<!--#include file="contentText.inc"-->
<!--#include file="contentHTML.inc"-->



<%

	////////////////////////////////////////////////////////////////////////////////////////////
	// Object Site
	////////////////////////////////////////////////////////////////////////////////////////////
	function Site()
	{
		// Members
		this.m_cn = Server.CreateObject("ADODB.Connection");

		this.m_nodeId  = QueryStringGetInteger("nid",-1);
		var nodeName  =  Request.QueryString("nname").Count > 0 ? Request.QueryString("nname").Item(1) : "";
		
		this.m_langId  = QueryStringGetInteger("lid",-1);
		var langName =  Request.QueryString("lname").Count > 0 ? Request.QueryString("lname").Item(1) : "";
		
		this.m_contentId  = QueryStringGetInteger("cid",-1);
		
		this.m_bPreview = QueryStringGetInteger("prv",0) == 1 ? true : false;

		// Internal Functions
		this.GetDefaultNodeId		= GetDefaultNodeId;
		this.GetDefaultLanguageId	= GetDefaultLanguageId;
		this.GetDefaultContentId	= GetDefaultContentId;
		this.GetNodeId				= GetNodeId;
		this.GetLanguageId			= GetLanguageId;

		// Struct Functions
		this.GetRequestedNode		= GetRequestedNode;
		this.GetTreeNodesById		= GetTreeNodesById;
		this.GetTreeNodesByName		= GetTreeNodesByName;

		// Language Functions
		this.GetActiveLanguages		= GetActiveLanguages;
		this.GetRequestedLanguageId = GetRequestedLanguageId;

		// Link Functions
		this.GetNodeLink			= GetNodeLink;
		this.GetNodeContentLink		= GetNodeContentLink;
		this.GetChangeLanguageLink	= GetChangeLanguageLink;
		
		// Content Functions
		this.GetContent				= GetContent;
		this.GetListOfContents		= GetListOfContents;
		this.GetContentsCount		= GetContentsCount;
		this.GetRequestedContentId	= GetRequestedContentId;

		// Other Functions		
		this.GetLastUpdate			= GetLastUpdate;
		
		
		// Initialization
		Response.buffer = true;

		this.m_cn.Open(Application("ADOConnectionString"));
		
		if (this.m_nodeId == -1)
		{
			if (nodeName != "")
				this.m_nodeId = this.GetNodeId(nodeName);
			
			if (this.m_nodeId == -1)
				this.m_nodeId = this.GetDefaultNodeId();
		}
	
		if (this.m_langId == -1)
		{
			if (langName != "")
				this.m_langId = this.GetLanguageId(langName);
			
			if (this.m_langId == -1)
				this.m_langId = this.GetDefaultLanguageId();
		}
			
		if (this.m_contentId == -1)
			this.m_contentId = this.GetDefaultContentId(this.m_nodeId, this.m_langId);
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetDefaultNodeId()
	{
		var iNodeId = -1;

		var cm  = Server.CreateObject("ADODB.Command");
		var rst = Server.CreateObject("ADODB.Recordset");

		cm.ActiveConnection = this.m_cn;
		cm.CommandText  = "SELECT TOP 1 topic_id FROM Topic WHERE ((content_link=?) OR (list_link=?))";
		cm.CommandText += " AND (visible=1) AND (content_type_id Is Not Null) ORDER BY hierarchy";
		cm.Parameters.Append(cm.CreateParameter("content_link", adVarChar, adParamInput, 255));
		cm.Parameters.Append(cm.CreateParameter("list_link", adVarChar, adParamInput, 255));
		cm("content_link") = GetCurrentPage();
		cm("list_link")    = GetCurrentPage();

		rst.Open(cm);
		if(!rst.EOF)
			iNodeId = rst("topic_id").value;
		rst.Close()

		return iNodeId;
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetDefaultLanguageId()
	{
		var iLanguageId = -1;
		
		var rstLanguage = Server.CreateObject("ADODB.Recordset");
		rstLanguage.Open("SELECT language_id FROM [language] WHERE [default] = 1", this.m_cn);
		if (!rstLanguage.EOF)
			iLanguageId =  rstLanguage("language_id").value;
		rstLanguage.Close();
		
		return iLanguageId;
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetDefaultContentId(nodeId, langId)
	{
		var iContentId = 1;
		
		var strSql = "";
		strSql =  "SELECT TOP 1 Topic_Content_List.list_id ";
		strSql += "FROM Content_Text, Topic_Content_List ";
		strSql += "WHERE (((Topic_Content_List.topic_id)=" + nodeId + " AND (Topic_Content_List.topic_id)=[Content_Text].[topic_id]) ";
		strSql += "AND ((Content_Text.language_id)=" + langId + ") AND ((Topic_Content_List.list_id)=[Content_Text].[list_id])) ";
		strSql += "ORDER BY [Topic_Content_List].[order]";
		
		var rstContent = Server.CreateObject("ADODB.Recordset");
		rstContent.Open(strSql, this.m_cn);
		if (!rstContent.EOF)
			iContentId = rstContent("list_id").value;
		
		return iContentId;
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetNodeId(nodeName)
	{
		var iNodeId = -1;
		var rst = Server.CreateObject("ADODB.Recordset");
		var cm  = Server.CreateObject("ADODB.Command");

		cm.ActiveConnection = this.m_cn;
		cm.CommandText = "SELECT topic_id FROM Topic WHERE name=?";
		cm.Parameters.Append(cm.CreateParameter("name", adVarChar, adParamInput, 255));
		cm("name") = nodeName;
		
		rst.Open(cm);
		if(!rst.EOF)
			iNodeId = rst("topic_id").value;
		rst.Close()

		return iNodeId;
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetLanguageId(langName)
	{
		var iLangId = -1;
		var rst = Server.CreateObject("ADODB.Recordset");
		var strSql = "SELECT language_id FROM [language] WHERE short_name='" + langName + "'";
		rst.Open(strSql, this.m_cn);
		if(!rst.EOF)
			iLangId = rst("language_id").value;
		rst.Close()

		return iLangId;
	}
	

	////////////////////////////////////////////////////////////////////////////////////////////
	function GetRequestedNode()
	{
		return this.GetTreeNodesById(this.m_nodeId,0);
	}
	

	////////////////////////////////////////////////////////////////////////////////////////////
	function GetTreeNodesById(nodeId, deep)
	{
		var root = null;
		var pn = null;
		var oldLevel = -1;

		var strSql = "";
		
		if (nodeId < 1) // all
		{
			root = new Node(0, -1);
			pn = root;
			
			strSql = "SELECT Topic.topic_id, [Topic].[level], Topic.content_link, Topic.external_link, Topic.list_link, ";
			strSql += "Topic.content_link_target, Topic.list_link_target, Topic.external_link_target, ";			
			strSql += "Topic.hierarchy, Menu.description, Menu.image_normal, Menu.image_active, Menu.image_highlight ";			
			strSql += "FROM Topic INNER JOIN Menu ON Topic.topic_id = Menu.topic_id ";
			strSql += "WHERE ((([Topic].[level])<" + deep + ") AND ((Menu.language_id)=" + this.m_langId + ") AND ((Topic.visible)=1)) ";
			strSql += "ORDER BY Topic.hierarchy";
			
		}
		else
		{
			strSql = "SELECT T_content.topic_id, [T_content].[level], T_content.content_link, T_content.list_link, T_content.external_link, ";
			strSql += "T_content.content_link_target, T_content.list_link_target, T_content.external_link_target, ";			
			strSql += "T_content.hierarchy, Menu.description, Menu.image_normal, Menu.image_active, Menu.image_highlight ";
			strSql += "FROM Topic AS T_node, Menu INNER JOIN Topic AS T_content ON Menu.topic_id = T_content.topic_id ";
			strSql += "WHERE (((T_node.topic_id)=" + nodeId + ") AND ((T_content.hierarchy) Like ([T_node].[hierarchy]+'%')) AND ";
			strSql += "((Menu.language_id)=" + this.m_langId +") AND (([T_content].[level])>=[T_node].[level]) AND (([T_content].[level])<=([T_node].[level]+ " + deep + ")) AND ";
			strSql += "((T_content.visible)=1)) ";
			strSql += "ORDER BY T_content.hierarchy";
		}
		
		var rst = Server.CreateObject("ADODB.Recordset");
		var rst2 = Server.CreateObject("ADODB.Recordset");
		var cmd = Server.CreateObject("ADODB.Command");		
		cmd.ActiveConnection = this.m_cn;
		cmd.CommandText = "SELECT TOP 1 T_content.topic_id, T_content.content_link,  T_content.content_link_target, T_content.list_link, T_content.list_link_target ";
		cmd.CommandText += "FROM Topic AS T_node, Topic AS T_content ";
		cmd.CommandText += "WHERE T_node.topic_id=? AND (T_content.content_link Is Not Null OR T_content.list_link Is Not Null) AND T_content.hierarchy Like [T_node].[hierarchy]+ '%' AND T_content.visible=1 ";
		cmd.CommandText += "ORDER BY T_content.hierarchy";
		cmd.Parameters.Append(cmd.CreateParameter("topic_id", adInteger, adParamInput));
		
		
		rst.Open(strSql, this.m_cn);
				
		while (!rst.EOF)
		{
			var id					= rst("topic_id").value;
			var level				= rst("level").value;
			var contentLink			= rst("content_link").value;
			var listLink			= rst("list_link").value;
			var externalLink		= rst("external_link").value;
			var contentLinkTarget	= rst("content_link_target").value;
			var listLinkTarget		= rst("list_link_target").value;
			var externalLinkTarget	= rst("external_link_target").value;
			var hierarchy			= rst("hierarchy").value;

			var linkNodeId			= null;
			var link				= null;
			var linkFrameTarget		= null;
			var bExternalLink		= false;
			var bHasContents		= false;

			if (contentLink == null && listLink == null && externalLink == null)
			{
				cmd("topic_id") = id;
				rst2.Open(cmd);
				if (!rst2.EOF)
				{
					contentLink			= rst2("content_link").value;
					contentLinkTarget	= rst2("content_link_target").value;
					listLink			= rst2("list_link").value;
					listLinkTarget		= rst2("list_link_target").value;
					linkNodeId			= rst2("topic_id").value;
				}

				if (listLink != null)
				{
					link = listLink;
					linkFrameTarget = listLinkTarget;
				}
				else
				{
					link = contentLink;
					linkFrameTarget = contentLinkTarget;				
				}

				rst2.Close();
			}
			else if (contentLink != null || listLink != null)
			{
				linkNodeId	= id;
				
				if (listLink != null)
				{
					link = listLink;
					linkFrameTarget = listLinkTarget;
				}
				else
				{
					link = contentLink;
					linkFrameTarget = contentLinkTarget;				
				}
				bHasContents = true;
			}
			else
			{
				link = externalLink;	
				linkFrameTarget = externalLinkTarget;
				bExternalLink = true;
			}


			var newNode = new Node(	id,
									level, 
									rst("description").value,
									rst("image_normal").value, 
									rst("image_active").value,
									rst("image_highlight").value,
									link,
									contentLink,
									linkNodeId,
									linkFrameTarget,
									contentLinkTarget, 
									bExternalLink,
									bHasContents,
									hierarchy);

			
			if (root == null)
			{
				root = newNode;		
				pn = root;
			}
			
			if (level > oldLevel)
			{
				pn.right = newNode;
				newNode.left = pn;
			}
			else if (level == oldLevel)
			{
				pn.down = newNode;
				newNode.up = pn;
				newNode.left = pn.left;
			}
			else
			{
				while (true)
				{
					pn= pn.left;
					if (pn.level == level)
					{
						pn.down = newNode;
						newNode.up = pn;
						newNode.left = pn.left;
						break;
					}
				}
			}

			oldLevel = level;
			pn = newNode;
			rst.MoveNext();
		}
		
		rst.Close();
		return root;
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetTreeNodesByName(nodeName, deep)
	{
		nodeId = this.GetNodeId(nodeName);
		return this.GetTreeNodesById(nodeId, deep);
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetActiveLanguages()
	{
		languages = new Array();
		var rstLanguage = Server.CreateObject("ADODB.Recordset");
		rstLanguage.Open("SELECT language_id, name, short_name FROM [language] WHERE [is_active] = 1 ORDER BY [order]", this.m_cn);
		while (!rstLanguage.EOF)
		{
			languages[languages.length] = new Language(	rstLanguage("language_id").value,
														rstLanguage("name").value,
														rstLanguage("short_name").value);
			
			rstLanguage.MoveNext();
		 }
		rstLanguage.Close();
		return languages;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetRequestedLanguageId()
	{
		return this.m_langId;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetNodeLink(node, bIncludeTarget, extra_params)
	{
		if (node == null)
			return "";
			
		var extra_parameters = new Array();
		if (extra_params != null)
			for (var i=0; i < extra_params.length; i++)
				extra_parameters[i] = extra_params[i];

		extra_parameters[extra_parameters.length] = "lid=" + this.m_langId;
		return node.GetLink(bIncludeTarget, extra_parameters);
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetNodeContentLink(node, bIncludeTarget, contentId, extra_params)
	{
		if (node == null) 
			return "";
			
		if (contentId == null)
			contentId = this.GetDefaultContentId(node.GetId(), this.m_langId);
			
		var extra_parameters = new Array();
		if (extra_params != null)
			for (var i=0; i < extra_params.length; i++)
				extra_parameters[i] = extra_params[i];
		
		extra_parameters[extra_parameters.length] = "lid=" + this.m_langId;
		extra_parameters[extra_parameters.length] = "cid=" + contentId;
		return node.GetContentLink(bIncludeTarget, extra_parameters);
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetChangeLanguageLink(newLangId, extra_params)
	{
		var str = GetCurrentPage();
		str += "?nid="	+ this.m_nodeId;
		str += "&lid=" + newLangId;
		str += "&cid="	+ this.m_contentId;
		
		if (extra_params != null)
		{
			for (var i=0; i < extra_params.length; i++)
				str += ("&" + extra_params[i]);	
		}
		
		return str;
	}

	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetContent(type, nodeId, langId, contentId)
	{
		if (nodeId == null)
			nodeId = this.m_nodeId;
		
		if (langId == null)
			langId = this.m_langId;
		
		if (contentId == null)
		{
			if (nodeId == this.m_nodeId)
				contentId = this.m_contentId;
			else
				contentId = this.GetDefaultContentId(nodeId, langId);		
		}
		
		var strDbTableName = "";
		var strContentClass = "";
		
		switch (type)
		{
			case 0: 
				strDbTableName		= "Content_Text"; 
				strContentClass		= "ContentText";
				break;
			case 1: 
				strDbTableName		= "Content_HTML"; 
				strContentClass		= "ContentHTML";
				break;
		}
			
		var strSQL = "";
		var rst = Server.CreateObject("ADODB.Recordset");

		var strSQL = "SELECT * FROM " + strDbTableName + " WHERE topic_id=" +  nodeId + " AND list_id=" + contentId + " AND language_id=" + langId;

		if (this.m_bPreview)
			strSQL += " AND preview=1";
		else
			strSQL += " AND preview=0";		
			
		rst.Open(strSQL, this.m_cn, adOpenStatic, adLockReadOnly, adCmdText);
		
		return eval("new " + strContentClass + "(rst,0,0);");
	}


	////////////////////////////////////////////////////////////////////////////////////////////
	function GetListOfContents (type, orderBy, bAsc, from, to, nodeId, langId)
	{
		if (orderBy == null)	orderBy = 0;
		if (bAsc == null)		bAsc = true;
		if (from == null)		from = 0;
		if (to == null)			to = -1;
		if (nodeId == null)		nodeId = this.m_nodeId;
		if (langId == null)		langId = this.m_langId;
		
		switch (type)
		{
			case 0: 
				strDbTableName		= "Content_Text"; 
				strContentClass		= "ContentText";
				break;
			case 1: 
				strDbTableName		= "Content_HTML"; 
				strContentClass		= "ContentHTML";
				break;
		}
		
		var sOrderBy = "";
		switch (orderBy)
		{
			case 1:		sOrderBy = strDbTableName + ".[title]";				break;
			case 2:		sOrderBy = strDbTableName + ".[modification_date]";	break;
			case 3:		sOrderBy = strDbTableName + ".[creation_date]";		break;
			default:	sOrderBy = "[Topic_Content_List].[order]";			break;
		}

		if (!bAsc)
			sOrderBy += " DESC";
			
		var strSQL = "";
		var rst = Server.CreateObject("ADODB.Recordset");

		strSQL = "SELECT " + strDbTableName + ".* FROM " + strDbTableName + ", Topic_Content_List ";
		strSQL += "WHERE " + strDbTableName + ".topic_id=" + nodeId + " AND " + strDbTableName + ".topic_id=[Topic_Content_List].[topic_id] ";
		strSQL += "AND " + strDbTableName + ".language_id=" + langId + " AND " + strDbTableName + ".list_id=[Topic_Content_List].[list_id] ";

		if (this.m_bPreview)
		{
			var contentId = null;
		
			if (nodeId == this.m_nodeId)
				contentId = this.m_contentId;
			else
				contentId = this.GetDefaultContentId(nodeId, langId);		
		
			strSQL += " AND ";
			strSQL += " ((" + strDbTableName + ".list_id =" + contentId + " AND " + strDbTableName + ".preview=1) OR ";
			strSQL += "  (" + strDbTableName + ".list_id <>" + contentId + " AND " + strDbTableName + ".preview=0))";
		}
		else
			strSQL += " AND " + strDbTableName + ".preview=0";
		
		strSQL += " ORDER BY " + sOrderBy;

		rst.Open(strSQL, this.m_cn, adOpenStatic, adLockReadOnly, adCmdText);
		
		eval("oContents = new " + strContentClass + "(rst, from, to);");
		
		if (oContents.RecordCount == 0)
		{
			var oContent = this.GetContent(type, nodeId, langId);
			if (oContent.RecordCount > 0)
				return oContent;
		}

		return oContents;
	}
	

	////////////////////////////////////////////////////////////////////////////////////////////
	function GetContentsCount(nodeId, langId)
	{
		if (nodeId == null)
			nodeId = this.m_nodeId;

		if (langId == null)
			langId = this.m_langId;

		var strSql = "";
		var rst = Server.CreateObject("ADODB.Recordset");
		
		strSql =  "SELECT table_name FROM Content_Type INNER JOIN Topic ON Content_Type.content_type_id = Topic.content_type_id ";
		strSql += " WHERE topic_id=" + nodeId;
			
		rst.Open(strSql, this.m_cn);		
		if (rst.EOF || rst("table_name").value == null)
			return;
			
		var sContentTable = rst("table_name").value;
		rst.Close();
		
		strSql = "SELECT Count(content_id) AS RecordsNumber FROM " + sContentTable + " WHERE topic_id=" + nodeId + " AND language_id=" + langId + " AND preview=0";
		rst.Open(strSql, this.m_cn);		
		var recordsNumber = rst("RecordsNumber").value;
		rst.Close();
		
		return recordsNumber;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetRequestedContentId()
	{
		return this.m_contentId;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////
	function GetLastUpdate()
	{
		var rst = Server.CreateObject("ADODB.Recordset");

		rst.Open("SELECT TOP 1 modification_date FROM System", this.m_cn);
		if(!rst.EOF)
			return GetFormattedDate(rst("modification_date"), false);
		return "";
	}	
%>
