/*
 *
 *	PL/SQL-Trace - The Oracle PL/SQL Tracing Facility
 *
 *	Copyright (c) 1995-2003 by Material Dreams
 *	All rights reserved.
 *	www.materialdreams.com/oracle
 *
 *	The user executing this procedure must have the right to execute
 *	the dbms_pipe package.
 *	Use GRANT EXECUTE ON dbms_pipe to <username> to grant the rights.
 *
 */

--------------------------------------------------------------------------------
-- use this procedure to send debug messages to the PlSqlTrace utility.
--------------------------------------------------------------------------------
CREATE OR REPLACE PROCEDURE SendDebugMessage (theMessage IN VARCHAR2, thePipe IN VARCHAR2 DEFAULT 'plsql_debug') AS
status	NUMBER;
BEGIN
	dbms_pipe.pack_message(LENGTH(theMessage));
	dbms_pipe.pack_message(theMessage);
	status := dbms_pipe.send_message(thePipe);
	IF status != 0 THEN
		raise_application_error(20099, 'Debug error');
	END IF;
END SendDebugMessage;
/

--------------------------------------------------------------------------------
-- use this procedure to send debug messages (with timestamp) to the PlSqlTrace utility.
--------------------------------------------------------------------------------
CREATE OR REPLACE PROCEDURE SendTraceMessage (theMessage IN VARCHAR2, thePipe IN VARCHAR2 DEFAULT 'plsql_debug') AS
BEGIN
	SendDebugMessage(TO_CHAR(SYSDATE) || ': ' || theMessage, thePipe);
END SendTraceMessage;
/

CREATE PUBLIC SYNONYM SendDebugMessage FOR SendDebugMessage;
CREATE PUBLIC SYNONYM SendTraceMessage FOR SendTraceMessage;
