/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	EFFECT.H					(c)	YoY'01						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_EFFECT_H_
#define							_EFFECT_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						"elektrodef.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//	If you use directly the variables in the class API, it's at your own risks. Prefer the methods...   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							guidEFFECT						(Aeffect::CI.guid)

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define							effectWIDTH						512

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Aeffect : public Anode
{
public:
	ELIBOBJ

	EDLL						Aeffect							(char *name, class Atable *t);
	EDLL virtual				~Aeffect						();

	virtual bool				action							(int time, int dtime)			{ return TRUE; }

	virtual void				settings						()								{ }

	virtual bool				save							(Afile *f)						{ return TRUE; }
	virtual bool				load							(Afile *f)						{ return TRUE; }

	EDLL static Aeffect *		getEffect						(Aobject *o);

	class Atable				*table;
	class AeffectFront			*front;
	class AeffectBack			*back;

	int							id;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class AeffectFront : public Aobject
{
public:
	ELIBOBJ

	EDLL						AeffectFront					(char *name, class Aeffect *t, int h);
	EDLL virtual				~AeffectFront					();

	EDLL virtual bool			notify							(Anode *o, int event, dword p);

	Aeffect						*effect;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class AeffectBack : public Aobject
{
public:
	ELIBOBJ

	EDLL						AeffectBack						(char *name, class Aeffect *t, int h);
	EDLL virtual				~AeffectBack					();

	EDLL virtual bool			notify							(Anode *o, int event, dword p);

	Aeffect						*effect;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class AeffectInfo : public Aplugz
{
public:
	ELIBOBJ 

								AeffectInfo						(char *name, ACI *eci, char *ename, char *ehelp);

	EDLL virtual Aeffect *		create							(char *name, Atable *table)=0;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

__inline AeffectInfo::AeffectInfo(char *name, ACI *eci, char *ename, char *ehelp) : Aplugz(name, eci, ename, ehelp)
{
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_EFFECT_H
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
