// improc.h : main header file for the IMPROC DLL
//

#define impr_filterSEP2Bm fxrt
#define impr_filterSEP2 fxrth
#define impr_setSec sc
#define impr_palleteCreateBm pk
#define impr_palleteCreate pkh
#define impr_colorReplaceFBm cr
#define impr_colorReplaceF crh



#if !defined IMPROC
#define IMPROC

//#include "resource.h"		// main symbols
 
class ImProcApp : public CWinApp
{
public:
	ImProcApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ImProcApp)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(ImProcApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
 

// smoothing edge protecting filter version 2
#define LOW_BOUND_ALT 1200
#define TRESFOLD_DEL_SPOTS 4
#define DEFAULT_TOLER_PAL_CREATE 110
//1800
bool impr_filterSEP2(HBITMAP hDibSect, int lowAccBnd = LOW_BOUND_ALT,
					 bool prg = false);
//bool impr_filterSEP2Bm(RGBQUAD* pDIBits,int nWidth, 
//	 int nHeight, int semiWndSize, int lowAccBnd = LOW_BOUND_ALT,
//	 bool prg = false);
bool impr_filterSEP2Bm(int* ,int nWidth, 
	 int nHeight, int semiWndSize, int lowAccBnd = LOW_BOUND_ALT,
	 bool prg = false);

// The following function creates the palette.
// pPallete should be RGBQUAD[256] array allocated outside
// this function. The function simply fills that array.
// It returns the optimal number of entries. If fails returns 0;
// The first entry is the background color.
// All other entries are colors rated according to their popularity.
// For impr_palleteCreate function the DEFAULT_TOLER =110 may be used
unsigned char impr_palleteCreate(RGBQUAD *pPallete, 
	int tolerance,HBITMAP hDibSec , bool prg = false);
unsigned char impr_palleteCreateBm(int * , int tolerance,
		 RGBQUAD* pDIBits, int width,int height, bool prg = false);

// Given a RGBQUAD[256] palette and the number of palette entries 
// to use. The function provides fast replacement of pixels in bitmap 
// with the closest color of the palette.
bool impr_colorReplaceF(HBITMAP hDibSec , 
					 RGBQUAD* pPalette, int colorPaletteNum);
bool impr_colorReplaceFBm(int * , int pixelNum, 
					 RGBQUAD* pPalette, int colorPaletteNum);

// The following function calls impr_palleteCreate and 
// impr_colorReplaceF functions.
// if nPaletteEntries < 0 then number of colors
// are defined automatically and returned in nPaletteEntries.
// Otherewise it is used to define num of pal entries
void impr_reduceColors(HBITMAP hDibSec ,int& nPaletteEntries);
void impr_reduceColorsBm(RGBQUAD* pDIBits, int width,int height,
				  int& nPaletteEntries);
 
// The function deletes small spots providing cleaning.
//200
#define COLOR_MERGE_THRESHOLD 40
bool impr_dellSmallSpots(HBITMAP hDibSec, 
			int weightedThreshold = TRESFOLD_DEL_SPOTS,  
			int  colorMergeThreshold = COLOR_MERGE_THRESHOLD,
			bool prg = false);
bool impr_dellSmallSpotsBm(RGBQUAD* pDIBits,int width,int height, 
		int weightedThreshold = TRESFOLD_DEL_SPOTS,// threshold to del spotds  
		int  colorMergeThreshold  = COLOR_MERGE_THRESHOLD,
		// threshold to merge adjacent color parts
		bool prg = false);
bool impr_getModifiedPalette(
		HBITMAP hDibSec, 
		RGBQUAD* palette, 
		int &palEntryNum);
void impr_setSec(void* pVoid);

/*
To use

impr_filterSEP2 or impr_filterSEP2Bm

then 
impr_palleteCreate or impr_palleteCreateBm

then 
impr_colorReplaceF or impr_colorReplaceFBm

then 
impr_dellSmallSpots or impr_dellSmallSpots
*/


#endif //IMPROC
