
{.$DEFINE JPIRCDEBUG}

Unit ABI;

Interface

{$G-}

Uses DOS,CRT,XSTRING,
{$IFDEF JPIRCDEBUG}
     JPIRCWIN,
{$ENDIF}
     JP_UNIT;

{$I TCP.INC}


CONST  StandardBufSize = 1500;
       NoDriverIO : Boolean = False;
       OverRideCF : Boolean = False;
       Verbose : Boolean = True;
       DoShowTcpError : Boolean = True;

TYPE
       IPAddr       = Array[0..3] of Byte;      {dword}

			 TcpDrvInfoREC = RECORD
                        myip        : IPAddr;
												netmask 		: IPAddr;
												gateway 		: IPAddr;
												dnsserver 	: IPAddr;
												timeserver	: IPAddr;
												mtu 				: Word;
                        max_frag    : Integer;                   {? v3.01+}
                        def_ttl     : Byte;
												def_tos 		: Byte;
                      { unknown     : Array[0..1] of Byte;      }
												tcp_mss 		: Word;
												tcp_rwin		: Word;
                        traceflags  : Word;
												domain			: String[255];
{$IFDEF TCPDRV301}
                        dns_list    : Array[1..4] of IPAddr;
                        time_list   : Array[1..4] of IPAddr;
                        ip_dropped  : LongInt;
                        tcp_dropped : LongInt;
                        udp_dropped : LongInt;
{$ENDIF}
                      END;

       SesInfoREC   = RECORD
											 ip_srce		: IPAddr;
											 port_srce	: word;
											 ip_dest		: IPAddr;
											 port_dest	: word;
											 ip_prot		: Byte;
											 Active 		: Boolean;
										 END;
			 SesInfoPtr 	= ^SesInfoREC;


       TcpStatusREC = RECORD
                       StatPtr      : SesInfoPtr;
											 State				: Byte;
											 BytesReady 	: Word;
											 BytesGoing 	: Word;
											 IP_Prot				 : Byte;
											 Active 			: Boolean;
											 IP_SRCE			: IPAddr;
											 Port_srce		: Word;
											 IP_DEST			: IPAddr;
											 Port_dest		: Word;
										 END;

			 BufferREC = RECORD
                       Buffer       : Array[1..StandardBufSize] of Char;
											 Length 			: Word;
											END;

			 TcpDataREC 	= RECORD
											 ReadCRLF 		: Boolean;	{on TcpGET ONLY!}
											 Urgent 			: Boolean;	{on TcpGET ONLY!}
										 END;


{TCP Session Record contains information that is updated with our routines}

			 TcpSessionREC = RECORD
												Handle			: Word;
												LocalPort 	: Word;
												Status			: TcpStatusREC; {State}
																										{BytesReady}
																										{BytesGoing}
																										{IP_Prot}
																										{Active}
																										{IP_srce}
																										{IP_dest}
												Result			: Byte;
												Tcp_srce		: Word;
												Tcp_dest		: Word;
												IPDest			: IPAddr;
												DAT 				: TcpDataREC;  {ReadCRLF, Urgent}
												BytesTransd : Word;
												Buffer			: BufferREC;
                        Openned     : Boolean;
                      END;


			 DefaultTREC	= RECORD
												ttl 	: Byte;
												tos 	: Byte;
												id		: Word;
											timeout : Word;
										 END;


			 udpSessionREC	= RECORD
												 Handle 			: Word;
												 LocalPort		: Word;
												 udp_srce 		: Word;
												 udp_dest 		: Word;
												 Status 			: tcpStatusREC;
												 IPDest 			: IPAddr;
												 Result 			: Byte;
												 BytesTransd	: Word;
												 Buffer 			: BufferREC;
												 PktsAvail		: Word;
												 SizeNextPkt	: Word;
														{SysInfo		: SesInfoREC;}
												 pktInfo		 : DefaultTREC;
                         Openned     : Boolean;
											 END;

			 ipSessionREC 	= RECORD
													Handle			: Word;
													Protocol		: Byte;
													IPDest			: IPAddr;
													Result			: Byte;
													Status			: TcpStatusREC;
													BytesTransd : Word;
													Buffer			: BufferREC;
													PktsAvail 	: Word;
													SizeNextPkt : Word;
														{SysInfo		: SesInfoREC;}
													pktInfo 	 : DefaultTREC;
                          Openned     : Boolean;
											 END;

CONST   NullAddr: IPAddr = (0,0,0,0);

VAR Key             : String;
		Debug 					: Byte;
    CurrentHandle   : Word;
		TcpDrvInfo			: TcpDrvInfoREC;
    OldTcpInfo      : Boolean;
    TcpInfov3       : Boolean;
		TcpDrvTimeouts	: Boolean;
		TcpDrvAsync 		: Boolean;
		CurSession			: TcpSessionREC;
{    SessionHandles  : Array[0..tcpMaxSessions] of Word;           }
{    SessionTrack    : Array[0..tcpMaxSessions] of TcpSessionREC;  }

		Regs						: Registers;
		iRegs 					: Registers;
		dRegs 					: Registers;

		PktsInputQueue	: Word;
		PktsOutputQueue : Word;
		TcpDrvErr 			: Byte;

		Result					: Word;
		TcpInt					: Byte;
    DNSIPAddr       : IPAddr;
    tPointer        : Pointer;
		A 							: String;
		I 							: Integer;

  {$F+}
  var DriverCriticalFlag : ^Byte;
      DCFWaitingProc  : Procedure;
{$IFDEF DOIO_TIMER}
      OldTimer:Procedure;
{$ENDIF}
  {$F-}


{AddBuffer - Finally found an easy way to Put stuff in, or append, or delete
             from any of the tcpSessionREC,udpSessionREC,ipSessionREC buffers}
Procedure AddBuffer(var S:BufferREC; Opts:Byte; ToAdd:String);

Procedure ShowTcpError(Details: String);

{$F+}
Procedure DriverIO;
{$F-}

Procedure GetTcpDriverInfo;

Function Tcp_Active(CurrentSession:TcpSessionREC):Boolean;
Function Tcp_State(var CurrentSession:TcpSessionREC):Byte;

{ -------------- TCP ------------ }
Function Tcp_Open(var NewSession:TcpSessionREC; Opts:Byte; host:IPAddr;
													 tcp_srce:Word; tcp_dest:Word; timeout:Word):Byte;
Function Tcp_Close(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
Function Tcp_Get(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
Function Tcp_Put(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
Function Tcp_Status(var CurrentSession:TcpSessionREC; Opts:Byte):Byte;
Procedure tcp_sendtext(var S:tcpSessionREC; ToSend:String);
Procedure tcp_sendtextln(var S:tcpSessionREC; ToSend:String);

{ -------------- IP ------------ }

Function ip_Open(var NewSession:ipSessionREC; Opts:Byte; host:IPAddr;
									 protocol:byte):Byte;
Function ip_Close(var CurrentSession:ipSessionREC; Opts:Byte):Byte;
Function ip_Recv(var CurrentSession:ipSessionREC; Opts:Byte; timeout:Word):Byte;
Function ip_Send(var CurrentSession:ipSessionREC; Opts:Byte; id:Word;
														ttl:Word; tos:Word; timeout:Word):Byte;
Function ip_Status(var CurrentSession:ipSessionREC; Opts:Byte):Byte;

{ -------------- UDP ------------ }

Function udp_Open(var NewSession:udpSessionREC; Opts:Byte; host:IPAddr;
									 udp_srce:Word; udp_dest:Word):Byte;
Function Udp_Close(var CurrentSession:udpSessionREC; Opts:Byte):Byte;
Function Udp_Recv(var CurrentSession:udpSessionREC; Opts:Byte; timeout:Word):Byte;
Function Udp_Send(var CurrentSession:udpSessionREC; Opts:Byte; id:Word;
														ttl:Word; tos:Word; timeout:Word):Byte;
Function Udp_Status(var CurrentSession:udpSessionREC; Opts:Byte):Byte;

Procedure TcpDrvCALL(var R:Registers);
(****************************************************)
Implementation
(****************************************************)

Procedure DefaultDCFWaiting; far;
 begin
  Write('[WAIT]');
  asm
   nop
   nop
  end;
 end;

Procedure TcpDrvCALL(var R:Registers);
 begin
   If DriverCriticalFlag<>nil then
     begin
         While (DriverCriticalFlag^<>0) and (OverRideCF=false)
               and (not IsScrLock) do
             DCFWaitingProc;
     end;
{   If IsScrLock then exit; }
   Intr(TcpInt, R);
 end;

Procedure AddBuffer(var S:BufferREC; Opts:Byte; ToAdd:String);
 begin
  If (Opts AND 1)=0 then S.Length:=0;
  If (Length(ToAdd)+S.Length > SizeOf(S.Buffer)) then
		 begin
      Writeln('Buffer Overflow locally ERROR IN ADDBUFFER ');
			exit;
		 end;

      Move(ToAdd[1], S.Buffer[S.Length+1], Ord(ToAdd[0]));
      S.Length:=S.Length+Ord(ToAdd[0]);
 end;

Procedure ShowTcpError(Details: String);
var
	eWord:Word;
	TmpRes:String;
begin
  eWord:=Regs.DL;
  If (DoShowTcpError=False) and (eWord>2) then exit;
  TmpRes:='UnkownError';
	If eWord=1 then TmpRes:='err_badcall';
	If eWord=2 then TmpRes:='err_critical';
	If eWord=3 then TmpRes:='err_nohandles';
	If eWord=4 then TmpRes:='err_badhandle';
	If eWord=5 then
		begin
			TmpRes:='err_timeout';
			If debug=1 then TmpRes:='';
		end;
	If eWord=6 then TmpRes:='err_badsession';

	If eWord=0 then TmpRes:='';
	If Details='' then Details:='Unspecified details';
	if (tmpres<>'') and (Debug>0) then
		begin
			Writeln('[ERROR:'+TmpRes+'@ '+Details+']');
		end;
end;


{$F+}
Procedure DriverIO;
begin
    If DriverCriticalFlag^<>0 then Write('[!!ERROR!!]');
    If DriverCriticalFlag^<>0 then exit;
    If NoDriverIO=True then Write('[NOIO]');
    If NoDriverIO=True then exit;
    iRegs.AX:=$0200;
    iRegs.BX:=0; iRegs.CX:=0; iRegs.DX:=0;
    Intr(TcpInt,iRegs);
    TcpDrvErr:=iRegs.DL;
    PktsInputQueue:=iRegs.AX;
    PktsOutputQueue:=iRegs.CX;
end;
{$F-}

Procedure GetTcpDriverInfo;
 var
	 tWord:Word;
 begin
							 Regs.AX:=$0400; Regs.CX:=SizeOf(TcpDrvInfo);
							 Regs.ES:=Seg(TcpDrvInfo);
							 Regs.DI:=Ofs(TcpDrvInfo);
               TcpDrvCALL(Regs);
							 tWord:=Regs.CX;
               If tWord = 288 then OldTcpInfo:=True;
               If tWord = 288+44 then TcpInfov3:=True;
 end;

Function Tcp_Open(var NewSession:TcpSessionREC; Opts:Byte; host:IPAddr;
									 tcp_srce:Word; tcp_dest:Word; timeout:Word):Byte;
 var
	Result:Byte;
 begin
  verbose:=true;       {CONSTRUCTION}
	Regs.AH:=$10; Regs.AL:=Opts;		{Opts:	 0=normal, 1=listener, 128=async}
  FillChar (NewSession, SizeOf(NewSession), 0);
	NewSession.Tcp_srce:=tcp_srce;					{source port}
	NewSession.Tcp_dest:=tcp_dest;					{destination port}
	NewSession.IPDest:=host;								{destination IP}
	Regs.BX:=tcp_srce; Regs.CX:=tcp_dest;
	Regs.DI:=host[0]+(host[1]*256);
	Regs.SI:=host[2]+(host[3]*256);
	Regs.DX:=timeout;
(******
  If Verbose then
    begin
      Writeln('tcp_srce ',tcp_srce);
      Writeln('tcp_dest ',tcp_dest);
      Writeln('timeout  ',timeout);
    end;
*******)
  TcpDrvCALL(Regs);
	NewSession.Result:=Regs.DL;
	ShowTcpError('Tcp_Open');
	Result:=Regs.DL;
  NewSession.Openned:=False;
  If Result=0 then
		begin
			NewSession.Handle:=Regs.BX;
			NewSession.LocalPort:=Regs.AX;
			CurrentHandle:=Regs.BX;
      NewSession.Openned:=True;
(**********
     if Verbose then
      begin
       Writeln(' Port : ',NewSession.LocalPort);
       Writeln('handle: 0x'+WordToHexASCII(NewSession.Handle));
      end;
***********)
       dRegs.AH:=$14; dRegs.AL:=Opts; dRegs.BX:=NewSession.Handle;
			 dRegs.CX:=0; dRegs.DX:=0;
       TcpDrvCALL(dRegs);
       if debug>0 then ShowTcpError('Tcp_open-Status');
			 NewSession.Status.State:=dRegs.DH;
			 NewSession.Status.BytesReady:=dRegs.AX;
			 NewSession.Status.BytesGoing:=dRegs.CX;
			 NewSession.Status.StatPtr:=Ptr(dRegs.ES, dRegs.DI);
       NewSession.Status.IP_SRCE:=NewSession.Status.StatPtr^.ip_srce;
       NewSession.Status.IP_DEST:=NewSession.Status.StatPtr^.ip_dest;
       NewSession.Status.ip_prot:=NewSession.Status.StatPtr^.ip_prot;
       NewSession.Status.Active:=NewSession.Status.StatPtr^.Active;
			 NewSession.Result:=dRegs.DL;
		end;

	Tcp_Open:=Result;
 end;

Function Tcp_Active(CurrentSession:TcpSessionREC):Boolean;
 begin
   Tcp_Active:=(CurrentSession.Status.StatPtr^.Active);
 end;

Function Tcp_State(var CurrentSession:TcpSessionREC):Byte;
 begin
	 dRegs.AH:=$14; dRegs.AL:=0;
	 dRegs.BX:=CurrentSession.Handle;
   TcpDrvCALL(dRegs);
	 CurrentSession.Status.State:=dRegs.DH;
   CurrentSession.Result:=dRegs.DL;                   {new}
   CurrentSession.Status.BytesReady:=dRegs.AX;
	 CurrentSession.Status.BytesGoing:=dRegs.CX;
	 Tcp_State:=CurrentSession.Status.State;
 end;

Function Tcp_Close(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
 var
	 LocalPort:Word;				{close with timeout 0 does NOT release the handle}
 begin
	Regs.AH:=$11; Regs.AL:=Opts;		{Opts:	 0=normal, 1=listener, 128=async}
	Regs.BX:=CurrentSession.Handle; Regs.CX:=0;
	Regs.DX:=timeout;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Tcp_Close');
	Tcp_Close:=Regs.DL;
  CurrentSession.Openned:=False;
  If ((Opts and 1) =1) and (timeout=0) then CurrentSession.Openned:=True;
 end;

Function Tcp_Get(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
begin
	Regs.AH:=$12; Regs.AL:=Opts;		{Opts:	 0=normal (wait till buffer full) 	 }
																			 {	 1=get as much as possible and return}
																			 {	 2=read to <cr><lf> (don't include)  }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle; Regs.CX:=SizeOf(CurrentSession.Buffer.Buffer);
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
	Regs.DX:=timeout;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Tcp_Get');
  Tcp_Get:=tcp_Status(CurrentSession,0);                  {Regs.DL}
	{ax = no. bytes transferred}
	CurrentSession.BytesTransd:=Regs.AX;
	CurrentSession.Buffer.Length:=Regs.AX;
	{dh = returned flags:  2 = <cr><lf> read in option 2,  8 = urgent data present}
	If (Regs.DH AND 2)=2 then CurrentSession.DAT.ReadCRLF:=true
												else CurrentSession.DAT.ReadCRLF:=false;
	If (Regs.DH AND 8)=8 then CurrentSession.DAT.Urgent:=true
												else CurrentSession.DAT.Urgent:=false;
end;

Function Tcp_Put(var CurrentSession:TcpSessionREC; Opts:Byte; timeout:Word):Byte;
begin
	Regs.AH:=$13; Regs.AL:=Opts;		{Opts:	 0=normal wait till buffer delivered }
																			 {	 1=put as much as possible & return  }
																			 {	 2=append <cr><lf> to data					 }
																			 {	 4=push (wait till data acknowledged)}
																			 {	 8=urgent data											 }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle;
	Regs.CX:=CurrentSession.Buffer.Length;
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
	Regs.DX:=timeout;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Tcp_Put');
  Tcp_Put:=tcp_Status(CurrentSession,0);         {Regs.DL}
	{ax = no. bytes transferred}
	CurrentSession.BytesTransd:=Regs.AX;
end;

Function Tcp_Status(var CurrentSession:TcpSessionREC; Opts:Byte):Byte;
 var
	 SesInfoP 	: SesInfoPtr;
	 TmpIP			: IPAddr;
	 TmpLong		: Longint;
	 I					: Integer;
	 TmpOff 		: Word;
	 TmpSeg 		: Word;
 begin
	dRegs.AH:=$14; dRegs.AL:=Opts;		{Opts:	 0=normal, 1=listener, 128=async}
	dRegs.BX:=CurrentSession.Handle;
	dRegs.CX:=0;	dRegs.DX:=0;
  TcpDrvCALL(dRegs);
	ShowTcpError('Tcp_Status');
			 CurrentSession.Status.State:=dRegs.DH;
			 CurrentSession.Status.BytesReady:=dRegs.AX;
			 CurrentSession.Status.BytesGoing:=dRegs.CX;
			 SesInfoP:=Ptr(dRegs.ES, dRegs.DI);
			 CurrentSession.Status.IP_SRCE:=SesInfoP^.ip_srce;
			 CurrentSession.Status.IP_DEST:=SesInfoP^.ip_dest;
       CurrentSession.Status.port_srce := SesInfoP^.port_srce;
       CurrentSession.Status.port_dest := SesInfoP^.port_dest;
       CurrentSession.Status.ip_prot:=SesInfoP^.ip_prot;
			 CurrentSession.Status.Active:=SesInfoP^.Active;
	CurrentSession.Result:=Regs.DL;
	Tcp_Status:=Regs.DL;
 end;


Procedure tcp_sendtext(var S:tcpSessionREC; ToSend:String);
 begin
   AddBuffer(S.Buffer, 0, ToSend);
   {tcp_Put(S, 4, $FFFF);}
   tcp_Put(S, 4, $0000);

 end;

Procedure tcp_sendtextln(var S:tcpSessionREC; ToSend:String);
 begin
   AddBuffer(S.Buffer, 0, ToSend);
   tcp_Put(S, 6, $FFFF);
 end;





(********************************UDP***************************************)

Function udp_Open(var NewSession:udpSessionREC; Opts:Byte; host:IPAddr;
									 udp_srce:Word; udp_dest:Word):Byte;
 var
	Result:Byte;
 begin
  Regs.AH:=$20; Regs.AL:=Opts;    {Opts:   0=normal, 128=async}
	FillChar (NewSession, SizeOf(NewSession), 0);
	NewSession.udp_srce:=udp_srce;
	NewSession.udp_dest:=udp_dest;
	NewSession.IPDest:=host;
	Regs.BX:=udp_srce; Regs.CX:=udp_dest;
	Regs.DI:=host[0]+(host[1]*256);
	Regs.SI:=host[2]+(host[3]*256);
  TcpDrvCALL(Regs);
	NewSession.Result:=Regs.DL;
	ShowTcpError('Udp_Open');
	Result:=Regs.DL;
	If Result=0 then
		begin
			NewSession.Handle:=Regs.BX;
			NewSession.LocalPort:=Regs.AX;
			CurrentHandle:=Regs.BX;
(********
     if verbose then
      begin
       Writeln(' Port : ',NewSession.LocalPort);
       Writeln('handle: 0x'+WordToHexASCII(NewSession.Handle));
      end;
********)
    end;
	Udp_Open:=Result;
 end;

Function Udp_Close(var CurrentSession:UdpSessionREC; Opts:Byte):Byte;
 var
	 LocalPort:Word;				{close with timeout 0 does NOT release the handle}
 begin
	Regs.AH:=$21; Regs.AL:=Opts;		{Opts:	 0=normal, 128=async}
	Regs.BX:=CurrentSession.Handle;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Udp_Close');
	Udp_Close:=Regs.DL;
 end;

Function Udp_Recv(var CurrentSession:udpSessionREC; Opts:Byte; timeout:Word):Byte;
begin
	Regs.AH:=$22; Regs.AL:=Opts;		{Opts:	 0=normal (wait till buffer full) 	 }
																			 {	 1=get as much as possible and return}
																			 {	 2=read to <cr><lf> (don't include)  }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle; Regs.CX:=SizeOf(CurrentSession.Buffer.Buffer);
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
	Regs.DX:=timeout;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Udp_Recv');
	Udp_Recv:=Regs.DL;
	{ax = no. bytes transferred}
	CurrentSession.BytesTransd:=Regs.AX;
	CurrentSession.Buffer.Length:=Regs.AX;
	{dh = returned flags:  2 = <cr><lf> read in option 2,  8 = urgent data present}
	CurrentSession.BytesTransd:=Regs.AX;
	CurrentSession.Buffer.Length:=Regs.AX;
	CurrentSession.pktInfo.ttl:=lo(Regs.BP);
	CurrentSession.pktInfo.tos:=hi(Regs.BP);
	CurrentSession.pktInfo.id:=Regs.SI;
end;

Function Udp_Send(var CurrentSession:udpSessionREC; Opts:Byte; id:Word;
														ttl:Word; tos:Word; timeout:Word):Byte;
begin
	Regs.AH:=$23; Regs.AL:=Opts;		{Opts:	 0=normal wait till buffer delivered }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle;
	Regs.CX:=CurrentSession.Buffer.Length;
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
	Regs.DX:=timeout;
  Regs.SI:=id;  Regs.BP:=lo(ttl)+(lo(tos)*256);
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Udp_Send');
	Udp_Send:=Regs.DL;
	{ax = no. bytes transferred}
{         Writeln(Regs.DL, '    ',Regs.CX);   }
  CurrentSession.BytesTransd:=Regs.CX;
end;

Function Udp_Status(var CurrentSession:udpSessionREC; Opts:Byte):Byte;
 var
	 SesInfoP 	: SesInfoPtr;
	 TmpIP			: IPAddr;
	 TmpLong		: Longint;
	 I					: Integer;
	 TmpOff 		: Word;
	 TmpSeg 		: Word;
 begin
	dRegs.AH:=$24; dRegs.AL:=Opts;		{Opts:	 0=normal, 1=listener, 128=async}
	dRegs.BX:=CurrentSession.Handle;
	dRegs.CX:=0;	dRegs.DX:=0;
  TcpDrvCALL(dRegs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('Udp_Status');
			 CurrentSession.PktsAvail:=dRegs.AX;
			 CurrentSession.SizeNextPkt:=dRegs.CX;
			 SesInfoP:=Ptr(dRegs.ES, dRegs.DI);
			 CurrentSession.Status.IP_SRCE:=SesInfoP^.ip_srce;
			 CurrentSession.Status.IP_DEST:=SesInfoP^.ip_dest;
			 CurrentSession.Status.ip_prot:=SesInfoP^.ip_prot;
			 CurrentSession.Status.Active:=SesInfoP^.Active;
	Udp_Status:=Regs.DL;
 end;

(******************************** IP **************************************)

Function ip_Open(var NewSession:ipSessionREC; Opts:Byte; host:IPAddr;
									 protocol:byte):Byte;
 var
	Result:Byte;
 begin
	Regs.AH:=$30; Regs.AL:=Opts;		{Opts:	 0=normal, 128=async}
	FillChar (NewSession, SizeOf(NewSession), 0);
	Regs.BL:=protocol;
	Regs.DI:=host[0]+(host[1]*256);
	Regs.SI:=host[2]+(host[3]*256);
  TcpDrvCALL(Regs);
	NewSession.Result:=Regs.DL;
	ShowTcpError('IP_Open');
	Result:=Regs.DL;
	If Result=0 then
		begin
      NewSession.Handle:=Regs.BX;   {was Regs.AX but it isn't correct?}
(****
      If Verbose then
          Writeln('IP handle: 0x'+WordToHexASCII(NewSession.Handle));
******)
    end;
{  Write('Other: ',ip_Status(NewSession, Opts)); }
	ip_Open:=Result;
 end;

Function ip_Close(var CurrentSession:ipSessionREC; Opts:Byte):Byte;
 begin
	Regs.AH:=$31; Regs.AL:=Opts;		{Opts:	 0=normal, 128=async}
	Regs.BX:=CurrentSession.Handle;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('ip_Close');
	ip_Close:=Regs.DL;
 end;

Function ip_Recv(var CurrentSession:ipSessionREC; Opts:Byte; timeout:Word):Byte;
begin
	Regs.AH:=$32; Regs.AL:=Opts;		{Opts:	 0=normal (wait till buffer full) 	 }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle; Regs.CX:=SizeOf(CurrentSession.Buffer.Buffer);
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
  Regs.DX:=timeout;
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('ip_Recv');
	ip_Recv:=Regs.DL;
	{ax = no. bytes transferred}
	CurrentSession.BytesTransd:=Regs.AX;
	CurrentSession.Buffer.Length:=Regs.AX;
	CurrentSession.pktInfo.ttl:=lo(Regs.BP);
	CurrentSession.pktInfo.tos:=hi(Regs.BP);
	CurrentSession.pktInfo.id:=Regs.SI;
end;

Function ip_Send(var CurrentSession:ipSessionREC; Opts:Byte; id:Word;
														ttl:Word; tos:Word; timeout:Word):Byte;
begin                  {NOTE: timeout value not used, remove in future}
	Regs.AH:=$33; Regs.AL:=Opts;		{Opts:	 0=normal wait till buffer delivered }
																			 { 128=async														 }
	Regs.BX:=CurrentSession.Handle;
  Regs.CX:=CurrentSession.Buffer.Length;        {CurrentSession.Buffer.Length;}
	Regs.ES:=Seg(CurrentSession.Buffer.Buffer);
	Regs.DI:=Ofs(CurrentSession.Buffer.Buffer);
  Regs.DX:=CurrentSession.Handle;              {timeout;}
	Regs.SI:=id;	Regs.BP:=ttl+(tos*256);
  TcpDrvCALL(Regs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('ip_Send');
	ip_Send:=Regs.DL;
	{ax = no. bytes transferred}
	CurrentSession.BytesTransd:=Regs.AX;
end;

Function ip_Status(var CurrentSession:ipSessionREC; Opts:Byte):Byte;
 var
	 SesInfoP 	: SesInfoPtr;
	 TmpIP			: IPAddr;
	 TmpLong		: Longint;
	 I					: Integer;
	 TmpOff 		: Word;
	 TmpSeg 		: Word;
 begin
	dRegs.AH:=$14; dRegs.AL:=Opts;		{Opts:	 0=normal, 1=listener, 128=async}
	dRegs.BX:=CurrentSession.Handle;
	dRegs.CX:=0;	dRegs.DX:=0;
  TcpDrvCALL(dRegs);
	CurrentSession.Result:=Regs.DL;
	ShowTcpError('ip_Status');
			 CurrentSession.Status.State:=dRegs.DH;
			 CurrentSession.PktsAvail:=dRegs.AX;
			 CurrentSession.SizeNextPkt:=dRegs.CX;
			 SesInfoP:=Ptr(dRegs.ES, dRegs.DI);
			 CurrentSession.Status.IP_SRCE:=SesInfoP^.ip_srce;
			 CurrentSession.Status.IP_DEST:=SesInfoP^.ip_dest;
			 CurrentSession.Status.ip_prot:=SesInfoP^.ip_prot;
			 CurrentSession.Status.Active:=SesInfoP^.Active;
	ip_Status:=Regs.DL;
 end;

{$IFDEF JPIRCDEBUG}
Procedure ListAll;
var
  SesInfoP : SesInfoPtr;
  TmpIP : IPAddr;
  TmpLong: LongInt;
  I: Integer;
  TmpOff,TmpSeg:Word;
Begin

End;


{$ENDIF}

Function SearchForTcpInt:Byte;
 var
   TmpInt:Byte;
 begin
  SearchForTcpInt:=0;
  For TmpInt:=$60 to $FF do
     begin
        A:='';
        GetIntVec(TmpInt,tPointer);
        For I := 0 TO 15 DO A:=A + Chr(Mem[Seg(tPointer^):Ofs(tPointer^)+I]);
        If Copy(A,4,8)='TCP_DRVR' then
          begin
            SearchForTcpInt:=TmpInt;
            break;
          end;
     end;
 end;


Procedure PushKey(Ch: Char);
var
  TempTail :Word;
  Head: Word Absolute $0040:$001A;
  Tail: Word Absolute $0040:$001C;
  WP :^Word;
begin
  TempTail:=Tail;
  Tail:=Tail+2;
  If Head=Tail then
      Begin
        Tail:=TempTail;
        Sound(540);
        Delay(200);
        NoSound;
     End Else Begin
        WP:=Ptr($40, TempTail);
        WP^ := Ord(Ch)+(0*256) AND 65535;
        If (Tail<$200) and (Tail>60) then Tail:=30;
        If (Tail>$1FF) and (Tail>$200+254) then Tail:=$200;
      End;
end;

{$IFDEF NOIO_TIMER}
{$F+}
VAR LI:longint;

CONST
   inside: boolean = FALSE;
   ClockInt: byte = $08;
   smooth: boolean = TRUE;

Procedure NewTimer(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word);
interrupt;
 begin
  asm cli end;
  If (INSIDE=TRUE) then
    begin
                                                {$IFDEF CXINT}
                                                     if smooth then
                                                         asm
                                                            pushf
                                                            call OldTimer;
                                                            sti
                                                         end;
                                                {$ENDIF}
     asm iret end;
    end;
  INSIDE:=TRUE;
 { if DriverCriticalFlag^<>0 then Write('');}
  If DriverCriticalFlag^=0 then DriverIO;     {   else Write('');}
  asm
    pushf
    call OldTimer;
		sti
	end;
  inside:=FALSE;
 end;
{$ENDIF}

var    SaveExitProc    : Pointer;

Procedure NewExitProc; far;
 begin
     ExitProc := SaveExitProc;

{$IFDEF DOIO_TIMER}
       if debug>1 then Write('Pre-Remove:');
       SetIntVec(ClockInt, @OldTimer);
       if debug>1 then Writeln('Post-Remove');
{$ENDIF}
        If Verbose then
          Begin
             Writeln; Writeln('Exiting');
          End;
       SetCBreak(True);
{
       Write('DriverCriticalFlag = ');
       If DriverCriticalFlag=nil then Write('NIL')  else Write('valid');
       Writeln('    = ',DriverCriticalFlag^);
}
{        SaveExitProc:=ExitProc;}
  end;

{$F-}

(********************************************************************)

function Is286Able: Boolean; assembler;
asm
				PUSHF
				POP 		BX
				AND 		BX,0FFFH
				PUSH		BX
				POPF
				PUSHF
				POP 		BX
				AND 		BX,0F000H
				CMP 		BX,0F000H
				MOV 		AX,0
				JZ			@@1
				MOV 		AX,1
@@1:
end;

BEGIN
{$IFDEF SHOWSTARTMSG}
 for I:=1 to StartUpMsgLen do Write(StartUpMsg[I]);
{$ENDIF}

{$IFOPT G+}
   If not Is286Able then
     Begin
       Writeln('This program requires a 286 CPU or better.');
       Halt(86);
     End;
{$ENDIF}

  TcpInt:=$61;           {This is the DEFAULT interrupt to check}

	If Copy(ParamStr(1),1,2)='0x' then
						 Val('$'+Copy(ParamStr(1),3,Length(ParamStr(1))-2),TcpInt,Result);
	If (TcpInt<$60) or (TcpInt>$7F) then
	 begin
			Writeln('Invalid Interrupt number (0x'+ByteToHEXASCII(TcpInt)+')');
      Halt(255);
	 end;
	A:='';
	GetIntVec(TcpInt,tPointer);
	For I := 0 TO 15 DO A:=A + Chr(Mem[Seg(tPointer^):Ofs(tPointer^)+I]);
	If not (Copy(A,4,8)='TCP_DRVR') then
		begin
     TcpInt:=SearchForTcpInt;
     If TcpInt=0 then
          begin
             If AutoLoadNTCPDRV and (ParamStr(1)<>'') then
               BEGIN
                 A:='ntcpdrv'+#13+ParamStr(0)+' '+#13;
                 For I:=1 to Length(A) do PushKey(A[I]);
              END ELSE BEGIN
                 Writeln('Error: Interrupt 0x61 does not point to a Trumpet TCP driver!');
                 Writeln('       Not only that, but we also couldn''t find it anywheres else either!');
               END;
             Halt(61);
          end;
    end;


	PktsInputQueue:=0; PktsOutputQueue:=0;
 FillChar (dRegs, SizeOf(dRegs), 0);
 FillChar (iRegs, SizeOf(iRegs), 0);
 FillChar (Regs, SizeOf(Regs), 0);
 FillChar (CurSession, SizeOf(CurSession), 0);

  If debug>0 then Writeln('0x'+ByteToHEXASCII(TcpInt));
  Regs.AX:=$00FF; Regs.BX:=0; Regs.CX:=0; Regs.DX:=0;
	Intr(TcpInt,Regs);
	If Regs.AL=$0 then
		begin
          {     Write(' Trumpet TCP/IP TSR       | ');}
							 GetTcpDriverInfo;
{               If OldTcpInfo then Writeln('Using OLD (v2.xx) TcpInfo');     }
{               If TcpInfov3 then Writeln('Using TcpInfo on v3.xx NTCPDRV'); }
{              Writeln('Domain = ',#34,TcpDrvInfo.domain,#34);}
							 TcpDrvTimeouts := (Regs.DH AND 1)=1;
							 TcpDrvAsync		:= (Regs.DH AND 2)=2;
          {if debug>2 then Writeln('  Supports:  Timeouts=',TcpDrvTimeouts,'    Async=',TcpDrvAsync);}
		end else Writeln('false?');
  (**********************
    Writeln('           MyIP=',IPTOASCII(TcpDrvInfo.myip));
    Writeln('        NetMask=',IPTOASCII(TcpDrvInfo.netmask));
    Writeln('        Gateway=',IPTOASCII(TcpDrvInfo.gateway));
    Writeln('            DNS=',IPTOASCII(TcpDrvInfo.dnsserver));
    Writeln('     TimeServer=',IPTOASCII(TcpDrvInfo.timeserver));
  **************************)
  If TcpDrvInfo.traceflags<>0 then Writeln('    DEBUG = ',TcpDrvInfo.traceflags);
	Writeln;
	Debug:=1;

  SaveExitProc:=ExitProc;
  ExitProc:=@NewExitProc;


  Regs.AH:=$03;
  Intr(TcpInt, Regs);
  ShowTcpError('CRITICAL FLAG');
  DriverCriticalFlag:=nil;
  DriverCriticalFlag:=Ptr (Regs.ES, Regs.DI);
  If (Regs.ES=0) and (Regs.DI=0) then DriverCriticalFlag:=nil;
  If (Regs.DL<>0) then DriverCriticalFlag:=nil;
  DCFWaitingProc:=DefaultDCFWaiting;

{$IFDEF DOIO_TIMER}
  if debug >1 then Write('Pre-Install:');
  GetIntVec(ClockInt,@OldTimer);
  SetIntVec(ClockInt,Addr(NewTimer));
  if debug >1 then Writeln('Post-Install');
{$ENDIF}

END.

