(*

  Tandy BGI Driver demo

  (c)Copyright 1991 - Michael Chapin

*)

Program BGI_DEMO;

Uses
  Crt,
  graph;

Const
  XparentLine = 5;
  XparentPat = 4;
  PatBase = 6;
  LineBase = 22;

  zig : Array[1..10] Of Integer =
    (30, 10, 150, 25, 50, 88, 130, 88, 30, 10);

Var
  midscrx, midscry : Integer;
  gd, gm           : Integer;
  AutoDetect       : Pointer;
  x, y             : Integer;


{$F+}
Function DetectTandy : Integer;
Var
  Vid : Integer;
  ch  : Char;
Begin
  WriteLn;
  WriteLn;
  WriteLn('0 - Tandy 1000 160x200x16');
  WriteLn('1 - Tandy 1000 320x200x16');
  WriteLn;
  Write('Choose Mode:');
  Repeat
    ch := ReadKey;
  Until((ch = '0') Or (ch = '1'));
  DetectTandy := Ord(ch) - 48;
End;
{$F-}

Procedure DrawScreen;
Begin
  ClearDevice;
  SetColor(15);
  Rectangle(0, 0, GetMaxX, GetMaxY);
  Line(0, 11, GetMaxX, 11);
End;

Var
  Clock : LongInt Absolute $0040:$006C;

Procedure PauseIt(secs : Integer);
Var
  stop : LongInt;
  ch   : Char;
  loop : Boolean;
Begin
  secs := secs * 18;
  stop := Clock + secs;
  ch := #0;
  Loop := True;
  While (Clock < stop) And Loop Do
  Begin
    If KeyPressed Then
    Begin
      ch := ReadKey;
      loop := False;
    End;
  End;
  If ch = #27 Then
  Begin
    CloseGraph;
    Halt(0);
  End;
End;

Procedure FirstScreen;
Var
 strg  : String[6];
Begin
  DrawScreen;
  SetTextJustify(CenterText, TopText);
  SetColor(Red);
  OutTextXY(midscrx, 2, 'Tandy BGI Driver');
  SetColor(Yellow);
  OutTextXY(midscrx, 190, '<ESC> to end demo');
  MoveTo(3, 14);
  SetColor(7);
  SetTextJustify(LeftText, TopText);
  OutText('X resolution: ');
  SetColor(15);
  Str(GetMaxX + 1, strg);
  OutText(strg);
  MoveTo(3, 24);
  SetColor(7);
  OutText('Y resolution: ');
  SetColor(15);
  OutText('200');
  MoveTo(3, 34);
  SetColor(7);
  OutText('Max colors: ');
  SetColor(15);
  OutText('16');
  PauseIt(4);
  SetFillStyle(SlashFill, 5);
  SetWriteMode(XparentPat);
  SetColor(5);
  Bar3D(10, 10, 100, 100, 0, False);
  PauseIt(8);
End;

Procedure SecondScreen;
Var
  x, y, z, i : Integer;
Begin
  DrawScreen;
  SetColor(9);
  SetTextJustify(CenterText, TopText);
  OutTextXY(midscrx, 2, 'Lines');
  SetLineStyle(DashedLn, 0, NormWidth);
  z := (GetMaxX Div 16) - 2;
  For y := 0 To 15 Do
  Begin
    SetWriteMode(LineBase + y);
    i := 20;
    For x := 0 To 15 Do
    Begin
      SetColor(x);
      Line(i, 12, i, 198);
      Inc(i, z);
    End;
    PauseIt(1);
  End;
  PauseIt(3);
End;

Procedure XorCircle;
Begin
  DrawScreen;
  SetColor(11);
  SetTextJustify(CenterText, TopText);
  OutTextXY(midscrx, 2, 'XOR Circle');
  SetFillStyle(SolidFill, 14);
  Bar(1, 12, midscrx - 1, 198);
  SetWriteMode(1);
  SetColor(6);
  Circle(midscrx, midscry, 50);
  PauseIt(3);
  SetWriteMode(0);
  SetWriteMode(XparentPat);
  SetFillStyle(SlashFill, 2);
  SetColor(2);
  FillEllipse(midscrx, midscry, 50, 25);
  PauseIt(2);
  SetFillStyle(BKslashFill, 4);
  SetColor(4);
  SetWriteMode(PatBase + LightGray);
  FillEllipse(midscrx, midscry - 10, 50, 25);
  PauseIt(4);
End;

Procedure PolyDemo;
Begin
  DrawScreen;
  SetColor(6);
  SetTextJustify(CenterText, TopText);
  OutTextXY(midscrx, 2, 'Poly. Fill');

  SetFillStyle(SolidFill, 14);
  Bar(1, 12, midscrx - 1, 198);

  SetWriteMode(1);
  SetWriteMode(PatBase + Red);
  SetFillStyle(XhatchFill, 7);
  SetLineStyle(SolidLn, 0, 1);
  SetColor(2);
  FillPoly(5, zig);
  PauseIt(4);
End;


BEGIN
  AutoDetect := @DetectTandy;
  WriteLn('BGI Tandy 1000 Driver Demo.');
  WriteLn('(c)Copyright 1991, Michael Chapin');
  WriteLn;

  gd := InstallUserDriver('T1000', AutoDetect);
  gd := Detect;
  InitGraph(gd, gm, '');

  x := GraphResult;
  If x <> 0 Then
    Halt(x);
  midscrx := GetMaxX Div 2;
  midscry := (GetMaxY - 12) Div 2;

  FirstScreen;
  SecondScreen;
  XorCircle;
  PolyDemo;
  CloseGraph;
END.





