;------------------------------------------------------------------------
;                                                                        
; CSRPRT.INC Printer and Print-To-Device Include File for DMCSR
;                                                                        
;------------------------------------------------------------------------

; Printer margin 
MARGIN struc
    MARGIN_left               db  ?   ;left margin 
    MARGIN_lnwidth            db  ?   ;line width 
    MARGIN_linepp             db  ?   ;total lines per page 
    MARGIN_plinepp            db  ?   ;printed lines per page 
MARGIN ends



; Page setup 
PGSETUP struc
    PGSETUP_mode              db  ?   ;LANDSCAPE,PORTRAIT 
    PGSETUP_mNotebk           db  size MARGIN dup (?)   ;notebook is no longer supported 
    PGSETUP_mLandscp          db  size MARGIN dup (?)   ;landscape margin defs 
    PGSETUP_mPortrait         db  size MARGIN dup (?)   ;portrait margin defns 
    PGSETUP_bDspace           db  ?   ;double space boolean flag 
    PGSETUP_bPgpause          db  ?   ;pause between pages flag 
    PGSETUP_bScontrol         db  ?   ;send control sequences flag 
    PGSETUP_bGraphic          db  ?   ;graphic mode boolean flag 
    PGSETUP_bText             db  ?   ;text mode boolean flag 
PGSETUP ends



; Page setup options 
PGOPT struc
    PGOPT_max_line_wid        db  ?   ;max width 
    PGOPT_bMode               db  ?   ;mode enable flag 
    PGOPT_bLmargin            db  ?   ;left margin enable flag 
    PGOPT_bLwidth             db  ?   ;line width enable flag 
    PGOPT_bLinepp             db  ?   ;total lines/page enable flag 
    PGOPT_bPLinepp            db  ?   ;printed lines/page enable flag 
    PGOPT_bDspace             db  ?   ;set double space flag 
PGOPT ends



; Page modes 
PGMODE struc
    PGMODE_pNotebook          db  size PGOPT dup (?)   ;notebook is no longer supported 
    PGMODE_pLandscape         db  size PGOPT dup (?)   ;landscape pg setup opts 
    PGMODE_pPortrait          db  size PGOPT dup (?)   ;portrait pg setup opts 
PGMODE ends



; Printout types 
PORTRAIT    equ 0
LANDSCAPE   equ 1

PRINTER struc
    PRINTER_bTextOnly         db  ?
    PRINTER_bIBMCompat        db  ?
    PRINTER_bCROnly           db  ?
    PRINTER_name              db  12 dup (?)
    PRINTER_max_columns       db  ?
    PRINTER_paper_sizes       db  ?
    PRINTER_line_pitches      db  ?
    PRINTER_char_pitches      db  ?
    PRINTER_char_sets         db  ?
    PRINTER_font_styles       db  ?
    PRINTER_print_mode        db  ?
    PRINTER_bFormFeed         db  ?
    PRINTER_unaddr_width      db  ?
    PRINTER_unaddr_height     db  ?
    PRINTER_orientations      db  ?
    PRINTER_font_attrs        db  ?
    PRINTER_nColors           db  ?
    PRINTER_horz_dpi          dw  ?
    PRINTER_vert_dpi          dw  ?
PRINTER ends



PRT_TEXT_ONLY   equ SELECTED
PRT_GRAPHICS    equ DESELECTED

PRT_IBM         equ SELECTED
PRT_TANDY       equ DESELECTED

CR_ONLY         equ SELECTED
CR_WITH_LF      equ DESELECTED

PRT_A4          equ 01h
PRT_A5          equ 02h
PRT_B5          equ 04h
PRT_LEGAL       equ 08h
PRT_LETTER      equ 10h
PRT_HALF        equ 20h

PRT_3LPI        equ 01h
PRT_6LPI        equ 02h
PRT_8LPI        equ 04h

PRT_10CPI       equ 01h
PRT_12CPI       equ 02h
PRT_16CPI       equ 04h

PRT_CS_TANDY    equ 01h
PRT_CS_ASCII    equ 02h
PRT_CS_IBM1     equ 04h
PRT_CS_IBM2     equ 08h

PRT_STANDARD    equ 01h
PRT_CORRESPOND  equ 02h

PRT_UNIDIRECT   equ 01h
PRT_BIDIRECT    equ 02h
PRT_SHEET       equ 04h
PRT_CONTINUOUS  equ 08h

PRT_PORTRAIT    equ 01h
PRT_LANDSCAPE   equ 02h

PRT_ELONGATED   equ 01h
PRT_DBL_HEIGHT  equ 02h
PRT_SUBSCRIPT   equ 04h
PRT_SUPERSCRIPT equ 08h
PRT_BOLD        equ 10h
PRT_ITALIC      equ 20h
PRT_UNDERLINE   equ 40h
PRT_OVERSCORE   equ 80h

; Print-To-Device 
PTD_READY       equ 0
PTD_CANCEL      equ CSR_ERROR
PTD_TO_SCREEN   equ 0
PTD_TO_PRINTER  equ 1
PTD_TO_FILE     equ 2

; Device flags for ptd_open 
PTD_DEVICES     equ 07h        ; all devices (screen, printer, file) 
PTD_SCREEN      equ 01h        ; mask for screen device 
PTD_PRINTER     equ 02h        ; mask for printer device 
PTD_FILE        equ 04h        ; mask for file device 

; Character Y extent sizes with printer CPI scales 
PRT_10CPI_YEXT  equ 166  ; 166.67 = yext of chars in a 10 cpi draw list 
PRT_12CPI_YEXT  equ 200  ; 200.00 = yext of chars in a 12 cpi draw list 
PRT_16CPI_YEXT  equ 277  ; 277.77 = yext of chars in a 16 cpi draw list 

;end of CSRPRT.INC
