/*--------------------------------------------------------------*/
/*                                                              */
/* SPELL.H contains C program defines and structure for         */
/*         accessing spell checking resource.                   */
/*                                                              */
/*--------------------------------------------------------------*/

#ifndef SPELL_INCLUDED
#define SPELL_INCLUDED 1

struct	spell_defn
{
    char   *SPELL_start_selected; /* pointer to selected text to proof	*/
    char   *SPELL_end_selected;	  /* pointer to end of selected area	*/
    char   *SPELL_text_end;	/* pointer to end of text		*/
    char   *SPELL_end_of_buffer;/* pointer to last position in buffer	*/
};
typedef	struct spell_defn SPELL;

#define	SPL_ALL_KNOWN              0
#define	SPL_NO_ACTION		         1
#define	SPL_ACTION                 2
#define	SPL_FULL_NO_ACTION         5
#define	SPL_FULL_ACTION            6
#define	SPL_DICT_TRUANT_NO_ACTION  9
#define	SPL_DICT_TRUANT_ACTION     10

/* NEED defines for these two - referred to in spellman.doc */
/* (I am guessing at values based on code todd wrote) */
#define SPL_KNOWN	0
#define SPL_UNKNOWN	-1
#define SPL_DICT_TRUANT	-2

/* function prototypes for spell checker functions */
int spell_bind_init( void );
void spell_bind_end( void );
int spl_check_text( struct spell_defn *pSpell );
int spl_check_edit(struct editfield_defn *pEditfield );
int spl_get_alternates( char *pWord, char *pBuffer );
int spl_check_word( char *pWord );
int spl_init_cache( );
int spl_init_user_dict( );

#endif

/* end of SPELL.H */
