/*----------------------------------------------------------------------------
	Demo1/2	-	Records as much sound as will fit in memory and
			then plays it back.
			2-Jul-94

			Demo1 records until you tell it to stop or the
			available memory is filled.  Recording is terminated
			by pressing a key.  Demo1 will then play the recorded
			sound back.

			Demo2 is the same as Demo1 except that by changing two
			parameters (done in the Makefile), periods of silence
			are not recorded.  This implements a VOX function.  A
			timer will indicate when recording stops because of
			silence.

	DEMO1 and DEMO2 are part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
----------------------------------------------------------------------------*/

#include "sound.h"
#include "dsetup.h"
#include "dgetbuf.h"
#include "drecord.h"
#include "dplay.h"
#include <stdio.h>

/*	VOX_THRESHOLD specifies that a sample that is more than +/- n from
	the centerline is not silence.  If this value is 0, the VOX mode
	is disabled and recording will continue regardless of the input level.

	VOX_LENGTH specifies the amount of time of silence (in 100's of
	milliseconds) must be found in a row before the recorder will pause.
*/

#ifndef VOX_THRESHOLD
#define	VOX_THRESHOLD		0
#define	VOX_LENGTH		0
#endif


#ifdef __STDC__
int	main(void)
#else
int	main()
#endif
{
	printf("Demonstration #%d - Record sounds and play them back\n",DEMO);
	printf("Version  2(1)  18-Oct-94\n");
	printf("Copyright 1994 Frank Durda IV. All rights reserved.\n");

/*	Allocate buffers that are used by the sound toolkit, then initialize
	the sound toolkit for operation.
*/

	set_up_sound((u_short) 15, (u_short) 0, (u_short) 0, (u_short) 0,
		(u_short) 0);


	set_up_buffers();		/*Allocate buffers to store sound in
					  that will be recorded by the sound
					  toolkit.*/

	do_record_sound(VOX_THRESHOLD,VOX_LENGTH);	/*Record the sound,
							  placing the data
					  		  in memory.*/

	do_playback_sound();		/*Playback the sound stored in memory.*/

	snd_exit();			/*Turn off the sound toolkit.  This
					  also disables the hardware.*/

	return(0);			/*Exit*/
}

