/*-----------------------------------------------------------------------------
	Do_compress_and_save -	
			This function takes the sound that is store in the
			sound buffers allocated by set_up_buffers(), compresses
			the contents and writes the compressed data to a file.
			2-Jul-94

			Note:	This function is used by demo2.  Refer to
				DEMO2.C for more information.

			The format of the file is:
				(Repeat the following for each SOUND structure):
				+0	A long integer indicating the length of 
					the compressed data.
				+4	A long integer indicating the length
					of the sound data uncompressed.
				+8	An unsigned character (byte)
					containing the recording sampling rate.
				+9	An unsigned character (byte)
					containing the system id (machine type)
					that was used to record the sound.
				+10	Start of the compressed data.
				Next SOUND structure goes here
				A long integer containing 0 marks the end of
				the file.

	DSAVE is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <io.h>
#include "sound.h"
#include "dgetbuf.h"
#include "dsave.h"

#ifdef __STDC__
void do_compress_and_save(char *filename)
#else
void do_compress_and_save(filename)
#endif
{
	int	fd;			/*File handle for save file */
	COMPINFO Info;			/*Compress scratch area */
	COMPPARAM Param;		/*Compress parameters */
	unsigned char filebuffer[512];	/*Buffer for file writes */
	u_long ret;			/*Return value from compress */
	u_long chunklength; 		/*Length of compressed data for
					  this SOUND structure */
	long	lenpos, endpos;		/*File positions */
	int	bufno;			/*Index for SOUND structures */
	u_char 	rate;			/*Speed sound was recorded at */
	u_char	system;			/*Machine type recording was made on*/
	u_long	uncomplen;		/*Uncompressed length of sound */

	rate = sndheaders[0]->sndp->rate;	/*Get rate and system */
	system = sndheaders[0]->sndp->system;

/*	Set up the compress parameter data */

	Param.pinfo = &Info;		/*Scratch area pointer */
	Param.start = 0;		/*Do the entire sound */
	Param.end = 0;
	Param.compress_mode = DESKMATE88_ADJUSTABLE;	/*Specify parameters */
	Param.precision = 0;		/*Exact sound reproduction */
	Param.threshhold = 0;
	Param.threshhold_length = 0;

	if ((fd = open(filename,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,
             0666)) < 0) {		/*Open the save file*/

		printf("Cannot open sound data file %s\n", filename);
		exit(1);
	}
/*	For each SOUND structure */

	for (bufno = 0; bufno < numbuffers; bufno++) {

/*	If there is no sound recorded, ignore this SOUND */

		if (sndheaders[bufno]->sndp->sndlen == 0)
			continue;

/*	Compress the sound */

		ret = snd_compress_part(sndheaders[bufno]->sndp,
					(unsigned char far *) filebuffer, 
					(unsigned short) 512,
					CTYPE_DESKMATE88,
					(COMPPARAM far *) &Param);
		chunklength = ret;

/*	Get current file position */

		lenpos = lseek(fd, (long) 0, SEEK_CUR);

/*	Write the compressed length (currently wrong) */

		if (write(fd, (char *) &chunklength, sizeof(chunklength)) !=
		    sizeof(chunklength)) {
			perror("Cannot write save file");
			exit(1);
		}

/*	Write the uncompressed length */

		uncomplen = sndheaders[bufno]->sndp->sndlen;
		if (write(fd, (char *) &uncomplen,
		    sizeof(uncomplen)) != sizeof(uncomplen)) {
			perror("Cannot write save file");
			exit(1);
		}

/*	Write the rate */

		if (write(fd, &rate, sizeof(rate)) != sizeof(rate)) {
			perror("Cannot write save file");
			exit(1);
		}

/*	Write the system */

		if (write(fd, (char *) &system, sizeof(system)) !=
		    sizeof(system)) {
			perror("Cannot write save file");
			exit(1);
		}
		
/*	Write first chunk to file */
		if (write(fd, filebuffer, (unsigned int) ret) != 
		    (int) ret) {
			perror("Cannot write save file");
			exit(1);
		}

/*	Process the rest of the data */

		while ((ret=snd_compress_part((SOUND far *) 0, 
		        		      (unsigned char far *) filebuffer, 
					      (unsigned short) 512, 
					      CTYPE_DESKMATE88,
					      (COMPPARAM far *) &Param))!=0) {

			if (write(fd, filebuffer, (unsigned int) ret) != 
				(int) ret) {
				perror("Cannot write save file");
				exit(1);
			}
			chunklength += ret;
		}

/*	Get current file position */

		endpos = lseek(fd, (long) 0, SEEK_CUR);
		if (endpos < 0)
			perror("lseek 1 failed");

/*	Seek to where we wrote the (wrong) length */

		if (lseek(fd, lenpos, SEEK_SET) < 0)
			perror("lseek 2 failed");

/*	Write the correct length */

		printf("Compressed %lu bytes into %lu\n", sndheaders[bufno]->
		       sndp->sndlen, chunklength);
		if (write(fd, (char *) &chunklength, sizeof(chunklength)) !=
		    sizeof(chunklength)) {
			perror("Cannot write save file");
			exit(1);
		}

/*	Seek back to the end of the file */

		if (lseek(fd, endpos, SEEK_SET) < 0)
			perror("lseek 3 failed");
	}

/*	Write the last-chunk indicator */

	chunklength = 0;
	write(fd, (char *) &chunklength, sizeof(chunklength));

/*	Close the file */

	close(fd);
}

