.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH "TANDY SOUND BIOS" PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
TANDY SOUND BIOS troff documentation \- Version 1(5) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IX
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 1.0i 1.5i 2.5i 3.5i 4.5i 5.5i
.if t  .in +0.5i
.if n  .in +1.0i
..
.de OX
.if t  .in -0.5i
.if n  .in -1.0i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.de TX
.if t  .ti -0.5i
.if n  .ti -1.0i
..
.de IR
.if t  .ta 2.0i
.if n  .ta 2.4i
.if t  .in +2.0i
.if n  .in +2.4i
..
.de OR
.if t  .in -2.0i
.if n  .in -2.4i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.SH \fBName\fR
.br
Tandy Sound BIOS Functions

.SH Syntax
.B mov  ah,function
.br
.B int  0x1a
.br

.SH Description
Starting with the Tandy 1000 SL and 1000 TL computers, Tandy included
BIOS functions that would provide a way to tell if the machine had
a PSSJ sound chip.  These BIOS calls also provide some simple audio
functions.

In earlier Tandy 1000 systems, the sound hardware was located in a range of
I/O ports identical to those used in the IBM PCjr.  When Tandy began
putting the sound hardware in PC-AT compatible computers, the sound
hardware conflicted with the I/O ports the IBM AT used for the second DMA
controller.  So Tandy
moved the sound hardware to a different range of I/O ports.  Tandy also
produced an adapter card with the PSSJ sound hardware on it and the I/O
ports changed once again.

Fortunately, the BIOS was also changed each time the PSSJ changed
I/O addresses, so the PSSJ Digital Sound Toolkit simply has to ask the BIOS
where the sound hardware is and the toolkit is able to configure itself to
any of the systems that have PSSJ hardware.

The BIOS functions also allow for recording and playback of small
pieces of audio, but the resulting audio usually has clicks at the 
start and end of each piece of sound, and the size of the sounds
that can be used are limited.

The following BIOS functions are defined:

.nf
.IN
INT 0x1a        AH = 0x81       Get sound status
.br
.IN
Returns:
.IN
AX =            I/O Port location of PSSJ chip is this system
.br
.if t CF = 0            BIOS driver is not busy
.if n CF = 0    BIOS driver is not busy
.br
.if t CF = 1            BIOS driver is busy
.if n CF = 1    BIOS driver is busy
.br
.OU
.OU

INT 0x1a        AH = 0x82       Input sound  (from the microphone)
.IN
Accepts:
.IN
ES:BX = Buffer address
.br
CX =            Buffer length
.br
DX =            Sampling Rate, where lower is faster
.br
.OU
Returns:
.IN
AH =            0x00
.br
.if t CF = 0            BIOS driver is not busy
.if n CF = 0    BIOS driver is not busy
.br
.if t CF = 1            BIOS driver is busy
.if n CF = 1    BIOS driver is busy
.br
.OU
.OU
.bp
INT 0x1a        AH = 0x83       Output Sound  (to the speaker)
.IN
Accepts:
.IN
ES:BX = Buffer Address
.br
CX =            Buffer Length
.br
DX =            Sampling Rate, where lower is faster
.br
AL =            Volume (0 - 7 where 0 = no sound)
.br
.OU
Returns:
.IN
AH =            0x00
.br
.if t CF = 0            BIOS driver is not busy
.if n CF = 0    BIOS driver is not busy
.br
.if t CF = 1            BIOS driver is busy
.if n CF = 1    BIOS driver is busy
.br
.OU
.OU

INT 0x1a        AH = 0x84       Stop Sound Input and Output

INT 0x1a        AH = 0x85       Reinitialize joystick after any INT 0x1A sound call
.br
.OU

.fi
.SH Notes

The transfer rate values in register DX are not the same for calls 
AH=0x82 and AH=0x83.  To input a buffer of data with the AH=0x82 call with 
a given DX value and play it back with the AH=0x83 call so that it sounds 
the same, the DX value for output would have to be approximately 11.5 
times as big as the DX value for input when run on a Tandy 1000 SL (8.00 
MHz 8086 processor).  This ratio is slightly different on other processors 
(8088 and 80286) and system architectures.

Starting with the TL2 and SL2, Tandy began using a newer version of the
PSSJ chip that double-buffered recording data so the ratio between
recording and playback is always 1:10.

These BIOS calls use the DMA hardware to input and output the sound 
buffer.  When functions AH=0x82 and AH=0x83 are called, the BIOS initiates 
the I/O and returns to the calling program immediately.  When the DMA 
transfer is complete, the BIOS receives a hardware interrupt and executes 
a software INT 0x15 with AH=0x91 and AL=0xfb.  If an application program 
needs to know when the data transfer has been completed, it will have 
to intercept INT 0x15 and watch for this event.

These BIOS calls mask the hardware restriction of not being able 
to DMA across a 64K memory address boundary from the caller, but the 
size of the sound data must be less than or equal to 64K in size.

.IN
.TI
NOTE:   The PSSJ design is reasonably accurate up to approximately 
40 KHz (sampling rate = 8).  Faster rates may produce inconsistent results 
from one machine to another.
.OU
.bp
.SH \fBLocating Tandy Sound Hardware\fR

The sound hardware that has been in Tandy PC systems has changed over the
years.  Initially it consisted of a three-voice sound generator identical to
the one IBM used in the PCjr.  Starting with the 1000SL and 1000TL, digital
audio capability was added to the functions of the three-voice sound generator
in the PSSJ chip.  

The following code can be run on any PC-compatible computer and it
will determine if the three-voice sound generator is present, if the
three-voice sound generator and digital sound support is present, or if there
is no Tandy sound hardware at all.  The code also returns the port numbers
that are correct for the machine the code is being run on.  This is useful
for applications that are able to use subsets of the hardware or just
need to know where the hardware is located on a given machine.

.nf
.if t   mov     ax,8100h        ;Issue a status command to
.if n   mov     ax,8100h                ;Issue a status command to
.if t   int     1ah             ;the sound BIOS call
.if n   int     1ah                     ;the sound BIOS call
	cmp     ah,80h          ;See what the result is
.if t   jc      $yesboth        ;BIOS returned a port number
.if n   jc      $yesboth                ;BIOS returned a port number

	mov     ax,0f000h
	mov     es,ax
	mov     al,byte ptr es:0c000h
	cmp     al,21h          ;This byte is present on all 1000s
	jz      $tionly

;       The TI sound and digital sound hardware is not present,
;       at least on Tandy systems.

	jmp     $noiron         ;Quit

;       The TI sound hardware is available but the digital sound
;       hardware (DAC) is not.

$tionly:
	mov     cx,00c0h
.if t   xor     dx,dx           ;DX = 0 - NO DIGITAL SOUND AVAILABLE
.if n   xor     dx,dx                   ;DX = 0 - NO DIGITAL SOUND AVAILABLE
	jmp     $tisound                ;CX = port number of TI sound chip

;       The TI sound and digital sound hardware (DAC) are present.

$yesboth:
.if t   mov     cx,ax           ;Get returned base port #
.if n   mov     cx,ax                   ;Get returned base port #
.if t   mov     dx,cx           ;Make a copy
.if n   mov     dx,cx                   ;Make a copy
	sub     cx,4
.if t   jmp     $allsound       ;CX = port number of TI sound
.if n   jmp     $allsound               ;CX = port number of TI sound
.if t                           ;DX = digital sound hardware base port
.if n                                   ;DX = digital sound hardware base port

\&...
$noiron:                                ;Code to handle no TI sound chip
.if t                           ;and no DAC goes here
.if n                                   ;and no DAC goes here
.if t                           ;PC-Speaker only or add-in sound board?
.if n                                   ;PC-Speaker only or add-in sound board?
\&...
.if t .bp
.if t $tisound:                 ;Code to handle systems with
.if n $tisound:                         ;Code to handle systems with
.if t                           ;TI sound chip and no DAC goes
.if n                                   ;TI sound chip and no DAC goes
.if t                           ;here.  (1000, 1000A, 1000EX,
.if n                                   ;here.  (1000, 1000A, 1000EX,
.if t                           ;1000HX, 1000SX, 1000TX, 1000AX,
.if n                                   ;1000HX, 1000SX, 1000TX, 1000AX,
.if t                           ;PCjr).
.if n                                   ;PCjr).
\&...
.if t $allsound:                        ;Code to handle systems with 
.if n $allsound:                                ;Code to handle systems with 
.if t                           ;TI sound chip and a DAC goes
.if n                                   ;TI sound chip and a DAC goes
.if t                           ;here.  (1000SL, 1000TL, 1000TL/2,
.if n                                   ;here.  (1000SL, 1000TL, 1000TL/2,
.if t                           ;1000TL/3, 1000RL, 1000RLX, 2500,
.if n                                   ;1000TL/3, 1000RL, 1000RLX, 2500,
.if t                           ;2500SX)
.if n                                   ;2500SX)
.fi

.SH \fBSee Also\fR

Tandy Technical Reference manuals for the 1000TL, 1000SL, 1000TL2, 1000TL3, 1000SL2, 1000RL, 1000RLX, 1000RLS, 2500, 2500SX, or Sensation I

.SH \fBCredit\fR
The PSSJ BIOS functions were developed by Frank Yerrace at Tandy Corporation
and are included in the ROMs of selected computers manufactured by Tandy.
The PSSJ Digital Sound Toolkit only uses the BIOS calls to locate the location
of the PSSJ hardware in a portable manner.
.br
This documentation is Copyright 1994 Frank Durda IV, see \fIintro(PSSJ)\fR for
restrictions.
.br
\-\-\-\-\-\-
.br
410185

