.if t  .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_COMPRESS_PART PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_COMPRESS_PART troff documentation \- Version 1(6) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IX
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 1.0i 1.5i 2.5i 3.5i 4.5i 5.5i
.if t  .in +0.5i
.if n  .in +1.0i
..
.de OX
.if t  .in -0.5i
.if n  .in -1.0i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.de TX
.if t  .ti -0.5i
.if n  .ti -1.0i
..
.de IR
.if t  .ta 2.0i
.if n  .ta 2.4i
.if t  .in +2.0i
.if n  .in +2.4i
..
.de OR
.if t  .in -2.0i
.if n  .in -2.4i
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.de IW
.if t  .in +2.0i
.if n  .in +2.4i
..
.de OW
.if t  .in -2.0i
.if n  .in -2.4i
..
.de TW
.if t  .ti -2.0i
.if n  .ti -2.4i
..
.de IK
.if t  .in +1.5i
.if n  .in +1.8i
..
.de OK
.if t  .in -1.5i
.if n  .in -1.8i
..
.de TK
.if t  .ti -1.5i
.if n  .ti -1.8i
..
.SH \fBName\fR
.br
snd_compress_part \- Compress audio data

.SH Syntax
\fBunsigned long snd_compress_part(pSound, start, end, pinfo, dest, dest_size, precision, threshold, threshold_length);\fR
.br
.B SOUND far *pSound;
.br
.B unsigned long start, end;
.br
.B COMPINFO *pinfo;
.br
.B unsigned char *dest;
.br
.B unsigned int dest_size;
.br
.B unsigned char precision;
.br
.B unsigned char threshold;
.br
.B unsigned int threshold_length;
.br

.SH Description
\fISnd_compress_part\fR is called in a loop to perform data compression on the 
sound specified by \fIpSound\fR.  On each call, the buffer pointed to by
\fIdest\fR is filled with up to \fIdest_size\fR characters, and then the
number of characters stored there is returned.  All calls but the first
should specify NULL for \fIpSound\fR.  On the last call,
\fIsnd_compress_part\fR will return zero, meaning no bytes were stored
in \fIdest\fR; when this happens, the compression is finished.

The parameter \fItype\fR specifies the algorithm to be used to do the
compression.  There is currently only one compression type,
CTYPE_DESKMATE88.  Additional compression details are specified in the
structure pointed to by \fIpParam\fR.  The contents of this structure
vary according to what type is set to.  

.SH Technical Details 
Compression is used to allow sounds to be stored in less space than 
they would otherwise require.  Depending on the compression method used, 
significant space savings can be achieved, although some do so at the 
expense of sound quality.

When \fIsnd_compress_part\fR is called, the caller specifies which
compression algorithm is to be applied, along with any other parameters the
selected algorithm requires.  The decompression call, 
\fIsnd_decompress_part\fR(PSSJ), determines which compression algorithm
was used on the data and then applies the correct decompression algorithm.

The \fBCOMPPARAM\fR structure is what is used to give a compression algorithm 
any parameters or options it needs.  Thus its contents vary according 
to which compression algorithm is selected.
.if n .bp
.SH Compression formats
As of this release, the only compression algorithm currently implemented is:

\fBDESKMATE88\fR -  Produces results identical to the compression used in 
the DeskMate 88 Sound Editor and the DeskMate 88 Music application.
.if t .bp
.IN
DESKMATE88
.br
.IN

This compression and decompression algorithm produces results compatible
with the compression used in the DeskMate 88 Sound Editor and the DeskMate 
88 Music application.  To use this algorithm, the \fItype\fR parameter to
\fIsnd_compress_part\fR needs to be \fBCTYPE_DESKMATE88\fR and the
following fields in the \fBCOMPPARAM\fR structure are filled in by the
caller as follows:

.IK
.TK
.if t \fBpinfo\fR -                     Pointer to a \fBCOMPINFO\fR structure.  The \fBCOMPINFO\fR
.if n \fBpinfo\fR -             Pointer to a \fBCOMPINFO\fR structure.  The \fBCOMPINFO\fR
structure need not be initialized to anything, it is a scratch area used by
the compress function.

.TK
.if t \fBstart\fR -                     The first sound sample to be included in the compression
.if n \fBstart\fR -             The first sound sample to be included in the compression
(the index to the first sample in the \fBSOUND\fR is 0)

.TK
.if t \fBend\fR -                       The first sample to be excluded from the compression.  That
.if n \fBend\fR -                       The first sample to be excluded from the compression.  That
is, 1 plus the index of the last sample to be included in the compression. 
0 may be specified to indicate all bytes from start to the last byte 
of the sound.

.TK
.if t \fBcompress_mode\fR -     Indicates the parameters to be used in the
.if n \fBcompress_mode\fR -   Indicates the parameters to be used in the
compression.  This field should be set to one of the following, depending
on the sound source:

.IW
.TW
\fBDESKMATE88_MUSIC\fR          Parameters set for music compression
.br
.TW
.if t \fBDESKMATE88_SPEECH\fR   Parameters set for speech compression
.if n \fBDESKMATE88_SPEECH\fR           Parameters set for speech compression
.br
.TW
\fBDESKMATE88_ADJUSTABLE\fR     Complete control of the parameters
.br
.OW
.OK
.if n .bp
.if t .sp
The caller must keep track of the length of the uncompressed sound (with 
\fIend\fR - \fIstart\fR, or
\fIpSound\fR->\fIsndlen\fR - \fIstart\fR if \fIend\fR is 0)
and carry the length with the compressed sound for use on decompression. 
The length of the compressed sound (the sum of the return values from
\fIsnd_compress_part\fR) must also be carried with the compressed sound for
use when decompressing.

This algorithm has three parameters that adjust how the compression 
is performed.  There are fields in the \fBCOMPPARAM\fR structure:
\fIprecision\fR, \fIthreshold\fR, and \fIthreshold_length\fR.  These fields
are only used when the \fIcompress_mode\fR field is set to
\fBDESKMATE88_ADJUSTABLE\fR.  If one of the other values for
\fIcompress_mode\fR is selected, predefined values for \fIprecision\fR, 
\fIthreshold\fR, and \fIthreshold_length\fR are assumed.

When \fIcompress_mode\fR is \fBDESKMATE88_MUSIC\fR, \fIprecision\fR is
1 and \fIthreshold\fR is 0 (when \fIthreshold\fR is 0, it doesn't matter
what \fIthreshold_length\fR is set to, since setting \fIthreshold\fR to
zero disables method C [see the discussion below]).

When \fIcompress_mode\fR is \fBDESKMATE88_SPEECH\fR, \fIprecision\fR is 1,
\fIthreshold\fR is 12, and \fIthreshold_length\fR is 60.
.if t .bp
By selecting \fBDESKMATE88_ADJUSTABLE\fR these parameters can be used
to adjust the level of compression, in exchange for certain trade-offs.
These trade-offs consist of more or less sound quality for less or more
compression, respectively.  In order to understand how to adjust the values,
it will first be explained in general how the compression is done, how the
variables affect the compression, and the gains and losses for each.

.nf
/* Compression-precision default defines */
.if t #define SND_PRECIS             1  /* "precision" compression default */
.if n #define SND_PRECIS        1       /* "precision" compression default */
#define SND_SPEECH_THR 12       /* "threshold" speech comp. default */
.if t #define SND_MUSIC_THR   0 /* "threshold" music comp. default */
.if n #define SND_MUSIC_THR   0 /* "threshold" music comp. default */
#define SND_THRESH_LEN 60       /* "threshold_length" default */
.fi

These defines are the default control parameters and are
defined in sound.h.

The DESKMATE88 compression algorithm performs several different types 
of compression on the sound presented to it.  These are:

.IN
.TI
A)      Scan the entire length of the sound and look to see which delta 
values occur more often than any others (delta values are explained below). 
Then, build a table of the fourteen most common values. Whenever the 
difference (or delta value) between the current sample and the next sample 
is in the table, use a four-bit quantity (sufficient to hold values from 
0-13) to represent the new sample instead of the actual eight-bit sample.

.TI
B)      Replace long repetitions of the same sample value with a special 
code and a number telling how many times to repeat the value.

.TI
C)      Look for long repetitions of low level sound that might be pauses 
between words and replace this with silence (followed by an application 
of Method B).
.OU

Because Method B in no way affects sound quality, it has no parameters 
to change its behavior.

Methods A and C, however, are capable of actually removing some of the 
redundancy and unused or unwanted information in the sound to be compressed. 
Thus, parameters are available to alter their behavior.  In the case 
of Method A, that parameter is precision.  In the case of Method C those 
parameters are \fIthreshold\fR and \fIthreshold_length\fR.

\fBCompression Method A\fR

Let's say that we have the following group of sound samples from an 
imaginary sound (all numbers are given in hexadecimal):

	80      84      86      78      74      70      89      74      80      85

On the screen of a typical sound editor, sounds are displayed with 
0 at the bottom of the screen, 80 at the middle (normal silence), and 
FF at the top of the screen.  So, the data above would appear to oscillate 
above and below the center line displayed by the sound editor.
.if t .bp
.if n .sp
The difference (or delta value) between the first and second samples is
4 (84 - 80), between the third and fourth is -14 (78 - 86), and so on.
.if n .bp
.if t .sp
Delta values are valuable because most sounds use the entire spectrum 
of sample values (00 through FF) but the changes from sample to sample 
tend to be small and steady, thus the delta values all tend to be small 
and clustered around zero.

In a typical sound, fourteen delta values will account for 80% of the 
changes between one sample and the next.  Therefore, a cache table can 
be built that contains the most common delta values and use only four 
bits to specify a cache table entry rather than eight bits to specify 
a new sample value.

Precision is used to decide how close a delta value needs to be to an 
entry in the table of most common deltas, before we will use that entry. 
For example, to ensure that the decompressed sound is exactly like the 
original, precision is set to 0.  This ensures that our current difference 
will exactly match one in the table before using that table entry.  However, 
if a close match is sufficient (and it usually is for the human ear) 
then it might be decided that the current difference only has to match 
a delta table entry within one before using the table entry.  In that 
case, precision is set to 1.

Precision is set to 1 by the DeskMate Sound Editor when it compresses 
both speech and music.  Precision values must lie between 0 and 3 with 
0 being exact reproduction of the original sound and 3 being rather significant 
distortion.

The best way to determine whether a precision of 1 or above will be 
acceptable on a particular sound is to try it on some similar sounds 
and listen to the results.  A precision of 2 is fairly acceptable on 
speech and music with only a slight increase in "hiss" as the result.

.if n .bp
\fBMethod C\fR

Fortunately Method C is enormously easier to understand and adjust. 
Its two parameters specify a moving box that is centered around the 
"origin" or silence value of 80 (hex).  This box moves forward, and if 
at any time the box encounters a region where all of the sound sample 
values fall within the box it assumes that this region contains only 
low level background noise (perhaps between spoken words) which may be 
replaced with silence.

The two parameters determine the size of the box (and what it will consider 
to be background noise) in the following way:

.nf
.if n \&                                                        _
.if n \&      /\\            threshold length                   / \\
.if n \&    /   \\          =================  /\\ +threshold  /     \\
.if n \&__/      \\      /__|___/\\__________|_/   \\         /         \\__
.if n \&          \\    /   =================       \\     / -threshold
.if n \&           \\__/                              \\_/
.if t \&                                                                         _
.if t \&    \0/\\                 threshold length                            / \\
.if t \&    /   \\           ==================  \0/\\ +threshold  /     \\
.if t \&__/  \0  \\      /__|___/\\_______________|_/   \\            /         \\__
.if t \&          \\ \0 /     ==================       \\        / -threshold
.if t \&           \\_/                                            \\___/
.fi

Thus, \fIthreshold\fR determines the height of the box and 
\fIthreshold_length\fR determines the length.
.if t .bp
.if n .sp
Setting the value of \fIthreshold\fR to 0 will cause compression Method C 
to be turned off altogether.   It is recommended that this method be 
turned off for anything other than speech, such as recorded music or 
sound effects.  Setting it to higher values (like 12, which is the value 
used for speech compression within the DeskMate Sound Editor) will determine 
how loud the background noise can get and still be removed.  Setting 
\fIthreshold\fR at too high a value can cause low levels of speech to be removed 
completely, so care must  be exercised in setting this value.  Setting 
it too low would allow small rises in the background noise level to be 
considered as "signal", preventing compression (removal) of this part 
of the noise.

The value that \fIthreshold_length\fR is set to is multiplied by 51 in order 
to determine the number of samples that must fall within the \fIthreshold\fR
boundaries before being replaced with silence.  Setting this value too 
high would cause hiss to be ignored because a long enough pause of "noise" 
could not be found.  Setting this value too low would cause the small 
pauses within words to be replaced with silence (resulting in a strange 
clipped sound to the speech).  The value for this parameter is 60 when 
speech is compressed by the DeskMate Sound Editor.
.OU
.if n .bp
.SH Return Values
.IZ
.TZ
.if t More than 0   Data compression of this segment successful
.if n More than 0       Data compression of this segment successful
(return value is the length of the compressed data stored into the 
buffer  pointed to by \fIdest\fR)
.br
.TZ
Zero            Data compression of entire sound is complete
.br
.TZ
BADPARM \fIType\fR is an unsupported compression algorithm
.br
.OZ

.SH \fBSee Also\fR

snd_file_record(PSSJ) 

.SH \fBCredit\fR
\fISnd_compress_part(PSSJ)\fR is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro(PSSJ)\fR for
restrictions.
.br
\-\-\-\-\-\-
.br
410186

