.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_FILE_PLAY PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_FILE_PLAY troff documentation \- Version 1(9) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_file_play \- Plays sounds directly from a file on a hard disk drive.

.SH Syntax
\fBshort far snd_file_play(handle, options, reserved1, reserved2, reserved3);\fR
.br
.if n .sp
.B FILE handle;
.br
.B unsigned short options;
.br
.B unsigned short reserved1;
.br
.B long reserved2;
.br
.B long reserved3;
.br

.SH Description
\fISnd_file_play\fR accepts the handle to an already-opened file and
plays the contents.  

Each sound file begins with a header which contains information on
the size, speed and pitch of the recording.  This information is
used by \fIsnd_file_play\fR to configure the hardware and
the sound toolkit for playback of the sound.   Once all the parameters
in the file are accepted, the player will begin playing the audio data.

The caller is responsible for opening the sound file and passing a
handle to \fIsnd_file_play\fR.  The file must be readable and
positioned to the first byte of the file, just as the file would be
when first opened.

Once the player starts producing sound, \fIsnd_file_play\fR will return to
the caller and the file will continue to be played until the end of the
sound is reached, \fIsnd_stop\fR(PSSJ) or \fIsnd_exit\fR(PSSJ) are called,
or a disk error occurs.  \fISnd_file_play\fR continues to run in the
background, leaving the calling program free to perform other activities.
There are restrictions as to what other things can be done at the same time.
See the Notes and the Restrictions sections, below.

If the calling program desires to wait for the sound to finish playing
or for a certain amount of the sound to be played before performing an
operation, the \fIsnd_wait\fR(PSSJ) function can be used to determine where
the player currently is in the file.  (See \fIsnd_wait\fR(PSSJ) for more
information.)

The \fIoptions\fR parameter controls operation of the player.  The
following bits are defined.  
.if t .sp
.if n .bp
.IZ
.TZ
CLOSEFILE       If specified, the file will be closed by the player when
it stops playing the file.  By default, the caller is responsible
for closing the file after the player has stopped playing the contents
of the file.
.br
.OZ

All others bits in \fIoptions\fR are reserved and must be set to zero.

.SH Notes
\fISnd_file_play\fR uses buffers that were allocated by the caller and
provided to the digital sound toolkit via the \fIsnd_addbuf\fR(PSSJ) call.
For reliable operation on a 8MHz 286 system (1000TL) at 22KHz sampling
rates, at least 25 buffers (about 56K) should be provided.  The number of
buffers suggested for 5.5KHz sampling is 15 buffers.  On slower systems
(1000SL), slow disk drives, high disk fragmentation, high sampling rates, or
excessive foreground activity, the number of buffers should be increased.
Having insufficient buffers is indicated by periods of silence or "hiccups"
in sound output.  Faster (386/486) systems and faster hard disk drives
can use fewer buffers.
.if n .sp
.if t .bp
\fISnd_file_play\fR only reads files that have a PSSJ digital sound
toolkit header on them.  This header is compatible with files
created by the Deskmate Sound Editor (1990 versions and later).
Files that do not have this header cannot be played.
Conversion to and from other formats is trivial.

Files are played from start to finish unless stopped prematurely.
Multi-note files (Deskmate 1990 Music instrument files) can only play the
first note.

\fISnd_file_play\fR will stop playing if any error is returned by
MS-DOS in response to a disk I/O request.  The "Abort, Retry or Ignore"
message or any other text will not be displayed if an error occurs.

.SH Storage Media Restrictions
(The following statements assume that the slower PSSJ-equipped systems
are to be supported, such as the 1000TL or the 1000SL.  Some of the
issues are not applicable on 386 and 486 systems.)

\fISnd_file_play\fR cannot be used with files that are located
on floppy disk drives.  The continuous data transfer rates of most floppy
systems are not high enough.  This is regardless of the CPU speed.

All hard disk drives, hard cards, CD-ROM and Iomega drives can all be
used at sampling rates of 5.5Khz and 11Khz.  Extremely fragmented
filesystems may affect playback quality, so this should be avoided. 
.if n .bp
.if t .sp
22Khz can be used from disk only with drives with good seek times
(35 milliseconds or better) and low fragmentation.  (If the drive has the
capability to perform DMA or CPU data transfers and you are on a 286-based
or faster system, select CPU data transfer as it is usually faster under DOS.)

.SH Concurrency Restrictions
The activities you can perform while a sound is being played are limited
by these rules:

.IN
.TI
(1)     Never leave interrupts disabled for more than three milliseconds
at a time.  Longer periods will cause fragments of the sound
that is being played to be repeated.  (If you disable interrupts
and then make DOS or BIOS calls, you may inadvertently
leave interrupts disabled too long, so watch for this.)  For
example, a program that waits for a vertical sync period to occur so
it can reprogram video registers can have to wait up to 20 msec and
must avoid
disabling interrupts.

.TI
(2)     Interrupt-driven (background) printing (on IRQ7) may not be
performed.  The PSSJ chip uses IRQ7 for both audio and printing
functions.

.TI
(3)     The PSSJ chip uses DMA channel 1, so no other adapter card can
use this channel while audio operations are being performed.  

.TI
(4)     The file handle specified in the \fIsnd_file_play\fR call must
not be used by the calling program while \fIsnd_file_play\fR
is still active.
.if t .bp
.if n .sp
.TI
(5)     The calling program should not exit before the PSSJ digital sound
toolkit player completes its activities.  If you want a program to play
audio and for the playback to continue after that program exits, a TSR
that contains the toolkit code should be used to play the sound and
the main program should pass commands to the TSR.  (The \fBCLOSEFILE\fR
option is useful in TSRs.)  As soon as control returns to the program
that called the TSR, the main program may exit and the TSR will remain
in memory.  The TSR can be removed from memory only after a
\fIsnd_exit\fR(PSSJ) call is made.
(The PSP region describing the open file and the PSSJ digital sound
toolkit code must remain intact in RAM while it is playing audio as it
contains numerous interrupt service routines that are active.)

.TI
(6)     Simultaneous disk I/O to any device can impact playback
performance.  To a certain extent this can be prevented by
allocating additional buffers for the player to use and
allow the player to fill these buffers before other disk I/O
commences.  The speed of the CPU and access time of the
drives involved will directly affect this situation.
.if n .bp
.if t .sp
.TI
(7)     Some DOS calls for keyboard activity wait inside MS-DOS until
a key is pressed before returning.  These calls also forbid
disk I/O to occur in background while waiting for a key to be
pressed.  Using these calls while \fIsnd_file_play\fR is being
used will cause sound output to be interrupted.  (These same
calls also cause spooled printing to pause.)  Since high-level
languages like "C" may make these calls to perform certain
functions, it may be difficult to determine if
you are using these DOS calls without trying the program
out first.
.br
With some DOS C compilers, the \fIgetch\fR(S) function blocks disk I/O
and has to be avoided.

.TI
(8)     On 1000 SL, SL/2, TL, TL/2 systems and other systems with
enhanced (16 color PCJr) CGA video, the last 128K of RAM should not be
used for toolkit code or for the buffers that you allocate for the
toolkit's use.  This memory is actually dual-ported video memory
(not all of this memory is used for video all the time) and may have
up to 12 wait states on each access, depending on the current video mode.
The player may be unable to operate at higher sampling rates if
it has to use this memory.
.OU

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID There are several causes for this error:
.br
.IN
.TI
1.      The Player or Recorder is active.
.br
.TI
2.      Not enough buffers provided to \fIsnd_addbuf\fR(PSSJ).
.br
.TI
3.      Sound file could not be read.
.br
.TI
4.      Sound file header contained errors or requested unsupported functions.
.br
.OU
.OZ

.SH See Also
snd_wait(PSSJ), snd_stop(PSSJ), snd_exit(PSSJ)

.SH Credit
\fISnd_file_play\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402189

