	page	60,132
;-----------------------------------------------------------------------------
;	Addbuf.asm - snd_addbuf() function for the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	round_esbx:NEAR		

	include external.inc

	include sound.inc

snddata	segment public 'DATA'
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg

;------------------------------------------------------------------------------
;	snd_addbuf	Add buffer(s) to the player buffer queue

;	C definition:	extern int snd_addbuf(saddr, int);

;	Function:	snd_addbuf() adds buffer(s) to sound's buffer queue.
;			If called with a NULL saddr argument, snd_addbuf() 
;			returns the player buffer size.  Otherwise, the 
;			memory pointed to by saddr is carved up into the
;			specified number of buffers which are added to the
;			buffer queue.  The memory handed snd_addbuf() MUST
;			be a multiple of the size returned when snd_addbuf()
;			is called with NULL.

;			You cannot call snd_addbuf() anymore after calling
;			snd_init().  snd_addbuf() will ignore the request.

;	Accepts:	An saddr or NULL, and an int for number-of-buffers.

;	Returns:	The buffer size, when called with NULL;
;			0 when adding a buffer

;			Original version by John Elliott IV
;			Edits by Frank Durda IV
;------------------------------------------------------------------------------
	public _snd_addbuf
_snd_addbuf	proc far

;	Save the world
	push	bp
	mov	bp,sp
	push	ds
	push	es

;	Create the world
	mov	ax,snddata
	mov	ds,ax	;======================================================
	assume	DS:snddata
	page
;	Finally, get some work done

	les	bx,[bp].spptr	;::::::::<13>Get far pointer to memory:::::::::
	mov	cx,[bp].spint		;Get number-of-buffers

	mov	ax,es
	or	ax,bx			;<13>Is the ptr NULL?
	jnz	$start

	mov	ax,MERRYGO_SIZE_BYTES + HEADER_SIZE
	jmp	short $exit	

$start:	mov	al,byte ptr snd_mode	;<22>Get player/recorder status
	test	al,UNINITIALIZED
	jz	$ret_bad		;Naughty! init() was called

;	Check the number of buffer we have so far
	mov	ax,num_buffers
	add	ax,cx			;Ensure request won't make
	cmp	al,128			;num_buffers > 128
	jbe	$addmem			;Test should include 128 since we are
					;looking post-addition.

$ret_bad:
	mov	ax,INVALID
	jmp	short $exit

;	MOV queue_free pointer TO ptr->play_buf_next

$addmem:
	mov	ax,word ptr queue_free
	mov	word ptr es:[bx].play_buf_next,ax	;<13>
	mov	ax,word ptr queue_free[2]
	mov	word ptr es:[bx].play_buf_next[2],ax	;<13>

;	Convert es:bx to a crunchy pointer and store in queue_free

	push	cx
	call	round_esbx		;<13>Force to nearest paragraph
	pop	cx
	mov	word ptr queue_free,bx	;<13>Store converted form
	mov	word ptr queue_free[2],es
	page
;	Increment number-of-buffers counter

	inc	num_buffers

;	round_esbx() makes bx very low, so we don't worry about carry

	add	bx,MERRYGO_SIZE_BYTES + HEADER_SIZE	;<13>
	loop	$addmem
$ret_zero:
	mov	ax,0
$exit:	pop	es	;::::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	ds	;======================================================
	pop	bp
	ret				;NEAR or FAR

_snd_addbuf	endp
sndseg	ends
	end
