	page	60,132
;-----------------------------------------------------------------------------
;	Play.Asm - Snd_Play()  Plays audio from memory or disk
;	PLAY.ASM is part of the PSSJ Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	snd_play_on:NEAR
	extrn	snd_play_off:NEAR
	extrn	_snd_stop:FAR
	extrn	round_dssi:NEAR
	extrn	rnd_dssi_m:NEAR
	extrn	round_esdi:NEAR
	extrn	roundup:NEAR
	extrn	player_irq:NEAR
	extrn	_snd_cue:FAR		;<13>
	extrn	snd_fragmove:NEAR	;<29>

MAKEPLAY=1
	include	external.inc
SHOWINC=1
	include	sound.inc
	page
	public	dma_ticket,dma_bias,dma_trip
	public	merrygo_phys_page,merrygo_phys_offs
	public	queue_play, queue_last, merrygo_buf
	public	snd_mode,snd_mode2,queue_free
	public	srcbuf,curticket,sndrate
	public	ld_buf_ptr,ld_buf,ld_buf_len,ld_last_sample,ld_rate
	public	req_len
	public	num_buffers
	public	DacBase,cur_db_level,db_level
	public	irq_vect_addr
	public	dma_mask_port,dma_page_port,dma_addr_port,dma_count_port
	public	dma_mask_value,emptyfill
	public	_snd_play,snd_queue,duo_art,intbl,play_safety
	public	irq_next_task
	public	circleirq,snd_time_count,_snd_clock,_snd_clock_t,tmp_queue
	public	snd_residue
	page
snddata	segment	public	'DATA'

req_len		dd	0		;Number of bytes in a sound that are
					;to be expanded (all or end-start)

;	These variables control the combining of sounds from multiple
;	calls to snd_play into one or more buffers.  The state from
;	one call to the next is saved here.

ld_buf		dd	0		;Points to the buffer that will
					;be used to expand and queue the
					;next sound in.
ld_buf_ptr	dd	0		;Points to next location to write
					;data to.
ld_buf_len	dw	0		;Number of bytes that can be added
					;to this buffer
tmp_queue	dd	0		;<29>Used for temporary holding area
ld_last_sample	db	80h		;Used to pad a buffer on flush
ld_rate		db	0

srcbuf		dd	0

curticket	dw	0ffffh
snd_time_count	dd	0		;<23>
sndrate		db	0
circleirq	db	0		;<23>Locking for clk/idle stuff

;	Player/recorder buffer management is handled by these
;	pointers

queue_free	dd	0		;Pointer to start of free-list
					;Initially set-up by snd_init

queue_play	dd	0		;Pointer to buffers to play.
					;Initially NULL.
queue_last	dd	0		;Points at last element in play-list
					;Items are added here

merrygo_buf	dd	0		;The buffer the DMA will use for
					;all recording/playback operations.
					;Selected from the buffers on the
					;free-list by snd_init.  It MUST NOT
					;cross a 64k physical boundary.

irq_vect_addr	dw	0		;IRQ vector offset
snd_mode	dw	UNINITIALIZED	;<22>Player mode status
snd_mode2	dw	0		;<9>Overflow
emptyfill	db	80h		;Used to pad safety area on underrun
merrygo_phys_page	db	0	;Physical address of merrygo_buf
merrygo_phys_offs	dw	0	;for use by the DMA.  Set by snd_init
	page
;	The state of the player/recorder is handled by these elements

dma_ticket	dw	0		;Buffer number the player is
					;playing at this instant
dma_bias	db	0
dma_trip	db	0		;Number of buffers to hold before
					;starting DMA.

DMACLR		equ	0ch
dma_mask_port	dw	0ah		;Channel 1
dma_page_port	dw	83h		;Channel 1
dma_addr_port	dw	02h		;Channel 1
dma_count_port	dw	03h		;Channel 1
dma_mask_value	db	1		;Channel 1

trig_count	db	0		;# of buffers queued so far
	
;	Misc information

_snd_clock	dw	0		;Current play or record time
snd_residue	dw	0		;<34>Residue in bytes
_snd_clock_t	dw	0		;Previous play or record time
DacBase		dw	304h		;Port location on plug-in card
cur_db_level	db	7
db_level	db	7

num_buffers	dw	0		;<33>Number of buffers allocated

;		Mac  3000 SL   TL   Dbl Ext2 Ext3 Ext4
;		/Syn  -8	    Buf
outtbl	db	0a0h,0a1h,0a0h,0a0h,0a0h,0a0h,0a0h,0a0h	;5500 Hz
	db	0a0h,0a2h,0a1h,0a1h,0a0h,0a0h,0a0h,0a0h	;11000 Hz
	db	0a0h,0a3h,0a1h,0a5h,0a0h,0a0h,0a0h,0a0h	;22000 Hz
	db	0a0h,0a3h,0a1h,0a5h,06eh,0a0h,0a0h,0a0h	;<27>32500 Hz
	db	0a0h,0a3h,0a1h,0a5h,090h,0a0h,0a0h,0a0h	;<27>39700 Hz

;		Mac  3000 SL   TL   Dbl  Ext2 Ext3 Ext4
;		/Syn  -8	    Buf
intbl	db	03fh,03fh,03fh,03fh,040h,03fh,03fh,03fh	;5500 Hz
	db	01fh,01fh,01fh,01fh,020h,01fh,01fh,01fh	;11000 Hz
	db	00fh,00fh,00fh,00fh,010h,00fh,00fh,00fh	;22000 Hz
	db	00fh,00fh,00fh,00fh,00bh,00fh,00fh,00fh	;<27>32500 Hz
	db	00fh,00fh,00fh,00fh,009h,00fh,00fh,00fh	;<27>39700 Hz


snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg,ds:snddata

irq_next_task	dd	0		;Jump to this address if the interrupt
					;is not ours and put this address back
					;when we are done. MUST BE IN SNDSEG!!!
;------------------------------------------------------------------------------
;	Snd_Play	- Handles the queues, plays the music and
;			  cleans the glasses.
;			  A bigger ball-of-wax you will never find
;			By Frank Durda IV
;------------------------------------------------------------------------------

	public	_snd_play
_snd_play	proc far		;(*sp)

	push	bp
	mov	bp,sp
	push	si			;Required by C
	push	di			;Required by C
	push	ds
	cld				;<25>Make string copies work

	mov	ax,snddata
	mov	ds,ax		;=============================================
	assume	DS:snddata
	push	es

;	See if we are in play mode already.  If not, do something about it.

$recheck:
	mov	al,byte ptr snd_mode	;<22>
	test	al,RAMPUP		;<34>Are we switched into play mode?
	jnz	$rdy			;Don't do anything, we are ready
	test	al,UNINITIALIZED
	jnz	$notinit		;Not initialized, abort
	page
;	Here we need to see if the recorder is running.  If it is, wait
;	for it to finish and then continue.   If they wanted to abort the
;	recording, they should have called stop.

	sti	;<26>Looks important------------------------------------------
$chkrec:mov	al,byte ptr snd_mode	;<22>
	test	al,INRECORD
	jz	$needramp		;recorder is not active
	jmp	short $chkrec

;	Dunno what they were doing here, so abort

$notinit:
	mov	ax,INVALID		;Can't call us yet
	jmp	$plabort		;<2>Get outta here


;	Okay, the recorder is not running. 
;	Here we need to adjust the ramp

$needramp:
	mov	al,TOPLAY		;<13>Use this new function
	push	ax			;<13>
	call	_snd_cue		;<13>Less efficient but done once.
	add	sp,2			;<13>Fix stack

;	Before we do anything, see if we have a current buffer.  If not,
;	allocate one.

$rdy:	mov	ax,word ptr ld_buf[2]	;Get segment
	or	ax,ax			;Is it NULL?
	jnz	$rd2
	call	getbuf			;Need a buffer
					;We will block in this routine if
					;no buffers are available

$rd2:	les	di,[bp].spptr	;::::::::Get *sp from caller:::::::::::::::::::
	page
;	Pick up rate information which can change for each call

	mov	al,es:[di].sndplayrate	;Get rate
	mov	ld_rate,al		;Decides expansion ratio

;	Write ticket of buffer to caller
	push	es
	les	si,ld_buf	;::::::::Look at current buffer:::::::::::::::
	mov	ax,es:[si].play_buf_ticket	;Get the magic number
	pop	es	;:::::::::::::::::::::::::::::::::::::::::::::::::::::
	mov	es:[di].sndticket,ax	;Store ticket number

;	Compute number of bytes to play

	mov	ax,word ptr es:[di].sndend	;Get ending address
	mov	bx,word ptr es:[di].sndend[2]	;Get MSW
	mov	cx,word ptr es:[di].sndst	;Get starting offset
	mov	dx,word ptr es:[di].sndst[2]	;Get MSW
	les	di,es:[di].sndstrptr	;::::::::es:di= sp->soundhdr->soundstr:

	mov	si,ax			;Was an end specified?
	or	si,bx
	jnz	$endgiven		;End of range was specified

;	Here no end-range was specified (0), so use max length.

	mov	ax,word ptr es:[di].sndlen	;Get length of sound
	mov	bx,word ptr es:[di].sndlen[2]	;Get MSW
	jmp	short $endcom

$endgiven:
	dec	ax			;Adjust by one
	sbb	bx,0			;Handle borrow
	page
;	Okay, AX/BX contain the last byte to play, so get the range
;	and the starting position.

$endcom:sub	ax,cx			;Get starting offset
	sbb	bx,dx			;Get MSW
	jc	$badrange		;END < START, play entire thing
	mov	si,ax
	or	si,bx			;Is count non-zero?
	jnz	$shjp1			;Range is valid
	jmp	$pldone			;Nothing to play

$badrange:
	mov	ax,word ptr es:[di].sndlen	;Get length of sound
	mov	bx,word ptr es:[di].sndlen[2]	;Get MSW
	xor	cx,cx			;Set start to zero
	xor	dx,dx

;	Store the length to play

$shjp1:	mov	word ptr req_len,ax	;Save length
	mov	word ptr req_len[2],bx	;and segment

;	Now compute the new start of the sound.

$playl1:mov	ax,word ptr es:[di].sndbuf	;Get address of sound
	mov	bx,word ptr es:[di].sndbuf[2]	;Get segment
	call	roundup			;Force offset low

	add	ax,cx			;Add in offset
	jnc	$nolswc			;No segment adjust required
	add	bx,1000H		;Increment segment

$nolswc:and	dx,0fh			;Lose all but lower bits of MSW
	jz	$nosegad		;Segment does not need additional adj
	ror	dx,1
	ror	dx,1
	ror	dx,1
	ror	dx,1
	add	bx,dx			;Build new segment register

$nosegad:
	call	roundup			;Force offset to low value

	mov	word ptr srcbuf,ax	;Save new start of buffer
	mov	word ptr srcbuf[2],bx	;Save segment
	page
;	Now compute play rate

	mov	al,byte ptr snd_mode	;<22>Get mode
	test	al,BIAS			;Are we playing?
	jnz	$nobias			;Don't need a new bias parm

	mov	ah,es:[di].sndbias
	mov	dma_bias,ah		;Store TL/SL fudge factor

	mov	al,ld_rate		;Get sample rate for first sound

;	Program Dac speed

	dec	al			;Zero-Based now
	mov	si,offset outtbl
	shl	al,1			;x2 rate of first buffer
	shl	al,1			;x4
	shl	al,1			;x8
	mov	ah,dma_bias
	add	al,ah			;Add in play bias from first buffer
	xor	ah,ah
	add	si,ax
	mov	al,[si]			;Read playback rate with fudge
	mov	dx,DacBase
	inc	dx
	inc	dx			;306
	out	dx,al			;Set rate

	or	byte ptr snd_mode,BIAS	;<22>Don't set these values again
					;until player goes idle again

;	Now we can take our new buffer and expand its contents into
;	local buffers. 

$nobias:les	di,ld_buf_ptr	;::::::::Get target buffer position::::::::::::
	mov	cx,word ptr ld_buf_len	;How many bytes will fit
	mov	dx,word ptr req_len	;Get length of sound to play LSB
	mov	bh,ld_rate		;Get the rate
	mov	bl,ld_last_sample	;Get last sample of last sound

	push	ds			;Save our segment
	lds	si,srcbuf	;=======Point at source buffer=================
	page
$do64k:	call	round_dssi		;Force into reasonable place

;	At this point, DS:SI points at source buffer.
;	DX is number of bytes that can be read (goes to zero)
;	ES:DI points at target buffer.  
;	CX is number of bytes that can be written.
;	BL is last sample output
;	BH contains rate information

	cmp	bh,R11000
	jz	$do11
	ja	$more22
	jmp	$do5

;	This copies the 22 khz for playing at 22 khz
;	Code is optimized for pipelining, not for size.

if 1
$more22:
;	DX is number of bytes that can be read (goes to zero)
;	CX is number of bytes that can be written.
	cmp	cx,dx			;<29>Which number is smaller?
	jc	$lesst22		;<29>Less target than source

;	Here the bytes of source is less than the target buffer or
;	the two sizes are equal.

	sub	cx,dx			;<29>Subtract amount we will copy
					;<29>now cx >= 0
	mov	ax,cx			;<29>from target and save it away
	mov	cx,dx			;<29>Make source the length cntr

	call	snd_fragmove		;<29>
	mov	cx,ax			;<29>Put target pointer back
	mov	bl,es:[di-1]		;<29>Save last sample for dovetailing
	jmp	short $doneexp		;<29>All done, DX not needed

;	Here the target buffer isn't as big as the remaining source string

$lesst22:
	sub	dx,cx			;<29>Subtract amount we will copy
					;<29>dx > 0  (can't be equal)
	call	snd_fragmove		;<29>
	call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	$more22			;<29>More to do

	
else
	movsb				;<23>[7-t]Read and store the byte
	dec	cx			;Decrement target counter
	jz	$full22			;Least likely path
$emp22:	dec	dx			;Decrement source counter
	jnz	$more22			;Do another byte
	mov	bl,es:[di-1]		;<27>Save last sample in case next sound
	jmp	short $doneexp		;submitted is at a lower speed.

$full22:call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp22
endif

$doneexp:
	mov	ax,ds
	pop	ds	;================Get our segment=======================
	mov	dx,word ptr req_len[2]	;Get length of sound to play MSB
	or	dx,dx
	jz	$realdone		;All done

;	Here the MSB was non-zero, so decrement it and run the thing again

	dec	dx
	mov	word ptr req_len[2],dx	;Store new MSB
	xor	dx,dx
	mov	bh,ld_rate		;Get the rate (5.5 khz wipes it out)

	push	ds
	mov	ds,ax	;======================================================
	jmp	$do64k			;DX is equal to 65536

	page
$realdone:
	mov	word ptr ld_buf_ptr,di	;Store segment and offset
	mov	word ptr ld_buf_ptr[2],es
	mov	word ptr ld_buf_len,cx	;Store remaining count
	mov	ld_last_sample,bl	;Store last sample

;	All done with this sound.

$pldone:xor	ax,ax			;<2>
$plabort:				;<2>
	pop	es	;::::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	ds	;======================================================
	pop	di
	pop	si
	pop	bp
	ret				;NEAR or FAR
	page
;	Handle expansion of 11 khz to 22 khz
;	Here always have a previous sample, so we need to generate a sample
;	that would appear between the two values.
;	Code is optimized for pipelining, not for size.

$do11:	lodsb				;<23>Edit 19 mods cut math compute
					;<23>time in half over previous
	xchg	al,bl			;<23>Put new value in AL, old in BL
	add	al,bl			;<23>Sum last and new (9-bit)
	rcr	al,1			;<23>Divide by two (average)
	stosb				;Write generated sample
	dec	cx			;Decrement target counter
	jz	$full11a
$emp11a:mov	al,bl			;<23>Now play new sample
$com11:	stosb
	dec	cx			;Decrement target counter
	jz	$full11b
$emp11b:dec	dx			;Decrement source counter
	jnz	$do11			;Do another byte
	jmp	$doneexp

$full11a:
	call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp11a

$full11b:
	call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp11b
	page
;	Handle expansion of 5.5 khz to 22 khz
;	Here always have a previous sample, so we need to generate 3 samples
;	that would appear between the two values.
;	Code is optimized for pipelining, not for size.

$do5:	lodsb
	mov	ah,al			;Get the value
	add	ah,bl			;Add in previous (9-bit)
	rcr	ah,1			;Average the two and get the center
					;value
	mov	bh,ah			;Take center average
	add	bh,bl			;and add previous (9-bit)
	rcr	bh,1			;bh now contains first sample

	xchg	bh,al
	stosb				;Write it  (*1)
	dec	cx			;Decrement target counter
	jz	$full5a
$emp5a:	mov	al,ah			;Get center value
	stosb				;Write it  (*2)
	dec	cx			;Decrement target counter
	jz	$full5b
$emp5b:	mov	al,bh			;Take newest value (exed to BH)
	add	al,ah			;Add in center average
	rcr	al,1			;Create 3rd number
	stosb				;Write it (*3)
	dec	cx			;Decrement target counter
	jz	$full5c
$emp5c:	mov	al,bh			;Newest value
	stosb				;Write it (*4)
	dec	cx			;Decrement target counter
	jz	$full5d
$emp5d:	mov	bl,al			;Make this the last value
	dec	dx			;Decrement source counter
	jnz	$do5			;Do another byte
	jmp	$doneexp
	page
$full5a:call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp5a

$full5b:call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp5b

$full5c:call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp5c

$full5d:call	snd_queue
	call	getbuf
	call	rnd_dssi_m		;Avoid rolling out of our segment
	jmp	short $emp5d

_snd_play	endp
	page
;------------------------------------------------------------------------------
;	Snd_Queue - Adds a buffer onto the play chain and starts the
;	player if it is supposed to.
;	Interrupts are disabled briefly and then are put back as they were.
;	- By Frank Durda IV
;	Trashes
;		ES,DI
;------------------------------------------------------------------------------
snd_queue proc near 
	push	ds
	push	ax
	push	bx
	push	dx
	mov	ax,snddata
	mov	ds,ax	;======================================================
	assume ds:snddata

	les	di,ld_buf	;::::::::Get current pointer:::::::::::::::::::
	mov	ax,es
	mov	bx,di
	pushf	
	cli	;--------------------------------------------------------------
	les	di,queue_last	;::::::::Point at last buffer to play::::::::::
	mov	dx,es
	or	dx,di
	jnz	$notempty

;	Here there are no entries in the queue.  So set things up

	mov	word ptr queue_play,bx	;Point start of queue somewhere.
	mov	word ptr queue_play[2],ax

	lea	di,queue_last		;This will give something
	mov	dx,ds			;to chain new buffer onto
	mov	es,dx	;::::::::::::::::by building a fake previous buffer::::
	mov	dl,1
	mov	trig_count,dl		;Set count to 1
	jmp	short $quecom
	db	'fdiv'			;Copyright signature
	db	0			;Must remain unchanged - see intro.n
	page
$notempty:
	mov	word ptr queue_last,bx	;Advance pointer to last item
	mov	word ptr queue_last[2],ax	
	inc	byte ptr trig_count	;Increment counter of buffers
$quecom:mov	word ptr es:[di].play_buf_next,bx	;Add to end of chain
	mov	word ptr es:[di].play_buf_next[2],ax

	and	byte ptr snd_mode,NOT STOPDMA	;<23>Clear the STOP flag in
					;<23>the case where we are nearly out
					;<23>of things to do, but now there
					;<23>is one buffer left, so don't
					;<23>give up now.

;	Now see if we are supposed to start the player after n buffers

	mov	al,byte ptr snd_mode	;<22>
	test	al,INPLAY
	jnz	$runx			;Already running, skip this
	mov	al,dma_trip		;Get trip point
	or	al,al
	jz	$runx			;Don't start here
	cmp	al,trig_count		;Get queued buffer count
	ja	$runx			;Not time yet
	call	duo_art			;Force the player to start now

$runx:	popf	;--------------------------------------------------------------
	pop	dx
	pop	bx
	pop	ax
	pop	ds	;======================================================
	ret
snd_queue endp
	page
;------------------------------------------------------------------------------
;	Getbuf - pulls a buffer off the free-list and makes it the next
;		 buffer we will use for expansion.
;	- By Frank Durda IV
;	returns pointer in ES:DI
;	returns length in CX
;------------------------------------------------------------------------------

getbuf	proc near
	push	ax
	push	ds
	mov	ax,snddata
	mov	ds,ax	;======================================================
	assume ds:snddata

$anybufs:
	pushf				;Save EI/DI
	cli	;--------------------------------------------------------------
	les	di,queue_free	;::::::::::::::::::::::::::::::::::::::::::::::
	mov	ax,es
	or	ax,di
	jz	$nobufs			;No buffers are free

;	A buffer is available

	mov	word ptr ld_buf,di	;Save that
	mov	word ptr ld_buf[2],es

	mov	ax,curticket		;Update ticket #
	inc	ax
	mov	curticket,ax
	mov	word ptr es:[di].play_buf_ticket,ax

	mov	ax,di
	add	ax,HEADER_SIZE
	mov	word ptr ld_buf_ptr,ax	;Build pointer to data area
	mov	word ptr ld_buf_ptr[2],es
	push	di
	push	es			;Save next char pointer

	les	di,es:[di].play_buf_next;::::::::Get next pointer::::::::::::::

	mov	word ptr queue_free,di	;Next buffer (or NULL)
	mov	word ptr queue_free[2],es	;Is now next free

	pop	es	;::::::::::::::::::::::::::::::::::::::::::::::::::::::
	pop	di

	xor	cx,cx			;Zero "next" on buffer
	mov	word ptr es:[di].play_buf_next,cx	;in ld area
	mov	word ptr es:[di].play_buf_next[2],cx
	page
	mov	cx,MERRYGO_SIZE_BYTES
	mov	ld_buf_len,cx		;Remainder

	mov	di,ax			;First byte offset

	popf	;--------------------------------------------------------------
	pop	ds	;======================================================
	pop	ax

;	es:di now points to first byte in ld_buf_ptr target area
;	cx is length

	ret				;NEAR

;	Here there are no buffers available - so we must block

$nobufs:mov	al,byte ptr snd_mode	;<22>
	test	al,INPLAY
	jnz	$isrun
	push	bx
	push	dx
	call	duo_art			;Start playing now!
	pop	dx
	pop	bx
$isrun:	popf	;--------------------------------------------------------------
	jmp	short $anybufs		;Look again
getbuf	endp
	page
;------------------------------------------------------------------------------
;	DuoArt	- The actual player piano playing thingy

;	When this routine gets called, it will start the player,
;	provided there is something to do.  It is remotely possible
;	that the calling program cleared the queue between the time
;	we were asked to play it and the time we get here.
;	By Frank Durda IV
;------------------------------------------------------------------------------

duo_art	proc near

	push	bp
	mov	bp,sp
	push	si

;	Okay, look at our pointer to the buffers and here we go!

	les	si,queue_play	;::::::::Get pointer to first/next buffer::::::
					;to play
	assume es:nothing

	mov	ax,es			;Check for null pointer
	or	ax,si
	jnz	$queueok		;There is at least one buffer to play

;	Here there were no buffers - someone screwed up or chickened out.

	pop	si
	pop	bp
	ret				;NEAR or FAR
	page
;	We have a valid pointer to the first buffer

$queueok:
	push	di
	mov	ax,es:[si].play_buf_ticket	;Get ticket we are about to play
	mov	dma_ticket,ax		;This will be used by snd_wait()
	or	byte ptr snd_mode,INPLAY	;<22>Indicate we are in play

	mov	ax,es

	add	si,HEADER_SIZE		;<17>Skip control information
	les	di,merrygo_buf	 ;:::::::Get pointer to the circle buffer::::::
	mov	bx,ds			;<29>Save snddata
	mov	ds,ax	;================Set up source=========================

	cld
	mov	cx,MERRYGO_SIZE_WORDS
	rep	movsw			;Do the transfer
	mov	al,[si-1]		;<29>
	mov	ds,bx			;<29>Get snddata
	mov	emptyfill,al		;Save that byte in case we need
					;to stretch it.

;	The first buffer is now loaded.  Start the DMA

;	Now the first buffer is in position.  The rate and volume have
;	already been programmed.

	mov	dx,DacBase		;Get hardware port
	mov	al,PLAYMODE OR DMADRQ OR DMAIEI
	out	dx,al			;Hardware is ready for DMA traffic
	mov	al,PLAYMODE OR DMADRQ OR DMAIEICL OR DMAIEI
	out	dx,al			;Hardware is ready for DMA traffic
	page
;	Program DMA

	in	al,21h			;Get IMR
	and	al,7fh			;Clear interrupt mask
	out	21h,al

;	Clear LSB/MSB flip-flop DMA kludge

	mov	dx,dma_mask_port
	mov	bl,dma_mask_value
	mov	al,bl
	or	al,4			;5
	out	dx,al

	inc	dx			;dma_mode_port
	mov	al,01011000B		;Play
	or	al,bl			;Add in channel field
	out	dx,al

	mov	dx,dma_page_port
	mov	al,merrygo_phys_page
	out	dx,al			;Set page of DMA buffer

	mov	dx,dma_addr_port
	mov	ax,merrygo_phys_offs
	out	dx,al			;Write LSB

	mov	al,ah
	out	dx,al			;Write MSB

	inc	dx			;dma_count_port
	mov	ax,MERRYGO_SIZE_BYTES-1	;Xfers one more than we ask
	out	dx,al

	mov	al,ah
	out	dx,al

	mov	dx,dma_mask_port
	mov	al,dma_mask_value
	out	dx,al			;DMA is ON!!!

	call	play_safety

	pop	di
	pop	si
	pop	bp
	ret
duo_art	endp
	page
;------------------------------------------------------------------------------
;	Play_safety - Handles those few bytes at the beginning of the DMA area
;	This subroutine is called when:
;	(1) the first buffer has been loaded and we are waiting for the
;	    first few samples to be output, or
;	(2) we have just received an interrupt and have transferred the
;	    last n bytes.  Now we select the next buffer and do the first
;	    few bytes si points to the last buffer transmitted
;	Trashes
;		AX, BX, CX, DX, SI, DI, ES
;------------------------------------------------------------------------------
play_safety	proc	near
	
	les	di,queue_play	;::::::::Get pointer to buffer just placed:::::
					;in DMA buffer
	cld				;<25>Do it to be sure we are covered

	mov	ax,es			;Check for null pointer
	or	ax,di
	jz	$silence		;<23>The queue has been drained by
					;snd_stop, put on the breaks.
					;<23>Was calling the wrong place

;	The ticket manager has been moved here.  It will now increment when
;	a particular buffer has just started playing (< 100 usecs), instead
;	of going to play in a while (< 100 msecs).  This should improve
;	screen synchronization.

	mov	ax,es:[si].play_buf_ticket	;<23>Get ticket we are playing
	mov	dma_ticket,ax		;<23>This will be used by snd_wait()

;<23>	This keeps track of the number of .1 sec intervals that have passed.

	mov	ax,1			;<23>
	add	word ptr snd_time_count,ax	;<23>Increment time thingy
	jnc	$noc			;<23>
	inc	word ptr snd_time_count+2	;<23>Increment MSW
	page
$noc:	mov	ax,es			;Save pointer to buffer being freed
	mov	bx,di

	push	word ptr es:[di].play_buf_next	;This will be top of
	push	word ptr es:[di].play_buf_next[2]	;Play queue

	mov	ax,word ptr queue_free	;Get pointer to first free item
	mov	bx,word ptr queue_free[2];or null

	mov	word ptr queue_free,di	;Store pointer to our buffer
	mov	word ptr queue_free[2],es

	mov	word ptr es:[di].play_buf_next,ax
	mov	word ptr es:[di].play_buf_next[2],bx	;Point to our pointer

;	Now, remove the item from the play queue

	pop	dx
	pop	si
	mov	word ptr queue_play,si	;Store it
	mov	word ptr queue_play[2],dx	;Store it

	mov	ax,si			;Is it a null pointer?
	or	ax,dx
	jnz	$morebufs

	mov	word ptr queue_last,dx	;Set last pointer to NULL
	mov	word ptr queue_last[2],dx	;Set last pointer to NULL
	page
;	Here there are no buffers left to play.  So fill the safety area
;	will copies of the last byte in the previous buffer.  We will
;	work our way back to 80h later.  Maybe.

$silence:				;<23>
	mov	ah,emptyfill
	les	di,merrygo_buf	;::::::::Get pointer to the circle buffer::::::
	mov	cx,SPLIT_FILL_WORDS

;	Now set a flag we will see when we enter the ISR again.

	or	byte ptr snd_mode,STOPDMA	;<22>
	mov	dx,dma_count_port	;<29>

;	Wait until the DMA has passed the target area before doing the xfer

$queuedrain:				;This checks to see if we have
	mov	al,0ffh			;passed the safety margin area
	out	DMACLR,al		;<29>If the safety area is 4 bytes,
					;I have a hard time believing
	in	al,dx			;it take less than 181usec to get
	mov	bl,al			;here, even on a 20mhz system.
	in	al,dx
	mov	bh,al

	cmp	bx,MERRYGO_SPLIT	;Have at least n bytes been moved?
	jae	$queuedrain		;<15>No, wait a bit (was ja.)
	
;	Here the DMA has moved beyond the safety area, so fill it in.

	mov	al,ah			;Make a words worth
	rep	stosw			;Fill it
	ret
	page
;	Take the first few bytes of the next buffer and make them the
;	safety area.

$morebufs:
	les	di,merrygo_buf	;::::::::Get pointer to the circle buffer::::::
	mov	cx,SPLIT_FILL_WORDS

	mov	dx,dma_count_port	;<29>Set up once
	push	ds			;<29>
	lds	si,queue_play	;<29>====Get next buffer=======================
	add	si,HEADER_SIZE		;<29>Skip control information

$passsafety:				;This checks to see if we have
	mov	al,0ffh			;passed the safety margin area
	out	DMACLR,al		;<29>If the safety area is 4 bytes,
					;I have a hard time believing
	in	al,dx			;it take less than 181usec to get
	mov	bl,al			;here, even on a 20mhz system.
	in	al,dx
	mov	bh,al

	cmp	bx,MERRYGO_SPLIT	;Have at least n bytes been moved?
	jae	$passsafety		;<15>No, wait a bit (was ja.)

;	The DMA is out of the way, and all registers are ready - DO IT
	
	rep	movsw			;Fill it
	mov	al,[si-1]		;<29>Do dec here
	pop	ds	;======================================================
	mov	emptyfill,al		;Save that byte in case we need
					;to stretch it.
	ret				;All done
play_safety endp

sndseg	ends
	end

