IFNDEF SHOWINC
.xlist
ENDIF
;-----------------------------------------------------------------------------
;	Sound.Inc     - Equates and includes for the PSSJ Digital Sound
;			Toolkit Library as of Version 3(40).
;	Sound.Inc is part of the PSSJ Digital Sound Toolkit.
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
;	Mode word equates

INPLAY		equ	0001H		;Player DMA is running
INRECORD	equ	0002H		;Recorder DMA is running
UNINITIALIZED	equ	0004H		;Are we initialized
STOPDMA		equ	0008H		;Signal to ISR to abort DMA
RAMPUP		equ	0010H		;State of playback hardware
BIAS		equ	0020H		;Indicates if bias info is set
SHUTDOWN	equ	0040H		;<32>Ack interrupt but do nothing
modesp1		equ	0080H		;

DISKPLAY	equ	0100H		;Disk play is in operation
DISKRECORD	equ	0200H		;Disk record is active
DISKABORT	equ	0400H		;Wrapping up some disk operation
DOS_HOOKED	equ	0800H
COMPRESS	equ	1000H		;<24>File on disk is/will be compressed
HAVEBLK		equ	2000H		;<24>
EXPBUSY		equ	4000H
DISKBUSY	equ	8000H		;<18>Can't interrupt this

;	Second Mode Word  snd_mode2
FASTRAMP	equ	0001H		;<9>Let it click, just hurry!
THRESHOLD	equ	4000H		;
COMPENSATE	equ	8000H		;
	page
;	State breakdown rules
;	If UNINITIALIZED,  INPLAY, INRECORD, STOPDMA, BIAS and RAMPUP are false
;	UNINITIALIZED cleared by snd_init, set by snd_exit.
;	All other states require UNINITIALIZED to be false

;	If RAMPUP, (set by first call to snd_play after init or record)
;	INRECORD must be false.
;	INPLAY or INRECORD is set when the DMA actually starts.
;	INRECORD cannot go high until RAMPUP is low.
;	RAMPUP cannot go low until until INPLAY is low.

;	STOPDMA goes high while INPLAY is high, indicating 
;	the DMA operation will end at next IRQ.
;	STOPDMA is cleared by player_irq.  INPLAY also cleared.

;	state machine
;		UNINITIALIZED set, INPLAY, INRECORD, STOPDMA, RAMPUP, BIAS clear
;	1.	snd_init called.
;		UNINITIALIZED, INPLAY, INRECORD, STOPDMA, RAMPUP, BIAS clear
;	2.	snd_play called.  Calls rampup
;		RAMPUP, BIAS set, UNINITIALIZED, INPLAY, INRECORD, STOPDMA clear
;	3.	duo_art called (by snd_flush or sndqueue) and DMA starts
;		RAMPUP, BIAS, INPLAY set, UNINITIALIZED, INRECORD, STOPDMA clear
;	4.	player_irq exhausts queue.
;		RAMPUP, BIAS, INPLAY, STOPDMA set, UNINITIALIZED, INRECORD clear
;	5.	player_irq sees STOPDMA on next interrupt and stops DMA
;		RAMPUP set, UNINITIALIZED, INRECORD, INPLAY, STOPDMA, BIAS clear

;	6.	snd_play called with additional sounds.  No rampup call.
;		RAMPUP, BIAS set, UNINITIALIZED, INPLAY, INRECORD, STOPDMA clear
;	7.	duo_art called (by snd_flush or sndqueue) and DMA starts
;		RAMPUP, BIAS, INPLAY set, UNINITIALIZED, INRECORD, STOPDMA clear
;	8.	player_irq exhausts queue.
;		RAMPUP, BIAS, INPLAY, STOPDMA set, UNINITIALIZED, INRECORD clear
;	9.	player_irq sees STOPDMA on next interrupt and stops DMA
;		RAMPUP set, UNINITIALIZED, INRECORD, INPLAY, STOPDMA, BIAS clear
	page
;	10.	snd_record called, invokes rampdown
;		UNINITIALIZED, INRECORD, INPLAY, STOPDMA, RAMPUP, BIAS clear
;	11.	recorder starts
;		INRECORD set, UNINITIALIZED, INPLAY, STOPDMA, RAMPUP, BIAS clear
;	12.	recorder runs out of buffers or snd_stop call is made
;		UNINITIALIZED, INPLAY, STOPDMA, RAMPUP, INRECORD, BIAS clear


;	Machine type flags

MMAC		equ	0		;Accurate sample rate
MSYNTH		equ	0		;Synthetically produced
M3000		equ	1		;286 8.0 MHZ 1W
M1000SL		equ	2		;8086 7.16 MHZ
M1000TL		equ	3		;286 8.0 MHZ
M1KSLTL2	equ	4		;<27>Double buffering hides CPU type
Mextra1		equ	5		;Future strange machine #1
Mextra2		equ	6		;Future strange machine #2
Mextra3		equ	7		;Future strange machine #3
Mextra4		equ	8		;Future strange machine #4

;	Error flags and other things

INVALID		equ	-1		;Call made when driver uninitialized
					;or call simply not legal at this point
NOERROR		equ	0
INITBUF		equ	1		;No buffers were allocated
					;before snd_init was called
INITDMA		equ	2		;All buffers spanned 64K physical
					;addresses - player cannot initialize
BADDMA		equ	3		;DMA Channel requested is invalid
BADIRQ		equ	4		;The IRQ number requested is invalid
NOIRON		equ	5		;Can't find our hardware
BADSIZE		equ	6		;Record buffer is too small or
					;too small for requested time.
WOULDBLOCK	equ	7		;<5>Record failed because the queue
					;<5>was full. (BLOCK is non-zero)


;	The following are the error codes returned by the Deathmate resource
;	which for some unknown reason has to return single letter codes.

RESOK		equ	NOERROR+'0'	;Command accepted
RESNOTINIT	equ	'U'		;Not initialized - signals earlier
					;failure that was ignored.
RESBUSY		equ	'B'		;Another file is being played
					;or recorded.
RESFNF		equ	'F'		;Specified file was not found
RESNOTTIME	equ	'W'		;Specified point in time has not
					;arrived
RESISTIM	equ	'G'		;Specified point in time has arrived

RESBADCMD	equ	'X'		;Unknown command code
RESYES		equ	'Y'
RESNO		equ	'N'


TRUE		equ	1
FALSE		equ	0
TORECORD	equ	INRECORD	;<5>
TOPLAY		equ	INPLAY		;<5>
EOF		equ	-1		;<24>
MOREDATA	equ	-2		;<24>
	page
DacPgm		equ	0		;0xc4 or 0x304 or 0x1e4
DacWrite	equ	1		;0xc5 or 0x305 or 0x1e5
DacRead		equ	1		;0xc5 or 0x305 or 0x1e5
DacFreq		equ	2		;0xc6 or 0x306 or 0x1e6
DacGain		equ	3		;0xc7 or 0x307 or 0x1e7
SNDCHNL		equ	4		;0xc0 or 0x300 or 0x1e0 NEGATIVE


;	DacPgm Command bits

PLAYMODE	equ	00000011B	;0x03 Direct Write to DAC
RECMODE		equ	00000010B	;0x02 Successive Approx
DMADRQ		equ	00000100B	;0x04 DRQ Enable
DMAIEICL	equ	00001000B	;0x08 Interrupt Clear/Enable
DMAIEI		equ	00010000B	;0x10 Interrupt Disable/Enable


;	DacPgm Status Bits

OURIRQ		equ	00001000B	;0x08 Interrupt is from sound hardware
SAMPLRDY	equ	10000000B	;0x80 When **LOW**, sample is available


;	Sampling rate defines
R5500		equ	1		;5.5k sampling rate
R11000		equ	2		;11k sampling rate
R22000		equ	3		;22k sampling rate
R32500		equ	4		;<27>32.5k sampling rate
R39800		equ	5		;<27>29.8k sampling rate
MAXRATE		equ	5

MERRYGO_SIZE_BYTES	equ	2200
MERRYGO_SIZE_WORDS	equ	MERRYGO_SIZE_BYTES/2
SPLIT_FILL_BYTES	equ	100
MERRYGO_SPLIT		equ	MERRYGO_SIZE_BYTES-SPLIT_FILL_BYTES
SPLIT_FILL_WORDS	equ	SPLIT_FILL_BYTES/2

	page
@codesize	equ	1

;	SP overlay, for passed parameter to snd_play and others

sptr	struc
	dw	?
	dw	(@codesize+1) dup (?)
spptr	dd	?			;Points to a soundhdr
spint	dw	?			;Integer arg
sptr	ends

;	init overlay, for passed parameter to snd_init

sinit	struc
		dw	?
		dw	(@codesize+1) dup (?)
init_trigger	dw	?		;Play threshold
init_dma_chan	dw	?
init_irq	dw	?
init_options	dw	?		;<9>
sinit	ends
	page
;	soundhdr overlay.  A SP-> to a soundhdr which points to
;	a soundstr which points to the actual sound data.
;	Confused?  Wait till you see the segment overrides....

;	This structure does not exist when recording

soundhdr	struc
sndstrptr	dd	?		;Pointer to a soundstr
sndst		dd	?		;LONG of where to start in sound
sndend		dd	?		;LONG of where to end in sound
sndticket	dw	?		;Ticket of buffer sound ended up in.
sndplayrate	db	?		;Rate to play sound at
sndreserved	db	?		;Get around MS compiler foolishness
sndresv1	dd	?		;<8>Reserved
sndresv2	dd	?		;<8>I see the future - Reserved
soundhdr	ends

SNDHDR_SIZE	=	size soundhdr
	
;	This structure describes the sound and its "fixed" properties
;	This area is written to only when recording.

soundstr	struc
sndbuf		dd	?		;The sound itself
sndlen		dd	?		;Length of the sound in the buffer
sndblen		dd	?		;Length of the buffer containing
sndrecrate	db	?		;Sampling rate it was recorded at
sndbias		db	?		;1 if we have to kludge timing
sndchain	dd	?		;<32>Chain field
sndresv4	dd	?		;<8>I see the future - Reserved
soundstr	ends

SOUND_SIZE	=	size soundstr

;	This structure is what the sound buffer the user gives us
;	look like

play_buffers	struc
play_buf_next	dd	?		;Pointer to next buffer
play_buf_ticket	dw	?		;Ticket number
		dw	?
play_buffers	ends

HEADER_SIZE	=	size play_buffers
page

;	This structure describes the header on a PSSJ sound file.

disk_header	struc
hd_name		db	44 dup (?)	;Instrument or other description
					;Terminated with CR/LF/^Z
hd_kludge	db	?		;Extra ^Z
hd_format	db	?		;Accept 0x80 only for now
hd_count	dw	?		;Sound Count (=1 for normal files)
hd_inst		db	?		;Instrument # (0 for normal files)
hd_res1		db	17 dup (?)	;Reserved
hd_compress	dw	?		;Compression type (0 for none)
hd_compinfo	db	20 dup (?)	;Compression info
hd_rate		dw	?		;Sampling rate
hd_rate_msw	dw	?		;Reserved
hd_bias		dw	?		;Skew value for hardware
hd_res2		db	20 dup (?)	;Reserved
disk_header	ends

disk_sound	struc
hd_next		dd	?		;Pointer to next sound block
hd_option	dw	?		;Sound options
hd_pitch	db	?		;Pitch info (instrument only)
hd_mystery	db	?		;Something that sound uses
hd_low		db	?		;Low range of scaling
hd_high		db	?		;High range of scaling
hd_offset	dd	?		;Offset in file for start of sound
hd_length	dd	?		;Length of sound 
hd_truelen	dd	?		;Decompressed size
hd_st_sust	dd	?		;Sustain mark
hd_end_sust	dd	?		;Sustain end
hd_res4		db	16 dup (?)	;Reserved
disk_sound	ends


IFNDEF SHOWINC
.list
ENDIF
