# include <stdio.h>
# include <conio.h>
# include <stdlib.h>
# include "sound.h"
# include "dsetup.h"
# include "dgetbuf.h"
# include "dplay.h"
# include "dload.h"
# include "demo3.h"

/*
 *	This demonstration program reads a compressed sound from a file,
 *	decompresses it, and plays it.  The program expects one
 *	command-line argument, the name of a file containing the sound
 *	to play.
 *
 *	The file format expected is the format used by the companion
 *	demonstration program for the sound library, and is unlikely to
 *	be compatible with anything else.
 */
# ifdef __STDC__
int	main(int argc, char *argv[])
# else
int	main(argc, argv)
int	argc;
char	*argv[];
# endif
{
	/* check arguments */
	if (argc != 2)
	{
		printf("Usage:  demo3 savefile\n");
		exit(1);
	}
	/* get buffers for the sound library, and initialize hardware */
	set_up_sound((u_short) 5, (u_short) 0, (u_short) 0, (u_short) 0,
		(u_short) 0);

	/* get buffers to read the sound into */
	set_up_buffers();

	/* decompress the sound and load it into memory */
	do_decompress_and_load(argv[1]);

	/* play the sound */
	do_playback_sound();

	/* shut down the sound hardware */
	snd_exit();
	return 0;
}
