# include "sound.h"
# include "dsetup.h"
# include "dgetbuf.h"
# include "drecord.h"
# include "dplay.h"
# include "dmdemo.h"
# include "dmmenu.h"
# include "csrcfg.h"
# include "dmexec.h"

# include <stdio.h>
# include <conio.h>
# include <stdlib.h>
# include "dsave.h"
# include "demodlg.h"

# include "dload.h"
# include "dmguf.h"

# include "demoinfo.h"

/*
 *	This DeskMate demonstration program provides the basic functions
 *  a sound application would need such as:
 *		allows multiple recording of a sound,
 *		compresses a sound,
 *  		stores a sound to a disk file,
 *		loads a sound file from disk,
 *		decompresses a sound,
 *		plays a sound.
 *
 *	The program may be passed one command-line argument, the name
 *	of a file containing the sound to play.  At which time the file
 *	is loaded.
 *
 *	The file format expected is the format used by the companion
 *	demonstration program for the sound library, and is unlikely to
 *	be compatible with anything else.
 */
# ifdef __STDC__
int	main(int argc, char *argv[])
# else
int	main(argc, argv)
int	argc;
char	*argv[];
# endif
{
	char		filename[70];
	MSGBOX		msg;
	EVENT		event;
	MOUSE_CFG	mouse;
	int		erc;

	/* Bind to the DeskMate CSR for user interface capabilities */
	if ( csr_init() == CSR_ERROR )
		exit(1);

	/* Bind to the DeskMate CSR for user interface capabilities */ 
	if ( guf_bind_init() == CSR_ERROR )
	{
	    csr_end();
	    exit(1);
	}

	/* Check for Joystick Driver - disable the driver */
	cfg_get_ms_data( &mouse );
	if ( strncmp( mouse.driver, "DMMDJOY", 7 ) == 0 )
	{
		/* Joystick driver loaded */
		ms_erase_pointer();
		ms_disable_driver();
		JoyWasLoaded = 1;
		/* unhook the joystick vector */
		Set_Joy();
	} /* disable the joystick until just before snd_exit */

	/* This application does not allow code shedding */
	dm_exec_dont_shed();

	/* Draw the default screen */
	Demo_Draw_Screen();

	/* Display Welcome Message */
	IS.pString = "This demo will record a sound, play it back, save and load a sound file.";
	info_draw ( &IB );
	wait1000();

	/* get buffers for the sound library and set things up */
	/* also calls snd_init */
	set_up_sound((u_short) 5, (u_short) 0, (u_short) 0,
			 (u_short) 0, (u_short) 0);

	/* allocate memory to store the sound in */
	set_up_buffers();

	/* check arguments */
	if (argc > 1)
	{
		strcpy( filename, argv[1] );
		do_decompress_and_load(filename);
		menu1items[PLAY_BACK_INDEX].bEnabled = ENABLED;
		menu0items[SAVE_AS_INDEX].bEnabled = ENABLED;
	}
	else
	{
		menu1items[PLAY_BACK_INDEX].bEnabled = DISABLED;	
		menu0items[SAVE_AS_INDEX].bEnabled = DISABLED;
	}

	/* make sure the CTRL_P accelerator is registered with the core */
	mb_draw( &menubar );

	do
	{
		event_read( &event );

		switch ( event.msg )
		{
			case EVENT_COMMAND :
				switch ( event.param )
				{
					case RECORD :
						/* record the sound */
						do_record_sound();

						/* Enable playback */
						menu1items[PLAY_BACK_INDEX].bEnabled = ENABLED;
						menu0items[SAVE_AS_INDEX].bEnabled = ENABLED;
						mb_draw( &menubar );
						break;

					case PLAY_BACK :

						/* play it back */
						do_playback_sound();

						break;

					case SAVE_AS :
						filename[0] = 0;
						if ( get_filename(filename) == FALSE )
							break;
						/* compress sound and save the compressed to a file */

						do_compress_and_save(filename);

						break;

					case OPEN :
						/* open a disk file */

						if ( dlgbox_Generic( "", filename, FIO_OPEN ) == FALSE )
						{
							vid_move_cursor(0, 4 * CHAR_YEXT );
							vid_clear_to_bot();
							break;
						}
						vid_move_cursor(0, 4 * CHAR_YEXT );
						vid_clear_to_bot();

						/* decompress the sound and load it into memory */
						do_decompress_and_load(filename);
						menu1items[PLAY_BACK_INDEX].bEnabled = ENABLED;
						menu0items[SAVE_AS_INDEX].bEnabled = ENABLED;
						mb_draw( &menubar );

						break;

					default :
						break;
				}
			break;

			case EVENT_MOUSE :
				if ( event.param == MS_BUTTON_DOWN )
				 	event_purge();
				break;
	      
			case EVENT_APPL :
				switch( event.param )
				{
					case APPL_ACCESS :
						if (JoyWasLoaded)
						{
							/* Joystick driver loaded */
							/* put the joystick back the way it was */
							Un_Set_Joy();
							ms_enable_driver();
							ms_draw_pointer();
							JoyWasLoaded = 0;
						} /* enable the joystick after the snd_exit */

						/* user wants to run an accessory */
						dm_acc_run( event.x );

						/* the setup accessory may have been run and changed the mouse driver */
						/* So, Check for Joystick Driver - disable the driver */
						cfg_get_ms_data( &mouse );
						if ( strncmp( mouse.driver, "DMMDJOY", 7 ) == 0 )
						{
							/* Joystick driver loaded */
							ms_erase_pointer();
							ms_disable_driver();
							JoyWasLoaded = 1;
							/* unhook the joystick vector */
							Set_Joy();
						} /* disable the joystick until just before snd_exit */
						/* redraw the menubar and the screen */
						Demo_Draw_Screen();
						break;

					case APPL_TASK_SWITCH :
						/* snd_exit required before tskswi */
						if (JoyWasLoaded)
							Un_Set_Joy(); /* reset joystick vector */
						snd_exit();
						erc = dm_yield();
						if ( erc == DM_NOT_ALLOWED )
						{
							if (JoyWasLoaded)
								Set_Joy(); /* unhook joystick vector */
							snd_init(0,0,0,0);
							break;
						}

						if ( erc == DM_OK )
						{
						/* redraw the menubar and the screen and re-initialize the sound hardware */
							if (JoyWasLoaded)
								Set_Joy();
							snd_init(0,0,0,0);
							Demo_Draw_Screen();
						}
						else
						{
							/* the yield failed somehow */
							msg.pMessage = "TaskSwitch failed, exiting program";
							bomb_out( &msg );
						}
						break;
        
					default :
						break;
        
				} /* end of switch on type of application event */
			default:
				break;
    	}

	} while ( !(event.msg == EVENT_COMMAND && event.param == EXIT) );

	/* shut down the hardware before we touch the joystick */
	snd_exit();

	/* Check for Joystick Driver */
	if (JoyWasLoaded)
	{
		/* Joystick driver was loaded */
		/* put the joystick vector back the way it was */
		Un_Set_Joy();
		ms_enable_driver();
		ms_draw_pointer();
		JoyWasLoaded = 0;
	} /* enable the joystick after the snd_exit */

	csr_end();
	guf_bind_end();
	exit(0);
}

bomb_out( pMsg )
MSGBOX	*pMsg;
{
	msg_run( pMsg );

	/* call this before joystick calls */
	snd_exit();
	
	/* Check for Joystick Driver */
	if ( JoyWasLoaded )
	{
		/* Joystick driver loaded */
		/* put the joystick vector back the way it was */
		Un_Set_Joy();
		ms_enable_driver();
		ms_draw_pointer();
	} /* enable the joystick after the snd_exit */

	guf_bind_end();
	csr_end();
	exit(1);
} /* end of demo bomb out routine */

get_filename( pName )
char	*pName;
{
	unsigned int	ret;

	PBs[0].bState = PB_UP;
	PBs[1].bState = PB_UP;

	Dlg.focus_index = 0;

	EFs[0].pBuffer = pName;		/* write filename directly */
	EFs[0].cursor_offset = EF_SELECT_ALL;

	dlg_draw( &Dlg );

	do
	{
		ret = dlg_run( &Dlg );

	} while ( ret == EF1_tag );

	vid_move_cursor(0, 5*CHAR_YEXT);
	vid_clear_to_bot();

	if ( ret == PB1_tag )
		return(TRUE);
	else
		return(FALSE);
}

Demo_Draw_Screen()
{
	vid_clear_screen();
	ttl_set_app_version(4);

	menubar.bRedraw = MB_REDRAW;
	mb_draw( &menubar );
	menubar.bRedraw = MB_NO_REDRAW;

	ttl_put_app_name("Sound Library");
	ttl_put_data_name("DMDEMO");
}

wait1000()
{
	vid_busy_disable();
	waitloop(1000);
	vid_busy_enable();
}
