#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "stddefs.h"
#include "icon.h"
#include "xlib_all.h"
#include "yaklib.h"
#include "gadgets.h"
#include "yakpal.h"

#define QUIT 1
#define SAVE 2
#define MIRROR 3

#define gridWidth 250
#define gridHeight 200
#define nullChar 13

byte grid[gridWidth][gridHeight];
int workingWidth, workingHeight;
int xShift = 0, yShift = 0;
int bigXShift = 0, bigYShift = 0;
icon myicon;
int color = 1;

unsigned char bg = 0;

void bufferToGrid(char * buffer)
{
  int k = 4;
  for (int heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for (int widthCounter = 0; widthCounter < gridWidth; ++widthCounter)
      if ((heightCounter < workingHeight) && (widthCounter < workingWidth))
	grid[widthCounter][heightCounter] = buffer[k++];
      else
	grid[widthCounter][heightCounter] = 0;
}

void showBigGrid(void)
{
  int i, j;
  for(i=0;i<32;i++)
    for(j=0;j<32;j++)
    {
      if (grid[i+xShift][j+yShift])
	x_rect_fill(i*5+1,j*5+1,i*5+5,j*5+5,Page0_Offs,grid[i+xShift][j+yShift]);
      else
	x_rect_fill(i*5+1,j*5+1,i*5+5,j*5+5,Page0_Offs,bg);
    }

  x_rect_fill(149,174,277,240,Page0_Offs,bg);
  for (i=0; i<128; i++)
    for (j=0;j<64;j++)
    {
      if (grid[i+bigXShift][j+bigYShift])
	x_rect_fill(150+i,175+j,151+i,176+j,Page0_Offs,grid[i+bigXShift][j+bigYShift]);
    }
  x_line(149 + xShift - bigXShift, 174 + yShift - bigYShift, 182 + xShift - bigXShift, 174 + yShift - bigYShift, 8, Page0_Offs);
  x_line(149 + xShift - bigXShift, 208 + yShift - bigYShift, 182 + xShift - bigXShift, 208 + yShift - bigYShift, 8, Page0_Offs);
  x_line(149 + xShift - bigXShift, 174 + yShift - bigYShift, 149 + xShift - bigXShift, 208 + yShift - bigYShift, 8, Page0_Offs);
  x_line(182 + xShift - bigXShift, 174 + yShift - bigYShift, 182 + xShift - bigXShift, 208 + yShift - bigYShift, 8, Page0_Offs);

}

void shiftGrid(int deltaX, int deltaY)
{
  char spareGrid[gridWidth][gridHeight];
  int widthCounter, heightCounter;
  for (heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for (widthCounter = 0; widthCounter < gridWidth; ++widthCounter)
      spareGrid[widthCounter][heightCounter] =
	(((widthCounter + deltaX) < 0) || ((widthCounter + deltaX) >= gridWidth) ||
	(((heightCounter + deltaY) < 0) || ((heightCounter + deltaY) >= gridHeight))) ?
	0 :
	grid[widthCounter + deltaX][heightCounter + deltaY];
  for (heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for (widthCounter = 0; widthCounter < gridWidth; ++widthCounter)
      grid[widthCounter][heightCounter] = spareGrid[widthCounter][heightCounter];
  showBigGrid();
}

void lookRel(int deltaX, int deltaY)
{
  xShift = ((xShift + deltaX < 0) || (xShift + deltaX + 32 >= gridWidth)) ?
	   xShift : xShift + deltaX;
  yShift = ((yShift + deltaY < 0) || (yShift + deltaY + 32 >= gridHeight)) ?
	   yShift : yShift + deltaY;
  bigXShift = xShift - (xShift % 64);
  bigYShift = yShift - (yShift % 64);
  showBigGrid();

}

char * gridToBuffer(void)
{
  char * buffer;
  buffer = new char[4 + workingWidth*workingHeight];
  *(int *)&buffer[0] = (int)workingWidth;
  *(int *)&buffer[2] = (int)workingHeight;

  int k = 4;
  for (int heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for (int widthCounter = 0; widthCounter < gridWidth; ++widthCounter)
      if ((heightCounter < workingHeight) && (widthCounter < workingWidth))
	buffer[k++] = grid[widthCounter][heightCounter];
  return buffer;
}

void getNewWorkingDimensions(void)
{
  workingHeight = workingWidth = 0;
  for (int heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for (int widthCounter = 0; widthCounter < gridWidth; ++widthCounter)
      if(grid[widthCounter][heightCounter])
      {
	if (widthCounter >= workingWidth)
	  workingWidth = widthCounter + 1;
	if (heightCounter >= workingHeight)
	  workingHeight = heightCounter + 1;
      }
}

void saveThis(char * filename)
{
  getNewWorkingDimensions();
  char * myRolledBuffer = gridToBuffer();
  delete myicon.unrolledPic;
  myicon.unrolledPic = unRollBlt(myRolledBuffer, workingWidth, workingHeight);
  myicon.width = workingWidth;
  myicon.height = workingHeight;
  myicon.save(filename);
}

int gridx(int x)
{
  return x/5 + xShift;
}

int gridy(int y)
{
  return y/5 + yShift;
}

int gridScreenx(int x)
{
  return (x + xShift) * 5;
}

int gridScreeny(int y)
{
  return (y + yShift) * 5;
}

int palScreenx(int color)
{
  return (color / 16) * 10 + 200;
}

int palScreeny(int color)
{
  return (color % 16) * 10;
}

void mirrorGridRight(int column)
{
  int heightCounter, widthCounter;
  for(heightCounter = 0; heightCounter < gridHeight; ++heightCounter)
    for(widthCounter = 0; widthCounter < column; ++widthCounter)
      grid[column + (column - widthCounter - 1)][heightCounter] = grid[widthCounter][heightCounter];
  showBigGrid();
}

void selectColor(int tempcolor)
{
  x_rect_fill(palScreenx(color), palScreeny(color), palScreenx(color) + 10, palScreeny(color) + 10, Page0_Offs,0);
  x_rect_fill(palScreenx(color), palScreeny(color), palScreenx(color) + 9, palScreeny(color) + 9, Page0_Offs,color);
  color = tempcolor;
  x_rect_fill(palScreenx(color), palScreeny(color), palScreenx(color) + 10, palScreeny(color) + 10, Page0_Offs,15);
  x_rect_fill(palScreenx(color), palScreeny(color), palScreenx(color) + 9, palScreeny(color) + 9, Page0_Offs,color);
}


void main(int argc,char *argv[])
{
    int i,j;
    int ext = 0;
    int w,h;
    int x,y,v;
    char commandChar = nullChar;
    char c;

    if(argc != 2)
    {
      cout << "\nYakEdit 1.4 modified by V. Putz 6 mar 1993\n\n";
      cout << "usage:\nC:>yedit <filename>\n";
      cout << "where <filename> is a yak icon file.  Include \".yak\" extension.\n\n";
      exit(0);
    }
    x_set_mode(3,376);
    x_text_init();
    yakPalette myYakPalette("standard.ypl");
    myYakPalette.put();

    mouse.init();
    yakLib myYakLib("draw");
    gadgetList myGadgetList;
    myGadgetList.add(new gadgetNode(new button(0,20, 'Q', QUIT, "qbutton", icon::normal, &myYakLib),
                     new gadgetNode(new button(0,0, 'S', SAVE, "sbutton", icon::normal, &myYakLib),
                     new gadgetNode(new button(0,40, 'M', MIRROR, ""),NULL))));
    myicon.load(argv[1]);
    char * myRolledBuffer = rollBlt(myicon.unrolledPic, myicon.width, myicon.height);
    workingWidth = myicon.width;
    workingHeight = myicon.height;
    bufferToGrid(myRolledBuffer);
    delete(myRolledBuffer);
    mouse.hide();
    for(i=0;i<16;i++)
	for(j=0;j<16;j++)
	    x_rect_fill(200+i*10,j*10,200+i*10+9,j*10+9,Page0_Offs,i*16+j);
    showBigGrid();
    for(i=0;i<33;i++)
    {
	x_line(i*5,0,i*5,160,3,Page0_Offs);
	x_line(0,i*5,160,i*5,3,Page0_Offs);
    }
    myGadgetList.draw(300,190);
    mouse.show();
    while(ext != QUIT)
    {
	x_rect_fill(0,200,20,220,Page0_Offs,color);

	  mouse.show();
	while(!kbhit() && (mouse.buttonStatus() == 0) && (ext != QUIT))
	{
	  x_bgprintf(0,166, Page0_Offs, 20, 1, "X: %d   Y: %d   ", (int)(mouse.x()/5) + xShift, (int)(mouse.y()/5 + yShift));
	  ext = myGadgetList.status();
	  switch(ext)
	    {
	      case QUIT : break;
	      case SAVE : saveThis(argv[1]); break;
	      case MIRROR: mirrorGridRight(gridx(mouse.x())); break;
	    }
	}
	mouse.hide();
	x = mouse.x();
	y = mouse.y();
	if (kbhit())
	  commandChar = getch();
	if(x > 200 && x < 360 && y > 0 && y < 160)
	{
	    if(mouse.isPressed(yakMouse::leftButton))
	      selectColor(((x - 200)/10)*16+(y/10));
	    else if (mouse.isPressed(yakMouse::rightButton))
	    {
	      bg = ((x - 200)/10)*16+(y/10);
	      showBigGrid();
	      x_rect_fill(0,200,20,220,Page0_Offs,color);
	    }
	}
	else if(x < 160 && y < 160)
	{
	    if(mouse.isPressed(yakMouse::leftButton))
	    {
		x_rect_fill(x/5*5+1,y/5*5+1,x/5*5+5,y/5*5+5,Page0_Offs,color);
		x_rect_fill(150+x/5+xShift-bigXShift,175+y/5+yShift-bigYShift,
			    151+x/5+xShift-bigXShift,176+y/5+yShift-bigYShift,Page0_Offs,color);
		grid[gridx(x)][gridy(y)] = color;
	    }
	    else if (mouse.isPressed(yakMouse::rightButton))
	    {
		x_rect_fill(x/5*5+1,y/5*5+1,x/5*5+5,y/5*5+5,Page0_Offs,bg);
		x_rect_fill(150+x/5+xShift-bigXShift,175+y/5+yShift-bigYShift,
			    151+x/5+xShift-bigXShift,176+y/5+yShift-bigYShift,Page0_Offs,bg);
		grid[gridx(x)][gridy(y)] = 0;
	    }

	}
	if (commandChar != nullChar)
	{
	  switch (commandChar)
	  {
	    case '1' : shiftGrid(1,-1); break;
	    case '2' : shiftGrid(0,-1); break;
	    case '3' : shiftGrid(-1,-1); break;
	    case '4' : shiftGrid(1,0); break;
	    case '6' : shiftGrid(-1,0); break;
	    case '7' : shiftGrid(1,1); break;
	    case '8' : shiftGrid(0,1); break;
	    case '9' : shiftGrid(-1,1); break;
            case ' ': selectColor(grid[gridx(x)][gridy(y)]);
          }
          if (commandChar == 0)
          {
	    commandChar = getch();
            switch (commandChar)
            {
    	      case 72 : lookRel(0, -1); break;
	      case 80 : lookRel(0, 1); break;
	      case 75 : lookRel(-1,0); break;
	      case 77 : lookRel(1,0); break;
	      case 71 : lookRel(-1,-1); break;
	      case 73 : lookRel(1,-1); break;
	      case 79 : lookRel(-1,1); break;
	      case 81 : lookRel(1,1); break;
            }
	  }
	  commandChar = 13;
	}
    }

    mouse.remove();
    x_text_mode();
}

