#!/bin/bash
#MCbx 2015

#If we don't have initialized files, we have to boot
if [ ! -e "/tmp/buffer" ]; then
	source ./bootstrap.sh
fi
if [ ! -e "/tmp/title" ]; then
	source ./bootstrap.sh
fi

#Load global variables from files
BUFFER=$(cat "/tmp/buffer")
TITLE2=$(cat "/tmp/title")
TITLE=$TITLE2
export DIALOGRC=./dialog.rc

#Verify buffer existence. If not, we must bootstrap.
if [ ! -d "$BUFFER" ]; then
	source ./bootstrap.sh
fi

#Set dialog initial settings
DIALOG() {
	dialog --backtitle "$TITLE" "$@"
	#dialog "$@"
	return $?
}

#Perform menu in infinite loop
DEFITEM="1"
while :
do

#Buffer count
COUNT=$(find $BUFFER -follow -maxdepth 2 | wc -l)
COUNT=$(($COUNT-1))
TITLE=$TITLE2"                                            Buffer: $COUNT items"

#Spawn menu
DIALOG --nocancel --title "Main Menu" \
--default-item "$DEFITEM" \
--menu "Scanner control panel \nSelect operation:" \
19 40 16 \
1 "Clear buffer" \
2 "Start scanner operation" \
3 "Merge buffer" \
4 "Export to drive" \
5 "Export to FTP" \
6 "Re-acquire to buffer" \
7 "File Manager" \
8 "Turn the computer off" \
9 "Information" \
a "Additional Programs" \
0 "Exit to console" 2>/tmp/menuitem.tmp

menuitem=$(cat /tmp/menuitem.tmp)
#echo $menuitem

if [ "${menuitem}" = "0" ]; then
	clear
	echo "Run M.sh to get back to menu"
	exit
fi

if [ "${menuitem}" = "1" ]; then
	command='rm -rf $BUFFER/*'
	DIALOG --title "Deleting buffer" \
	--yesno "You want to clear buffer by executing: \n $command \n \
	Are you sure?" 7 60
	resp=$?
	if [ $resp -eq 0 ]; then
		clear
		echo "Clearing buffer..."
		eval $command
	fi
	DEFITEM="2"
fi

if [ "${menuitem}" = "2" ]; then
	if [ ! "${COUNT}" = "0" ]; then
		DIALOG --title "Non-empty buffer" \
		--yesno "Do you really want to start with non-empty buffer?" \
		7 60
		resp=$?
		if [ $resp -eq 0 ]; then
			source ./operate.sh
		fi
	else
	source ./operate.sh
	fi
	DEFITEM="3"
fi

if [ "${menuitem}" = "3" ]; then
	if [ "${COUNT}" = "0" ]; then
	DIALOG --title "Empty buffer" \
	--msgbox "Error: Buffer looks to be empty!" 7 60
	else
		source ./join.sh
		DEFITEM="4"
	fi
fi

if [ "${menuitem}" = "4" ]; then
	#Ask about folder
	Destination=$(DIALOG --stdout --title "Select/type destination" --dselect /media/ 14 48)
	if [ ! -z "$Destination" ]; then
		if [ ! -d $Destination ]; then
			mkdir $Destination
		fi
		rsync -a --info=progress2 $BUFFER/ $Destination
		echo Sync...
		sync
		echo Completed. Press Return to go to menu.
		beep
		read
	fi
	DEFITEM="1"
fi

if [ "${menuitem}" = "5" ]; then
	ftplog="anonymous"
	ftppw="email@"
	ftppat="/FTP/scan/Book"
	ftpad="192.168.1.1"
	if [ -e "./ftplog" ]; then
		ftplog=$(cat "./ftplog")
	fi
	if [ -e "./ftppw" ]; then
		ftppw=$(cat "./ftppw")
	fi
	if [ -e "./ftpad" ]; then
		ftpad=$(cat "./ftpad")
	fi
	if [ -e "./ftppat" ]; then
		ftppat=$(cat "./ftppat")
	fi
	DIALOG --title "FTP settings" --form "Enter FTP server details" \
	11 52 4 \
	"Address: " 1 1 $ftpad 1 12 33 40 \
	"User: " 2 1 $ftplog 2 12 33 40 \
	"Password: " 3 1 $ftppw 3 12 33 40 \
	"Directory: " 4 1 $ftppat 4 12 33 40 2>/tmp/form.tmp
	#Does file contain data?
	if [ -s /tmp/form.tmp ]; then
		ftpad=$(sed -n "1p" /tmp/form.tmp)
		ftplog=$(sed -n "2p" /tmp/form.tmp)
		ftppw=$(sed -n "3p" /tmp/form.tmp)
		ftppat=$(sed -n "4p" /tmp/form.tmp)
		echo $ftpad >./ftpad
		echo $ftplog >./ftplog
		echo $ftppw >./ftppw
		echo $ftppat >./ftppat
		ncftpput -R -v -m -u $ftplog -p  $ftppw $ftpad $ftppat $BUFFER/*
		echo Completed. Press Return to go to menu
		beep
		read
	fi
	DEFITEM="1"
fi

if [ "${menuitem}" = "6" ]; then
	if [ ! "${COUNT}" = "0" ]; then
		DIALOG --title "Non-empty buffer" \
		--yesno "Do you really want to start with non-empty buffer?" \
		7 60
		resp=$?
		if [ $resp -eq 0 ]; then
			CAM1=""
			CAM2=""
			source ./acquire.sh
		fi
	else
	CAM1=""
	CAM2=""
	source ./acquire.sh
	fi
	DEFITEM="3"
fi

if [ "${menuitem}" = "7" ]; then
	mc
	DEFITEM="7"
fi

if [ "${menuitem}" = "8" ]; then
	ENDING="Do you want to shut down?\n\n";
	if [ -f "./goodbye.msg" ]; then
		END2=$(cat goodbye.msg)
		ENDING=$ENDING$END2
	fi
	DIALOG --title "Going out" \
	--yesno "$ENDING" \
	20 70
	resp=$?
	if [ $resp -eq 0 ]; then
		sudo shutdown -h now
	fi
	DEFITEM="1"
fi

if [ "${menuitem}" = "9" ]; then
	INFO="LightBSC - Lightweight Book Scanner Computer\n \
	2015 MCbx, GPL       http://mcbx.netne.net\n\
	Allows to easily drive a book scanner using low-resource \
	embedded system with Linux. \
	\n\nBuffer disk usage: "
	PFREE=$(df -h $BUFFER | awk '{ print $5 " (" $4 " free)" }' | grep %)
	DIALOG --title "Information" \
	--msgbox "$INFO$PFREE" \
	15 64
	DEFITEM="1"
fi

if [ "${menuitem}" = "a" ]; then
	source ./usersoft.sh
	DEFITEM="a"
fi

done
