/*
 * $Workfile: gfx_tv.c $
 * $Revision: 4 $
 * $Date: 9/08/00 12:23p $
 *
 * Copyright (c) 1999-2000 National Semiconductor Corporation.
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of National 
 * Semiconductor Corporation. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into
 * with National Semiconductor Corporation.
 * This code is supplied as is.
 *
 * This file contains routines to program the TV encoder.  
 *
 * Routines:
 * 
 *    gfx_set_tv_enable
 *    gfx_set_tv_output
 *    gfx_set_tv_format
 *    gfx_set_tv_cc_enable
 *    gfx_set_tv_cc_data
 */

/*
 *$History: gfx_tv.c $
 * 
 * *****************  Version 4  *****************
 * User: Hari         Date: 9/08/00    Time: 12:23p
 * Updated in $/Engineering Releases/Durango/gfx
 * Added the function declarations for the focus, sc1200 and geode tv
 * functionality.
*/

/* INCLUDE SUPPORT FOR GEODE TV ENCODER, IF SPECIFIED */

#if GFX_TV_GEODE
#include "tv_geode.c"
#endif

/* INCLUDE SUPPORT FOR SC1200 TV ENCODER, IF SPECIFIED */
/*
//#if GFX_TV_SC1200		
//#include "tv_1200.c"	
//#endif					
*/
/* INCLUDE SUPPORT FOR FS451 TV ENCODER, IF SPECIFIED */

#if GFX_TV_FS451
#include "tv_fs450.c"
#endif

/* WRAPPERS IF DYNAMIC SELECTION */
/* Extra layer to call either Geode or FS451 TV encoder routines. */

#if GFX_I2C_DYNAMIC
/*-----------------------------------------------------------------------------
 * gfx_set_tv_format
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_format(int format, int resolution)
{
	int retval = -1;
#if GFX_TV_SC1400
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = sc1400_set_tv_format(format, resolution);
#endif
#if GFX_TV_SC1200	
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_format(format, resolution);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_format(format, resolution);
#endif 
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_output
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_output(int output)
{
	int retval = -1;
#if GFX_TV_SC1400
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = sc1400_set_tv_output(output);
#endif
#if GFX_TV_SC1200 
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_output(output);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_output(output);
#endif 
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_enable
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_enable(int enable)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_enable(enable);
#endif 
#if GFX_TV_SC1200	
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_enable(enable);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_enable(enable);
#endif 
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_defaults
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_defaults(int format)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_defaults(format);
#endif 
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_defaults(format);
#endif 
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_flicker_filter
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_flicker_filter(int ff)
{
	int retval = GFX_STATUS_UNSUPPORTED;
#if GFX_TV_SC1200
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_flicker_filter(ff);
#endif
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_cc_enable
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_cc_enable(int enable)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_cc_enable(enable);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_cc_enable(enable);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		return(retval);
#endif 
	return(retval);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_cc_data
 *
 * This routine writes the two specified characters to the CC data register 
 * of the TV encoder.
 *-----------------------------------------------------------------------------
 */
int gfx_set_tv_cc_data(unsigned char data1, unsigned char data2)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_cc_data(data1, data2);
#endif 
#if GFX_TV_SC1200 
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_cc_data(data1, data2);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		return(retval);
#endif 
	return(retval);
}
#if 0
/*---------------------------------------------------------------------------
 * gfx_test_tvout_odd_field
 *---------------------------------------------------------------------------
 */
int gfx_test_tvout_odd_field(void)
{
	int status = GFX_STATUS_UNSUPPORTED;
	#if GFX_VIDEO_SC1200
	if (gfx_video_type == GFX_VIDEO_TYPE_SC1200)
		status = sc1200_test_tvout_odd_field();
	#endif
	return(status);
}

/*---------------------------------------------------------------------------
 * gfx_test_tv_encoder_odd_field
 *---------------------------------------------------------------------------
 */
int gfx_test_tv_encoder_odd_field(void)
{
	int status = GFX_STATUS_UNSUPPORTED;
	#if GFX_VIDEO_SC1200
	if (gfx_video_type == GFX_VIDEO_TYPE_SC1200)
		status = sc1200_test_tv_encoder_odd_field();
	#endif
	return(status);
}
#endif

////

int gfx_get_tv_enable(unsigned int *p_on)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_tv_enable( p_on);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_tv_enable( p_on);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_tv_enable( p_on);
#endif 
	return(retval);

}


// ==========================================================================
//
//	TV standard

int gfx_get_tv_standard(unsigned long *p_standard)

{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_tv_standard( p_standard);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_tv_standard(p_standard);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_tv_standard( p_standard);
#endif 
	return(retval);
}

int gfx_get_available_tv_standards(unsigned long *p_standards)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_available_tv_standards( p_standards);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_available_tv_standards(p_standards);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_available_tv_standards( p_standards);
#endif 
	return(retval);

}

int gfx_set_tv_standard(unsigned long standard)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_standard( standard);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_standard(standard);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_standard(standard);
#endif 
	return(retval);
}

// ==========================================================================
//
//	vga mode as known by the driver

int gfx_get_tv_vga_mode(unsigned long *p_vga_mode)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_tv_vga_mode( p_vga_mode);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_tv_vga_mode(p_vga_mode);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_tv_vga_mode(p_vga_mode);
#endif 
	return(retval);
}

int gfx_get_available_tv_vga_modes(unsigned long *p_vga_modes)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_available_tv_vga_modes( p_vga_modes);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_available_tv_vga_modes(p_vga_modes);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_available_tv_vga_modes(p_vga_modes);
#endif 
	return(retval);
}

int gfx_set_tv_vga_mode(unsigned long vga_mode)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tv_vga_mode( vga_mode);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tv_vga_mode(vga_mode);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tv_vga_mode(vga_mode);
#endif 
	return(retval);
}

// ==========================================================================
//
//	tvout mode

int gfx_get_tvout_mode(unsigned long *p_tvout_mode)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_tvout_mode( p_tvout_mode);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_tvout_mode(p_tvout_mode);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_tvout_mode(p_tvout_mode);
#endif 
	return(retval);
}

int gfx_set_tvout_mode(unsigned long tvout_mode)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_tvout_mode( tvout_mode);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_tvout_mode(tvout_mode);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_tvout_mode(tvout_mode);
#endif 
	return(retval);

}

// ==========================================================================
//
//	Sharpness

int gfx_get_sharpness(int *p_sharpness)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_sharpness( p_sharpness);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_sharpness(p_sharpness);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_sharpness(p_sharpness);
#endif 
	return(retval);
}

int gfx_set_sharpness(int sharpness)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_sharpness( sharpness);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_sharpness(sharpness);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_sharpness(sharpness);
#endif 
	return(retval);

}

// ==========================================================================
//
// flicker filter control.

int gfx_get_flicker_filter(int *p_flicker)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_flicker_filter( p_flicker);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_flicker_filter(p_flicker);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_flicker_filter(p_flicker);
#endif 
	return(retval);
}

int gfx_set_flicker_filter(int flicker)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_flicker_filter( flicker);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_flicker_filter(flicker);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_flicker_filter(flicker);
#endif 
	return(retval);
}

// ==========================================================================
//
//	Overscan and Position

int gfx_get_overscan(int *p_x, int *p_y)
{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_overscan( p_x, p_y);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc12000_get_overscan(p_x, p_y);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_overscan(p_x, p_y);
#endif 
	return(retval);

}
                           
int gfx_set_overscan(int x, int y)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_overscan( x, y);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_overscan(x, y);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_overscan(x, y);
#endif 
	return(retval);
}

int gfx_get_position(int *p_x, int *p_y)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_position( p_x, p_y);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_position(p_x, p_y);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_position(p_x, p_y);
#endif 
	return(retval);
}

int gfx_set_position(int x, int y)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_position( x, y);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_position(x, y);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_position(x, y);
#endif 
	return(retval);
}
// ==========================================================================
//
//	Color, Brightness, and Contrast

int gfx_get_color(int *p_color)

{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_color(p_color);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_color(p_color);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_color(p_color);
#endif 
	return(retval);
}

int gfx_set_color(int color)
{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_color(color);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_color(color);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_color(color);
#endif 
	return(retval);
}

int gfx_get_brightness(int *p_brightness)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_brightness(p_brightness);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_brightness(p_brightness);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_brightness(p_brightness);
#endif 
	return(retval);
}

int gfx_set_brightness(int brightness)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_brightness(brightness);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_brightness(brightness);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_brightness(brightness);
#endif 
	return(retval);
}

int gfx_get_contrast(int *p_contrast)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_contrast(p_contrast);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_contrast(p_contrast);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_contrast(p_contrast);
#endif 
	return(retval);
}

int gfx_set_contrast(int contrast)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_contrast(contrast);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_contrast(contrast);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_contrast(contrast);
#endif 
	return(retval);
}

// ==========================================================================
//
//	YC filters

int gfx_get_yc_filter(unsigned int *p_yc_filter)

{
	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_yc_filter(p_yc_filter);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_yc_filter(p_yc_filter);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_yc_filter(p_yc_filter);
#endif 
	return(retval);
}

int gfx_set_yc_filter(unsigned int yc_filter)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = gfx_set_yc_filter(yc_filter);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_yc_filter(yc_filter);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_yc_filter(yc_filter);
#endif 
	return(retval);
}


int gfx_get_aps_trigger_bits(unsigned int *p_trigger_bits)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_get_aps_trigger_bits(p_trigger_bits);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_get_aps_trigger_bits(p_trigger_bits);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_get_aps_trigger_bits(p_trigger_bits);
#endif 
	return(retval);
}

int gfx_set_aps_trigger_bits(unsigned int trigger_bits)

{

	int retval = -1;
#if GFX_TV_GEODE
	if (gfx_tv_type & GFX_TV_TYPE_GEODE)
		retval = geode_set_aps_trigger_bits(trigger_bits);
#endif 
#if GFX_TV_SC1200  
	if (gfx_tv_type & GFX_TV_TYPE_SC1200)
		retval = sc1200_set_aps_trigger_bits(trigger_bits);
#endif
#if GFX_TV_FS451
	if (gfx_tv_type & GFX_TV_TYPE_FS451)
		retval = fs450_set_aps_trigger_bits(trigger_bits);
#endif 
	return(retval);
}




#endif /* GFX_TV_DYNAMIC */

/* END OF FILE */
