DECLARE SUB ConvertStrCodeToKeyStroke (STRCODE%(), KeyStroke$())
DECLARE SUB PrintResultOfKeyStroke (RKeyStroke$())
DECLARE SUB PrintResultOfScanCode (RScanCode() AS INTEGER)
DECLARE SUB PrintKeyStroke (KS$)
DECLARE SUB SetKeyStroke ()
DECLARE SUB GetKeyStroke (DP$, KS$)
DECLARE SUB PrintScanCode (DP$)
DECLARE SUB SaveKeyCode (DS$)
DECLARE SUB ClearKeyBuffer ()




REM ************* KB950 PROGRAMMING SOFTWARE V2.0 ************
REM -------------- 1995/02/23 BY CHIEN ------------------
REM ============= DECLARE VARIABLE ======================

DEFINT A-Z
REM $INCLUDE: 'KB950.INI'

ASMBYTE = 70
DIM ASMPROG(1 TO ASMBYTE + 5) AS STRING * 1
DIM CCODE1(300), CCODE2(200), KEYCODE(200), keyflag(200)
DIM KEYMAP(200) AS INTEGER
DIM STRCODE(128, 70) AS INTEGER
DIM KeyStroke(128, 30) AS STRING
DIM TmpStrCode(128) AS INTEGER
DIM TmpKeyStroke(30) AS STRING
DIM MAP1(20) AS INTEGER
DIM TN AS SINGLE
DIM KEYMAKE(140, 5) AS INTEGER, KEYBREAK(140, 7) AS INTEGER
DIM inreg AS RegTypeX, outreg AS RegTypeX
DIM SHARED ScanToStroke$(1 TO 128, 0 TO 1)
REM ============= ASSEMBLY SOURCE CODE ==================

SetKeyStroke

Xmit8042:

  DATA &H55
  DATA &H8B  ,&HEC
  DATA &H8B  ,&H5E  ,&H06
  DATA &H8B  ,&H07
  DATA &H50
  DATA &H29  ,&HC9
  DATA &HE4  ,&H64
  DATA &HA8  ,&H02
  DATA &H74  ,&H05
  DATA &HE2  ,&HF8
  DATA &H58
  DATA &HEB  ,&H2B
  DATA &H58
  DATA &HFA
  DATA &HE6  ,&H60
  DATA &H29  ,&HC9
  DATA &HE4  ,&H64
  DATA &HA8  ,&H01

  DATA &H74  ,&H04
  DATA &HE2  ,&HF8
  DATA &HEB  ,&H1B
  DATA &H29  ,&HC9
  DATA &HB3  ,&H06
  DATA &HE4  ,&H64
  DATA &HA8  ,&H01
  DATA &H75  ,&H08
  DATA &HE2  ,&HF8
  DATA &HFE  ,&HCB
  DATA &H75  ,&HF4
  DATA &HEB  ,&H09
  DATA &HE4  ,&H60
  DATA &HB4  ,&H00
  DATA &H8B  ,&H5E  ,&H06
  DATA &H89  ,&H07
  DATA &H5D
  DATA &HFB
  DATA &HCA  ,&H02 ,&H00

REM *** COMPUTER KEYBOARD SCAN CODES MAP TO KEY CODE ***

KEYMAP(1) = &H76: KEYMAP(2) = &H16
KEYMAP(3) = &H1E: KEYMAP(4) = &H26
KEYMAP(5) = &H25: KEYMAP(6) = &H2E
KEYMAP(7) = &H36: KEYMAP(8) = &H3D
KEYMAP(9) = &H3E: KEYMAP(&HA) = &H46
KEYMAP(&HB) = &H45: KEYMAP(&HC) = &H4E
KEYMAP(&HD) = &H55: KEYMAP(&HE) = &H66
KEYMAP(&HF) = &HD: KEYMAP(&H10) = &H15
KEYMAP(&H11) = &H1D: KEYMAP(&H12) = &H24
KEYMAP(&H13) = &H2D: KEYMAP(&H14) = &H2C
KEYMAP(&H15) = &H35: KEYMAP(&H16) = &H3C
KEYMAP(&H17) = &H43: KEYMAP(&H18) = &H44
KEYMAP(&H19) = &H4D: KEYMAP(&H1A) = &H54
KEYMAP(&H1B) = &H5B: KEYMAP(&H1C) = &H5A
KEYMAP(&H1D) = &H14: KEYMAP(&H1E) = &H1C
KEYMAP(&H1F) = &H1B: KEYMAP(&H20) = &H23
KEYMAP(&H21) = &H2B: KEYMAP(&H22) = &H34
KEYMAP(&H23) = &H33: KEYMAP(&H24) = &H3B
KEYMAP(&H25) = &H42: KEYMAP(&H26) = &H4B
KEYMAP(&H27) = &H4C: KEYMAP(&H28) = &H52
KEYMAP(&H29) = &HE: KEYMAP(&H2A) = &H12
KEYMAP(&H2B) = &H5D: KEYMAP(&H2C) = &H1A
KEYMAP(&H2D) = &H22: KEYMAP(&H2E) = &H21
KEYMAP(&H2F) = &H2A: KEYMAP(&H30) = &H32
KEYMAP(&H31) = &H31: KEYMAP(&H32) = &H3A
KEYMAP(&H33) = &H41: KEYMAP(&H34) = &H49
KEYMAP(&H35) = &H4A: KEYMAP(&H36) = &H12
KEYMAP(&H37) = &H37: KEYMAP(&H38) = &H11
KEYMAP(&H39) = &H29: KEYMAP(&H3A) = &H58
KEYMAP(&H3B) = &H5: KEYMAP(&H3C) = &H6
KEYMAP(&H3D) = &H4: KEYMAP(&H3E) = &HC
KEYMAP(&H3F) = &H3: KEYMAP(&H40) = &HB
KEYMAP(&H41) = &H2: KEYMAP(&H42) = &HA
KEYMAP(&H43) = &H1: KEYMAP(&H44) = &H9
KEYMAP(&H45) = &H77: KEYMAP(&H46) = &H7E
KEYMAP(&H47) = &H6C: KEYMAP(&H48) = &H75
KEYMAP(&H49) = &H7D: KEYMAP(&H4A) = &H7B
KEYMAP(&H4B) = &H6B: KEYMAP(&H4C) = &H73
KEYMAP(&H4D) = &H74: KEYMAP(&H4E) = &H79
KEYMAP(&H4F) = &H69: KEYMAP(&H50) = &H72
KEYMAP(&H51) = &H7A: KEYMAP(&H52) = &H70
KEYMAP(&H53) = &H71
KEYMAP(&H57) = &H78: KEYMAP(&H58) = &H7

MAP1(0) = &H13
MAP1(1) = &H12
MAP1(2) = 0
MAP1(3) = 0
MAP1(4) = 0
MAP1(5) = 0
MAP1(6) = 0
MAP1(7) = 0
MAP1(8) = &H14
MAP1(9) = &H11
MAP1(10) = &H17
MAP1(11) = &H10
MAP1(12) = &H7E
MAP1(13) = &H77
MAP1(14) = &H58
MAP1(15) = &H70

CONST KOVER = &HF7

 UpiStat = &H64
 UpiData = &H60

 NO = 0
 YES = 1

 PRESS = 0
 RELEASE = 1

 STARTSEG = SADD(STARTLBL$)

REM LOAD MAKE/BREAK CODE FILE

OPEN "MAKE.DAT" FOR INPUT AS #1
FOR YY1 = 0 TO 126
  FOR YY2 = 1 TO 4
   IF EOF(1) THEN

     BEEP: CLS
     LOCATE 1, 1: PRINT "LOAD MAKE.DAT FILE FAILURE."
     CLOSE
     END
   END IF

   INPUT #1, KK$
    KEYMAKE(YY1, YY2) = VAL(KK$)
   NEXT
 NEXT
 CLOSE #1

OPEN "BREAK.DAT" FOR INPUT AS #1
FOR YY1 = O TO 126
  FOR YY2 = 1 TO 6
   IF EOF(1) THEN
     BEEP: CLS
     LOCATE 1, 1: PRINT "LOAD BREAK.DAT FILE FAILURE."
     CLOSE
     END
   END IF

   INPUT #1, KK$
   KEYBREAK(YY1, YY2) = VAL(KK$)

   NEXT
  NEXT
 CLOSE #1

PTR = VARPTR(ASMPROG(1))
DEF SEG = VARSEG(ASMPROG(1))
RESTORE Xmit8042
FOR i = 0 TO (ASMBYTE - 1)
 READ j
 POKE (PTR + i), j
NEXT i

FOR DD1 = 1 TO 128
   STRCODE(DD1, 0) = 0
   STRCODE(DD1, 1) = KOVER
   NEXT


KEY 1, CHR$(&HAB):          ' DEFINE F1-F5 'S ASCII CODE
KEY 2, CHR$(&HAC)
KEY 3, CHR$(&HAD)
KEY 4, CHR$(&HAE)
KEY 5, CHR$(&HAF)
KEY 6, CHR$(&HB0)
KEY 7, CHR$(&HB1)
KEY 8, CHR$(&HB2)
KEY 9, CHR$(&HB3)
KEY 10, CHR$(&HB4)          ' F10
KEY 30, CHR$(&HB5):         ' F11
KEY 31, CHR$(&HB6)          ' F12

DO
GOSUB MainScreen
LOCATE 1, 1, 0
A$ = INPUT$(1)
SELECT CASE A$

  CASE "1"
     GOSUB ProgKey

  CASE "2"
     GOSUB KeyConfig

  CASE "3"
     GOSUB MsrConfig

  CASE "4"
     GOSUB Kb950Test


  CASE "5"
     CLS
     LOCATE 1, 1, 0
     PRINT "EXIT KB950 PROGRAM ENVIRONMENT."
     END

  CASE ELSE
   BEEP


END SELECT
LOOP WHILE (1)

END
REM ==================  MAIN SCREEN  ====================================

MainScreen:
CLS
LOCATE 4, 20: PRINT "  KB950-02 SERIES 84-KEY P.O.S. KEYBOARD"
LOCATE 5, 20: PRINT "       STRING PROGRAMMING SOFTWARE"
LOCATE 6, 20: PRINT "        VERSION 1.3  GIGA-TMS INC."
LOCATE 10, 23: PRINT "[1]  PROGRAMMING KEY-CODE"
LOCATE 12, 23: PRINT "[2]  P.O.S. KEYBOARD CONFIGURATION "
LOCATE 14, 23: PRINT "[3]  MAGNETIC STRIPE READER CONFIGURATION"
'LOCATE 14, 20: PRINT "[4]  DSP800 DEMOSTRATION"
LOCATE 16, 23: PRINT "[4]  TEST KB950"
LOCATE 18, 23: PRINT "[5]  QUIT"
LOCATE 1, 1, 0
RETURN

REM ********************************************************************

MsrConfig:
DO
CLS
LOCATE 7, 20: PRINT "***** MAGNETIC STRIPE READER CONFIGURATION *****"
LOCATE 10, 25: PRINT "[1]  MSR ADD SS/ES"
LOCATE 12, 25: PRINT "[2]  MSR ADD CARRIAGE RETURN (CR)"
LOCATE 14, 25: PRINT "[3]  SET KEYBOARD TYPE"
LOCATE 16, 25: PRINT "[4]  BACK TO MAIN MENU"
LOCATE 1, 1, 0
A$ = INPUT$(1)
SELECT CASE A$

  CASE "1"
   RUNFG = 0
   DO
    LOCATE 18, 40
    INPUT "MSR ADD SS/ES (1)ON or (2)OFF : ", X
   LOOP WHILE (X <> 1 AND X <> 2)
       MXD = &HF1
       GOSUB SENDDATA

        IF X = 1 THEN
          MXD = &H0
        ELSE
          MXD = &H1
        END IF
        GOSUB SENDDATA

       MXD = &H4
       GOSUB SENDDATA

       MXD = &H0
       GOSUB SENDDATA


        MXD = &HF4
        GOSUB SENDDATA

       LOCATE 25, 60
       IF RUNFG = 0 THEN
        PRINT "STATUS: SET OK      ";
       ELSE
        PRINT "STATUS: SET FAIL    ";
       END IF

     LOCATE 25, 30: PRINT "<Press any key to continue>";
        A$ = INPUT$(1)



  CASE "2"
  RUNFG = 0
  DO
    LOCATE 18, 40
    INPUT "MSR ADD CR (1)ON or (2)OFF : ", X
  LOOP WHILE (X <> 1 AND X <> 2)

       MXD = &HF1
       GOSUB SENDDATA

        IF X = 1 THEN
          MXD = &H0
        ELSE
          MXD = &H1
        END IF
        GOSUB SENDDATA

       MXD = 5
       GOSUB SENDDATA

       MXD = 0
       GOSUB SENDDATA

        MXD = &HF4
        GOSUB SENDDATA


       LOCATE 25, 60
       IF RUNFG = 0 THEN
        PRINT "STATUS: SET OK      ";
       ELSE
        PRINT "STATUS: SET FAIL    ";
       END IF

     LOCATE 25, 30: PRINT "<Press any key to continue>";
        A$ = INPUT$(1)

  CASE "3"
      GOSUB RdCountryCode

REM  SET COUNTRY CODE TO SPEC. ITEM
        RUNFG = 0
        MXD = &HF1
        GOSUB SENDDATA

        MXD = COUNC
        GOSUB SENDDATA

        MXD = 1
        GOSUB SENDDATA

        MXD = 0
        GOSUB SENDDATA

        MXD = &HF4
        GOSUB SENDDATA

      FOR i = 0 TO 255 STEP 2

        LOCATE 23, 10
        PRINT "LOCATE CODE : "; HEX$(INT(i / 2)),
        PRINT "ATTR : "; HEX$(CCODE1(i)),
        PRINT "CODE : "; HEX$(CCODE1(i + 1))


        MXD = &HF1
        GOSUB SENDDATA

        MXD = CCODE1(i)
        GOSUB SENDDATA

        MXD = i MOD 64
        GOSUB SENDDATA

        MXD = INT(i / 64) + 4: REM PAGE 04-07
        GOSUB SENDDATA

        MXD = CCODE1(i + 1)
        GOSUB SENDDATA

        MXD = (i + 1) MOD 64
        GOSUB SENDDATA

        MXD = INT((i + 1) / 64) + 4
        GOSUB SENDDATA

        MXD = &HF4
        GOSUB SENDDATA

        LOCATE 25, 60: PRINT "STATUS:";
        IF RUNFG = 1 THEN
          PRINT "PROGRAM FAIL";
          BEEP: BEEP: BEEP
          GOTO LOOP2
        END IF
     NEXT

        LOCATE 25, 60: PRINT "STATUS:";
        PRINT "PROGRAM OK  ";
        BEEP
LOOP2:
        RUNFG = 0

     LOCATE 25, 30: PRINT "<Press any key to continue>";
     A$ = INPUT$(1)

  CASE "4"
  RETURN

  CASE ELSE
   BEEP
   RETURN

END SELECT
LOOP WHILE (1)


RdCountryCode:
DO
  LOCATE 20, 20: INPUT "[1] U.S [2] GERMAN [3] FRENCH [4] SPANISH: ", X
LOOP WHILE ((X < 1) OR (X > 4))

'    00 : for US
'    01 :     UK
'    02 :     IT
'    03 :     SP
'
'    10 : for GR
'    11 :     FR
'
  SELECT CASE X

    CASE 1
     COUNC = 0
     OPEN "KB950-US.COD" FOR INPUT AS #1
     LOCATE 21, 20: PRINT "OPEN KB950-US.COD LOAD TO KB950"

  CASE 2
    COUNC = &H10
     OPEN "KB950-GR.COD" FOR INPUT AS #1
     LOCATE 21, 20: PRINT "OPEN KB950-GR.COD LOAD TO KB950"

  CASE 3
    COUNC = &H11
     OPEN "KB950-FR.COD" FOR INPUT AS #1
     LOCATE 21, 20: PRINT "OPEN KB950-FR.COD LOAD TO KB950"

  CASE 4
    COUNC = &H3
     OPEN "KB950-SP.COD" FOR INPUT AS #1
     LOCATE 21, 20: PRINT "OPEN KB950-SP.COD LOAD TO KB950"

  CASE ELSE
     GOTO RdCountryCode

  END SELECT


  FOR bb = 0 TO 255 STEP 2

   INPUT #1, CCODE1(bb), CCODE1(bb + 1)
   NEXT
   CLOSE #1
   RETURN

RdCountryCode1:
  X = 1
  SELECT CASE X

    CASE 1
     COUNC = 0
     OPEN "KB950-US.COD" FOR INPUT AS #1

  CASE 2
    COUNC = &H10
     OPEN "KB950-GR.COD" FOR INPUT AS #1

  CASE ELSE
     GOTO RdCountryCode1

  END SELECT


  FOR bb = 0 TO 255 STEP 2

   INPUT #1, CCODE1(bb), CCODE1(bb + 1)
   NEXT
   CLOSE #1
   RETURN


REM *****************************************************************

KeyConfig:
DO
CLS
LOCATE 7, 20: PRINT "***** KEY CONFIGURATION *****"
LOCATE 10, 25: PRINT "[1]  KEY BUZZER SWITCH"
LOCATE 12, 25: PRINT "[2]  SET DELAY TIME"
LOCATE 14, 25: PRINT "[3]  BACK TO MAIN MENU"

A$ = INPUT$(1)
SELECT CASE A$

  CASE "1"
    GOSUB KCBUZZER

  CASE "2"
   RUNFG = 0
   DO
    LOCATE 18, 40
    PRINT "                                ";
    LOCATE 18, 40
    INPUT "DELAY FACTOR 0-63 (*0.2ms) :", X
   LOOP WHILE (X < 0 OR X > 63)
       MXD = &HF1
       GOSUB SENDDATA

       MXD = X
        GOSUB SENDDATA

       MXD = &H3
       GOSUB SENDDATA

       MXD = &H0
       GOSUB SENDDATA

       MXD = &HF4
       GOSUB SENDDATA


       LOCATE 25, 60
       IF RUNFG = 0 THEN
        PRINT "STATUS: SET OK      ";
       ELSE
        PRINT "STATUS: SET FAIL    ";
       END IF

     LOCATE 25, 30: PRINT "<Press any key to continue>";
        A$ = INPUT$(1)

  CASE "3"
   RETURN
  CASE ELSE
   BEEP
   RETURN


END SELECT

LOOP WHILE (1)

KCBUZZER:
  RUNFG = 0
  DO
    LOCATE 18, 35
    INPUT "KEY BUZZER (1)ON or (2)OFF :", X
  LOOP WHILE (X <> 1 AND X <> 2)
       MXD = &HF1
       GOSUB SENDDATA

        IF X = 1 THEN
          MXD = 0
        ELSE
          MXD = &H1
        END IF
        GOSUB SENDDATA

       MXD = 2
       GOSUB SENDDATA

       MXD = 0
       GOSUB SENDDATA

       MXD = &HF4
       GOSUB SENDDATA

       LOCATE 25, 60
       IF RUNFG = 0 THEN
        PRINT "STATUS: SET OK      ";
       ELSE
        PRINT "STATUS: SET FAIL    ";
       END IF

     LOCATE 25, 30: PRINT "<Press any key to continue>";
        A$ = INPUT$(1)
        RETURN




REM ********************************************************************

ProgKey:
CLS
GOSUB EDITUSER
RETURN


SHOWKEY:
CLS
OPEN "KB950a.FRM" FOR INPUT AS #3
FOR i = 1 TO 16
 LINE INPUT #3, SA$
 LOCATE i, 1: PRINT SA$;
NEXT
CLOSE #3
LOCATE 24, 1: PRINT "[F11] START [F12] END [ENTER] SET [UP/DOWN] SELECT KEY {Message} ";
RETURN

FOR i = 0 TO 11
 FOR j = 0 TO 6
  IF KEYCODE(i * 7 + j) <> &H60 THEN
    LOCATE 6 + 2 * j, 43 + 3 * i
    p$ = HEX$(KEYCODE(i * 7 + j))
    PRINT STRING$(2 - LEN(p$), "0"); p$
  ELSE
    LOCATE 6 + 2 * j, 43 + 3 * i
    PRINT "  ";

  END IF
 NEXT
NEXT
LOCATE 24, 1: PRINT "[F11] START PROG [F12] END PROG [UP DOWN LEFT RIGHT] SELECT KEY  {Message} ";

RETURN

FlashKey:

FOR i = 0 TO 11
 FOR j = 0 TO 6
  IF KEYCODE(i * 7 + j) <> &H60 THEN
   LOCATE 6 + 2 * j, 43 + 3 * i
   p$ = HEX$(KEYCODE(i * 7 + j))
   PRINT STRING$(2 - LEN(p$), "0"); p$
 ELSE
   LOCATE 6 + 2 * j, 43 + 3 * i
   PRINT "  ";
  END IF
 NEXT
NEXT

RETURN


ShowTest:

FOR i = 0 TO 11
 FOR j = 0 TO 6
  IF KEYCODE(i * 7 + j) <> &H60 THEN
   LOCATE 6 + 2 * j, 43 + 3 * i
   p$ = HEX$(KEYCODE(i * 7 + j))

   IF keyflag(i * 7 + j) <> 0 THEN
     cpx = (keyflag(i * 7 + j) MOD 8)
     IF cpx = 0 THEN cpx = 1
     COLOR 0, cpx
   END IF
   PRINT STRING$(2 - LEN(p$), "0"); p$
   COLOR 7, 0

  END IF
 NEXT
NEXT

RETURN


REM **************************************************************

SENDDATA:
    ERRN = 0
SENDDATAX:
    BVD% = MXD
    CALL ABSOLUTE(BVD%, VARPTR(ASMPROG(1)))

   FOR VV = 1 TO 1000: NEXT
   LOCATE 25, 60: PRINT "STATUS:";
   SELECT CASE BVD%

      CASE &HFA
        PRINT "Linking       ";
        ERRN = 0
      CASE ELSE
        IF ERRN > 5 THEN
          RUNFG = 1
          PRINT "No Responce  ";
          RETURN
        ELSE
         ERRN = ERRN + 1
         PRINT "Resend       ";
         GOTO SENDDATAX
        END IF

    END SELECT

    RETURN

SENDDATA1:
    ERRN = 0
SENDDATA1X:
    BVD% = MXD
    LOCATE 24, 50: PRINT "OUT :"; HEX$(BVD%)
    CALL ABSOLUTE(BVD%, VARPTR(ASMPROG(1)))

   FOR VV = 1 TO 1000: NEXT
    SELECT CASE BVD%
      CASE &HFA
        ERRN = 0
      CASE ELSE
        IF ERRN > 5 THEN
          RUNFG = 1
          RETURN
        ELSE
         ERRN = ERRN + 1
         GOTO SENDDATA1X
        END IF

    END SELECT
    RETURN




KPPROG:

  OUT &H64, &HD1: REM READ KBC'S OUTPUT
  WHILE (INP(&H64) AND &H2) = &H2
  WEND

       LOCATE 24, 65: PRINT "PROGRAMMING     ";
      RUNFG = 0
      FOR II1 = 1 TO 84
       IF STRCODE(II1, 0) > 64 THEN
         STRCODE(II1, 0) = 64
         LK = 64
       END IF
       IF STRCODE(II1, 0) < 64 THEN
         STRCODE(II1, STRCODE(II1, 0) + 1) = KOVER
         LK = STRCODE(II1, 0) + 1
       END IF

       FOR II2 = 1 TO LK

        LOCATE 23, 1
            PRINT "NOW PROGRAM KEY NO. :"; II1,
     REM    PRINT "CODE :"; HEX$(STRCODE(II1, II2)); "  ";
     REM    PRINT HEX$(II2 - 1); "  "; HEX$(II1 + 7);

        MXD = &HF1
        GOSUB SENDDATA

        MXD = STRCODE(II1, II2):    REM DATA CODE
        GOSUB SENDDATA

        MXD = II2 - 1: REM SEQUENCE NO.
        GOSUB SENDDATA

        MXD = II1 + 7: REM PAGE NO 08-7F
                       REM FIRST CODE IS 08
        GOSUB SENDDATA

     MXD = &HF4
    GOSUB SENDDATA
    NEXT
        IF RUNFG = 1 THEN
          LOCATE 24, 65
          PRINT "PROGRAM FAIL   ";
          BEEP: BEEP: BEEP
          GOTO KPLOOP1
        END IF
     NEXT

        LOCATE 24, 65
        PRINT "PROGRAM OK    ";
        BEEP
        RUNFG = 0
KPLOOP1:
        LOCATE 25, 25: PRINT "<Press any key to continue>";
         A$ = INPUT$(1)
        RETURN

KPPROG1:

  OUT &H64, &HD1: REM READ KBC'S OUTPUT
  WHILE (INP(&H64) AND &H2) = &H2
  WEND

       LOCATE 24, 65: PRINT "PROGRAMMING     ";
      RUNFG = 0


      FOR II1 = LCC + 1 TO LCC + 1
       IF STRCODE(II1, 0) > 64 THEN
         STRCODE(II1, 0) = 64
         LK = 64
       END IF
       IF STRCODE(II1, 0) < 64 THEN
         STRCODE(II1, STRCODE(II1, 0) + 1) = KOVER
         LK = STRCODE(II1, 0) + 1
       END IF

      FOR II2 = 1 TO LK
        LOCATE 23, 1
            PRINT "NOW PROGRAM KEY NO. :"; II1,
     REM    PRINT "CODE :"; HEX$(STRCODE(II1, II2)); "  ";
     REM    PRINT HEX$(II2 - 1); "  "; HEX$(II1 + 7);

        MXD = &HF1
        GOSUB SENDDATA

        MXD = STRCODE(II1, II2):    REM DATA CODE
        GOSUB SENDDATA

        MXD = II2 - 1: REM SEQUENCE NO.
        GOSUB SENDDATA

        MXD = II1 + 7: REM PAGE NO 08-7F
                       REM FIRST CODE IS 08
        GOSUB SENDDATA

     MXD = &HF4
    GOSUB SENDDATA
    NEXT
        IF RUNFG = 1 THEN
          LOCATE 24, 65
          PRINT "PROGRAM FAIL   ";
          BEEP: BEEP: BEEP
          GOTO KPLOOP2
        END IF
   NEXT

        LOCATE 24, 65
        PRINT "PROGRAM KEY OK";
      BEEP
        RUNFG = 0
KPLOOP2:
        LOCATE 25, 25: PRINT "<Press any key to continue>";
         A$ = INPUT$(1)
       RETURN


CLEARKEY:
      FOR i = 0 TO 65
        STRCODE((LCC + 1), i) = 0
      NEXT
    RETURN


EDITUSER:
      CLOSE #1
      GOSUB SHOWKEY
      LCC = 0
      PLCC = 0

  OUT &H64, &HD0: REM READ KBC'S OUTPUT
  WHILE (INP(&H64) AND &H2) = &H2
  WEND

  ClearKeyBuffer

     WHILE (1)
      GOSUB SHOWLOC
      DO
       X$ = INKEY$
      LOOP WHILE (LEN(X$) = 0)

       SELECT CASE X$

        CASE CHR$(13)

KeyIn:

         VIEW PRINT 19 TO 22
         CLS 2
         VIEW PRINT 1 TO 25

         LOCATE 19, 2
         PRINT "Set To : [1] Function Key F11"
         LOCATE 20, 2
         PRINT "         [2] Function Key F12 "
         LOCATE 21, 2
         PRINT "         [3] ALT + F11"
                                   
         LOCATE 19, 35
         PRINT "[4] ALT + F12"
         LOCATE 20, 35
         PRINT "[5] CTRL + F11"
         LOCATE 21, 35
         PRINT "[6] CTRL + F12"

         LOCATE 22, 12
         PRINT "Select :";
           ANS$ = INPUT$(1)
         SELECT CASE ANS$

         CASE "1"
             GOSUB CLEARKEY

             STRCODE(LCC + 1, 0) = 3
             STRCODE(LCC + 1, 1) = &H78
             STRCODE(LCC + 1, 2) = &HF0
             STRCODE(LCC + 1, 3) = &H78
             KeyStroke$(LCC + 1, 0) = "1"
             KeyStroke$(LCC + 1, 1) = "<F11>"

         CASE "2"

             GOSUB CLEARKEY

             STRCODE(LCC + 1, 0) = 3
             STRCODE(LCC + 1, 1) = &H7
             STRCODE(LCC + 1, 2) = &HF0
             STRCODE(LCC + 1, 3) = &H7
             KeyStroke$(LCC + 1, 0) = "1"
             KeyStroke$(LCC + 1, 1) = "<F12>"


         CASE "3"
             GOSUB CLEARKEY
             STRCODE(LCC + 1, 0) = 6
             STRCODE(LCC + 1, 1) = &H11
             STRCODE(LCC + 1, 2) = &H78
             STRCODE(LCC + 1, 3) = &HF0
             STRCODE(LCC + 1, 4) = &H78
             STRCODE(LCC + 1, 5) = &HF0
             STRCODE(LCC + 1, 6) = &H11
             KeyStroke$(LCC + 1, 0) = "2"
             KeyStroke$(LCC + 1, 1) = "<Alt>"
             KeyStroke$(LCC + 1, 2) = "<F11>"



         CASE "4"
             GOSUB CLEARKEY
             STRCODE(LCC + 1, 0) = 6
             STRCODE(LCC + 1, 1) = &H11
             STRCODE(LCC + 1, 2) = &H7
             STRCODE(LCC + 1, 3) = &HF0
             STRCODE(LCC + 1, 4) = &H7
             STRCODE(LCC + 1, 5) = &HF0
             STRCODE(LCC + 1, 6) = &H11
             KeyStroke$(LCC + 1, 0) = "2"
             KeyStroke$(LCC + 1, 1) = "<Alt>"
             KeyStroke$(LCC + 1, 2) = "<F12>"

         CASE "5"
             GOSUB CLEARKEY
             STRCODE(LCC + 1, 0) = 6
             STRCODE(LCC + 1, 1) = &H14
             STRCODE(LCC + 1, 2) = &H78
             STRCODE(LCC + 1, 3) = &HF0
             STRCODE(LCC + 1, 4) = &H78
             STRCODE(LCC + 1, 5) = &HF0
             STRCODE(LCC + 1, 6) = &H14
             KeyStroke$(LCC + 1, 0) = "2"
             KeyStroke$(LCC + 1, 1) = "<Ctrl>"
             KeyStroke$(LCC + 1, 2) = "<F11>"


         CASE "6"
             GOSUB CLEARKEY
             STRCODE(LCC + 1, 0) = 6
             STRCODE(LCC + 1, 1) = &H14
             STRCODE(LCC + 1, 2) = &H7
             STRCODE(LCC + 1, 3) = &HF0
             STRCODE(LCC + 1, 4) = &H7
             STRCODE(LCC + 1, 5) = &HF0
             STRCODE(LCC + 1, 6) = &H14
             KeyStroke$(LCC + 1, 0) = "2"
             KeyStroke$(LCC + 1, 1) = "<Ctrl>"
             KeyStroke$(LCC + 1, 2) = "<F12>"

         CASE CHR$(27)
              GOTO NODO1

         CASE ELSE
             GOTO KeyIn
       END SELECT












NODO1:
         GOSUB SHOWLOC

        CASE CHR$(&HB5): REM PRESS [F11]

          GOSUB STRPROG
          GOSUB SHOWKEY
          GOSUB SHOWLOC

          LOCATE 24, 65: PRINT "EDIT OK         ";

        CASE CHR$(0) + CHR$(&H48): REM UP
           PLCC = LCC
           LCC = LCC - 1
           IF LCC < 0 THEN
              BEEP
              LCC = 0
              LOCATE 24, 65: PRINT "OUT OF RANGE   ";

           ELSE
              LOCATE 24, 65: PRINT "SELECT KEY     ";

           END IF
           GOSUB SHOWLOC

        CASE CHR$(0) + CHR$(&H50): REM down
           PLCC = LCC
           LCC = LCC + 1
           IF LCC > 83 THEN
              BEEP
              LOCATE 24, 65: PRINT "OUT OF RANGE   ";
              LCC = 83
           ELSE
              LOCATE 24, 65: PRINT "SELECT KEY     ";
           END IF
           GOSUB SHOWLOC

        CASE CHR$(0) + CHR$(&H4B): REM LEFT
            PLCC = LCC
            LCC = LCC - 7
            IF LCC < 0 THEN
              LOCATE 24, 65: PRINT "OUT OF RANGE   ";
              LCC = LCC + 7
              BEEP
           ELSE
              LOCATE 24, 65: PRINT "SELECT KEY     ";
           END IF
            GOSUB SHOWLOC

        CASE CHR$(0) + CHR$(&H4D): REM RIGHT
            PLCC = LCC
            LCC = LCC + 7
            IF LCC > 83 THEN
              BEEP
              LOCATE 24, 65: PRINT "OUT OF RANGE   ";
              LCC = LCC - 7
           ELSE
              LOCATE 24, 65: PRINT "SELECT KEY     ";

             END IF
            GOSUB SHOWLOC

        CASE CHR$(&HAB): REM LOAD DEFAULT
           

           CLOSE #1
           OPEN "KB950.KEY" FOR BINARY AS #1 LEN = 1
             FOR MN = 1 TO 84
              FOR MN1 = 0 TO 64

               IF EOF(1) THEN
                 BEEP: CLS
                 LOCATE 1, 1: PRINT "LOAD "; FFF$; " FILE FAILURE."
                 CLOSE
                 END
               END IF
               STRCODE(MN, MN1) = ASC(INPUT$(1, #1))
              NEXT
             NEXT
           CLOSE #1

          
          
         FOR KeyIndex = 1 TO 87
            TmpDefaultStrCode$ = HEX$(STRCODE(KeyIndex, 1))
            CALL GetKeyStroke(TmpDefaultStrCode$, TmpDefaultKeyStroke$)
            KeyStroke$(KeyIndex, 1) = TmpDefaultKeyStroke$
            KeyStroke$(KeyIndex, 0) = "1"
         NEXT KeyIndex

            KeyStroke$(28, 0) = "2"
            KeyStroke$(28, 2) = "0"
            'KeyStroke$(33, 0) = "1"
            'KeyStroke$(33, 1) = "5"

            STRCODE(71, 0) = 3
            STRCODE(71, 1) = &H78
            STRCODE(71, 2) = &HF0
            STRCODE(71, 3) = &H78
            KeyStroke$(71, 0) = "1"
            KeyStroke$(71, 1) = "<F11>"

            STRCODE(78, 0) = 3
            STRCODE(78, 1) = &H7
            STRCODE(78, 2) = &HF0
            STRCODE(78, 3) = &H7
            KeyStroke$(78, 0) = "1"
            KeyStroke$(78, 1) = "<F12>"


            GOSUB SHOWKEY
            GOSUB SHOWLOC
            LOCATE 24, 65: PRINT "LOAD OK         ";


        CASE CHR$(&HAC): REM LOAD USER KEY
           CLOSE #1

          LOCATE 23, 1
          INPUT "KEYIN KEYCODE FILENAME [KB950-U.KEY] : ", FFF$
          IF FFF$ = "" THEN
            FFF$ = "KB950-U.KEY"
            LOCATE 23, 40: PRINT FFF$
          END IF

           OPEN FFF$ FOR BINARY AS #1 LEN = 1
            IF LOF(1) = 0 THEN
               CLOSE #1
               GOSUB SHOWKEY
               GOSUB SHOWLOC
               LOCATE 24, 65: PRINT "FILE NOT FOUND";
             ELSE
              FOR MN = 1 TO 84
               FOR MN1 = 0 TO 64
                IF EOF(1) THEN
                  BEEP: CLS
                  LOCATE 1, 1: PRINT "LOAD "; FFF$; " FILE FAILURE."
                  CLOSE
                  END
                 END IF
                STRCODE(MN, MN1) = ASC(INPUT$(1, #1))
              NEXT
             NEXT
           CLOSE #1

           GOSUB SHOWKEY
           GOSUB SHOWLOC

           CALL ConvertStrCodeToKeyStroke(STRCODE(), KeyStroke$())

           LOCATE 24, 65: PRINT "LOAD OK         ";
          END IF
        CASE CHR$(&HAE): REM CLEAR KEY

           LOCATE 24, 65: PRINT "CLEAR          ";

           GOSUB SHOWKEY
           GOSUB SHOWLOC
           FOR KL = 1 TO 4
            LOCATE 18 + KL, 1: PRINT STRING$(80, " ");
           NEXT
           LOCATE 21, 1: PRINT "[1] CLEAR ALL MAP."
           LOCATE 22, 1: PRINT "[2] CLEAR SPECIFIC KEY.";
           LOCATE 23, 1, 1: PRINT "[3] ABORT TO CLEAR KEY.  SELECT:";

            X$ = INPUT$(1)
            SELECT CASE X$
             CASE "1"
               GOSUB KPCLR
               GOSUB SHOWKEY
               GOSUB SHOWLOC
               LOCATE 24, 65: PRINT "CLEAR ALL OK   ";
             CASE "2"
              FOR BM = 0 TO 65
                STRCODE(LCC + 1, BM) = 0
              NEXT

              FOR KeyStrokeIndex = 1 TO 22
               KeyStroke$(LCC + 1, KeyStrokeIndex) = ""
              NEXT KeyStrokeIndex
              KeyStroke$(LCC + 1, 0) = "0"


              GOSUB SHOWKEY
              GOSUB SHOWLOC
              LOCATE 24, 65: PRINT "CLEAR KEY OK   ";

             CASE ELSE
               GOSUB SHOWKEY
               GOSUB SHOWLOC
               LOCATE 24, 65: PRINT "ABORT CLEAR   ";
             END SELECT

        CASE CHR$(&HAD): REM SAVE KEY CODE

          LOCATE 23, 1
          INPUT "KEYIN KEYCODE FILENAME [KB950-U.KEY] : ", FFF$
          IF FFF$ = "" THEN
            FFF$ = "KB950-U.KEY"
            LOCATE 23, 40: PRINT FFF$
          END IF

           OPEN FFF$ FOR OUTPUT AS #1
             FOR MN = 1 TO 84
              FOR MN1 = 0 TO 64
                PRINT #1, CHR$(STRCODE(MN, MN1));
              NEXT
             NEXT
           CLOSE #1
           GOSUB SHOWKEY
           GOSUB SHOWLOC
           LOCATE 24, 65: PRINT "SAVE OK       ";

       CASE CHR$(&HAF)

          LOCATE 24, 65: PRINT "PROGRAM        ";

           FOR KL = 1 TO 5
            LOCATE 18 + KL, 1: PRINT STRING$(80, " ");
           NEXT
           LOCATE 21, 1: PRINT "[1] PROGRAM ALL MAP."
           LOCATE 22, 1: PRINT "[2] PROGRAM SPECIFIC KEY.";
           LOCATE 23, 1, 1: PRINT "[3] ABORT TO PROGRAM KEY.  SELECT:";

           X$ = INPUT$(1)
           FOR KL = 1 TO 5
            LOCATE 18 + KL, 1: PRINT STRING$(80, " ");
           NEXT


           SELECT CASE X$

             CASE "1"
               GOSUB KPPROG
               GOSUB SHOWKEY
               GOSUB SHOWLOC
             CASE "2"
              GOSUB KPPROG1
              GOSUB SHOWKEY
              GOSUB SHOWLOC

             CASE ELSE
               GOSUB SHOWKEY
               GOSUB SHOWLOC
               LOCATE 24, 65: PRINT "ABORT PROGRAM ";
             END SELECT

       CASE CHR$(27)
           CLOSE
           RETURN

       END SELECT
     WEND
 RETURN

READKEY:

 KFLAG = NO
 GOSUB RDDATA
 GOSUB SPECKEY

  TSP = SKBS XOR KTEMP
  FOR VV = 15 TO 0 STEP -1
   IF (TSP AND (2 ^ VV)) <> 0 THEN

     KEYC = MAP1(VV)
     PREV = -1
     IF (SKBS AND (2 ^ VV)) <> 0 THEN
       KFLAG = YES
       KSTAT = PRESS
     ELSE
       KFLAG = YES
       KSTAT = RELEASE
     END IF
   END IF
  NEXT
  KTEMP = SKBS

 RETURN


RDDATA:
  TS = 5
  DO
   DO
    TS = TS - 1
    IF TS <= 0 THEN
       IF (PREV <> -1) AND (PREV <> &H78) THEN
         'PRINT HEX$(PREV), "RELEASE"
          KFLAG = YES
          KSTAT = RELEASE
          KEYC = PREV
       END IF
       PREV = -1
       GOTO RDQ1
     END IF

   LOOP WHILE (INP(&H64) AND &H1) = &H1

   dx = INP(&H60)
   FOR VC = 1 TO 100: NEXT
  LOOP WHILE (dx >= &H80)
      'PRINT "ORG: "; HEX$(DX)

      KEYC = KEYMAP(dx)
       IF KEYC = PREV THEN GOTO RDQ1

   IF (KEYC = &H11) OR (KEYC = &H12) OR (KEYC = &H14) OR (KEYC = &H78) THEN
     PREV = -1
      KFLAG = NO
       KSTAT = PRESS
        GOTO RDQ1
   END IF


   PREV = KEYC
   KSTAT = PRESS
   KFLAG = YES

RDQ1:
  REM **** CLEAR KEY BUFFER ****
  DO
   p$ = INKEY$
  LOOP WHILE (p$ <> "")

RETURN


Rddata1:
X$ = INKEY$
IF LEN(X$) <> 0 THEN
 PRINT
 FOR M = 1 TO LEN(X$)
 PRINT HEX$(ASC(MID$(X$, M, 1))), "PRESS"
 NEXT
 PRINT X$
END IF
RETURN



REM *********************************************************************


SPECKEY:

  inreg.ax = &H1200: REM READ ENHANCE KB FLAG
  CALL INTERRUPTX(&H16, inreg, outreg)
  SKBS = outreg.ax AND &HFF03

RETURN



STRPROG:
    BEEP
    LOCATE 24, 65
    PRINT "EDIT KEY      ";

    PREV = &H78
    GOSUB SPECKEY
    KTEMP = SKBS
    IP = 0
    LOCATE 19, 1
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    LOCATE 21, 1
    PRINT "KEY STROKE LENGTH [MAX.21]:"; VAL(KeyStroke$(LCC + 1, 0))
    LOCATE 19, 1

  WHILE (INP(&H64) AND &H1) = &H1
   XX = INP(&H60)
  WEND

  DP$ = ""
  WHILE (1)
   GOSUB READKEY
    bb = 1
    IF KFLAG = YES THEN
                                REM F12 PRESS EXIT PROG

       IF KEYC = &H7 THEN
          BEEP
          STRCODE((LCC + 1), 0) = IP
          GOTO STREXIT
       END IF

       IF KSTAT = PRESS THEN
         FOR BB1 = 1 TO 4
           IF KEYMAKE(KEYC, BB1) <> &HFF THEN
             IP = IP + 1
             STRCODE((LCC + 1), IP) = KEYMAKE(KEYC, BB1)
             DP$ = DP$ + STRING$(2 - LEN(HEX$(STRCODE(LCC + 1, IP))), "0")
             DP$ = DP$ + HEX$(STRCODE(LCC + 1, IP)) + "  "

           END IF
         NEXT
       'PRINT "<<"; DP$; ">>"
       IF IP < 64 THEN
         CALL GetKeyStroke(RIGHT$(DP$, 4), KS$)
         CALL PrintKeyStroke(KS$)
         KSCounts = KSCounts + 1
         KeyStroke$(LCC + 1, KSCounts) = KS$
       END IF

       '   "PRESS"
       ELSE
         FOR BB2 = 1 TO 6
          IF KEYBREAK(KEYC, BB2) <> &HFF THEN
            IP = IP + 1
            STRCODE((LCC + 1), IP) = KEYBREAK(KEYC, BB2)
            DP$ = DP$ + STRING$(2 - LEN(HEX$(STRCODE(LCC + 1, IP))), "0")
            DP$ = DP$ + HEX$(STRCODE(LCC + 1, IP)) + "  "
            
          END IF
         NEXT


       '   "RELEASE"
       END IF
      IF (KSTAT = RELEASE) THEN
       IF IP > 64 THEN
         BEEP
         LOCATE 24, 65
         PRINT "FULL PRESS [F12]";
         IP = IPTM
       ELSE

         CALL PrintScanCode(DP$)
         'CALL GetKeyStroke(DP$, KS$)
         'CALL PrintKeyStroke(KS$)
         'KSCounts = KSCounts + 1
         'KeyStroke$(LCC + 1, KSCounts) = KS$

         DP$ = ""
         IPTM = IP
       END IF
      END IF
     KFLAG = NO
    END IF
  WEND
STREXIT:

    CALL PrintScanCode("RESET")
    CALL PrintKeyStroke("RESET")
    KeyStroke$(LCC + 1, 0) = STR$(KSCounts)
    KSCounts = 0
    DO
     X$ = INKEY$
    LOOP WHILE (X$ <> "")

 CLS
RETURN




SHOWLOC:

    LOCATE (3 + 2 * (PLCC MOD 7)), (10 + 5 * INT(PLCC / 7)), 0
    COLOR 7, 0: PRINT STRING$(2 - LEN(LTRIM$(STR$(PLCC + 1))), " "); STR$(PLCC + 1); " ";

    LOCATE (3 + 2 * (LCC MOD 7)), (10 + 5 * INT(LCC / 7)), 0

    COLOR 0, 7: PRINT STRING$(2 - LEN(LTRIM$(STR$(LCC + 1))), " "); STR$(LCC + 1); " ";
    COLOR 7, 0

    LOCATE 17, 1: PRINT "                  ";
    LOCATE 17, 1: PRINT "KEY POSITION : "; LCC + 1
    LOCATE 18, 1: PRINT "                         ";
    LOCATE 18, 1: PRINT "SCAN CODE LENGTH [MAX.64]:"; STRCODE(LCC + 1, 0);

    LOCATE 19, 1
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    PRINT STRING$(80, " ")
    LOCATE 19, 1

'    FOR M = 1 TO STRCODE(LCC + 1, 0)
'     PRINT STRING$(2 - LEN(HEX$(STRCODE(LCC + 1, M))), "0");
'     PRINT HEX$(STRCODE(LCC + 1, M)); "  ";
'     IF STRCODE(LCC + 1, M) = KOVER THEN EXIT FOR
'    NEXT

    TmpStrCode(0) = STRCODE(LCC + 1, 0)
    FOR M = 1 TO STRCODE(LCC + 1, 0)
      TmpStrCode(M) = STRCODE(LCC + 1, M)
    NEXT M

    TmpKeyStroke$(0) = KeyStroke$(LCC + 1, 0)
    FOR M = 1 TO VAL(KeyStroke$(LCC + 1, 0))
      TmpKeyStroke$(M) = KeyStroke$(LCC + 1, M)
    NEXT M
   
    CALL PrintResultOfScanCode(TmpStrCode())
    CALL PrintResultOfKeyStroke(TmpKeyStroke$())
   
    LOCATE 21, 1
    PRINT "KEY STROKE LENGTH [MAX.21]:"; VAL(KeyStroke$(LCC + 1, 0))
    VIEW PRINT 1 TO 25

RETURN


KPCLR:

      FOR II = 0 TO 84
       FOR JJ = 0 TO 65
        STRCODE(II, JJ) = 0
       NEXT
      NEXT
      FOR KeyIndex = 1 TO 128
         FOR KeyStrokeIndex = 1 TO 30
            KeyStroke$(KeyIndex, KeyStrokeIndex) = ""
         NEXT KeyStrokeIndex
         KeyStroke$(KeyIndex, 0) = "0"
      NEXT KeyIndex


  RETURN


DSP800Demo:
    CLS
      SHELL "SENDSP.EXE 12345"
      X$ = INPUT$(1)
    RETURN

' *****************************
Rs232:

DO
CLS
LOCATE 7, 20: PRINT "***** RS232 DEVICE BY KB-INTERFACE *****"
LOCATE 10, 25: PRINT "[1]  SEND DATA TO KB950'S RS232"
LOCATE 12, 25: PRINT "[2]  BACK TO MAIN MENU"

A$ = INPUT$(1)
SELECT CASE A$

  CASE "1"
    GOSUB DSP800Demo

  CASE "2"
   RETURN

  CASE ELSE
   BEEP
   RETURN


END SELECT
LOOP WHILE (1)

REM *******************************************************************


Kb950Test:
DO
CLS
LOCATE 8, 20: PRINT "***** TEST SCREEN *****"
LOCATE 10, 15: PRINT "[1]  TEST KEYBOARD INPUT ( KB950's MSR, KEY, RS232 Etc.)"
LOCATE 12, 15: PRINT "[2]  SELT TEST KB950"
LOCATE 14, 15: PRINT "[3]  BACK TO MAIN MENU"

A$ = INPUT$(1)
SELECT CASE A$

  CASE "1"
    CLS
    LOCATE 1, 1, 1
    PRINT "MSR & KEYBOARD TEST ( PRESS [ESC] KEY TO EXIT )"
    DO
      A$ = INKEY$
      IF LEN(A$) <> 0 THEN
      PRINT A$;
    END IF
    LOOP WHILE A$ <> CHR$(27)

  CASE "2"
    RUNFG = 0
    LOCATE 16, 50: PRINT "SEND RESET COMMAND TO KEYBOARD"
    MXD = &HFF
    GOSUB SENDDATA


       LOCATE 25, 60
       IF RUNFG = 0 THEN
        PRINT "STATUS : RESET OK ";
       ELSE

        PRINT "STATUS : RESET FAIL";
       END IF

     LOCATE 25, 30: PRINT "<Press any key to continue>";
    p$ = INPUT$(1)

  CASE "K"

         CLOSE #1
         OPEN "KB950.KEY" FOR RANDOM AS #1 LEN = 1
            FOR MN = 0 TO 83
                INPUT #1, KEYCODE(MN)
              NEXT
            CLOSE #1
            GOSUB SHOWKEY
            GOSUB TestKey

  CASE "M"
    GOSUB MANUDEFAULT

  CASE "3"
   RETURN
  CASE ELSE
   BEEP
   RETURN


END SELECT
LOOP WHILE (1)

REM *******************

TestKey:
 TA = 0
 FOR INX = 0 TO 83
   keyflag(INX) = 0
 NEXT

 WHILE (1)
  DO
   DO
    RX = INP(&H64)
   LOOP WHILE (RX AND &H1) = &H1
   dx = INP(&H60)
  LOOP WHILE (dx >= &H80)
  LOCATE 1, 1: PRINT "  "
  LOCATE 1, 1: PRINT HEX$(dx)

  dx = KEYMAP(dx)
  LOCATE 2, 1: PRINT "  "
  LOCATE 2, 1: PRINT HEX$(dx)
   FOR INX = 0 TO 83
     IF KEYCODE(INX) = dx THEN
        IF keyflag(INX) = 0 THEN TA = TA + 1
        keyflag(INX) = keyflag(INX) + 1
       GOSUB ShowTest
     END IF
   NEXT
  IF TA >= 82 THEN
    DO
     X$ = INKEY$
    LOOP WHILE (X$ <> "")
    RETURN
  END IF

 WEND
RETURN



MANUDEFAULT:

      CLS
      LOCATE 10, 20: PRINT "1. NOW PROGRAMMING KEY-CODE TABLE"
      RUNFG = 0
      OPEN "KB950.KEY" FOR RANDOM AS #1 LEN = 1
      IF LOF(1) = 0 THEN
         CLOSE #1
         OPEN "KB950.KEY" FOR RANDOM AS #1 LEN = 1
         FOR MN = 0 TO 127
           KEYCODE(MN) = &H60
           PRINT #1, KEYCODE(MN)
         NEXT
         CLOSE #1
      ELSE
         CLOSE #1
         OPEN "KB950.KEY" FOR RANDOM AS #1 LEN = 1
         FOR MN = 0 TO 83
           INPUT #1, KEYCODE(MN)
         NEXT
         CLOSE #1
      END IF
      CLOSE #1

      FOR i = 0 TO 83

        MXD = &HF1
        GOSUB SENDDATA1

        MXD = i
        GOSUB SENDDATA1

        MXD = &H80
        GOSUB SENDDATA1

        MXD = KEYCODE(i)
        GOSUB SENDDATA1

        MXD = &HF4
        GOSUB SENDDATA1

     NEXT

     LOCATE 10, 60
     IF RUNFG = 0 THEN
       PRINT "PROGRAM OK  ";
     ELSE
       PRINT "PROGRAM FAIL";
     END IF
     RUNFG = 0

      LOCATE 11, 20: PRINT "2. NOW PROGRAMMING KEY CONFIG"

   FOR bb = 128 TO 133
       MXD = &HF1
       GOSUB SENDDATA1

       MXD = bb
       GOSUB SENDDATA1

       MXD = &H80
       GOSUB SENDDATA1

        MXD = &H0
        GOSUB SENDDATA1

        MXD = &HF4
        GOSUB SENDDATA1
     NEXT

     LOCATE 11, 60
     IF RUNFG = 0 THEN
       PRINT "PROGRAM OK  ";
     ELSE
       PRINT "PROGRAM FAIL";
     END IF
     RUNFG = 0

     LOCATE 12, 20: PRINT "3. NOW PROGRAMMING KEYBOARD TYPE";

      GOSUB RdCountryCode1
 REM  SET COUNTRY CODE TO SPEC. ITEM

        MXD = &HF1
        GOSUB SENDDATA1

        MXD = 129
        GOSUB SENDDATA1

        MXD = &H80
        GOSUB SENDDATA1

        MXD = COUNC
        GOSUB SENDDATA1

        MXD = &HF4
        GOSUB SENDDATA1

      FOR i = 0 TO 127

        MXD = &HF1
        GOSUB SENDDATA1

        MXD = CCODE1(i * 2)
        GOSUB SENDDATA1

        MXD = i
        GOSUB SENDDATA1

        MXD = CCODE1(i * 2 + 1)
        GOSUB SENDDATA1

        MXD = &HF4
        GOSUB SENDDATA1
     NEXT

     LOCATE 12, 60
     IF RUNFG = 0 THEN
       PRINT "PROGRAM OK  ";
     ELSE
       PRINT "PROGRAM FAIL";
     END IF
     RUNFG = 0

     LOCATE 20, 22: PRINT "*** MANUFACTURE PROGRAMMING IS FINISHED ***"
     LOCATE 21, 22: PRINT "     < Press Any Key to Back Main >"
     BEEP
     X$ = INPUT$(1)


RETURN




REM **************************** END ********************************

SUB ClearKeyBuffer
  DO
   p$ = INKEY$
  LOOP WHILE (p$ <> "")
END SUB

SUB ConvertStrCodeToKeyStroke (STRCODE(), KeyStroke$())

DIM TmpKeyStroke(0 TO 100), KeepScanCode(0 TO 100)

KeyStrokeIndex = 0
FOR KeyIndex = 1 TO 84
   
   TotalScanCodeCount = STRCODE(KeyIndex, 0)

   FOR KeepScanCodeIndex = 1 TO TotalScanCodeCount
      KeepScanCode(KeepScanCodeIndex) = STRCODE(KeyIndex, KeepScanCodeIndex)
   NEXT KeepScanCodeIndex
  
   DO
      ChangeCount = 0
      KSRCount = 0

      FOR ScanCodeIndex = 1 TO TotalScanCodeCount

         IF ScanCodeIndex + 1 > TotalScanCodeCount THEN EXIT FOR
        
         KSRCount = KSRCount + 1

         TmpKeyStroke(KSRCount) = KeepScanCode(ScanCodeIndex)
        
         TmpStrCode = KeepScanCode(ScanCodeIndex + 1)
        
         IF TmpStrCode = &HF0 THEN
            ScanCodeIndex = ScanCodeIndex + 2
            ChangeCount = ChangeCount + 1
         END IF

      NEXT ScanCodeIndex

      IF ChangeCount <> 0 THEN
         TotalScanCodeCount = KSRCount
         FOR KeepScanCodeIndex = 1 TO TotalScanCodeCount
            KeepScanCode(KeepScanCodeIndex) = TmpKeyStroke(KeepScanCodeIndex)
         NEXT KeepScanCodeIndex
      END IF
     

   LOOP WHILE ChangeCount <> 0
  
  
   KeyStroke$(KeyIndex, 0) = STR$(TotalScanCodeCount)

   FOR KeyStrokeIndex = 1 TO TotalScanCodeCount
      TmpDP$ = HEX$(KeepScanCode(KeyStrokeIndex))

      CALL GetKeyStroke(TmpDP$, TmpKS$)
      KeyStroke$(KeyIndex, KeyStrokeIndex) = TmpKS$
   NEXT KeyStrokeIndex


NEXT KeyIndex












END SUB

SUB GetKeyStroke (DP$, KS$)

TmpDP$ = LEFT$(DP$, 2)

IF TmpDP$ = "E0" THEN
   TmpDP$ = MID$(DP$, 5, 2)
END IF

IF LEN(TmpDP$) = 1 THEN
   TmpDP$ = "0" + TmpDP$
END IF


FOR i = 1 TO 88
   TmpKS$ = LEFT$(ScanToStroke$(i, 0), 2)
   IF (TmpDP$ = TmpKS$) THEN
      KS$ = ScanToStroke$(i, 1)
      EXIT SUB
   END IF
NEXT i


IF i > 87 THEN
   KS$ = "<UNKNOW>"
END IF

END SUB

SUB PrintKeyStroke (KS$)

   STATIC LineLen, Y, AddLine
 
   IF KS$ = "RESET" THEN
      LineLen = 0: Y = 0: AddLine = 0
      EXIT SUB
   END IF
 
   DPLen = LEN(KS$)
   LineLen = LineLen + DPLen

   IF LineLen >= 80 THEN
      AddLine = AddLine + 1
      IF AddLine >= 2 THEN
         AddLine = 0
      END IF
      LOCATE 22 + AddLine, 1
      PRINT STRING$(80, " ")

   END IF
 
   Y = 22 + AddLine

   IF LineLen >= 80 THEN
      LineLen = DPLen
      X = 0
   ELSE
      X = LineLen - DPLen
   END IF

   LOCATE Y, X + 1

   PRINT KS$; " ";
   LineLen = LineLen + 1   '+1 due to space

END SUB

SUB PrintResultOfKeyStroke (RKeyStroke$())
   VIEW PRINT 22 TO 23

   KeyStrokeLen = VAL(RKeyStroke$(0))

   KeyStrokeLineLen = 0

   PrintOrigin = 1
   LineTag = 0

   FOR i = 1 TO KeyStrokeLen

      KeyStrokeLineLen = LEN(RKeyStroke$(i)) + KeyStrokeLineLen + 1
      IF KeyStrokeLineLen >= 80 AND KeyStrokeLineLen < 160 AND LineTag = 0 THEN

         LineTag = 1
         KeyStrokeLineLen = LEN(RKeyStroke$(i)) + 80 + 1

      ELSEIF KeyStrokeLineLen >= 160 THEN

         LineTag = 0
         KeyStrokeLineLen = 0
         FOR j = KeyStrokeLen TO 1 STEP -1
            KeyStrokeLineLen = LEN(RKeyStroke$(j)) + KeyStrokeLineLen + 1
            IF KeyStrokeLineLen >= 80 AND KeyStrokeLineLen < 160 AND LineTag = 0 THEN
               LineTag = 1
               KeyStrokeLineLen = LEN(RKeyStroke$(j)) + 80 + 1
            ELSEIF KeyStrokeLineLen >= 160 THEN
               PrintOrigin = j + 1
               EXIT FOR
            END IF

         NEXT j

      END IF
      IF PrintOrigin <> 1 THEN EXIT FOR

   NEXT i

   FOR i = PrintOrigin TO KeyStrokeLen
      PRINT RKeyStroke$(i); " ";
   NEXT i
   VIEW PRINT 1 TO 25

END SUB

SUB PrintResultOfScanCode (RScanCode())

   VIEW PRINT 19 TO 20

   ScanCodeLen = RScanCode(0)
   IF ScanCodeLen <= 40 THEN
      FOR i = 1 TO ScanCodeLen
         PRINT HEX$(RScanCode(i)); "  ";
      NEXT i
   ELSEIF ScanCodeLen > 40 THEN
      FOR i = ScanCodeLen - 39 TO ScanCodeLen
         PRINT HEX$(RScanCode(i)); "  ";
      NEXT i
   END IF
   VIEW PRINT 1 TO 25

END SUB

SUB PrintScanCode (DP$)

   STATIC LineLen, Y, AddLine

  
   IF DP$ = "RESET" THEN
      LineLen = 0: Y = 0: AddLine = 0
      EXIT SUB
   END IF
  
   DPLen = LEN(DP$)
   LineLen = LineLen + DPLen

   IF LineLen >= 80 THEN
      AddLine = AddLine + 1
      IF AddLine >= 2 THEN
         AddLine = 0
      END IF
      LOCATE 19 + AddLine, 1
      PRINT STRING$(80, " ")
   END IF
  
   Y = 19 + AddLine

   IF LineLen >= 80 THEN
      LineLen = DPLen
      X = 0
   ELSE
      X = LineLen - DPLen
   END IF

   LOCATE Y, X + 1

   PRINT DP$



END SUB

SUB SaveKeyCode (DS$)

OPEN "a", #1, "1"

 PRINT #1, DS$; "|"

CLOSE #1

END SUB

SUB SetKeyStroke

ScanToStroke$(1, 0) = "76  F0  76  ": ScanToStroke$(1, 1) = "<ESC>"
ScanToStroke$(2, 0) = "05  F0  05  ": ScanToStroke$(2, 1) = "<F1>"
ScanToStroke$(3, 0) = "06  F0  06  ": ScanToStroke$(3, 1) = "<F2>"
ScanToStroke$(4, 0) = "04  F0  04  ": ScanToStroke$(4, 1) = "<F3>"
ScanToStroke$(5, 0) = "0C  F0  0C  ": ScanToStroke$(5, 1) = "<F4>"
ScanToStroke$(6, 0) = "03  F0  03  ": ScanToStroke$(6, 1) = "<F5>"
ScanToStroke$(7, 0) = "0B  F0  0B  ": ScanToStroke$(7, 1) = "<F6>"
ScanToStroke$(8, 0) = "83  F0  83  ": ScanToStroke$(8, 1) = "<F7>"
ScanToStroke$(9, 0) = "0A  F0  0A  ": ScanToStroke$(9, 1) = "<F8>"
ScanToStroke$(10, 0) = "01  F0  01  ": ScanToStroke$(10, 1) = "<F9>"
ScanToStroke$(11, 0) = "09  F0  09  ": ScanToStroke$(11, 1) = "<F10>"
ScanToStroke$(12, 0) = "7E  F0  7E  ": ScanToStroke$(12, 1) = "<Scroll Lock>"
ScanToStroke$(13, 0) = "0E  F0  0E  ": ScanToStroke$(13, 1) = "`"
ScanToStroke$(14, 0) = "16  F0  16  ": ScanToStroke$(14, 1) = "1"
ScanToStroke$(15, 0) = "1E  F0  1E  ": ScanToStroke$(15, 1) = "2"
ScanToStroke$(16, 0) = "26  F0  26  ": ScanToStroke$(16, 1) = "3"
ScanToStroke$(17, 0) = "25  F0  25  ": ScanToStroke$(17, 1) = "4"
ScanToStroke$(18, 0) = "2E  F0  2E  ": ScanToStroke$(18, 1) = "5"
ScanToStroke$(87, 0) = "73  F0  73  ": ScanToStroke$(87, 1) = "5"
ScanToStroke$(19, 0) = "36  F0  36  ": ScanToStroke$(19, 1) = "6"
ScanToStroke$(20, 0) = "3D  F0  3D  ": ScanToStroke$(20, 1) = "7"
ScanToStroke$(21, 0) = "3E  F0  3E  ": ScanToStroke$(21, 1) = "8"
ScanToStroke$(22, 0) = "46  F0  46  ": ScanToStroke$(22, 1) = "9"
ScanToStroke$(23, 0) = "45  F0  45  ": ScanToStroke$(23, 1) = "0"
ScanToStroke$(24, 0) = "4E  F0  4E  ": ScanToStroke$(24, 1) = "-"
ScanToStroke$(25, 0) = "55  F0  55  ": ScanToStroke$(25, 1) = "="
ScanToStroke$(26, 0) = "66  F0  66  ": ScanToStroke$(26, 1) = "<Backspace>"
ScanToStroke$(27, 0) = "0D  F0  0D  ": ScanToStroke$(27, 1) = "<Tab>"
ScanToStroke$(28, 0) = "15  F0  15  ": ScanToStroke$(28, 1) = "Q"
ScanToStroke$(29, 0) = "1D  F0  1D  ": ScanToStroke$(29, 1) = "W"
ScanToStroke$(30, 0) = "24  F0  24  ": ScanToStroke$(30, 1) = "E"
ScanToStroke$(31, 0) = "2D  F0  2D  ": ScanToStroke$(31, 1) = "R"
ScanToStroke$(32, 0) = "2C  F0  2C  ": ScanToStroke$(32, 1) = "T"
ScanToStroke$(33, 0) = "35  F0  35  ": ScanToStroke$(33, 1) = "Y"
ScanToStroke$(34, 0) = "3C  F0  3C  ": ScanToStroke$(34, 1) = "U"
ScanToStroke$(35, 0) = "43  F0  43  ": ScanToStroke$(35, 1) = "I"
ScanToStroke$(36, 0) = "44  F0  44  ": ScanToStroke$(36, 1) = "O"
ScanToStroke$(37, 0) = "4D  F0  4D  ": ScanToStroke$(37, 1) = "P"
ScanToStroke$(38, 0) = "54  F0  54  ": ScanToStroke$(38, 1) = "["
ScanToStroke$(39, 0) = "5B  F0  5B  ": ScanToStroke$(39, 1) = "]"
ScanToStroke$(40, 0) = "5A  F0  5A  ": ScanToStroke$(40, 1) = "<Enter>"
ScanToStroke$(41, 0) = "58  F0  58  ": ScanToStroke$(41, 1) = "<Caps Lock>"
ScanToStroke$(42, 0) = "1C  F0  1C  ": ScanToStroke$(42, 1) = "A"
ScanToStroke$(43, 0) = "1B  F0  1B  ": ScanToStroke$(43, 1) = "S"
ScanToStroke$(44, 0) = "23  F0  23  ": ScanToStroke$(44, 1) = "D"
ScanToStroke$(45, 0) = "2B  F0  2B  ": ScanToStroke$(45, 1) = "F"
ScanToStroke$(46, 0) = "34  F0  34  ": ScanToStroke$(46, 1) = "G"
ScanToStroke$(47, 0) = "33  F0  33  ": ScanToStroke$(47, 1) = "H"
ScanToStroke$(48, 0) = "3B  F0  3B  ": ScanToStroke$(48, 1) = "J"
ScanToStroke$(49, 0) = "42  F0  42  ": ScanToStroke$(49, 1) = "K"
ScanToStroke$(50, 0) = "4B  F0  4B  ": ScanToStroke$(50, 1) = "L"
ScanToStroke$(51, 0) = "4C  F0  4C  ": ScanToStroke$(51, 1) = ";"
ScanToStroke$(52, 0) = "52  F0  52  ": ScanToStroke$(52, 1) = "'"
ScanToStroke$(53, 0) = "12  F0  12  ": ScanToStroke$(53, 1) = "<Shift>"
ScanToStroke$(54, 0) = "1A  F0  1A  ": ScanToStroke$(54, 1) = "Z"
ScanToStroke$(55, 0) = "22  F0  22  ": ScanToStroke$(55, 1) = "X"
ScanToStroke$(56, 0) = "21  F0  21  ": ScanToStroke$(56, 1) = "C"
ScanToStroke$(57, 0) = "2A  F0  2A  ": ScanToStroke$(57, 1) = "V"
ScanToStroke$(58, 0) = "32  F0  32  ": ScanToStroke$(58, 1) = "B"
ScanToStroke$(59, 0) = "31  F0  31  ": ScanToStroke$(59, 1) = "N"
ScanToStroke$(60, 0) = "3A  F0  3A  ": ScanToStroke$(60, 1) = "M"
ScanToStroke$(61, 0) = "41  F0  41  ": ScanToStroke$(61, 1) = ","
ScanToStroke$(62, 0) = "49  F0  49  ": ScanToStroke$(62, 1) = "."
ScanToStroke$(63, 0) = "4A  F0  4A  ": ScanToStroke$(63, 1) = "/"
ScanToStroke$(64, 0) = "59  F0  59  ": ScanToStroke$(64, 1) = "<Shift>"
ScanToStroke$(65, 0) = "5D  F0  5D  ": ScanToStroke$(65, 1) = "\"
ScanToStroke$(66, 0) = "14  F0  14  ": ScanToStroke$(66, 1) = "<Ctrl>"
ScanToStroke$(67, 0) = "11  F0  11  ": ScanToStroke$(67, 1) = "<Alt>"
ScanToStroke$(68, 0) = "29  F0  29  ": ScanToStroke$(68, 1) = "<Space>"
ScanToStroke$(69, 0) = "E0  11  E0  F0  11  ": ScanToStroke$(69, 1) = "<Alt>"
ScanToStroke$(70, 0) = "E0  14  E0  F0  14  ": ScanToStroke$(70, 1) = "<Ctrl>"
ScanToStroke$(71, 0) = "70  F0  70  ": ScanToStroke$(71, 1) = "<Insert>"
ScanToStroke$(72, 0) = "6C  F0  6C  ": ScanToStroke$(72, 1) = "<Home>"
ScanToStroke$(73, 0) = "7D  F0  7D  ": ScanToStroke$(73, 1) = "<PageUp>"
ScanToStroke$(74, 0) = "71  F0  71  ": ScanToStroke$(74, 1) = "<Delete>"
ScanToStroke$(75, 0) = "69  F0  69  ": ScanToStroke$(75, 1) = "<End>"
ScanToStroke$(76, 0) = "7A  F0  7A  ": ScanToStroke$(76, 1) = "<PageDown>"
ScanToStroke$(77, 0) = "75  F0  75  ": ScanToStroke$(77, 1) = "<Up>"
ScanToStroke$(78, 0) = "6B  F0  6B  ": ScanToStroke$(78, 1) = "<Left>"
ScanToStroke$(79, 0) = "72  F0  72  ": ScanToStroke$(79, 1) = "<Down>"
ScanToStroke$(80, 0) = "74  F0  74  ": ScanToStroke$(80, 1) = "<Right>"
ScanToStroke$(81, 0) = "77  F0  77  ": ScanToStroke$(81, 1) = "<NumLock>"
ScanToStroke$(82, 0) = "4A  F0  4A  ": ScanToStroke$(82, 1) = "/"
ScanToStroke$(83, 0) = "7C  F0  7C  ": ScanToStroke$(83, 1) = "*"
ScanToStroke$(84, 0) = "7B  F0  7B  ": ScanToStroke$(84, 1) = "-"
ScanToStroke$(85, 0) = "79  F0  79  ": ScanToStroke$(85, 1) = "+"
ScanToStroke$(86, 0) = "71  F0  71  ": ScanToStroke$(86, 1) = "."
ScanToStroke$(87, 0) = "78  F0  78  ": ScanToStroke$(87, 1) = "<F11>"
ScanToStroke$(88, 0) = "07  F0  07  ": ScanToStroke$(88, 1) = "<F12>"
END SUB

