#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

int
main(void)
{
    fd_set rfds;
    struct timeval tv;
    int retval,i,j;
    int fd;
    char ch;

    fd=open("/dev/scanner", O_RDONLY);
    if (fd < 0) {
        perror("open");
        exit(1);
    };
    printf("fd = %d\n", fd);

    /* Watch scanner to see when it has input. */

    do {
      FD_ZERO(&rfds);
      FD_SET(fd, &rfds);
      /*      FD_SET(0, &rfds);*/
      /* Wait up to five seconds. */
      tv.tv_sec = 5;
      tv.tv_usec = 0;

      retval = select(16, &rfds, NULL, NULL, NULL);
      /* Don't rely on the value of tv now! */

      if (FD_ISSET(0, &rfds)) 
        break;
  
      if (FD_ISSET(fd,&rfds)) {
        printf("Data is available now. %d %d\n", 
               FD_ISSET(fd, &rfds), FD_ISSET(0, &rfds) );

        read(fd,&ch,1);
        
        j=1;
        i=1;
        while (j) {
          FD_ZERO(&rfds);
          FD_SET(fd, &rfds);
          tv.tv_sec=0;
          tv.tv_usec=0;

          select(16, &rfds, NULL,NULL,&tv);
          if (FD_ISSET(fd,&rfds)) {
            read(fd,&ch,1);
            i++;
          }
          else
            j=0;
          
        }

        printf("Read %d characters\n",i);
        
      }
    } while (1);
    close(fd);

    exit(0);
}

