use warnings;
use strict;
use Tk;
use Tk::BrowseEntry;
use File::Copy;
use DateTime;
use Text::Unidecode;


# ARCHIVE
# The script shows a nice GUI which allows to quickly archive CDs 
# and floppies from books.
# 
# Executed in current directory makes it an archive for disk image
# files and their metadata. 
# Metadata is stored in "info.txt" file in human and machine readable 
# plaintext form.
# Requires: Linux, ddrescue, Perl::Tk.
# MCbx 2016.

# To customize disk imaging procedures please find "SYSTEM" comment.
# and customize there.

my $dataFile="database.csv";

my $mw = MainWindow->new;
	$mw->title("Archiver");
	$mw->resizable(0,0);
    $mw->Label(-text => 'Author:')->grid(-column=>0,-row=>0, -padx=>2, -pady=>2,);
	my $authorStr="";
	my $author = $mw->Entry(-width=>70, -textvariable=>\$authorStr)->grid(-column=>1,-row=>0,-padx=>2, -pady=>2, -columnspan=>4,);
    $mw->Label(-text => 'Title:')->grid(-column=>0,-row=>1,-padx=>2, -pady=>2,);
	my $titleStr="";
	my $title = $mw->Entry(-width=>70, -textvariable=>\$titleStr)->grid(-column=>1,-row=>1,-padx=>2, -pady=>2,-columnspan=>4,);
	$mw->Label(-text => 'Type:')->grid(-column=>0,-row=>2,-padx=>2, -pady=>2,);
	my $typeStr="CD";
	my $type = $mw->BrowseEntry(-variable=>\$typeStr, -width=>10)->grid(-column=>1,-row=>2,-padx=>2, -pady=>2,);
	my @types = ('CD', 'DVD', '3.5 Floppy','5.25 Floppy');
	$type->insert('end', @types);
	$mw->Label(-text => 'Count:')->grid(-column=>2,-row=>2,-padx=>2, -pady=>2,);
	my $countStr=1;
	my $count = $mw->Entry(-width=>18, -textvariable=>\$countStr)->grid(-column=>3,-row=>2,-padx=>2, -pady=>2,);
	
	$mw->Label(-text => 'Condition:')->grid(-column=>0,-row=>3,-padx=>2, -pady=>2,);	
	my $condStr="OK";
	my $cond = $mw->BrowseEntry(-variable=>\$condStr, -width=>10)->grid(-column=>1,-row=>3,-padx=>2, -pady=>2,);
	my @conds = ('OK', 'Backup', 'Recovered', 'Damaged');
	$cond->insert('end', @conds);
	$mw->Label(-text => 'Comment:')->grid(-column=>2,-row=>3,-padx=>2, -pady=>2,);
	my $commentStr="";
	my $comment = $mw->Entry(-width=>40, -textvariable=>\$commentStr)->grid(-column=>3,-row=>3,-padx=>2, -pady=>2, -columnspan=>2,);
	
	#Create 3 windows for 3 items
	my $item1Str="";
	my $item1 = $mw->Entry(-width=>80, -textvariable=>\$item1Str)->grid(-column=>0,-row=>5,-padx=>2, -pady=>2,-columnspan=>4,);
	my $item2Str="";
	my $item2 = $mw->Entry(-width=>80, -textvariable=>\$item2Str)->grid(-column=>0,-row=>6,-padx=>2, -pady=>2,-columnspan=>4,);
	my $item3Str="";
	my $item3 = $mw->Entry(-width=>80, -textvariable=>\$item3Str)->grid(-column=>0,-row=>7,-padx=>2, -pady=>2,-columnspan=>4,);	
	
	
	#create 3 browsers
	$mw->Button(
        -text    => '...',
        -command => sub { 
			my $filename = $mw->getOpenFile( -title => 'Open File:', -defaultextension => '.*', -initialdir => '.' );		
			if ($filename ne "") 
			{
				$item1Str=$filename;
			}
			},
		-width => 2,
    )->grid(-column=>4,-row=>5,-padx=>2, -pady=>2,);
	$mw->Button(
        -text    => '...',
        -command => sub { 
			my $filename = $mw->getOpenFile( -title => 'Open File:', -defaultextension => '.*', -initialdir => '.' );		
			if ($filename ne "") 
			{
				$item2Str=$filename;
			}
			},
		-width => 2,
    )->grid(-column=>4,-row=>6,-padx=>2, -pady=>2,);
	$mw->Button(
        -text    => '...',
        -command => sub { 
			my $filename = $mw->getOpenFile( -title => 'Open File:', -defaultextension => '.*', -initialdir => '.' );		
			if ($filename ne "") 
			{
				$item3Str=$filename;
			}
			},
		-width => 2,
    )->grid(-column=>4,-row=>7,-padx=>2, -pady=>2,);
	
	$mw->Button(
        -text    => 'ISO from CD',
        -command => sub { 
			my $file="/tmp/";
			###SYSTEM###
			# Commands to launch terminal, create ISO of CD to "$file"
			#Remember to create unique name of $file because it must be present in 3 versions.
			my $i=0;
			while (-e $file.$i.".iso")
			{
				$i++;
			}
			$file=$file.$i.".iso";
			system("xterm -e \"ddrescue -vvv -r 10 -b 2048 -d /dev/cdrom ".$file.";read\"");
			
			
			if ($item1Str ne "")
				{
					if ($item2Str ne "")
					{
						if ($item3Str ne "")
						{
						my $msg="No free slots. The file is in: \n ".$file;
						$mw->messageBox(-icon => 'warning', -message => $msg, -title => 'Warning', -type => 'OK', -default => 'OK');
						}
						else
							{$item3Str=$file;}
					}
					else
						{$item2Str=$file;}
				}
				else
					{$item1Str=$file;}
		
		},
		-width => 12,
    )->grid(-column=>0,-row=>9,-padx=>2, -pady=>2,-columnspan=>1,);
	
	$mw->Button(
        -text    => 'IMG from FD',
        -command => sub { 
			my $file="";
			$file="/tmp/";
			###SYSTEM###
			# Commands to launch terminal, create IMG of FD to "$file"
			#Remember to create unique name of $file because it must be present in 3 versions.
			my $i=0;
			while (-e $file.$i.".img")
			{
				$i++;
			}
			$file=$file.$i.".img";
			system("xterm -e \"ddrescue -vvv -r 10 -d /dev/sdg ".$file.";read\"");
			
			
			if ($item1Str ne "")
				{
					if ($item2Str ne "")
					{
						if ($item3Str ne "")
						{
						my $msg="No free slots. The file is in: \n ".$file;
						$mw->messageBox(-icon => 'warning', -message => $msg, -title => 'Warning', -type => 'OK', -default => 'OK');
						}
						else
							{$item3Str=$file;}
					}
					else
						{$item2Str=$file;}
				}
				else
					{$item1Str=$file;}
		
		},
		-width => 12,
    )->grid(-column=>1,-row=>9,-padx=>2, -pady=>2,-columnspan=>1,);
	
	
	
    $mw->Button(
        -text    => 'Quit',
        -command => sub { exit },
		-width => 10,
    )->grid(-column=>2,-row=>9,-padx=>2, -pady=>2,-columnspan=>1,);
	
	
	
    $mw->Button(
        -text    => 'Apply',
		-width => 20,
        -command => sub { 
			my $dirname = "";
			
			#$dirname=(split(' ',$authorStr))[0];
			#$dirname=$dirname." ".$titleStr;
			#$dirname =~ s/ /_/g;
			#$dirname=unidecode($dirname);
			open (my $fh1, '<',$dataFile);
			my $lastLine;
			while (my $line = readline $fh1) 
			{
				if ( $line =~ /\S/ ) { $lastLine = $line } 
			}
			close ($fh1);
			my @aa=split("\";\"",$lastLine);
			$lastLine=$aa[0];
			$lastLine=substr($lastLine,1);
			$dirname=$lastLine+1;
			print "Make dir of ID: ".$dirname."\n";
			
			$lastLine="\"".$dirname."\";\"".$authorStr."\";\"".$titleStr."\";\"".$typeStr."\";\"".$countStr."\";\"".$condStr."\";\"";
			$lastLine=$lastLine.DateTime->now->ymd." ".DateTime->now->hms."\";\"".$commentStr."\"\n";
			
			print $lastLine."\n";

			mkdir "./".$dirname;
			
			open (my $fh,'>',"./".$dirname."/info.txt");
			print $fh "Author: ".$authorStr."\n";
			print $fh "Title: ".$titleStr."\n";
			print $fh "Type: ".$typeStr."\n";
			print $fh "Count: ".$countStr."\n";
			print $fh "Condition: ".$condStr."\n";
			print $fh "Comment: ".$commentStr."\n";
			print $fh "Acquired: ".DateTime->now->ymd." ".DateTime->now->hms."\n";
			close ($fh);
			open (my $fh2, '>>',$dataFile) or die ("Could not open datafile for writing!");
			print $fh2 $lastLine;
			close ($fh2);
			
			if (-e $item1Str)
				{
					my $ext = substr($item1Str, -3);
					move($item1Str,"./".$dirname."/001.".$ext);
				}
			if (-e $item2Str)
				{
					my $ext = substr($item2Str, -3);
					move($item2Str,"./".$dirname."/002.".$ext);
				}
			if (-e $item3Str)
				{
					my $ext = substr($item3Str, -3);
					move($item3Str,"./".$dirname."/003.".$ext);
				}
			$item1Str="";
			$item2Str="";
			$item3Str="";
			$authorStr="";
			$titleStr="";
			$commentStr="";
		},
    )->grid(-column=>2,-row=>9,-padx=>2, -pady=>2, -columnspan=>3,);
	
    MainLoop;
